/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;

public class AccountMoneyFormPlugin
extends AbstractReportFormPlugin {
    private static Log logger = LogFactory.getLog(AccountMoneyFormPlugin.class);
    public static final String HEAD_EXRATETABLE = "exratetable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("org");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("calculatestyle".equals(propName)) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String statdim = (String)this.getModel().getValue("calculatestyle");
        filterInfo.addFilterItem("calculatestyle", (Object)statdim);
        String showType = (String)this.getModel().getValue("showtype");
        FilterItemInfo showTypeItem = filterInfo.getFilterItem("showtype");
        if (showTypeItem != null) {
            showTypeItem.setValue((Object)showType);
        }
        this.setColumnOrder(statdim);
        ReportList list = (ReportList)this.getView().getControl("reportlistap");
        List columns = list.getColumns();
        ReportColumn c1 = (ReportColumn)columns.get(1);
        ReportColumn c2 = (ReportColumn)columns.get(2);
        ReportColumn c3 = (ReportColumn)columns.get(3);
        String[] sortFields = new String[]{c1.getFieldKey(), c2.getFieldKey(), c3.getFieldKey()};
        filterInfo.addFilterItem("sortFields", (Object)sortFields);
        queryParam.setFilter(filterInfo);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        IDataModel model = this.getModel();
        DynamicObject reportCurrency = (DynamicObject)model.getValue("filter_statcurrency");
        Date balanceDate = filter.getDate("balancedate");
        DynamicObjectCollection orgCollection = (DynamicObjectCollection)model.getValue("filter_org");
        String queryWay = (String)model.getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && EmptyUtil.isEmpty((DynamicObjectCollection)orgCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u4f7f\u7528\u516c\u53f8\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (reportCurrency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        if (balanceDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        DynamicObject exRateTable = (DynamicObject)filter.getValue(HEAD_EXRATETABLE);
        if (exRateTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        ReportQueryParam queryParam = event.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        boolean showAcct = filter.getBoolean("showacct");
        List columns = event.getColumns();
        int sort = -1;
        int color = -1;
        int acctNumber = -1;
        int cur = -1;
        block12: for (int i = 0; i < columns.size(); ++i) {
            String fieldKey;
            ReportColumn column = (ReportColumn)columns.get(i);
            switch (fieldKey = column.getFieldKey()) {
                case "sort": {
                    sort = i;
                    continue block12;
                }
                case "color": {
                    color = i;
                    continue block12;
                }
                case "acctnumber": {
                    acctNumber = i;
                    continue block12;
                }
                case "cur": {
                    cur = i;
                }
            }
        }
        ReportColumn cs = (ReportColumn)columns.get(sort);
        ReportColumn cc = (ReportColumn)columns.get(color);
        ReportColumn ca = (ReportColumn)columns.get(acctNumber);
        ReportColumn ccur = (ReportColumn)columns.get(cur);
        columns.remove(cs);
        columns.remove(cc);
        columns.remove(ccur);
        if (!showAcct) {
            columns.remove(ca);
        }
    }

    public void beforeBindData(EventObject e) {
        String frompage;
        DynamicObjectCollection queryFisBankRollOrg;
        super.beforeBindData(e);
        long orgId = RequestContext.get().getOrgId();
        Long mainCurrency = OrgHelper.getMainCurrency((long)orgId);
        this.getModel().setValue("filter_statcurrency", (Object)mainCurrency);
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_accountmoney");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue(HEAD_EXRATETABLE, initObj.getDynamicObject(HEAD_EXRATETABLE).getPkValue());
        }
        if (EmptyUtil.isNoEmpty((String)(frompage = (String)this.getView().getFormShowParameter().getCustomParam("frompage"))) && "mon_capital_card".equals(frompage)) {
            this.getModel().setValue("filter_currencyunit", (Object)"10000");
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    private void setColumnOrder(String key) {
        ReportList list = (ReportList)this.getView().getControl("reportlistap");
        List columns = list.getColumns();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if ("currency".equals(key)) {
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!"currency".equals(fieldKey)) continue;
                map.put("currency", i);
            }
            ReportColumn c0 = (ReportColumn)columns.get(0);
            if (!"currency".equals(c0.getFieldKey())) {
                Integer i = (Integer)map.get("currency");
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(0, ci);
                columns.set(i, c0);
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!key.equals(fieldKey)) continue;
                map.put(key, i);
            }
            ReportColumn c0 = (ReportColumn)columns.get(0);
            if (!key.equals(c0.getFieldKey())) {
                Integer i = (Integer)map.get(key);
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(0, ci);
                columns.set(i, c0);
            }
            HashMap<String, Integer> map2 = new HashMap<String, Integer>();
            for (int i = 0; i < columns.size(); ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                String fieldKey = column.getFieldKey();
                if (!"currency".equals(fieldKey)) continue;
                map2.put("currency", i);
            }
            ReportColumn c1 = (ReportColumn)columns.get(1);
            if (!"currency".equals(c1.getFieldKey())) {
                Integer i = (Integer)map2.get("currency");
                ReportColumn ci = (ReportColumn)columns.get(i);
                columns.set(1, ci);
                columns.set(i, c1);
            }
        }
    }
}

