/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDepositFormListPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("filter_basedate", (Object)DateUtils.getFirstDayOfCurMonth());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (!this.validata(queryParam)) {
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if ("orgview".equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)param.getFilter().getFilterItem("filter_orgview").getValue();
            param.getFilter().addFilterItem("org", (Object)TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id")));
        } else {
            param.getFilter().addFilterItem("org", (Object)RequestContext.get().getOrgId());
        }
        this.controlColums((String)param.getFilter().getFilterItem("filter_region").getValue(), statdim);
    }

    private void controlColums(String regions, String statdim) {
        LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u516c\u53f8", (String)"BankDepositFormListPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]));
        if (statdim.equals("finorgname")) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"BankDepositFormListPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]));
        } else if (statdim.equals("currency")) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BankDepositFormListPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            if (column instanceof ReportColumn && (col = (ReportColumn)column).getFieldKey().equals("orgname")) {
                col.setCaption(caption);
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            this.rebuildChildGroup((ReportColumnGroup)column, regions);
        }
    }

    private void rebuildChildGroup(ReportColumnGroup column, String regions) {
        if (EmptyUtil.isEmpty((String)regions)) {
            return;
        }
        List regionsList = Arrays.stream(regions.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        ReportColumnGroup group = column;
        List childrenColums = group.getChildren();
        ArrayList<ReportColumnGroup> rebuildColumns = new ArrayList<ReportColumnGroup>(childrenColums.size());
        for (AbstractReportColumn childColumn : childrenColums) {
            if (!(childColumn instanceof ReportColumnGroup)) continue;
            ReportColumnGroup childGroup = (ReportColumnGroup)childColumn;
            if (regionsList.contains("R1") && (childGroup.getFieldKey().equals("basechingroup") || childGroup.getFieldKey().equals("endchingroup"))) {
                rebuildColumns.add(childGroup);
            }
            if (regionsList.contains("R2") && (childGroup.getFieldKey().equals("basegatgroup") || childGroup.getFieldKey().equals("endgatgroup"))) {
                rebuildColumns.add(childGroup);
            }
            if (regionsList.contains("R3") && (childGroup.getFieldKey().equals("baseabroadgroup") || childGroup.getFieldKey().equals("endabroadgroup"))) {
                rebuildColumns.add(childGroup);
            }
            if (regionsList.size() <= 1 || !childGroup.getFieldKey().equals("basesumgroup") && !childGroup.getFieldKey().equals("endsumgroup")) continue;
            rebuildColumns.add(childGroup);
        }
        childrenColums.clear();
        childrenColums.addAll(rebuildColumns);
    }

    private boolean validata(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date baseDate = (Date)filterInfo.getFilterItem("filter_basedate").getValue();
        Date endDate = (Date)filterInfo.getFilterItem("filter_cutoffdate").getValue();
        if (EmptyUtil.isEmpty((Object)baseDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u671f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDepositFormListPlugin_9", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u672b\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDepositFormListPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (baseDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u671f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u671f\u672b\u65e5\u671f\u3002", (String)"BankDepositFormListPlugin_11", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String queryWay = (String)filterInfo.getFilterItem("filter_queryway").getValue();
        if ("org".equals(queryWay) && EmptyUtil.isEmpty((Object)filterInfo.getFilterItem("filter_org").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u67e5\u8be2\u65b9\u5f0f\u4e3a\u8d44\u91d1\u7ec4\u7ec7\u65f6\uff0c\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDepositFormListPlugin_13", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String region = (String)filterInfo.getFilterItem("filter_region").getValue();
        if (EmptyUtil.isEmpty((String)region)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5730\u57df\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDepositFormListPlugin_12", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"BankDepositFormListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        queryParam.getCustomParam().put("filter_statcurrency", currency.getPkValue());
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("filter_statdim")) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }
}

