/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.helper.ReportCommonHelper;
import kd.tmc.mon.report.helper.ReportQueryInfo;

public class CreditStructureFormPlugin
extends AbstractReportFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getFilter().addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        this.controlColums(queryParam);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        try {
            ReportQueryInfo queryInfo = ReportCommonHelper.getReportQueryInfo(queryParam, appId, entityName);
            filter.addFilterItem("org", (Object)queryInfo.getOrgRootId());
            filter.addFilterItem("companyviewnum", (Object)queryInfo.getCompanyViewId());
        }
        catch (TmcBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return false;
        }
        Date endDate = queryParam.getFilter().getDate("filter_enddate");
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u672b\u65e5\u671f", (String)"LetterOfGuaStructureFormPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String elem = queryParam.getFilter().getString("filter_elem");
        if (EmptyUtil.isEmpty((String)elem)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u8981\u7d20", (String)"FinStructureFormListPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "filter_banktype": {
                String bankType = (String)this.getModel().getValue("filter_banktype");
                this.getModel().setValue("org".equals(bankType) ? "filter_bank" : "filter_bankorg", null);
                break;
            }
            case "filter_startdate": {
                Date startDate = (Date)this.getModel().getValue("filter_startdate");
                DateEdit control = (DateEdit)this.getView().getControl("filter_enddate");
                if (startDate != null) {
                    control.setMinDate(startDate);
                } else {
                    control.setMinDate(DateUtils.getLastYear((Date)DateUtils.getCurrentDate(), (int)10));
                }
                Date endDate = (Date)this.getModel().getValue("filter_enddate");
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{endDate, startDate}) || !endDate.before(startDate)) break;
                this.getModel().setValue("filter_enddate", null);
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                try {
                    rptFilter.search();
                }
                catch (KDBizException bizEx) {
                    this.getView().showErrorNotification(bizEx.getMessage());
                }
                break;
            }
        }
    }

    private void controlColums(ReportQueryParam param) {
        Date startDate = (Date)param.getFilter().getFilterItem("filter_startdate").getValue();
        String statDim = (String)this.getModel().getValue("filter_statdim");
        String elem = (String)param.getFilter().getFilterItem("filter_elem").getValue();
        LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u6388\u4fe1\u4e3b\u4f53", (String)"CreditStructureFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]));
        if ("bank".equals(statDim)) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u6388\u4fe1\u673a\u6784", (String)"CreditStructureFormPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]));
        } else if ("currency".equals(statDim)) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CreditStructureFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        Iterator iterator = columns.iterator();
        ArrayList<Object> rebuildElemColumns = new ArrayList<Object>(columns.size());
        while (iterator.hasNext()) {
            ReportColumn col;
            AbstractReportColumn column = (AbstractReportColumn)iterator.next();
            if (column instanceof ReportColumn && (col = (ReportColumn)column).getFieldKey().equals("orgname")) {
                col.setCaption(caption);
            }
            if (column instanceof ReportColumnGroup) {
                ReportColumnGroup childFirstGroup = (ReportColumnGroup)column;
                if (elem.contains("creditamt") && "creditamtgroup".equals(childFirstGroup.getFieldKey())) {
                    rebuildElemColumns.add(childFirstGroup);
                }
                if (elem.contains("surplusamt") && "surplusamtgroup".equals(childFirstGroup.getFieldKey())) {
                    rebuildElemColumns.add(childFirstGroup);
                }
                if (elem.contains("useamt") && "useamtgroup".equals(childFirstGroup.getFieldKey())) {
                    rebuildElemColumns.add(childFirstGroup);
                }
                List childrenCol = ((ReportColumnGroup)column).getChildren();
                ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>(childrenCol.size());
                if (!EmptyUtil.isEmpty((Object)startDate)) continue;
                for (AbstractReportColumn childColum : childrenCol) {
                    ReportColumnGroup childGroup;
                    String fieldKey;
                    if (!(childColum instanceof ReportColumnGroup) || !"creditend".equals(fieldKey = (childGroup = (ReportColumnGroup)childColum).getFieldKey()) && !"surplusend".equals(fieldKey) && !"useend".equals(fieldKey)) continue;
                    rebuildColumns.add(childColum);
                    List threeChildren = childGroup.getChildren();
                    Iterator threeItes = threeChildren.iterator();
                    ArrayList<AbstractReportColumn> rebuildThreeColumns = new ArrayList<AbstractReportColumn>(childGroup.getChildren().size());
                    while (threeItes.hasNext()) {
                        String threeKey;
                        AbstractReportColumn threeChild = (AbstractReportColumn)threeItes.next();
                        if (!(threeChild instanceof ReportColumn) || !"creditendamt".equals(threeKey = ((ReportColumn)threeChild).getFieldKey()) && !"creditendrate".equals(threeKey) && !"surplusendamt".equals(threeKey) && !"surplusendrate".equals(threeKey) && !"useendamt".equals(threeKey) && !"useendrate".equals(threeKey)) continue;
                        rebuildThreeColumns.add(threeChild);
                    }
                    threeChildren.clear();
                    threeChildren.addAll(rebuildThreeColumns);
                }
                childrenCol.clear();
                childrenCol.addAll(rebuildColumns);
                continue;
            }
            if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                if (col.getFieldKey().equals("orgname")) {
                    if (!"org".equals(statDim) && !"bank".equals(statDim) && !"currency".equals(statDim)) continue;
                    rebuildElemColumns.add(column);
                    continue;
                }
                if (col.getFieldKey().equals("currency")) continue;
            }
            rebuildElemColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildElemColumns);
    }
}

