/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ExpireBizWarnFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String entityName = "billtype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter().getShowParameter();
        Map customParams = showParameter.getCustomParams();
        this.controlBills(customParams);
        DateEdit dateEidt = (DateEdit)this.getView().getControl("filter_cutoffdate");
        dateEidt.setMinDate(DateUtils.getCurrentDate());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        if (!"custom".equals(queryCutOffDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_cutoffdate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_cutoffdate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_cutoffdate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_cutoffdate"});
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String fieldName = evt.getFieldName();
        if ("billno".equals(fieldName)) {
            this.showbillDetail(rowData);
        } else if ("contractbillno".equals(fieldName)) {
            this.showContractbill(rowData);
        }
    }

    public void showbillDetail(DynamicObject rowData) {
        String billNo = rowData.getString("billno");
        String billType = rowData.getString(entityName);
        BillShowParameter parameter = new BillShowParameter();
        String field = "cfm_creditlimit".equals(billType) ? "number" : "billno";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)this.getEntityName(billType), (String)"id", (QFilter[])new QFilter[]{new QFilter(field, "=", (Object)billNo)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bills)) {
            Long billId = ((DynamicObject)bills.get(0)).getLong("id");
            parameter.setFormId(billType);
            parameter.setPkId((Object)billId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7684\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5", (String)"ExpireBizWarnFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[]{billNo}));
        }
    }

    public void showContractbill(DynamicObject rowData) {
        String contractbillno = rowData.getString("contractbillno");
        BillShowParameter parameter = new BillShowParameter();
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"fl_leasecontractbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)contractbillno)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bills)) {
            Long billId = ((DynamicObject)bills.get(0)).getLong("id");
            parameter.setFormId("fl_leasecontractbill");
            parameter.setPkId((Object)billId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u7684\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5", (String)"ExpireBizWarnFormPlugin_0", (String)"tmc-mon-report", (Object[])new Object[]{contractbillno}));
        }
    }

    private String getEntityName(String billType) {
        switch (billType) {
            case "cfm_loanbill_b_l": 
            case "cfm_loanbill_e_l": {
                return "cfm_loanbill";
            }
        }
        return billType;
    }

    private void controlBills(Map<String, Object> customParams) {
        StringBuilder billTypes = new StringBuilder();
        for (Map.Entry<String, Object> entry : customParams.entrySet()) {
            if (!entry.getKey().contains(entityName)) continue;
            billTypes.append(entry.getValue()).append(",");
        }
        List mulComs = ((MulComboProp)this.getModel().getDataEntityType().getProperties().get((Object)"filter_billtype")).getComboItems();
        Set types = Arrays.stream(billTypes.toString().split(",")).collect(Collectors.toSet());
        Iterator ites = mulComs.iterator();
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>();
        while (ites.hasNext()) {
            ValueMapItem item = (ValueMapItem)ites.next();
            if (!types.contains(item.getValue())) continue;
            itemList.add(new ComboItem(item.getName(), item.getValue()));
        }
        if (EmptyUtil.isEmpty((String)billTypes.toString())) {
            this.getModel().setValue("filter_billtype", (Object)mulComs.stream().map(o -> o.getValue()).collect(Collectors.joining(",")));
            return;
        }
        MulComboEdit mulField = (MulComboEdit)this.getView().getControl("filter_billtype");
        mulField.setComboItems(itemList);
        this.getModel().setValue("filter_billtype", (Object)billTypes);
        if (itemList.size() == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_billtype"});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_cutoffdate", "filter_billtype", "filter_currencyunit", "filter_statcurrency"});
    }
}

