/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinCostCalFormListPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.fillFinanceVar();
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("filter_startdate", (Object)DateUtils.getFirstDayOfCurMonth());
        this.getModel().setValue("filter_cutoffdate", (Object)DateUtils.getCurrentDate());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.registerControl();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("filter_enddatetype".equals(e.getProperty().getName())) {
            if ("today".equals(newValue)) {
                this.getModel().setValue("filter_cutoffdate", (Object)DateUtils.getCurrentDate());
            } else if ("yesterday".equals(newValue)) {
                this.getModel().setValue("filter_cutoffdate", (Object)DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1));
            }
        } else if (e.getProperty().getName().equals("filter_statdim")) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statdim"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"FinCostCalFormListPlugin_03", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd", (String)"FinCostCalFormListPlugin_04", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_currencyunit"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d27\u5e01\u5355\u4f4d", (String)"FinCostCalFormListPlugin_05", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        return this.validata(filterInfo, "filter_startdate", "filter_cutoffdate", "filter_region", "filter_data");
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        filter.addFilterItem("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        filter.addFilterItem("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        String loantype = (String)this.getView().getFormShowParameter().getCustomParam("loantype");
        filter.addFilterItem("loantype", (Object)loantype);
        if ("loan".equals(loantype)) {
            filter.addFilterItem("filter_data", (Object)"cfm");
        } else if ("bond".equals(loantype)) {
            filter.addFilterItem("filter_data", (Object)"bdim");
        } else {
            filter.addFilterItem("filter_data", this.getModel().getValue("filter_data"));
        }
    }

    private boolean validata(FilterInfo filterInfo, String ... props) {
        Date endDate;
        StringBuilder msg = new StringBuilder();
        for (String prop : props) {
            if (!EmptyUtil.isEmpty((Object)filterInfo.getFilterItem(prop).getValue())) continue;
            IDataEntityProperty property = this.getModel().getProperty(prop);
            msg.append(property.getDisplayName()).append("\u3001");
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"FinCostCalFormListPlugin_06", (String)"tmc-mon-report", (Object[])new Object[]{msg.substring(0, msg.length() - 1)}));
            return false;
        }
        Date startDate = (Date)filterInfo.getFilterItem("filter_startdate").getValue();
        if (DateUtils.getDiffDays((Date)startDate, (Date)(endDate = (Date)filterInfo.getFilterItem("filter_cutoffdate").getValue())) <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u76f8\u5dee\u8981\u5927\u4e8e\u7b49\u4e8e1\u5929", (String)"FinCostCalFormListPlugin_02", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"FinCostCalFormListPlugin_07", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String filterData = (String)filterInfo.getFilterItem("filter_data").getValue();
        if (EmptyUtil.isEmpty((String)filterData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinCostCalDataListPlugin_09", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("qinganalysis".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mon_fincostcalqing");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ReportQueryParam param = this.getQueryParam();
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)param));
            view.showForm(showParameter);
        }
    }

    private void registerControl() {
        if (!"mon".equals(this.getView().getFormShowParameter().getAppId())) {
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"filter_data"}, (boolean)false);
        }
    }

    private void fillFinanceVar() {
        BasedataEdit finproductF7 = (BasedataEdit)this.getControl("filter_finproduct");
        finproductF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(new QFilter("isleaf", "=", (Object)"1"));
            String loantype = (String)this.getView().getFormShowParameter().getCustomParam("loantype");
            if ("loan".equals(loantype)) {
                qFilter.and(new QFilter("finsource", "!=", (Object)"bond"));
            } else if ("bond".equals(loantype)) {
                qFilter.and(new QFilter("finsource", "=", (Object)"bond"));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

