/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StadimensionEnum;
import kd.tmc.mon.common.enums.StatisCycleEnum;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;
import kd.tmc.mon.report.helper.ReportCommonHelper;

public class FundFlowFormListPlugin
extends AbstractReportFormPlugin {
    private static final String[] colors = new String[]{"#098BFF", "#29ACE6", "#00CCCC", "#6DD38B", "#87DB3D", "#C7E052", "#FFD72D", "#FFB91A", "#FF9900", "#FF8144", "#FF6666", "#C2489B", "#6733CC", "#511FCC", "#3300CC", "#1F06A3", "#09087C"};

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_fundflow");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        DynamicObject row = null;
        DynamicObject amtcurrencyDy = null;
        String signStr = null;
        for (int i = 0; i < rowData.size(); ++i) {
            row = (DynamicObject)rowData.get(i);
            amtcurrencyDy = (DynamicObject)row.get("amtcurrency");
            signStr = "";
            if (!EmptyUtil.isEmpty((DynamicObject)amtcurrencyDy)) {
                signStr = amtcurrencyDy.getString("sign");
            }
            row.set("creditamount", (Object)(signStr + TmcBusinessBaseHelper.formatDecimal((BigDecimal)new BigDecimal((String)row.get("creditamount")), (int)2)));
            row.set("debitamount", (Object)(signStr + TmcBusinessBaseHelper.formatDecimal((BigDecimal)new BigDecimal((String)row.get("debitamount")), (int)2)));
            row.set("amount", (Object)(signStr + TmcBusinessBaseHelper.formatDecimal((BigDecimal)new BigDecimal((String)row.get("amount")), (int)2)));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = op.getOperateKey();
        ReportShowParameter showParameter = new ReportShowParameter();
        Map<String, Object> paramMap = this.getQueryParam(this.getModel());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(paramMap);
        showParameter.setPageId(this.getView().getPageId() + key);
        if (StringUtils.equals((CharSequence)"supevaluate", (CharSequence)key)) {
            showParameter.setFormId("mon_evalution");
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)"fievaluate", (CharSequence)key)) {
            showParameter.setFormId("mon_finevaluation");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap"});
        this.multiorgsIniF7();
    }

    private void multiorgsIniF7() {
        BasedataEdit multiOrgs = (BasedataEdit)this.getControl("filter_org");
        multiOrgs.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                ListShowParameter customParams = (ListShowParameter)e.getFormShowParameter();
                customParams.setCustomParam("isIncludeAllSub", (Object)true);
                e.setFormShowParameter((FormShowParameter)customParams);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"labelap", (CharSequence)key)) {
            Map<String, Object> paramMap = this.getQueryParam(this.getModel());
            if (this.verifyInfo(paramMap)) {
                DataSet queryDataSet = this.getQueryDataSet(paramMap);
                paramMap.put("labelap", (String)this.getModel().getValue("labelap"));
                boolean haveData = this.dealChart(queryDataSet, paramMap);
                this.getView().setVisible(Boolean.valueOf(haveData), new String[]{"flexpanelap"});
                queryDataSet.close();
            }
        } else if (StringUtils.equals((CharSequence)"filter_queryway", (CharSequence)key)) {
            this.setOrgPropMustInput();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
            return this.verifyInfo(paramMap);
        }
        return super.verifyQuery(queryParam);
    }

    private boolean verifyInfo(Map<String, Object> paramMap) {
        String filterStadimensionCode;
        Object org;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay) && null == (org = paramMap.get("filter_org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundFlowFormListPlugin_27", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        if (EmptyUtil.isEmpty((String)filterStaperiod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5468\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundFlowFormListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            Date bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
            Date bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
            if (EmptyUtil.isEmpty((Object)bookStartDate) || EmptyUtil.isEmpty((Object)bookEndDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundFlowFormListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]));
                return false;
            }
        }
        if (EmptyUtil.isEmpty((String)(filterStadimensionCode = (String)paramMap.get("filter_stadimension")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u7ef4\u5ea6\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundFlowFormListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FundFlowFormListPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
        if (exRateTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMoneyFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)"currency", (QFilter[])this.initQFilter(paramMap), null).groupBy(new String[]{"currency"}).finish();
        ArrayList<Long> sourceCurrencyIdLst = new ArrayList<Long>(10);
        Row row = null;
        while (queryDataSet.hasNext()) {
            row = queryDataSet.next();
            sourceCurrencyIdLst.add(row.getLong("currency"));
        }
        queryDataSet.close();
        return BaseDataHelper.verifyExchangeRate(sourceCurrencyIdLst, (Long)statCurrency.getLong("id"), (Long)TmcOrgDataHelper.getCurrentOrgId(), (Date)new Date(), (AbstractFormPlugin)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        queryParam.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String[] fields = null;
        String filterStadimensionCode = (String)paramMap.get("filter_stadimension");
        String statisStr = ResManager.loadKDString((String)"\u5468\u671f", (String)"FundFlowFormListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]);
        String currencyStr = ResManager.loadKDString((String)"\u4ea4\u6613\u5e01\u79cd", (String)"FundFlowFormListPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]);
        String outamountStr = ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d\uff08\u4e07\u5143\uff09", (String)"FundFlowFormListPlugin_25", (String)"tmc-mon-report", (Object[])new Object[0]);
        String inamountStr = ResManager.loadKDString((String)"\u4ea4\u6613\u7b14\u6570", (String)"FundFlowFormListPlugin_26", (String)"tmc-mon-report", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)StadimensionEnum.CURRENCY.getCode(), (CharSequence)filterStadimensionCode)) {
            fields = new String[]{statisStr, currencyStr, outamountStr, inamountStr};
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.SETTLEMENTTYPE.getCode(), (CharSequence)filterStadimensionCode)) {
            String settlementTypeStr = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"FundFlowFormListPlugin_12", (String)"tmc-mon-report", (Object[])new Object[0]);
            fields = new String[]{statisStr, settlementTypeStr, currencyStr, outamountStr, inamountStr};
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.RECPAYTYPEID.getCode(), (CharSequence)filterStadimensionCode)) {
            String paymentTypeStr = ResManager.loadKDString((String)"\u6536\u4ed8\u6b3e\u7c7b\u578b", (String)"FundFlowFormListPlugin_13", (String)"tmc-mon-report", (Object[])new Object[0]);
            fields = new String[]{statisStr, paymentTypeStr, currencyStr, outamountStr, inamountStr};
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            String fundTypeStr = ResManager.loadKDString((String)"\u8d44\u91d1\u7528\u9014", (String)"FundFlowFormListPlugin_14", (String)"tmc-mon-report", (Object[])new Object[0]);
            fields = new String[]{statisStr, fundTypeStr, currencyStr, outamountStr, inamountStr};
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>();
        if (fields != null) {
            String field = null;
            for (int i = 0; i < fields.length; ++i) {
                field = fields[i].trim();
                for (AbstractReportColumn column : columns) {
                    if (!column.getCaption().toString().equalsIgnoreCase(field)) continue;
                    rebuildColumns.add(column);
                }
            }
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgPropMustInput();
    }

    private void setOrgPropMustInput() {
        boolean isMustInput = ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"));
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"filter_org"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String updateType = (String)this.getModel().getValue("labelap");
        paramMap.put("labelap", updateType);
        DataSet queryDataSet = this.getQueryDataSet(paramMap);
        boolean haveData = this.dealChart(queryDataSet, paramMap);
        if (haveData) {
            this.dealPieChart(queryDataSet, paramMap);
        }
        this.getView().setVisible(Boolean.valueOf(haveData), new String[]{"flexpanelap"});
        queryDataSet.close();
    }

    private boolean dealChart(DataSet queryDataSet, Map<String, Object> paramMap) {
        boolean haveData = true;
        String updateType = (String)paramMap.get("labelap");
        DataSet drawChartDataSet = this.getDrawChartDataSet(queryDataSet, paramMap);
        ArrayList<Object[]> chartDataList = new ArrayList<Object[]>(10);
        Object[] o = null;
        Row row = null;
        while (drawChartDataSet.hasNext()) {
            row = drawChartDataSet.next();
            o = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                o[i] = row.get(i);
            }
            chartDataList.add(o);
        }
        drawChartDataSet.close();
        if (!EmptyUtil.isEmpty(chartDataList)) {
            this.drawChart(updateType, chartDataList);
        } else {
            haveData = false;
        }
        return haveData;
    }

    private void dealPieChart(DataSet queryDataSet, Map<String, Object> paramMap) {
        DataSet drawPieChartDataSet = this.getDrawPieChartDataSet(queryDataSet, paramMap);
        ArrayList<Object[]> chartDataList = new ArrayList<Object[]>(10);
        Object[] o = null;
        Row row = null;
        while (drawPieChartDataSet.hasNext()) {
            row = drawPieChartDataSet.next();
            o = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                o[i] = row.get(i);
            }
            chartDataList.add(o);
        }
        drawPieChartDataSet.close();
        this.drawPieChart(chartDataList);
    }

    private void drawPieChart(List<Object[]> chartDataList) {
        if (!EmptyUtil.isEmpty(chartDataList)) {
            ItemValue[] items = new ItemValue[chartDataList.size()];
            ItemValue tempValue = null;
            String name = null;
            BigDecimal number = null;
            for (int i = 0; i < chartDataList.size(); ++i) {
                number = (BigDecimal)chartDataList.get(i)[0];
                name = (String)chartDataList.get(i)[1];
                name = EmptyUtil.isNotEmpty((CharSequence)name) ? name : ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FundFlowFormListPlugin_16", (String)"tmc-mon-report", (Object[])new Object[0]);
                items[i] = tempValue = new ItemValue(name, (Number)number.setScale(6, 4), colors[i % colors.length]);
            }
            PieChart pieChart = (PieChart)this.getControl("piechartap");
            pieChart.clearData();
            pieChart.setShowTooltip(true);
            pieChart.setShowLegend(true);
            PieSeries series = pieChart.createPieSeries("");
            series.setData(items);
            series.setRadius("0%", "50%");
            series.setCenter("20%", "50%");
            pieChart.addTooltip("formatter", (Object)"{b0}: {d0}%");
            pieChart.setLegendPropValue("orient", (Object)"vertical");
            pieChart.setLegendPropValue("x", (Object)"right");
            pieChart.refresh();
        }
    }

    private void drawChart(String type, List<Object[]> chartDataList) {
        HistogramChart customchart = this.getMainChart();
        customchart.clearData();
        customchart.setMargin(Position.right, "110");
        customchart.setShowLegend(true);
        customchart.setLegendPropValue("left", (Object)"82%");
        customchart.setLegendPropValue("top", (Object)0);
        customchart.setLegendVertical(false);
        List<String> XData = this.getXData(chartDataList);
        Map<Group, List<Object>> YData = this.getYData(type, chartDataList);
        YData.forEach((group, data) -> this.createBarSeries((Group)group, (List<Object>)data));
        Axis xAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u5468\u671f", (String)"FundFlowFormListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]), false);
        xAxis.setCategorys(XData);
        xAxis.setMax((Number)(XData.size() - 1));
        HashMap axisLabelx = Maps.newHashMap();
        axisLabelx.put("rotate", "0");
        xAxis.setPropValue("axisLabel", (Object)axisLabelx);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", Boolean.TRUE);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        xAxisLabel.setShow(true);
        xAxisLabel.setBackgroundColor("black");
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        Axis yAxis = this.createValueAxis("amount".equals(type) ? ResManager.loadKDString((String)"\u91d1\u989d(\u4e07\u5143)", (String)"FundFlowFormListPlugin_18", (String)"tmc-mon-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b14\u6570(\u7b14)", (String)"FundFlowFormListPlugin_19", (String)"tmc-mon-report", (Object[])new Object[0]), true);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", "{value}");
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", Boolean.TRUE);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", Boolean.FALSE);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customchart.refresh();
    }

    private void createBarSeries(Group group, List<Object> data) {
        BarSeries barSeries = this.getMainChart().createBarSeries(group.groupName);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setBarWidth("10px");
        barSeries.setColor(group.color);
        barSeries.setType(group.chartType);
        barSeries.setAnimationDuration(2000);
        barSeries.setPropValue("yAxisIndex", (Object)group.yAxisIndex);
        barSeries.setData(data.toArray(new Number[0]));
    }

    private List<String> getXData(List<Object[]> chartDataList) {
        ArrayList<String> XData = new ArrayList<String>();
        if (EmptyUtil.isNoEmpty(chartDataList)) {
            for (int i = 0; i < chartDataList.size(); ++i) {
                XData.add((String)chartDataList.get(i)[0]);
            }
        }
        return XData;
    }

    private Map<Group, List<Object>> getYData(String type, List<Object[]> chartDataList) {
        LinkedHashMap<Group, List<Object>> summaryResult = new LinkedHashMap<Group, List<Object>>();
        if (EmptyUtil.isNoEmpty(chartDataList)) {
            ArrayList<Object> outList = new ArrayList<Object>(10);
            String outStr = "";
            String inStr = "";
            boolean amountFalg = false;
            if (StringUtils.equals((CharSequence)"amount", (CharSequence)type)) {
                outStr = ResManager.loadKDString((String)"\u652f\u51fa\u91d1\u989d", (String)"FundFlowFormListPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]);
                inStr = ResManager.loadKDString((String)"\u6536\u5165\u91d1\u989d", (String)"FundFlowFormListPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]);
                amountFalg = true;
            } else {
                outStr = ResManager.loadKDString((String)"\u652f\u51fa\u7b14\u6570", (String)"FundFlowFormListPlugin_9", (String)"tmc-mon-report", (Object[])new Object[0]);
                inStr = ResManager.loadKDString((String)"\u6536\u5165\u7b14\u6570", (String)"FundFlowFormListPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            Object o = null;
            for (int i = 0; i < chartDataList.size(); ++i) {
                o = chartDataList.get(i)[1];
                if (amountFalg) {
                    outList.add(((BigDecimal)o).setScale(2, 4));
                    continue;
                }
                outList.add(o);
            }
            summaryResult.put(new Group(outStr, "#56ffaa", ChartType.bar, 0), outList);
            ArrayList<Object> inList = new ArrayList<Object>(10);
            for (int i = 0; i < chartDataList.size(); ++i) {
                o = chartDataList.get(i)[2];
                if (amountFalg) {
                    inList.add(((BigDecimal)o).setScale(2, 4));
                    continue;
                }
                inList.add(o);
            }
            summaryResult.put(new Group(inStr, "#56aaff", ChartType.bar, 0), inList);
        }
        return summaryResult;
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#5F9EA0");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#5F9EA0");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private QFilter[] initQFilter(Map<String, Object> paramMap) {
        String datasource;
        QFilter qFilterCurrency;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        DynamicObjectCollection filterCurrency = (DynamicObjectCollection)paramMap.get("filter_currency");
        DynamicObjectCollection filterSettlementtype = (DynamicObjectCollection)paramMap.get("filter_settlementtype");
        DynamicObjectCollection filterIntype = (DynamicObjectCollection)paramMap.get("filter_intype");
        DynamicObjectCollection filterOuttype = (DynamicObjectCollection)paramMap.get("filter_outtype");
        DynamicObjectCollection filterFunduse = (DynamicObjectCollection)paramMap.get("filter_funduse");
        Date bookStartDate = null;
        Date bookEndDate = null;
        Boolean isToDay = Boolean.FALSE;
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurYear();
            bookEndDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurMonth();
            bookEndDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = currDate;
            bookEndDate = DateUtils.getNextDay((Date)currDate, (int)1);
            isToDay = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
            bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
            bookEndDate = DateUtils.getNextDay((Date)bookEndDate, (int)1);
        } else {
            bookStartDate = DateUtils.getFirstYearDate((Date)currDate);
            bookEndDate = DateUtils.getLastYearDate((Date)currDate);
        }
        boolean statsInnerAcct = (Boolean)paramMap.get("statsinneracct");
        if (!statsInnerAcct) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{acctFilter});
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter innerAcctFilter = new QFilter("accountbank", "in", acctIds);
            filter.add(innerAcctFilter);
        }
        paramMap.put("isToday", isToDay);
        QFilter qFilterBookStartDate = new QFilter(isToDay != false ? "createtime" : "bookdate", ">=", (Object)bookStartDate);
        QFilter qFilterBookEndDate = new QFilter(isToDay != false ? "createtime" : "bookdate", "<", (Object)bookEndDate);
        filter.add(qFilterBookStartDate);
        filter.add(qFilterBookEndDate);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCurrency)) {
            qFilterCurrency = new QFilter("currency", "in", filterCurrency.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterSettlementtype)) {
            qFilterCurrency = new QFilter("settlementtype", "in", filterSettlementtype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype) || EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
            QFilter qFilterRecpaytype = null;
            List recpaytypeList = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterIntype)) {
                recpaytypeList = filterIntype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                qFilterRecpaytype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_receivingbilltype"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOuttype)) {
                recpaytypeList = filterOuttype.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList());
                QFilter qFilterPaymenttype = new QFilter("recpaytypeid", "in", recpaytypeList).and(new QFilter("recpaytype", "=", (Object)"cas_paymentbilltype"));
                if (qFilterRecpaytype != null) {
                    qFilterRecpaytype.or(qFilterPaymenttype);
                } else {
                    qFilterRecpaytype = qFilterPaymenttype;
                }
            }
            filter.add(qFilterRecpaytype);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterFunduse)) {
            QFilter qFilterFundflowitem = new QFilter("entry.e_fundflowitem", "in", filterFunduse.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterFundflowitem);
        }
        if ("directconnacct".equals(datasource = (String)paramMap.get("datasource"))) {
            ArrayList<String> typeList = new ArrayList<String>(2);
            QFilter qFilter = new QFilter("accountbank.issetbankinterface", "=", (Object)"0");
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter1 = new QFilter("accountbank.finorgtype", "not in", typeList);
            filter.add(qFilter.and(qFilter1));
        }
        QFilter qFilterOrg = new QFilter("org", "in", this.getOrgIds());
        filter.add(qFilterOrg);
        filter.add(VisibleVirtualAcctHelper.notVirtualAcctQfTOBankJournal());
        filter.add(new QFilter("accountbank.isvirtual", "=", (Object)"0"));
        return filter.toArray(new QFilter[filter.size()]);
    }

    private List<Long> getOrgIds() {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = parameter.getFormId();
        String appId = parameter.getAppId();
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = this.getOrgPropValues();
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = this.getOrgPropValues();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
        }
        return orgIds;
    }

    private List<Long> getOrgPropValues() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
            return Collections.EMPTY_LIST;
        }
        return orgs.stream().map(v -> (Long)v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
    }

    private Map<String, Object> getQueryParam(IDataModel iDataModel) {
        Object companymulbdfieldObj;
        DynamicObject extraTable;
        Object funduseObject;
        Object outtypeObject;
        Object intypeObject;
        Object settlementtypeObject;
        Object currencyObject;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("filter_staperiod", iDataModel.getValue("filter_staperiod"));
        paramMap.put("filter_stadimension", iDataModel.getValue("filter_stadimension"));
        Object statCurrency = iDataModel.getValue("filter_statcurrency");
        paramMap.put("filter_statcurrency", statCurrency);
        DynamicObject repcurrencyDy = null;
        if (EmptyUtil.isNoEmpty((Object)statCurrency)) {
            repcurrencyDy = (DynamicObject)statCurrency;
            paramMap.put("filter_repcurrency_id", repcurrencyDy.getLong("id"));
        }
        if ((currencyObject = iDataModel.getValue("filter_currency")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection currencyDy = (DynamicObjectCollection)currencyObject;
            currencyDy = currencyDy.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_currency", currencyDy);
            paramMap.put("filter_currency_id", currencyDy.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).toArray());
        }
        if ((settlementtypeObject = iDataModel.getValue("filter_settlementtype")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection settlementtypeDy = (DynamicObjectCollection)settlementtypeObject;
            settlementtypeDy = settlementtypeDy.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_settlementtype", settlementtypeDy);
        }
        if ((intypeObject = iDataModel.getValue("filter_intype")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection intypeDy = (DynamicObjectCollection)intypeObject;
            intypeDy = intypeDy.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_intype", intypeDy);
        }
        if ((outtypeObject = iDataModel.getValue("filter_outtype")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection outtypeDy = (DynamicObjectCollection)outtypeObject;
            outtypeDy = outtypeDy.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_outtype", outtypeDy);
        }
        if ((funduseObject = iDataModel.getValue("filter_funduse")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection funduseDy = (DynamicObjectCollection)funduseObject;
            funduseDy = funduseDy.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_funduse", funduseDy);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(extraTable = (DynamicObject)iDataModel.getValue("exratetable")))) {
            paramMap.put("exratetable", extraTable);
            paramMap.put("exratetable_id", extraTable.getLong("id"));
        }
        paramMap.put("datasource", iDataModel.getValue("datasource"));
        paramMap.put("statsinneracct", iDataModel.getValue("statsinneracct"));
        paramMap.put("filter_perioddate_startdate", iDataModel.getValue("filter_perioddate_startdate"));
        paramMap.put("filter_perioddate_enddate", iDataModel.getValue("filter_perioddate_enddate"));
        paramMap.put("filter_queryway", iDataModel.getValue("filter_queryway"));
        DynamicObject orgView = (DynamicObject)iDataModel.getValue("filter_orgview");
        if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
            paramMap.put("filter_orgview", orgView);
            paramMap.put("filter_orgview_id", orgView.getLong("id"));
        }
        if ((companymulbdfieldObj = iDataModel.getValue("filter_org")) instanceof DynamicObjectCollection) {
            DynamicObjectCollection companymulbdfield = (DynamicObjectCollection)companymulbdfieldObj;
            companymulbdfield = companymulbdfield.stream().map(e -> e.getDynamicObject(1)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            paramMap.put("filter_org", companymulbdfield);
            paramMap.put("filter_org_id", companymulbdfield.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).toArray());
        }
        return paramMap;
    }

    private DataSet getQueryDataSet(Map<String, Object> paramMap) {
        QFilter[] qFilters = this.initQFilter(paramMap);
        String filterStadimensionCode = (String)paramMap.get("filter_stadimension");
        Boolean isToday = (Boolean)paramMap.get("isToday");
        String selectFiled = "";
        String orderBys = "";
        String transDetailGroupBy = "";
        if (StringUtils.equals((CharSequence)StadimensionEnum.CURRENCY.getCode(), (CharSequence)filterStadimensionCode)) {
            selectFiled = "createtime,currency,debitamount,creditamount";
            orderBys = "currency desc";
            transDetailGroupBy = "bizdate as createtime,currency";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.SETTLEMENTTYPE.getCode(), (CharSequence)filterStadimensionCode)) {
            selectFiled = "createtime,settlementtype,currency,debitamount,creditamount";
            orderBys = "settlementtype desc";
            transDetailGroupBy = "bizdate as createtime,0 as settlementtype,currency";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.RECPAYTYPEID.getCode(), (CharSequence)filterStadimensionCode)) {
            selectFiled = "createtime,recpaytype,recpaytypeid,currency,debitamount,creditamount";
            orderBys = "recpaytype desc,recpaytypeid desc";
            transDetailGroupBy = "bizdate as createtime,'' as recpaytype,0 as recpaytypeid,currency";
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            selectFiled = "createtime,entry.e_fundflowitem as entrye_fundflowitem,entry.e_amount as entrye_amount,entry.e_currency entrye_currency,currency,debitamount,creditamount";
            orderBys = "entry.e_fundflowitem desc";
            transDetailGroupBy = "bizdate as createtime,0 as entrye_fundflowitem,0 as entrye_amount,0 as entrye_currency,currency";
        }
        String dataSource = (String)paramMap.get("datasource");
        DataSet queryDataSet = null;
        switch (dataSource) {
            case "bankbalance": {
                StringBuilder selectFileds = new StringBuilder();
                selectFileds.append(transDetailGroupBy).append(",creditamount debitamount,debitamount creditamount");
                queryDataSet = this.queryTransDetail(paramMap, selectFileds.toString());
                break;
            }
            case "directconnacct": {
                DataSet queryJournal = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)(isToday != false ? selectFiled : selectFiled.replace("createtime", "bookdate as createtime")), (QFilter[])qFilters, (String)orderBys);
                StringBuilder selectFileds = new StringBuilder();
                selectFileds.append(transDetailGroupBy).append(",creditamount debitamount,debitamount creditamount");
                DataSet queryTransDetail = this.queryTransDetail(paramMap, selectFileds.toString());
                queryDataSet = queryJournal.union(queryTransDetail);
                break;
            }
            default: {
                queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_bankjournal", (String)(isToday != false ? selectFiled : selectFiled.replace("createtime", "bookdate as createtime")), (QFilter[])qFilters, (String)orderBys);
            }
        }
        if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            StringBuilder selectFileds = new StringBuilder();
            selectFileds.setLength(0);
            selectFileds.append("createtime");
            selectFileds.append(",entrye_fundflowitem");
            selectFileds.append(",case when debitamount > 0 then case when entrye_fundflowitem = 0 then debitamount else entrye_amount end else 0 end debitamount");
            selectFileds.append(",case when creditamount > 0 then case when entrye_fundflowitem = 0 then creditamount else entrye_amount end else 0 end creditamount");
            selectFileds.append(",case when entrye_fundflowitem = 0 then currency else entrye_currency end currency");
            queryDataSet = queryDataSet.select(selectFileds.toString());
            selectFiled = "createtime,entrye_fundflowitem,currency,debitamount,creditamount";
        }
        DataSet currencySet = queryDataSet.copy().groupBy(new String[]{"currency"}).sum("debitamount", "exchrate").finish();
        Date today = new Date();
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(currencySet.getRowMeta());
        Long reportCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        BigDecimal tempRate = null;
        Object[] rowData = null;
        Row row = null;
        Long currency = null;
        Long exchangeRateTableId = ((DynamicObject)paramMap.get("exratetable")).getLong("id");
        while (currencySet.hasNext()) {
            rowData = new Object[2];
            row = currencySet.next();
            currency = row.getLong("currency");
            rowData[1] = reportCurrencyId.equals(currency) ? BigDecimal.ONE : (EmptyUtil.isNoEmpty((BigDecimal)(tempRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)currency, (Long)reportCurrencyId, (Date)today))) ? tempRate : BigDecimal.ZERO);
            rowData[0] = currency;
            rowData[1] = EmptyUtil.isNoEmpty((BigDecimal)tempRate) ? tempRate : BigDecimal.ONE;
            datasetBuilder.append(rowData);
        }
        DataSet exchDataSet = datasetBuilder.build();
        queryDataSet = queryDataSet.join(exchDataSet, JoinType.LEFT).on("currency", "currency").select(selectFiled.split(","), new String[]{"exchrate"}).finish();
        queryDataSet = queryDataSet.select(selectFiled.replace("debitamount", "debitamount * exchrate debitamount").replace("creditamount", "creditamount * exchrate creditamount"));
        return queryDataSet;
    }

    private DataSet queryTransDetail(Map<String, Object> paramMap, String selectFileds) {
        QFilter[] transDetailFilters = this.initTransDetailFilters(paramMap);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bei_transdetail", (String)selectFileds, (QFilter[])transDetailFilters, null);
        return queryDataSet;
    }

    private QFilter[] initTransDetailFilters(Map<String, Object> paramMap) {
        boolean statsInnerAcct;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        DynamicObjectCollection filterCurrency = (DynamicObjectCollection)paramMap.get("filter_currency");
        Date bookStartDate = null;
        Date bookEndDate = null;
        Boolean isToDay = Boolean.FALSE;
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurYear();
            bookEndDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            bookEndDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = DateUtils.getFirstDayOfCurMonth();
            bookEndDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = currDate;
            bookEndDate = DateUtils.getNextDay((Date)currDate, (int)1);
            isToDay = Boolean.TRUE;
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod)) {
            bookStartDate = (Date)paramMap.get("filter_perioddate_startdate");
            bookEndDate = (Date)paramMap.get("filter_perioddate_enddate");
            bookEndDate = DateUtils.getNextDay((Date)bookEndDate, (int)1);
        } else {
            bookStartDate = DateUtils.getFirstYearDate((Date)currDate);
            bookEndDate = DateUtils.getLastYearDate((Date)currDate);
        }
        ArrayList<QFilter> acctBankFilter = new ArrayList<QFilter>(2);
        String datasource = (String)paramMap.get("datasource");
        if ("directconnacct".equals(datasource)) {
            ArrayList<String> typeList = new ArrayList<String>(2);
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            QFilter qFilter1 = new QFilter("finorgtype", "in", typeList);
            acctBankFilter.add(qFilter.or(qFilter1));
        }
        if (!(statsInnerAcct = ((Boolean)paramMap.get("statsinneracct")).booleanValue())) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            acctBankFilter.add(acctFilter);
        }
        if (acctBankFilter.size() > 0) {
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])acctBankFilter.toArray(new QFilter[acctBankFilter.size()]));
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter acctFilter = new QFilter("accountbank.id", "in", acctIds);
            filter.add(acctFilter);
        }
        paramMap.put("isToday", isToDay);
        QFilter qFilterStartDate = new QFilter("bizdate", ">=", (Object)bookStartDate);
        QFilter qFilterEndDate = new QFilter("bizdate", "<", (Object)bookEndDate);
        filter.add(qFilterStartDate);
        filter.add(qFilterEndDate);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCurrency)) {
            QFilter qFilterCurrency = new QFilter("currency", "in", filterCurrency.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filter.add(qFilterCurrency);
        }
        QFilter qFilterOrg = new QFilter("company", "in", this.getOrgIds());
        filter.add(qFilterOrg);
        filter.add(VisibleVirtualAcctHelper.notVirtualAcctQfTOBankJournal());
        filter.add(new QFilter("accountbank.isvirtual", "=", (Object)"0"));
        return filter.toArray(new QFilter[filter.size()]);
    }

    private DataSet getDrawPieChartDataSet(DataSet queryDataSet, Map<String, Object> paramMap) {
        String filterStadimensionCode = (String)paramMap.get("filter_stadimension");
        DataSet drawPieChartDataSet = null;
        String[] leftFiled = null;
        String[] resultFiled = null;
        if (StringUtils.equals((CharSequence)StadimensionEnum.CURRENCY.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet queryCurrencyDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[0], null);
            leftFiled = new String[]{"amount"};
            resultFiled = new String[]{"name"};
            drawPieChartDataSet = queryDataSet.copy().groupBy(new String[]{"currency"}).sum("(debitamount + creditamount)/10000", "amount").finish().orderBy(new String[]{"currency desc"}).join(queryCurrencyDataSet, JoinType.LEFT).on("currency", "id").select(leftFiled, resultFiled).finish();
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.SETTLEMENTTYPE.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet querySettlementtypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_settlementtype", (String)"id,name", (QFilter[])new QFilter[0], null);
            leftFiled = new String[]{"amount"};
            resultFiled = new String[]{"name"};
            drawPieChartDataSet = queryDataSet.copy().groupBy(new String[]{"settlementtype"}).sum("(debitamount + creditamount)/10000", "amount").finish().orderBy(new String[]{"settlementtype desc"}).join(querySettlementtypeDataSet, JoinType.LEFT).on("settlementtype", "id").select(leftFiled, resultFiled).finish();
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.RECPAYTYPEID.getCode(), (CharSequence)filterStadimensionCode)) {
            DataSet groupByDataSet = queryDataSet.copy().groupBy(new String[]{"recpaytype", "recpaytypeid"}).sum("(debitamount + creditamount)/10000", "amount").finish().orderBy(new String[]{"recpaytypeid desc"});
            resultFiled = new String[]{"amount"};
            leftFiled = new String[]{"name"};
            DataSet receivingDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_receivingbilltype", (String)"id,name", (QFilter[])new QFilter[0], null);
            receivingDataSet = groupByDataSet.copy().where(" recpaytype = 'cas_receivingbilltype' ").join(receivingDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(resultFiled, leftFiled).finish();
            DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_paymentbilltype", (String)"id,name", (QFilter[])new QFilter[0], null);
            paymentDataSet = groupByDataSet.copy().where(" recpaytype = 'cas_paymentbilltype' ").join(paymentDataSet, JoinType.LEFT).on("recpaytypeid", "id").select(resultFiled, leftFiled).finish();
            DataSet otherDataSet = groupByDataSet.where(" recpaytype not in ('cas_receivingbilltype' , 'cas_paymentbilltype') ");
            otherDataSet = otherDataSet.select(" amount,'' name ");
            drawPieChartDataSet = receivingDataSet.union(new DataSet[]{paymentDataSet, otherDataSet});
        } else if (StringUtils.equals((CharSequence)StadimensionEnum.FUNDFLOWITEM.getCode(), (CharSequence)filterStadimensionCode)) {
            leftFiled = new String[]{"amount"};
            resultFiled = new String[]{"name"};
            DataSet queryFundflowitemDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_fundflowitem", (String)"id,name", (QFilter[])new QFilter[0], null);
            drawPieChartDataSet = queryDataSet.copy().groupBy(new String[]{"entrye_fundflowitem"}).sum("(debitamount + creditamount)/10000", "amount").finish().join(queryFundflowitemDataSet, JoinType.LEFT).on("entrye_fundflowitem", "id").select(leftFiled, resultFiled).finish();
        }
        return drawPieChartDataSet;
    }

    private DataSet getDrawChartDataSet(DataSet queryDataSet, Map<String, Object> paramMap) {
        String dataFmt = null;
        String filterStaperiod = (String)paramMap.get("filter_staperiod");
        String hourStr = ResManager.loadKDString((String)"\u65f6", (String)"FundFlowFormListPlugin_24", (String)"tmc-mon-report", (Object[])new Object[0]);
        dataFmt = StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM" : (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM" : (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod) ? "HH" : (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterStaperiod) ? "YYYY-MM-dd" : "YYYY-MM")))));
        StringBuilder selectFiledSb = new StringBuilder();
        selectFiledSb.append("to_char(createtime, '").append(dataFmt).append("') createtime").append(",debitamount,creditamount");
        DataSet toCharDataSet = queryDataSet.copy().select(selectFiledSb.toString());
        if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterStaperiod)) {
            selectFiledSb.setLength(0);
            selectFiledSb.append("case when Cast(createtime as Integer) < 8 then '08:00").append(hourStr).append("' else createtime + ':00").append(hourStr).append("' end createtime").append(",debitamount,creditamount");
            toCharDataSet = toCharDataSet.select(selectFiledSb.toString());
        }
        String updateType = (String)paramMap.get("labelap");
        selectFiledSb.setLength(0);
        DataSet drawChartDataSet = null;
        if (StringUtils.equals((CharSequence)"amount", (CharSequence)updateType)) {
            selectFiledSb.append("createtime,debitamount/10000 debitamount,creditamount/10000 creditamount");
            drawChartDataSet = toCharDataSet.select(selectFiledSb.toString()).groupBy(new String[]{"createtime"}).sum("creditamount").sum("debitamount").finish();
        } else {
            selectFiledSb.append("createtime,case when creditamount > 0 then 1  else 0 end outamountcount,case when debitamount > 0 then 1  else 0 end inamountcount");
            drawChartDataSet = toCharDataSet.select(selectFiledSb.toString()).groupBy(new String[]{"createtime"}).sum("outamountcount").sum("inamountcount").finish();
        }
        toCharDataSet.close();
        return drawChartDataSet;
    }

    static class Group {
        private String groupName;
        private String color;
        private ChartType chartType;
        private Integer yAxisIndex;

        public Group(String groupName, String color, ChartType chartType, Integer yAxisIndex) {
            this.groupName = groupName;
            this.color = color;
            this.chartType = chartType;
            this.yAxisIndex = yAxisIndex;
        }
    }
}

