/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.EndDateTypeEnum;

public class GuaranteeStructFormListPlugin
extends AbstractReportFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_enddatetype": {
                this.handleEndDateType();
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                rptFilter.search();
                break;
            }
        }
    }

    private void handleEndDateType() {
        String endDateType = (String)this.getModel().getValue("filter_enddatetype");
        EndDateTypeEnum endDateTypeEnum = EndDateTypeEnum.getEndDateTypeEnum((String)endDateType);
        if (endDateTypeEnum != null) {
            endDateTypeEnum.setDate("filter_cutoffdate", this.getModel());
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        queryParam.getCustomParam().put("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        queryParam.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
        queryParam.getCustomParam().put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        this.controlTableColumns();
    }

    private void controlTableColumns() {
        String dimension = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        switch (dimension) {
            case "guaranteeorgtext": {
                col.add("guaranteeway");
                break;
            }
            case "guaranteeway": {
                col.add("guaranteeorgtext");
                break;
            }
            default: {
                col.add("guaranteeway");
            }
        }
        List columns = listTable.getColumns();
        columns.removeIf(columm -> {
            if (columm instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)columm;
                return col.contains(reportColumn.getFieldKey());
            }
            return false;
        });
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statdim"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"GuaranteeStructFormListPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd", (String)"GuaranteeStructFormListPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_currencyunit"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d27\u5e01\u5355\u4f4d", (String)"GuaranteeStructFormListPlugin_5", (String)"tmc-gm-report", (Object[])new Object[0]));
            return false;
        }
        Date baseDate = (Date)filters.getFilterItem("filter_basedate").getValue();
        if (EmptyUtil.isEmpty((Object)baseDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u671f\u65e5\u671f", (String)"GuaranteeStructFormListPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Date cutOffDate = (Date)filters.getFilterItem("filter_cutoffdate").getValue();
        if (EmptyUtil.isEmpty((Object)cutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u672b\u65e5\u671f", (String)"GuaranteeStructFormListPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (baseDate.after(cutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u671f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u671f\u672b\u65e5\u671f", (String)"GuaranteeStructFormListPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

