/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.helper.FinReportHelper;

public class LetterCreditFormListPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject baseCurrency;
        long orgId = RequestContext.get().getOrgId();
        if (EmptyUtil.isNoEmpty((Long)orgId) && EmptyUtil.isNoEmpty((DynamicObject)(baseCurrency = FinReportHelper.getBaseCurrency(orgId)))) {
            this.getModel().setValue("filter_statcurrency", baseCurrency.getPkValue());
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (!this.validata(filterInfo)) {
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if ("orgview".equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)param.getFilter().getFilterItem("filter_orgview").getValue();
            param.getFilter().addFilterItem("org", (Object)TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id")));
        } else {
            param.getFilter().addFilterItem("org", (Object)RequestContext.get().getOrgId());
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        param.getCustomParam().put("filter_statcurrency", currency.getPkValue());
        this.controlColums(param, statdim);
    }

    private void controlColums(ReportQueryParam param, String statdim) {
        LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba", (String)"LetterCreditFormListPlugin_13", (String)"tmc-mon-report", (Object[])new Object[0]));
        if (statdim.equals("bank")) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u5f00\u8bc1\u884c", (String)"LetterCreditFormListPlugin_14", (String)"tmc-mon-report", (Object[])new Object[0]));
        } else if (statdim.equals("currency")) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"LetterCreditFormListPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]));
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        String elems = (String)param.getFilter().getFilterItem("filter_elem").getValue();
        if (EmptyUtil.isEmpty((String)elems)) {
            return;
        }
        List elemsList = Arrays.asList(elems.split(",")).stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        Date baseDate = (Date)param.getFilter().getFilterItem("filter_basedate").getValue();
        boolean isBaseDateNull = EmptyUtil.isEmpty((Object)baseDate);
        List columns = listTable.getColumns();
        ArrayList<Object> newCols = new ArrayList<Object>(columns.size());
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                if (col.getFieldKey().equals("orgname")) {
                    col.setCaption(caption);
                    newCols.add(col);
                } else {
                    newCols.add(column);
                }
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            if (elemsList.contains("unpaidamt") && "unpaidamtgroup".equals(((ReportColumnGroup)column).getFieldKey())) {
                this.rebuildChildGroup((ReportColumnGroup)column, isBaseDateNull);
                newCols.add(column);
            }
            if (!elemsList.contains("paidamt") || !"paidamtgroup".equals(((ReportColumnGroup)column).getFieldKey())) continue;
            this.rebuildChildGroup((ReportColumnGroup)column, isBaseDateNull);
            newCols.add(column);
        }
        columns.clear();
        columns.addAll(newCols);
    }

    private void rebuildChildGroup(ReportColumnGroup group, boolean isBaseDateNull) {
        List childrenColums = group.getChildren();
        ArrayList<ReportColumnGroup> rebuildColumns = new ArrayList<ReportColumnGroup>(childrenColums.size());
        for (AbstractReportColumn childColumn : childrenColums) {
            if (!(childColumn instanceof ReportColumnGroup)) continue;
            ReportColumnGroup childGroup = (ReportColumnGroup)childColumn;
            if (!isBaseDateNull) {
                rebuildColumns.add(childGroup);
                continue;
            }
            if (childGroup.getFieldKey().contains("start")) continue;
            this.rebuildChildGroup(childGroup);
            rebuildColumns.add(childGroup);
        }
        childrenColums.clear();
        childrenColums.addAll(rebuildColumns);
    }

    private void rebuildChildGroup(ReportColumnGroup group) {
        List childrenColums = group.getChildren();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>(childrenColums.size());
        Iterator iterator = childrenColums.iterator();
        List<String> list = Arrays.asList("arrivalchangeamt", "arrivalchangerate", "paidchangeamt", "paidchangerate");
        while (iterator.hasNext()) {
            ReportColumn col;
            AbstractReportColumn column = (AbstractReportColumn)iterator.next();
            if (!(column instanceof ReportColumn) || list.contains((col = (ReportColumn)column).getFieldKey())) continue;
            rebuildColumns.add(column);
        }
        childrenColums.clear();
        childrenColums.addAll(rebuildColumns);
    }

    private boolean validata(FilterInfo filterInfo) {
        Date baseDate = (Date)filterInfo.getFilterItem("filter_basedate").getValue();
        Date endDate = (Date)filterInfo.getFilterItem("filter_cutoffdate").getValue();
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u672b\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditFormListPlugin_10", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isNoEmpty((Object)baseDate) && baseDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u671f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u671f\u672b\u65e5\u671f\u3002", (String)"LetterCreditFormListPlugin_11", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        String elem = (String)filterInfo.getFilterItem("filter_elem").getValue();
        if (EmptyUtil.isEmpty((String)elem)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterCreditFormListPlugin_12", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("filter_statdim")) {
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }
}

