/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.EndDateTypeEnum;

public class LetterOfGuaStructureFormPlugin
extends AbstractReportFormPlugin {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    protected void search() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_finorginfo": {
                this.setMulBasedata("filter_finorginfo");
                break;
            }
            case "filter_statdim": {
                String statdim = (String)e.getChangeSet()[0].getNewValue();
                IReportView view = this.getView();
                IDataModel model = this.getModel();
                if ("applyorg".equals(statdim) || "finorginfo".equals(statdim)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"filter_showttype", (Object)"step");
                } else {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"filter_showttype", (Object)"tile");
                }
                this.search();
                break;
            }
            case "filter_enddatetype": {
                this.handleEndDateType();
            }
        }
    }

    private void handleEndDateType() {
        String endDateType = (String)this.getModel().getValue("filter_enddatetype");
        EndDateTypeEnum endDateTypeEnum = EndDateTypeEnum.getEndDateTypeEnum((String)endDateType);
        if (endDateTypeEnum != null) {
            endDateTypeEnum.setDate("filter_cutoffdate", this.getModel());
        }
    }

    public void beforeQuery(ReportQueryParam param) {
        param.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
        param.getCustomParam().put("filter_finorginfo", this.getPageCache().get("filter_finorginfo"));
        this.controlTableColumns();
    }

    private List<String> allDimension() {
        return Arrays.asList("applyorg", "finorginfo", "currency", "guaranteetype");
    }

    private void controlTableColumns() {
        String dimension = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        List<String> allDimensions = this.allDimension();
        String[] curdimensions = dimension.split("_");
        List ExcludeDimensions = allDimensions.stream().filter(a -> Arrays.stream(curdimensions).noneMatch(a::equals)).collect(Collectors.toList());
        for (String excludeDimension : ExcludeDimensions) {
            col.add(excludeDimension);
            if (excludeDimension.contains("text")) continue;
            col.add(excludeDimension + "text");
        }
        List columns = listTable.getColumns();
        columns.removeIf(columm -> {
            if (columm instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)columm;
                return col.contains(reportColumn.getFieldKey());
            }
            return false;
        });
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statdim"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"LetterOfGuaStructureFormPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd", (String)"LetterOfGuaStructureFormPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Date baseDate = (Date)filters.getFilterItem("filter_basedate").getValue();
        if (EmptyUtil.isEmpty((Object)baseDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u671f\u65e5\u671f", (String)"LetterOfGuaStructureFormPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        Date cutOffDate = (Date)filters.getFilterItem("filter_cutoffdate").getValue();
        if (EmptyUtil.isEmpty((Object)cutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u672b\u65e5\u671f", (String)"LetterOfGuaStructureFormPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        if (baseDate.after(cutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u671f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u671f\u672b\u65e5\u671f", (String)"LetterOfGuaStructureFormPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setMulBasedata(String fieldName) {
        DynamicObjectCollection mulBasedata = (DynamicObjectCollection)this.getModel().getValue(fieldName);
        if (mulBasedata.isEmpty()) {
            this.getPageCache().put(fieldName, null);
        } else {
            String ids = mulBasedata.stream().map(a -> String.valueOf(((DynamicObject)a.get("fbasedataid")).getPkValue())).collect(Collectors.joining(","));
            this.getPageCache().put(fieldName, ids);
        }
    }
}

