/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form.funddaily;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.mon.report.form.funddaily.FundDailyQueryFactory;
import kd.tmc.mon.report.form.funddaily.IFundDailyConverge;
import kd.tmc.mon.report.form.funddaily.IFundDailyQuery;
import kd.tmc.mon.report.form.funddaily.dao.ComputeBalanceParam;
import kd.tmc.mon.report.form.funddaily.dao.NewRowsParam;
import kd.tmc.mon.report.helper.AcceptanceBillDataHelper;
import kd.tmc.mon.report.helper.CountBalanceHelper;
import kd.tmc.mon.report.helper.FundDailyCurrencyEnum;
import kd.tmc.mon.report.helper.FundDailyHelper;

public abstract class AbstractFundDailyReport
implements IFundDailyConverge {
    protected static final Log logger = LogFactory.getLog(AbstractFundDailyReport.class);
    Map<String, List<String>> addColumns = new HashMap<String, List<String>>(32);
    private static String REGEX_CHINESE = "[\u4e00-\u9fa5]";
    Map<String, Object> paramMap = null;
    protected String radixStr = "/1";
    private static final String[] arrayColumn = new String[]{"debitamount", "creditamount", "balance"};
    private static final Map<String, String> V_TREE_BASE_COMPANY_MAP = new HashMap<String, String>(2);
    private static final Map<String, String> CONTEXT_MAP;
    private static final Map<String, FundDailyCurrencyEnum> CURRENCY_UNIT_MAP;

    @Override
    public DataSet query(ReportQueryParam queryParam, Map<String, List<String>> resultColumns) throws Throwable {
        Map<String, Object> paramMap = this.getParams(queryParam);
        String currencyUnit = (String)paramMap.get("filter_currencyunit");
        if (StringUtils.isNotEmpty((CharSequence)currencyUnit)) {
            this.radixStr = "/" + CURRENCY_UNIT_MAP.get(currencyUnit).getRadix();
        }
        String filterType = (String)paramMap.get("filter_searchtype");
        Map<String, Object> getOrgMap = null;
        if ("queryorg".equals(filterType)) {
            DynamicObjectCollection orgDoc = (DynamicObjectCollection)paramMap.get("filter_company");
            getOrgMap = FundDailyHelper.getOrgMap(orgDoc);
        } else {
            DynamicObject dynamicObject = (DynamicObject)paramMap.get("filter_compview");
            getOrgMap = FundDailyHelper.getOrgMap(dynamicObject);
        }
        String source = (String)paramMap.get("filter_source");
        List<QFilter> filters = FundDailyHelper.baseFilter(paramMap);
        String commonSelectFields = "id, org as fundorg, org.id as orgid,  org.name as orgname, creditamount " + this.radixStr + " as creditamount, debitamount " + this.radixStr + " as debitamount, bookdate as bdate";
        IFundDailyQuery fundDailyQuery = FundDailyQueryFactory.getInstance().getQueryBean(source);
        DataSet endDealtDataSet = fundDailyQuery.queryBaseData(filters, commonSelectFields, paramMap);
        String[] groupByFields = this.groupByFields(null, false);
        DataSet unionDataSet = null;
        Date beginDate = (Date)paramMap.get("filter_begindate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        List<Date> dates = FundDailyHelper.getDatesBetweenDate(beginDate, endDate, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        for (Date date : dates) {
            Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
            Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
            DataSet dataSet = endDealtDataSet.copy().filter("bdate >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and bdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS')").addField("to_date('" + sdf.format(date) + "','yyyy-MM-dd')", "bookdate");
            if (unionDataSet == null) {
                unionDataSet = dataSet;
                continue;
            }
            unionDataSet = unionDataSet.copy().union(dataSet);
        }
        if (unionDataSet == null || unionDataSet.copy() == null) {
            return endDealtDataSet;
        }
        GroupbyDataSet sumCreditDebit = unionDataSet.copy().groupBy(groupByFields).sum("creditamount").sum("debitamount");
        DataSet resultSumData = sumCreditDebit.finish().orderBy(new String[]{"bookdate DESC"});
        DataSet computeBalanceData = this.computeBalance(resultSumData, getOrgMap);
        DataSet transDataSet = this.transRows2Columns(computeBalanceData);
        ArrayList<String> countColumn = new ArrayList<String>(16);
        for (Map.Entry<String, List<String>> colum : this.addColumns.entrySet()) {
            List<String> col = colum.getValue();
            countColumn.addAll(col);
        }
        DataSet avgDataSet = this.computeAvgBalance(transDataSet, countColumn).addField("0", "summarytype");
        DataSet totalDataSet = FundDailyHelper.buildTotalDataSet(avgDataSet, "orgname", countColumn);
        DataSet mergeTotalDataSet = FundDailyHelper.mergeTotalDataSet(avgDataSet, totalDataSet, this.getClass().getName());
        resultColumns.putAll(this.addColumns);
        return mergeTotalDataSet;
    }

    @Override
    public DataSet treeDataSet(DataSet mergeTotalDataSet, AbstractTmcListDataPlugin tAbstractTmcListDataPlugin) {
        String sumType;
        ArrayList<String> countColumn = new ArrayList<String>(16);
        for (Map.Entry<String, List<String>> colum : this.addColumns.entrySet()) {
            List<String> col = colum.getValue();
            countColumn.addAll(col);
        }
        Boolean balance = this.isContext("balance");
        if (balance.booleanValue()) {
            countColumn.add("avgbalance");
        }
        if ("sumbankorg".equals(sumType = (String)this.paramMap.get("filter_sumtype"))) {
            return AcceptanceBillDataHelper.getBizDsUpOrgTree(mergeTotalDataSet);
        }
        if ("queryorg".equals(this.paramMap.get("filter_searchtype"))) {
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"mon", (String)"mon_funddaily", (String)"47150e89000000ac");
            return this.getTreeDataSet(mergeTotalDataSet, null, orgIdList, countColumn, tAbstractTmcListDataPlugin);
        }
        DynamicObject dynamicObject = (DynamicObject)this.paramMap.get("filter_compview");
        Long companyViewId = dynamicObject.getLong("id");
        return this.getTreeDataSet(mergeTotalDataSet, companyViewId, null, countColumn, tAbstractTmcListDataPlugin);
    }

    private DataSet getTreeDataSet(DataSet bizDs, Long companyViewId, List<Long> orgIdList, List<String> statList, AbstractTmcListDataPlugin tAbstractTmcListDataPlugin) {
        Map<String, String> vTreeBaseMap = V_TREE_BASE_COMPANY_MAP;
        Map<String, String> vbizBaseMap = AcceptanceBillDataHelper.getBizBaseMap(bizDs, statList, vTreeBaseMap);
        bizDs = AcceptanceBillDataHelper.getBizDsWithOrgTree(bizDs, "rowid", "orgid", statList, vTreeBaseMap, vbizBaseMap, companyViewId, orgIdList);
        bizDs = AcceptanceBillDataHelper.getSumDataSet(bizDs, statList, true, tAbstractTmcListDataPlugin);
        return bizDs;
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns, ReportQueryParam queryParam, Map<String, List<String>> newColumns) throws Throwable {
        Map<String, Object> paramMap = this.getParams(queryParam);
        Date beginDate = (Date)paramMap.get("filter_begindate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        List<String> dayList = FundDailyHelper.getDateBetweenDate(beginDate, endDate, 1);
        String sumType = (String)paramMap.get("filter_sumtype");
        Boolean balance = this.isContext("balance");
        for (AbstractReportColumn column : columns) {
            String field = ((ReportColumn)column).getFieldKey();
            if ("sumorg".equals(sumType)) {
                if ("openorgname".equals(field) || "accountbankname".equals(field)) {
                    ((ReportColumn)column).setHide(true);
                }
            } else if ("sumorgaccount".equals(sumType)) {
                if ("openorgname".equals(field)) {
                    ((ReportColumn)column).setHide(true);
                    break;
                }
            } else if ("sumbankorg".equals(sumType) && ("orgname".equals(field) || "accountbankname".equals(field))) {
                ((ReportColumn)column).setHide(true);
            }
            if (balance.booleanValue() || !"avgbalance".equals(field)) continue;
            ((ReportColumn)column).setHide(true);
        }
        ArrayList<String> existDay = new ArrayList<String>(16);
        for (int i = dayList.size() - 1; i >= 0; --i) {
            String day = dayList.get(i);
            if (existDay.contains(day)) continue;
            existDay.add(day);
            ReportColumnGroup columnGroup = new ReportColumnGroup();
            columnGroup.setCaption(new LocaleString(day));
            columnGroup.setFieldKey(day);
            String date = day.replaceAll(REGEX_CHINESE, "");
            if (newColumns.containsKey(date)) {
                List<String> col = newColumns.get(date);
                HashMap<String, String> mapColumn = new HashMap<String, String>(32);
                for (String str : col) {
                    if (str.contains("creditamount")) {
                        mapColumn.put("creditamount", str);
                        continue;
                    }
                    if (str.contains("debitamount")) {
                        mapColumn.put("debitamount", str);
                        continue;
                    }
                    mapColumn.put("balance", str);
                }
                this.addNewColumnName(columnGroup, mapColumn, arrayColumn);
            } else {
                ArrayList<String> order = new ArrayList<String>();
                if (this.isContext("input").booleanValue()) {
                    order.add("input");
                }
                if (this.isContext("output").booleanValue()) {
                    order.add("output");
                }
                if (this.isContext("balance").booleanValue()) {
                    order.add("balance");
                }
                for (String context : order) {
                    this.addReportColumn(columnGroup, context + day, CONTEXT_MAP.get(context));
                }
            }
            columns.add((AbstractReportColumn)columnGroup);
        }
        return columns;
    }

    private void addNewColumnName(ReportColumnGroup columnGroup, Map<String, String> mapColumn, String[] arrayColumn) {
        for (String colum : arrayColumn) {
            String columName = "";
            columName = colum.equals("debitamount") ? ResManager.loadKDString((String)"\u6d41\u5165", (String)"AbstractFundDailyReport_01", (String)"tmc-mon-report", (Object[])new Object[0]) : (colum.equals("creditamount") ? ResManager.loadKDString((String)"\u6d41\u51fa", (String)"AbstractFundDailyReport_02", (String)"tmc-mon-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f59\u989d", (String)"AbstractFundDailyReport_03", (String)"tmc-mon-report", (Object[])new Object[0]));
            if (!mapColumn.containsKey(colum)) continue;
            String str = mapColumn.get(colum);
            this.addReportColumn(columnGroup, str, columName);
        }
    }

    private void addReportColumn(ReportColumnGroup columnGroup, String fieldKey, String caption) {
        ReportColumn col = new ReportColumn();
        col.setFieldKey(fieldKey);
        col.setFieldType("amount");
        col.setZeroShow(true);
        col.setCaption(new LocaleString(caption));
        col.setCurrencyField("report_currency");
        columnGroup.getChildren().add(col);
    }

    private DataSet computeBalance(DataSet bankJournalData, Map<String, Object> getOrgMap) throws ParseException {
        if (!this.isContext("balance").booleanValue()) {
            return bankJournalData;
        }
        List getOrgIds = (List)getOrgMap.get("list");
        Map orgName = (Map)getOrgMap.get("map");
        String source = (String)this.paramMap.get("filter_source");
        HashSet<String> compareOrgDate = new HashSet<String>(16);
        for (Row row : bankJournalData.copy()) {
            this.addCompareMap(row, compareOrgDate);
        }
        DataSet resultBankJournalData = bankJournalData.copy();
        Boolean isCash = (Boolean)this.paramMap.get("filter_iscash");
        DataSet sameDataSet = null;
        Date beginDate = (Date)this.paramMap.get("filter_begindate");
        Date endDate = (Date)this.paramMap.get("filter_enddate");
        DynamicObject current = (DynamicObject)this.paramMap.get("filter_currencies");
        List<Date> dayList = FundDailyHelper.getDatesBetweenDate(beginDate, endDate, 1);
        ArrayList<DataSet> listDateSet = new ArrayList<DataSet>(16);
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,isfinishinit,startperiod,currentperiod,entrybank.bank_journalbalance", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)getOrgIds)});
        HashMap<Long, DynamicObject> orgInitMap = new HashMap<Long, DynamicObject>(inits.length);
        for (DynamicObject init : inits) {
            DynamicObject org = init.getDynamicObject("org");
            Long orgId = org.getLong("id");
            orgInitMap.put(orgId, init);
        }
        for (Long orgId : getOrgIds) {
            for (Date date : dayList) {
                Long currencyId = current.getLong("id");
                DynamicObject init = (DynamicObject)orgInitMap.get(orgId);
                DynamicObject beginPeriod = null;
                if (init != null) {
                    beginPeriod = CountBalanceHelper.getBeginPeriod(orgId, init.getDynamicObject("currentperiod"), date);
                }
                ComputeBalanceParam param = new ComputeBalanceParam().setPeriod(beginPeriod).setOrgId(orgId).setCurrencyId(currencyId).setDate(date).setCash(isCash).setSource(source).setCompareOrgDate(compareOrgDate).setOrgName(orgName);
                sameDataSet = this.computeBankBalance(resultBankJournalData, listDateSet, sameDataSet, param);
                if (!isCash.booleanValue()) continue;
                sameDataSet = this.computeCashBalance(resultBankJournalData, listDateSet, sameDataSet, param);
            }
        }
        Boolean containBalance = false;
        resultBankJournalData = this.joinExistData(sameDataSet, resultBankJournalData);
        String[] resultSelectors = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        for (String selector : resultSelectors) {
            if (!"balance".equals(selector)) continue;
            containBalance = true;
            break;
        }
        if (!containBalance.booleanValue() && listDateSet.size() > 0) {
            resultBankJournalData = resultBankJournalData.copy().addField(BigDecimal.ZERO.toString(), "balance");
        }
        for (DataSet ds : listDateSet) {
            resultBankJournalData = resultBankJournalData.copy().union(ds);
        }
        return resultBankJournalData;
    }

    private DataSet transRows2Columns(DataSet dataSet) {
        CharSequence[] groupOrgSelectFields = (String[])Arrays.stream(dataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String groupFieldName = String.join((CharSequence)",", groupOrgSelectFields);
        Map<String, DataSet> mapDataSet = this.addNewColumns(dataSet, groupFieldName);
        DataSet newDataSet = this.convertRowsToColumns(dataSet, mapDataSet);
        String[] groupByFields = this.groupByFields(this.addColumns, true);
        GroupbyDataSet groupbyDataSet = newDataSet.groupBy(groupByFields);
        return groupbyDataSet.finish();
    }

    private Map<String, DataSet> addNewColumns(DataSet dataSet, String groupFieldName) {
        DataSet tempData = dataSet.copy();
        HashMap<String, String> fieldDays = new HashMap<String, String>(16);
        HashMap<String, DataSet> mapDataSet = new HashMap<String, DataSet>(16);
        while (tempData.hasNext()) {
            Row row = tempData.next();
            String filter = this.filterToNewColumn(row);
            StringBuffer subData = new StringBuffer();
            StringBuffer selectFields = new StringBuffer();
            selectFields.append(groupFieldName);
            this.handleContext(row, fieldDays, subData, selectFields);
            if (mapDataSet.containsKey(subData.toString())) {
                DataSet ds2 = (DataSet)mapDataSet.get(subData.toString());
                DataSet ds1 = dataSet.copy().filter(filter).select(selectFields.toString());
                DataSet union = ds1.union(ds2);
                mapDataSet.put(subData.toString(), union);
                continue;
            }
            DataSet ds1 = dataSet.copy().filter(filter).select(selectFields.toString());
            mapDataSet.put(subData.toString(), ds1);
        }
        return mapDataSet;
    }

    private DataSet convertRowsToColumns(DataSet dataSet, Map<String, DataSet> mapDataSet) {
        String groupFieldName = this.groupToConvert();
        DataSet resultDataSet = dataSet.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (Map.Entry<String, DataSet> dataSetMap : mapDataSet.entrySet()) {
            DataSet dataSetTemp = dataSetMap.getValue();
            if (resultDataSet == null) {
                resultDataSet = dataSetTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>(16);
            Collections.addAll(fieldNameList, dataSetTemp.getRowMeta().getFieldNames());
            for (String fieldName : resultDataSet.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = resultDataSet.join(dataSetTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                joinDataSet = joinDataSet.on(groupField.trim(), groupField.trim());
            }
            resultDataSet = joinDataSet.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return resultDataSet;
    }

    private void handleContext(Row row, Map<String, String> fieldDays, StringBuffer subData, StringBuffer selectFields) {
        String[] contexts;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Long fundOrg = row.getLong("fundorg");
        Date bookDate = row.getDate("bookdate");
        String date = format.format(bookDate);
        String dateField = "";
        String dateOrgFile = "";
        String appendSelector = "";
        List<String> column = this.addColumns.get(date);
        if (column == null) {
            column = new ArrayList<String>(32);
        }
        for (String context : contexts = this.configContext()) {
            if (!this.isContext(context).booleanValue()) {
                this.addColumns.put(date, column);
                continue;
            }
            dateField = this.selectedContext(context) + "_" + date;
            dateOrgFile = dateField + "_" + fundOrg;
            if (!fieldDays.containsKey(dateField)) {
                fieldDays.put(dateField, dateOrgFile);
            } else {
                dateOrgFile = fieldDays.get(dateField);
            }
            if (!column.contains(dateOrgFile)) {
                column.add(dateOrgFile);
            }
            appendSelector = ", " + this.selectedContext(context) + " as " + dateOrgFile;
            selectFields.append(appendSelector);
            subData.append(dateOrgFile);
            this.addColumns.put(date, column);
        }
    }

    private String selectedContext(String context) {
        if ("input".equals(context)) {
            return "debitamount";
        }
        if ("output".equals(context)) {
            return "creditamount";
        }
        return "balance";
    }

    private String[] configContext() {
        String searchContext = (String)this.paramMap.get("filter_searchcontext");
        String splitContext = searchContext.substring(1, searchContext.length() - 1);
        String[] contexts = splitContext.split(",");
        return contexts;
    }

    protected Boolean isContext(String txt) {
        String[] contexts = this.configContext();
        ArrayList listContext = new ArrayList(contexts.length);
        Collections.addAll(listContext, contexts);
        if (listContext.contains(txt)) {
            return true;
        }
        return false;
    }

    private Map<String, Object> getParams(ReportQueryParam queryParam) {
        if (this.paramMap == null) {
            this.paramMap = FundDailyHelper.transQueryParam(queryParam);
        }
        return this.paramMap;
    }

    private DataSet computeAvgBalance(DataSet transDataSet, List<String> countColumn) {
        if (!this.isContext("balance").booleanValue()) {
            return transDataSet;
        }
        ArrayList<String> balanceColumn = new ArrayList<String>(16);
        for (Map.Entry<String, List<String>> colum : this.addColumns.entrySet()) {
            List<String> col = colum.getValue();
            for (String c : col) {
                if (!c.contains("balance")) continue;
                balanceColumn.add(c);
            }
        }
        return this.calculateBalance(transDataSet, countColumn, balanceColumn);
    }

    protected abstract String[] groupByFields(Map<String, List<String>> var1, Boolean var2);

    protected abstract void addNewRowsDataSet(List<DataSet> var1, NewRowsParam var2);

    protected abstract DataSet calculateBalance(DataSet var1, List<String> var2, List<String> var3);

    protected abstract DataSet computeBankBalance(DataSet var1, List<DataSet> var2, DataSet var3, ComputeBalanceParam var4);

    protected abstract DataSet computeCashBalance(DataSet var1, List<DataSet> var2, DataSet var3, ComputeBalanceParam var4);

    protected abstract DataSet joinExistData(DataSet var1, DataSet var2);

    protected abstract void addCompareMap(Row var1, Set<String> var2);

    protected abstract String groupToConvert();

    protected abstract String filterToNewColumn(Row var1);

    static {
        V_TREE_BASE_COMPANY_MAP.put("orgname", "orgname");
        V_TREE_BASE_COMPANY_MAP.put("orgid", "rowid");
        CONTEXT_MAP = new HashMap<String, String>(3);
        CONTEXT_MAP.put("output", ResManager.loadKDString((String)"\u6d41\u51fa", (String)"AbstractFundDailyReport_02", (String)"tmc-mon-report", (Object[])new Object[0]));
        CONTEXT_MAP.put("input", ResManager.loadKDString((String)"\u6d41\u5165", (String)"AbstractFundDailyReport_01", (String)"tmc-mon-report", (Object[])new Object[0]));
        CONTEXT_MAP.put("balance", ResManager.loadKDString((String)"\u4f59\u989d", (String)"AbstractFundDailyReport_03", (String)"tmc-mon-report", (Object[])new Object[0]));
        CURRENCY_UNIT_MAP = Collections.unmodifiableMap(new HashMap<String, FundDailyCurrencyEnum>(8){
            {
                this.put(FundDailyCurrencyEnum.BILLION.getRadix(), FundDailyCurrencyEnum.BILLION);
                this.put(FundDailyCurrencyEnum.MILLION.getRadix(), FundDailyCurrencyEnum.MILLION);
                this.put(FundDailyCurrencyEnum.TENTHOUSAND.getRadix(), FundDailyCurrencyEnum.TENTHOUSAND);
                this.put(FundDailyCurrencyEnum.THOUSAND.getRadix(), FundDailyCurrencyEnum.THOUSAND);
                this.put(FundDailyCurrencyEnum.ORIGINAL.getRadix(), FundDailyCurrencyEnum.ORIGINAL);
            }
        });
    }
}

