/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form.funddaily;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mon.report.form.funddaily.AbstractFundDailyReport;
import kd.tmc.mon.report.form.funddaily.dao.ComputeBalanceParam;
import kd.tmc.mon.report.form.funddaily.dao.NewRowsParam;
import kd.tmc.mon.report.form.funddaily.dao.QueryParam;
import kd.tmc.mon.report.helper.CountBalanceHelper;
import kd.tmc.mon.report.helper.FundDailyHelper;

public class FundDailyConvergeOpenOrg
extends AbstractFundDailyReport {
    @Override
    protected String[] groupByFields(Map<String, List<String>> addColumns, Boolean isEndDeal) {
        ArrayList<String> groupByList = new ArrayList<String>(16);
        groupByList.add("fundorg");
        groupByList.add("orgid");
        groupByList.add("orgname");
        groupByList.add("openorgid");
        groupByList.add("openorgname");
        if (addColumns != null) {
            for (Map.Entry<String, List<String>> map : addColumns.entrySet()) {
                List<String> values = map.getValue();
                for (String value : values) {
                    groupByList.add(value);
                }
            }
        }
        if (!isEndDeal.booleanValue()) {
            groupByList.add("bookdate");
        }
        return groupByList.toArray(new String[0]);
    }

    @Override
    protected void addNewRowsDataSet(List<DataSet> listDateSet, NewRowsParam newRowsParam) {
        DataSet balanceData = newRowsParam.getBalanceData();
        Map<Long, String> orgNames = newRowsParam.getOrgNames();
        Date date = newRowsParam.getDate();
        Long orgId = newRowsParam.getOrgId();
        DynamicObject org = newRowsParam.getOpenOrg();
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("bookdate", (DataType)DataType.DateType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("orgid", (DataType)DataType.LongType));
        field.add(new Field("orgname", (DataType)DataType.StringType));
        field.add(new Field("openorgid", (DataType)DataType.LongType));
        field.add(new Field("openorgname", (DataType)DataType.StringType));
        Object[] rowData = new Object[7];
        rowData[0] = date;
        rowData[1] = BigDecimal.ZERO;
        rowData[2] = BigDecimal.ZERO;
        rowData[3] = orgId;
        rowData[4] = orgNames.get(orgId);
        if (!newRowsParam.getCash().booleanValue()) {
            rowData[5] = org.getLong("id");
            rowData[6] = org.getString("name");
        } else {
            rowData[5] = -9999999L;
            rowData[6] = ResManager.loadKDString((String)"\u73b0\u91d1", (String)"FundDailyQueryBankImpl_01", (String)"tmc-mon-report", (Object[])new Object[0]);
        }
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"mon_getDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        dsBuilder.append(rowData);
        DataSet newDataSet = dsBuilder.build();
        DataSet addFields = balanceData.copy().join(newDataSet, JoinType.LEFT).on("orgid", "orgid").select(new String[]{"fundorg", "orgid", "orgname", "openorgid", "openorgname", "bookdate", "creditamount", "debitamount", "balance"}).finish();
        listDateSet.add(addFields);
    }

    @Override
    protected DataSet calculateBalance(DataSet transDataSet, List<String> countColumn, List<String> balanceColumn) {
        DataSet avgBalanceDataSet = null;
        int balanceColumnSize = balanceColumn.size();
        for (Row row : transDataSet.copy()) {
            Long orgId = row.getLong("orgid");
            BigDecimal count = BigDecimal.ZERO;
            for (String balance : balanceColumn) {
                if (row.getBigDecimal(balance) == null) {
                    count = count.add(BigDecimal.ZERO);
                    continue;
                }
                count = count.add(row.getBigDecimal(balance));
            }
            BigDecimal avgBalance = count.divide(new BigDecimal(balanceColumnSize), 4, RoundingMode.HALF_UP);
            Long openOrgId = row.getLong("openorgid");
            DataSet filterDataSet = transDataSet.copy().filter("orgid = " + orgId + " and openorgid = " + openOrgId).addField(avgBalance.toString(), "avgbalance");
            if (avgBalanceDataSet == null) {
                avgBalanceDataSet = filterDataSet.copy();
                continue;
            }
            avgBalanceDataSet = avgBalanceDataSet.union(filterDataSet.copy());
        }
        if (avgBalanceDataSet == null) {
            return transDataSet;
        }
        String[] selector = (String[])Arrays.stream(avgBalanceDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet finishDataSet = transDataSet.copy().join(avgBalanceDataSet).on("orgid", "orgid").on("openorgid", "openorgid").select(selector).finish();
        countColumn.add("avgbalance");
        return finishDataSet;
    }

    @Override
    protected DataSet computeBankBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        DynamicObject period = param.getPeriod();
        Long orgId = param.getOrgId();
        Long currencyId = param.getCurrencyId();
        Date date = param.getDate();
        String source = param.getSource();
        Set<String> compareOrgDate = param.getCompareOrgDate();
        Map<Long, String> orgName = param.getOrgName();
        String[] resultBankSelector = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        ArrayList<Long> orgIds = new ArrayList<Long>(32);
        orgIds.add(orgId);
        orgIds.add(orgId);
        QFilter filters = CountBalanceHelper.getUsableAccountQFilter(orgIds);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.paramMap.get("filter_bankorg");
        List<Long> openOrgIdList = FundDailyHelper.getIdList(dynamicObjectCollection);
        if (openOrgIdList.size() > 0) {
            filters.and(new QFilter("bank.id", "in", openOrgIdList));
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, acctname, bank, issetbankinterface", (QFilter[])new QFilter[]{filters});
        HashMap openOrg = new HashMap(16);
        HashMap<Long, DynamicObject> openOrgMap = new HashMap<Long, DynamicObject>(16);
        Boolean isBankInterface = "2".equals(source);
        for (DynamicObject account : accounts) {
            Long openOrgId = account.getLong("bank.id");
            openOrgMap.put(openOrgId, account.getDynamicObject("bank"));
            List<DynamicObject> accountList = new ArrayList<DynamicObject>(32);
            if (openOrg.containsKey(openOrgId)) {
                accountList = (List)openOrg.get(openOrgId);
                accountList.add(account);
            } else {
                accountList.add(account);
            }
            openOrg.put(openOrgId, accountList);
        }
        DynamicObjectCollection openOrgDoc = (DynamicObjectCollection)this.paramMap.get("filter_bankorg");
        List<Long> getOpenOrgIds = FundDailyHelper.getIdList(openOrgDoc);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        for (Map.Entry map : openOrg.entrySet()) {
            List accountObject = (List)map.getValue();
            Long openOrgId = (Long)map.getKey();
            ArrayList<Long> accountIds = new ArrayList<Long>(16);
            ArrayList<Long> bankAccountIds = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : accountObject) {
                if (dynamicObject.getBoolean("issetbankinterface")) {
                    bankAccountIds.add(dynamicObject.getLong("id"));
                    continue;
                }
                accountIds.add(dynamicObject.getLong("id"));
            }
            if (!isBankInterface.booleanValue()) {
                accountIds.addAll(bankAccountIds);
            }
            QueryParam queryParam = new QueryParam().setPeriod(period).setOrgId(orgId).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr).setAccountIds(accountIds).setOpenOrgIds(getOpenOrgIds);
            DataSet balanceData = CountBalanceHelper.bankBalanceAmountOpOrg(queryParam);
            if (isBankInterface.booleanValue()) {
                QueryParam qParam = new QueryParam().setAccountIds(bankAccountIds).setOpenOrgIds(getOpenOrgIds).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
                DataSet bankBalanceData = CountBalanceHelper.countBalanceOpenOrg(qParam);
                balanceData = balanceData.union(bankBalanceData);
                balanceData = balanceData.copy().groupBy(new String[]{"fundorg", "orgid", "openorgid"}).sum("balance").finish();
            }
            String strDay = format.format(date);
            String key = openOrgId + "_" + strDay;
            Boolean isOldData = false;
            if (balanceData != null && compareOrgDate.contains(key)) {
                Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
                Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
                DataSet filterDataSet = resultBankJournalData.copy().filter("openorgid = " + openOrgId + " and bookdate >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS')  and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS') ");
                if ((filterDataSet = filterDataSet.copy().join(balanceData.copy(), JoinType.LEFT).on("openorgid", "openorgid").select(resultBankSelector, new String[]{"balance"}).finish()).copy().hasNext()) {
                    sameDataSet = sameDataSet == null ? filterDataSet : sameDataSet.union(filterDataSet.copy());
                    isOldData = true;
                }
            }
            if (isOldData.booleanValue()) continue;
            NewRowsParam newRowsParam = new NewRowsParam().setBalanceData(balanceData).setOrgNames(orgName).setDate(date).setOrgId(orgId).setOpenOrg((DynamicObject)openOrgMap.get(openOrgId));
            this.addNewRowsDataSet(listDateSet, newRowsParam);
        }
        return sameDataSet;
    }

    @Override
    protected DataSet computeCashBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        SimpleDateFormat SD_FORMAT = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        DynamicObject period = param.getPeriod();
        Long orgId = param.getOrgId();
        Long currencyId = param.getCurrencyId();
        Date date = param.getDate();
        Set<String> compareOrgDate = param.getCompareOrgDate();
        Map<Long, String> orgName = param.getOrgName();
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        QueryParam queryParam = new QueryParam().setPeriod(period).setOrgIds(orgIds).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
        DataSet balanceData = CountBalanceHelper.cashBalanceAmountOpenOrg(queryParam).addField("-9999999", "openorgid");
        String strDay = SD_FORMAT.format(date);
        String key = "-9999999_" + strDay;
        Boolean isOldData = false;
        if (balanceData != null && compareOrgDate.contains(key)) {
            Iterator iterator = balanceData.copy().iterator();
            BigDecimal balance = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                BigDecimal bigDecimal = row.getBigDecimal("balance");
                balance = balance.add(bigDecimal);
            }
            Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
            Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
            DataSet filterDataSet = resultBankJournalData.copy().filter("openorgid = -9999999 and bookdate >= to_date('" + SDF.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS')  and bookdate < to_date('" + SDF.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS') ");
            if ((filterDataSet = filterDataSet.copy().addField(balance.toString(), "balance")).copy().hasNext()) {
                sameDataSet = sameDataSet == null ? filterDataSet : sameDataSet.union(filterDataSet.copy());
                isOldData = true;
            }
        }
        if (!isOldData.booleanValue()) {
            NewRowsParam newRowsParam = new NewRowsParam().setBalanceData(balanceData).setOrgNames(orgName).setDate(date).setOrgId(orgId).setCash(true);
            this.addNewRowsDataSet(listDateSet, newRowsParam);
        }
        return sameDataSet;
    }

    @Override
    protected DataSet joinExistData(DataSet sameDataSet, DataSet resultBankJournalData) {
        if (sameDataSet == null) {
            return resultBankJournalData;
        }
        String[] resultSelectors = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet groupData = sameDataSet.copy().groupBy(new String[]{"openorgid", "openorgname", "bookdate"}).sum("balance").finish();
        return resultBankJournalData.copy().join(groupData, JoinType.LEFT).on("openorgid", "openorgid").on("bookdate", "bookdate").select(resultSelectors, new String[]{"balance"}).finish();
    }

    @Override
    protected void addCompareMap(Row row, Set<String> compareOrgDate) {
        SimpleDateFormat SD_FORMAT = new SimpleDateFormat("yyyyMMdd");
        Long openOrgId = row.getLong("openorgid");
        Date date = row.getDate("bookdate");
        String bookDateStr = SD_FORMAT.format(date);
        String compareKey = openOrgId + "_" + bookDateStr;
        String compareKeyOpen = "-9999999_" + bookDateStr;
        compareOrgDate.add(compareKey);
        compareOrgDate.add(compareKeyOpen);
    }

    @Override
    protected String groupToConvert() {
        return "fundorg,orgid,orgname,openorgid,openorgname";
    }

    @Override
    protected String filterToNewColumn(Row row) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date bookDate = row.getDate("bookdate");
        Date bDate = DateUtils.getDataFormat((Date)bookDate, (boolean)true);
        Date eDate = DateUtils.getDataFormat((Date)bookDate, (boolean)false);
        Long openOrgId = row.getLong("openorgid");
        return "openorgid = " + openOrgId + " and bookdate  >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS')";
    }
}

