/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.form.funddaily;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mon.report.form.funddaily.AbstractFundDailyReport;
import kd.tmc.mon.report.form.funddaily.dao.ComputeBalanceParam;
import kd.tmc.mon.report.form.funddaily.dao.NewRowsParam;
import kd.tmc.mon.report.form.funddaily.dao.QueryParam;
import kd.tmc.mon.report.helper.CountBalanceHelper;
import kd.tmc.mon.report.helper.FundDailyHelper;

public class FundDailyConvergeOpenOrgAcc
extends AbstractFundDailyReport {
    private static final String[] selector = new String[]{"fundorg", "orgid", "orgname", "accountbankid", "accountbankname", "openorgid", "openorgname", "bookdate", "creditamount", "debitamount", "balance"};

    @Override
    protected String[] groupByFields(Map<String, List<String>> addColumns, Boolean isEndDeal) {
        ArrayList<String> groupByList = new ArrayList<String>(16);
        groupByList.add("fundorg");
        groupByList.add("orgid");
        groupByList.add("orgname");
        groupByList.add("accountbankid");
        groupByList.add("accountbankname");
        groupByList.add("openorgid");
        groupByList.add("openorgname");
        if (addColumns != null) {
            for (Map.Entry<String, List<String>> map : addColumns.entrySet()) {
                List<String> values = map.getValue();
                for (String value : values) {
                    groupByList.add(value);
                }
            }
        }
        if (!isEndDeal.booleanValue()) {
            groupByList.add("bookdate");
        }
        return groupByList.toArray(new String[0]);
    }

    @Override
    protected void addNewRowsDataSet(List<DataSet> listDateSet, NewRowsParam newRowsParam) {
        DataSet balanceData = newRowsParam.getBalanceData();
        Map<Long, String> orgNames = newRowsParam.getOrgNames();
        Date date = newRowsParam.getDate();
        DynamicObject account = newRowsParam.getAccount();
        Boolean isCash = newRowsParam.getCash();
        Long orgId = newRowsParam.getOrgId();
        ArrayList<Field> field = new ArrayList<Field>(16);
        field.add(new Field("bookdate", (DataType)DataType.DateType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("orgid", (DataType)DataType.LongType));
        field.add(new Field("orgname", (DataType)DataType.StringType));
        field.add(new Field("accountbankid", (DataType)DataType.LongType));
        field.add(new Field("accountbankname", (DataType)DataType.StringType));
        field.add(new Field("openorgid", (DataType)DataType.LongType));
        field.add(new Field("openorgname", (DataType)DataType.StringType));
        Object[] rowData = new Object[9];
        rowData[0] = date;
        rowData[1] = BigDecimal.ZERO;
        rowData[2] = BigDecimal.ZERO;
        rowData[3] = orgId;
        rowData[4] = orgNames.get(orgId);
        rowData[5] = account.getLong("id");
        rowData[6] = isCash != false ? account.getString("name") : account.getString("acctname");
        if (!isCash.booleanValue()) {
            rowData[7] = account.getLong("bank.id");
            rowData[8] = account.getString("bank.name");
        } else {
            rowData[7] = -9999999L;
            rowData[8] = ResManager.loadKDString((String)"\u73b0\u91d1", (String)"FundDailyQueryBankImpl_01", (String)"tmc-mon-report", (Object[])new Object[0]);
        }
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"mon_getDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        dsBuilder.append(rowData);
        DataSet newDataSet = dsBuilder.build();
        DataSet addFields = balanceData.copy().join(newDataSet, JoinType.LEFT).on("orgid", "orgid").select(selector).finish();
        listDateSet.add(addFields);
    }

    @Override
    protected DataSet calculateBalance(DataSet transDataSet, List<String> countColumn, List<String> balanceColumn) {
        DataSet avgBalanceDataSet = null;
        int balanceColumnSize = balanceColumn.size();
        for (Row row : transDataSet.copy()) {
            Long orgId = row.getLong("orgid");
            BigDecimal count = BigDecimal.ZERO;
            for (String balance : balanceColumn) {
                if (row.getBigDecimal(balance) == null) {
                    count = count.add(BigDecimal.ZERO);
                    continue;
                }
                count = count.add(row.getBigDecimal(balance));
            }
            BigDecimal avgBalance = count.divide(new BigDecimal(balanceColumnSize), 4, RoundingMode.HALF_UP);
            Long accountBankId = row.getLong("accountbankid");
            Long openOrgId = row.getLong("openorgid");
            String accountBankName = row.getString("accountbankname");
            DataSet filterDataSet = transDataSet.copy().filter("orgid = " + orgId + " and accountbankid = " + accountBankId + " and openorgid = " + openOrgId + " and accountbankname = '" + accountBankName + "'").addField(avgBalance.toString(), "avgbalance");
            if (avgBalanceDataSet == null) {
                avgBalanceDataSet = filterDataSet.copy();
                continue;
            }
            avgBalanceDataSet = avgBalanceDataSet.union(filterDataSet.copy());
        }
        if (avgBalanceDataSet == null) {
            return transDataSet;
        }
        String[] selector = (String[])Arrays.stream(avgBalanceDataSet.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        DataSet finishDataSet = transDataSet.copy().join(avgBalanceDataSet).on("orgid", "orgid").on("accountbankid", "accountbankid").on("openorgid", "openorgid").on("accountbankname", "accountbankname").select(selector).finish();
        countColumn.add("avgbalance");
        return finishDataSet;
    }

    @Override
    protected DataSet computeBankBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        DynamicObject period = param.getPeriod();
        Long orgId = param.getOrgId();
        Long currencyId = param.getCurrencyId();
        Date date = param.getDate();
        String source = param.getSource();
        Set<String> compareOrgDate = param.getCompareOrgDate();
        Map<Long, String> orgName = param.getOrgName();
        String[] resultBankSelector = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        orgIds.add(orgId);
        QFilter filters = CountBalanceHelper.getUsableAccountQFilter(orgIds);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.paramMap.get("filter_bankorg");
        List<Long> openOrgIdList = FundDailyHelper.getIdList(dynamicObjectCollection);
        if (openOrgIdList.size() > 0) {
            filters.and(new QFilter("bank.id", "in", openOrgIdList));
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, acctname, bank, issetbankinterface", (QFilter[])new QFilter[]{filters});
        HashMap openOrg = new HashMap(32);
        for (DynamicObject account : accounts) {
            Long openOrgId = account.getLong("bank.id");
            Set<DynamicObject> accountList = new HashSet<DynamicObject>();
            if (openOrg.containsKey(openOrgId)) {
                accountList = (Set)openOrg.get(openOrgId);
                accountList.add(account);
            } else {
                accountList.add(account);
            }
            openOrg.put(openOrgId, accountList);
        }
        DynamicObjectCollection openOrgDoc = (DynamicObjectCollection)this.paramMap.get("filter_bankorg");
        List<Long> getOpenOrgIds = FundDailyHelper.getIdList(openOrgDoc);
        Boolean isBankInterface = "2".equals(source);
        for (Map.Entry map : openOrg.entrySet()) {
            Set accountObject = (Set)map.getValue();
            Long openOrgId = (Long)map.getKey();
            for (DynamicObject account : accountObject) {
                QueryParam queryParam;
                Long accountId = account.getLong("id");
                DataSet balanceData = null;
                if (isBankInterface.booleanValue() && account.getBoolean("issetbankinterface")) {
                    queryParam = new QueryParam().setAccountId(account.getLong("id")).setOpenOrgIds(getOpenOrgIds).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
                    balanceData = CountBalanceHelper.countBankBalanceData(queryParam);
                } else {
                    queryParam = new QueryParam().setPeriod(period).setOrgId(orgId).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr).setAccountId(account.getLong("id")).setOpenOrgIds(getOpenOrgIds);
                    balanceData = CountBalanceHelper.bankBalanceAmountOrgAcc(queryParam);
                }
                String strDay = format.format(date);
                String key = orgId + "_" + openOrgId + "_" + accountId + "_" + strDay;
                Boolean isOldData = false;
                if (balanceData != null && compareOrgDate.contains(key)) {
                    Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
                    Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
                    DataSet filterDataSet = resultBankJournalData.copy().filter("orgid = " + orgId + " and bookdate >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS')  and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and accountbankid = " + account.getLong("id"));
                    if ((filterDataSet = filterDataSet.copy().join(balanceData.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector, new String[]{"balance"}).finish()).copy().hasNext()) {
                        sameDataSet = sameDataSet == null ? filterDataSet : sameDataSet.union(filterDataSet.copy());
                        isOldData = true;
                    }
                }
                if (isOldData.booleanValue()) continue;
                NewRowsParam newRowsParam = new NewRowsParam().setBalanceData(balanceData).setOrgNames(orgName).setDate(date).setOrgId(orgId).setAccount(account);
                this.addNewRowsDataSet(listDateSet, newRowsParam);
            }
        }
        return sameDataSet;
    }

    @Override
    protected DataSet computeCashBalance(DataSet resultBankJournalData, List<DataSet> listDateSet, DataSet sameDataSet, ComputeBalanceParam param) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        DynamicObject period = param.getPeriod();
        Long orgId = param.getOrgId();
        Long currencyId = param.getCurrencyId();
        Date date = param.getDate();
        Set<String> compareOrgDate = param.getCompareOrgDate();
        Map<Long, String> orgName = param.getOrgName();
        String[] resultBankSelector = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        orgIds.add(orgId);
        List<DynamicObject> cashAccount = CountBalanceHelper.getCashAccount(orgIds);
        for (DynamicObject account : cashAccount) {
            Long accountId = account.getLong("id");
            QueryParam queryParam = new QueryParam().setPeriod(period).setCashCountId(account.getLong("id")).setCurrencyId(currencyId).setDate(date).setRadixStr(this.radixStr);
            DataSet balanceData = CountBalanceHelper.cashBalanceAmount(queryParam);
            String strDay = format.format(date);
            String key = orgId + "_" + accountId + "_" + strDay;
            Boolean isOldData = false;
            if (balanceData != null && compareOrgDate.contains(key)) {
                Date bDate = DateUtils.getDataFormat((Date)date, (boolean)true);
                Date eDate = DateUtils.getDataFormat((Date)date, (boolean)false);
                DataSet filterDataSet = resultBankJournalData.copy().filter("orgid = " + orgId + " and bookdate >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS')  and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and accountbankid = " + account.getLong("id"));
                if ((filterDataSet = filterDataSet.copy().join(balanceData.copy(), JoinType.LEFT).on("orgid", "orgid").select(resultBankSelector, new String[]{"balance"}).finish()).copy().hasNext()) {
                    sameDataSet = sameDataSet == null ? filterDataSet : sameDataSet.union(filterDataSet.copy());
                    isOldData = true;
                }
            }
            if (isOldData.booleanValue()) continue;
            NewRowsParam newRowsParam = new NewRowsParam().setBalanceData(balanceData).setOrgNames(orgName).setDate(date).setOrgId(orgId).setAccount(account).setCash(true);
            this.addNewRowsDataSet(listDateSet, newRowsParam);
        }
        return sameDataSet;
    }

    @Override
    protected DataSet joinExistData(DataSet sameDataSet, DataSet resultBankJournalData) {
        if (sameDataSet == null) {
            return resultBankJournalData;
        }
        String[] resultSelectors = (String[])Arrays.stream(resultBankJournalData.copy().getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        return resultBankJournalData.copy().join(sameDataSet, JoinType.LEFT).on("orgid", "orgid").on("openorgid", "openorgid").on("accountbankid", "accountbankid").on("bookdate", "bookdate").select(resultSelectors, new String[]{"balance"}).finish();
    }

    @Override
    protected void addCompareMap(Row row, Set<String> compareOrgDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Long orgId = row.getLong("orgid");
        Date date = row.getDate("bookdate");
        String bookDateStr = format.format(date);
        Long accountId = row.getLong("accountbankid");
        Long openOrgId = row.getLong("openorgid");
        String compareKey = orgId + "_" + openOrgId + "_" + accountId + "_" + bookDateStr;
        String compareKeyForCash = orgId + "_" + accountId + "_" + bookDateStr;
        compareOrgDate.add(compareKey);
        compareOrgDate.add(compareKeyForCash);
    }

    @Override
    protected String groupToConvert() {
        return "fundorg,orgid,orgname,accountbankid,accountbankname,openorgid,openorgname";
    }

    @Override
    protected String filterToNewColumn(Row row) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Long fundOrg = row.getLong("fundorg");
        Date bookDate = row.getDate("bookdate");
        Date bDate = DateUtils.getDataFormat((Date)bookDate, (boolean)true);
        Date eDate = DateUtils.getDataFormat((Date)bookDate, (boolean)false);
        Long accountId = row.getLong("accountbankid");
        Long openOrgId = row.getLong("openorgid");
        return "fundorg = " + fundOrg + " and accountbankid = " + accountId + " and openorgid = " + openOrgId + " and bookdate  >= to_date('" + sdf.format(bDate) + "','yyyy-MM-dd HH:mm:ss.SSS') and bookdate < to_date('" + sdf.format(eDate) + "','yyyy-MM-dd HH:mm:ss.SSS')";
    }
}

