/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class AcceptanceBillDataHelper {
    private static final Log logger = LogFactory.getLog(AcceptanceBillDataHelper.class);
    private static final List<String> TREELIST = Arrays.asList("rowid", "pid", "isgroupnode", "level", "sumlevel");
    private static final String LONGNUMBER = "longnumber";

    public static DataSet getBizDsWithOrgTree(DataSet bizDsBase, String lField, String rField, List<String> sumList, Map<String, String> vTreeBaseMap, Map<String, String> vbizBaseMap, List<Long> orgIdList) {
        return AcceptanceBillDataHelper.getBizDsWithOrgTree(bizDsBase, lField, rField, sumList, vTreeBaseMap, vbizBaseMap, null, orgIdList);
    }

    public static DataSet getBizDsUpOrgTree(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return bizDsBase;
        }
        return AcceptanceBillDataHelper.updataRowId(bizDsBase.addFields(new String[]{String.valueOf(DBServiceHelper.genGlobalLongId()), "0", "'0'", "0"}, new String[]{"rowid", "pid", "isgroupnode", "level"}));
    }

    public static DataSet getBizDsWithOrgTree(DataSet bizDsBase, String lField, String rField, List<String> sumList, Map<String, String> vTreeBaseMap, Map<String, String> vbizBaseMap, Long companyViewId, List<Long> orgIdList) {
        DataSet orgDateSet;
        if (bizDsBase == null || lField == null || rField == null) {
            return bizDsBase;
        }
        if (vTreeBaseMap == null) {
            vTreeBaseMap = new HashMap<String, String>(0);
        }
        if (vbizBaseMap == null) {
            vbizBaseMap = new HashMap<String, String>(0);
        }
        if ((orgDateSet = AcceptanceBillDataHelper.getOrgDateSet(companyViewId, orgIdList)) == null || bizDsBase.copy().isEmpty()) {
            return AcceptanceBillDataHelper.getBizDsUpOrgTree(bizDsBase.addNullField(LONGNUMBER));
        }
        boolean islField = Arrays.stream(orgDateSet.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(lField));
        boolean isrField = Arrays.stream(bizDsBase.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(rField));
        if (!islField || !isrField) {
            return AcceptanceBillDataHelper.getBizDsUpOrgTree(bizDsBase.addNullField(LONGNUMBER));
        }
        ArrayList<String> fieldList = new ArrayList<String>(TREELIST);
        fieldList.addAll(vTreeBaseMap.keySet());
        fieldList.addAll(vbizBaseMap.keySet());
        fieldList.addAll(sumList);
        fieldList.add(LONGNUMBER);
        String[] selectField = fieldList.toArray(new String[0]);
        String[] sumVel = (String[])sumList.stream().map(o -> "0").toArray(String[]::new);
        DataSet bizDsOrgs0 = orgDateSet.copy().join(bizDsBase.copy()).on(lField, rField).select(selectField).finish();
        ArrayList<String> bankAcctvgb = new ArrayList<String>(TREELIST);
        bankAcctvgb.addAll(vTreeBaseMap.keySet());
        bankAcctvgb.add(LONGNUMBER);
        DataSet bizDsOrgs1 = bizDsOrgs0.copy().where("isgroupnode='1'").groupBy(bankAcctvgb.toArray(new String[0])).finish();
        bizDsOrgs1 = AcceptanceBillDataHelper.addMapFields(bizDsOrgs1, vbizBaseMap).addFields(sumVel, sumList.toArray(new String[0])).updateField("pid", "rowid").updateField("level", "level+1").select(selectField);
        bizDsOrgs1 = AcceptanceBillDataHelper.updataRowId(bizDsOrgs1);
        Map<String, String> tPidMap = AcceptanceBillDataHelper.getDsMap(bizDsOrgs1, "pid", "rowid");
        DataSet bizDsOrgs2 = bizDsOrgs0.copy().updateField("pid", "rowid").updateField("level", "level+" + (tPidMap.size() > 0 ? "2" : "1"));
        bizDsOrgs2 = AcceptanceBillDataHelper.updataRowId(bizDsOrgs2);
        bizDsOrgs2 = AcceptanceBillDataHelper.updataPId(bizDsOrgs2, tPidMap);
        if (bizDsOrgs2 == null) {
            return bizDsOrgs2;
        }
        DataSet orgDateSet1 = AcceptanceBillDataHelper.addMapFields(orgDateSet, vbizBaseMap);
        orgDateSet1 = AcceptanceBillDataHelper.addMapFields(orgDateSet1, vTreeBaseMap);
        orgDateSet1 = orgDateSet1.addFields(sumVel, sumList.toArray(new String[0])).select(selectField);
        return bizDsOrgs2.union(new DataSet[]{bizDsOrgs1, orgDateSet1});
    }

    public static Map<String, String> getBizBaseMap(DataSet bizDsBase, List<String> sumList, Map<String, String> vTreeBaseMap) {
        if (bizDsBase == null) {
            return new HashMap<String, String>(0);
        }
        Map<String, DataType> bizDsBaseAllFieldMap = Arrays.stream(bizDsBase.getRowMeta().getFields()).collect(Collectors.toMap(Field::getName, Field::getDataType));
        ArrayList<String> bizDsBaseAllFieldList = new ArrayList<String>(bizDsBaseAllFieldMap.keySet());
        if (vTreeBaseMap != null) {
            bizDsBaseAllFieldList.removeAll(vTreeBaseMap.keySet());
        }
        bizDsBaseAllFieldList.removeAll(sumList);
        bizDsBaseAllFieldList.removeAll(TREELIST);
        bizDsBaseAllFieldList.remove(LONGNUMBER);
        return bizDsBaseAllFieldList.stream().collect(Collectors.toMap(o -> o, o -> {
            DataType tDataType = (DataType)bizDsBaseAllFieldMap.get(o);
            if (tDataType instanceof BigDecimalType) {
                return "0.00";
            }
            if (tDataType instanceof IntegerType || tDataType instanceof LongType) {
                return "0";
            }
            if (tDataType instanceof TimestampType) {
                return "null";
            }
            return "''";
        }));
    }

    public static List<String> getFieldList(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return new ArrayList<String>(0);
        }
        return Arrays.stream(bizDsBase.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
    }

    private static DataSet addMapFields(DataSet bizDataSet, Map<String, String> vTreeGbMap) {
        DataSet bizDS = bizDataSet.copy();
        if (vTreeGbMap.size() > 0) {
            ArrayList<String> vTreeGbKeyList = new ArrayList<String>(0);
            ArrayList<String> vTreeGbValueList = new ArrayList<String>(0);
            for (Map.Entry<String, String> vTreeGbEntry : vTreeGbMap.entrySet()) {
                vTreeGbKeyList.add(vTreeGbEntry.getKey());
                vTreeGbValueList.add(vTreeGbEntry.getValue());
            }
            bizDS = bizDS.addFields(vTreeGbValueList.toArray(new String[0]), vTreeGbKeyList.toArray(new String[0]));
        }
        return bizDS;
    }

    public static DataSet getSumDataSet(DataSet allDateSet, List<String> sumList, boolean isRemoveNoData, AbstractTmcListDataPlugin tAbstractTmcListDataPlugin) {
        if (allDateSet == null || allDateSet.copy().isEmpty()) {
            return allDateSet;
        }
        List<String> selectList = AcceptanceBillDataHelper.getFieldList(allDateSet);
        selectList.removeAll(TREELIST);
        selectList.removeAll(sumList);
        DataSet bizDs = tAbstractTmcListDataPlugin.getSumDataSetByLevel(allDateSet.copy(), sumList, String.join((CharSequence)",", selectList.toArray(new String[0])));
        if (isRemoveNoData) {
            bizDs = tAbstractTmcListDataPlugin.removeNoDataTreeDs(bizDs.copy(), sumList);
        }
        return bizDs;
    }

    private static DataSet updataPId(DataSet bizDsSet, Map<String, String> tPidMap) {
        List<String> rowFieldList = AcceptanceBillDataHelper.getFieldList(bizDsSet);
        String pid = "pid";
        if (bizDsSet == null || bizDsSet.copy().isEmpty() || !rowFieldList.contains("pid") || tPidMap == null || tPidMap.size() < 1) {
            return bizDsSet;
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AcceptanceBillDataHelper.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("pid") && tPidMap.containsKey(row.getString(rowField))) {
                    updataRow.add(tPidMap.get(row.getString(rowField)));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        bizDs.close();
        return bizDsBulider.build();
    }

    private static Map<String, String> getDsMap(DataSet bizDsSet, String keyField, String valueField) {
        HashMap<String, String> tDsMap = new HashMap<String, String>(0);
        List<String> rowFieldList = AcceptanceBillDataHelper.getFieldList(bizDsSet);
        if (bizDsSet != null && !bizDsSet.copy().isEmpty() && rowFieldList.contains(keyField) && rowFieldList.contains(valueField)) {
            DataSet bizDs = bizDsSet.copy();
            for (Row row : bizDs) {
                tDsMap.put(row.getString(keyField), row.getString(valueField));
            }
            bizDs.close();
        }
        return tDsMap;
    }

    private static DataSet updataRowId(DataSet bizDsSet) {
        List<String> rowFieldList = AcceptanceBillDataHelper.getFieldList(bizDsSet);
        String rowid = "rowid";
        if (bizDsSet == null || bizDsSet.copy().isEmpty() || !rowFieldList.contains("rowid")) {
            return bizDsSet;
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AcceptanceBillDataHelper.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("rowid")) {
                    updataRow.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        return bizDsBulider.build();
    }

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    private static DataSet getOrgDateSet(Long companyViewId, List<Long> orgIdList) {
        QFilter tQFilter = new QFilter("view.treetype", "=", (Object)"08");
        if (companyViewId != null) {
            tQFilter.and("view.id", "=", (Object)companyViewId);
        } else {
            tQFilter.and("view.number", "=", (Object)"08");
        }
        String selectFields = "org,org.name orgname,parent.id pid,parent.number pnumber,( case when isleaf='1' then '0' else '1' end ) isgroupnode,longnumber,level,sortcode,0 sumlevel";
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)selectFields, (QFilter[])tQFilter.toArray(), (String)"sortcode");
        orgDataSet = orgDataSet.addField("org", "rowid");
        if (orgIdList != null && !orgIdList.isEmpty()) {
            Map<String, String> tRowidPidMap = AcceptanceBillDataHelper.getDsMap(orgDataSet, "rowid", "pid");
            orgDataSet = orgDataSet.where("rowid in (" + String.join((CharSequence)",", (CharSequence[])orgIdList.stream().map(Object::toString).toArray(String[]::new)) + ")");
            Map<String, String> orgidMap = AcceptanceBillDataHelper.getDsMap(orgDataSet, "rowid", "pid");
            HashMap<String, String> tPidMap = new HashMap<String, String>(0);
            for (Map.Entry<String, String> orgidentry : orgidMap.entrySet()) {
                String treeOrg = AcceptanceBillDataHelper.getPid(tRowidPidMap, orgidMap, orgidentry.getValue());
                if (treeOrg.equals(orgidentry.getValue())) continue;
                tPidMap.put(orgidentry.getValue(), treeOrg);
            }
            if (tPidMap.size() > 0) {
                orgDataSet = AcceptanceBillDataHelper.updataPId(orgDataSet, tPidMap);
            }
        }
        return orgDataSet;
    }

    private static String getPid(Map<String, String> tRowidPidMap, Map<String, String> orgidMap, String treeOrg) {
        if (orgidMap.containsKey(treeOrg)) {
            return treeOrg;
        }
        if (tRowidPidMap.containsKey(treeOrg)) {
            treeOrg = tRowidPidMap.get(treeOrg);
            return AcceptanceBillDataHelper.getPid(tRowidPidMap, orgidMap, treeOrg);
        }
        return "0";
    }

    public static void rebuildColumn(String[] fields, ReportList listTable) {
        if (fields == null || fields.length < 1) {
            return;
        }
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> rebuildColumns = new ArrayList<AbstractReportColumn>();
        block0: for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            for (AbstractReportColumn column : columns) {
                if (!column.getCaption().getLocaleValue().equalsIgnoreCase(field)) continue;
                rebuildColumns.add(column);
                continue block0;
            }
        }
        if (!rebuildColumns.isEmpty()) {
            columns.clear();
            columns.addAll(rebuildColumns);
        }
    }

    public static DataSet exchangeRate(DataSet dataSet, DynamicObjectCollection currencies, DynamicObject reportCurrency, DynamicObject rateTable) {
        DataSet accountBalanceSet = QueryServiceHelper.queryDataSet((String)"exchangeRate", (String)"bd_exrate_tree", (String)"orgcur,excval", null, (String)"");
        Algo algo = Algo.create((String)"exchangeRate");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(accountBalanceSet.getRowMeta());
        for (DynamicObject currency : currencies) {
            Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)reportCurrency.getLong("id"), (Long)rateTable.getLong("id"), (Date)Calendar.getInstance().getTime());
            BigDecimal exchangeRate = BigDecimal.ONE.setScale(10);
            boolean quoteType = false;
            if (exchangeRateByRules.get("exchangeRate") != null) {
                exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
            }
            if (exchangeRateByRules.get("quoteType") != null) {
                quoteType = (Boolean)exchangeRateByRules.get("quoteType");
            }
            BigDecimal rate = quoteType ? BigDecimal.ONE.divide(exchangeRate, 10, 0) : exchangeRate.setScale(10, 0);
            Object[] rowData = new Object[]{currency.getLong("id"), rate};
            datasetBuilder.append(rowData);
        }
        DataSet rateDataSet = datasetBuilder.build();
        String[] leftSelector = (String[])Arrays.stream(dataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSet = dataSet.join(rateDataSet, JoinType.LEFT).on("currency", "orgcur").select(leftSelector, new String[]{"excval"}).finish();
        return dataSet;
    }

    public static DataSet exchangeRate(DataSet dataSet, DynamicObjectCollection currencies, DynamicObject reportCurrency, DynamicObject rateTable, Map<String, String> amountMappingMap) {
        dataSet = AcceptanceBillDataHelper.exchangeRate(dataSet, currencies, reportCurrency, rateTable);
        for (Map.Entry<String, String> entry : amountMappingMap.entrySet()) {
            dataSet = dataSet.addField(entry.getKey() + " * excval", entry.getValue());
        }
        return dataSet;
    }
}

