/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.service.bankjournal.AccountBalanceQueryParam;
import kd.tmc.mon.report.service.bankjournal.AccountBalanceQueryService;

public class AcctBalanceServiceHelper {
    private static String accountField = "accountbank.id";
    private static boolean isCash = false;

    public static DataSet getJournalBalance_ByDate(List<Long> orgIds, Set<Long> acctBankId, Long currencyId, Date bizDate, boolean isCash) {
        accountField = isCash ? "accountcash.id" : "accountbank.id";
        DataSet ds = null;
        for (Long orgId : orgIds) {
            DataSet tempDs = AcctBalanceServiceHelper.getJournalBalance_ByDate(orgId, acctBankId, currencyId, bizDate);
            if (ds == null) {
                ds = tempDs;
                continue;
            }
            ds = ds.union(tempDs);
        }
        return ds;
    }

    public static DataSet getJournalBalance_ByDate(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DataSet beginBalanceDs = AcctBalanceServiceHelper.getDayBeginBalance(orgId, acctBankId, currencyId, bizDate);
        DataSet ds = AcctBalanceServiceHelper.getRangeJournal(orgId, acctBankId, currencyId, bizDate, DateUtils.getNextDay((Date)bizDate, (int)1));
        if (!beginBalanceDs.isEmpty()) {
            ds = ds.isEmpty() ? beginBalanceDs : ds.union(beginBalanceDs);
        }
        ds = ds.addField("monthbalance + debitamount - creditamount", "endBalance").groupBy(new String[]{"org.id", "org.name", accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").sum("endBalance").finish();
        return ds;
    }

    public static DynamicObject getPeriodByYearAndNumber(long periodtypeId, int periodyear, int periodnumber) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodyear), new QFilter("periodnumber", "=", (Object)periodnumber), new QFilter("periodtype", "=", (Object)periodtypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DataSet getDayBeginBalance(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DataSet beginBalanceDs = AcctBalanceServiceHelper.getPeriodBalance(orgId, acctBankId, currencyId, bizDate);
        beginBalanceDs = beginBalanceDs.removeFields(new String[]{"period.id"});
        Date newBeginDate = AcctBalanceServiceHelper.getBeginDate(orgId, bizDate);
        DataSet ds = AcctBalanceServiceHelper.getRangeJournal(orgId, acctBankId, currencyId, newBeginDate, bizDate);
        if (ds.isEmpty()) {
            ds = beginBalanceDs;
        } else if (!beginBalanceDs.isEmpty()) {
            ds = ds.union(beginBalanceDs);
        }
        ds.groupBy(new String[]{"org.id", accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
        ds = ds.select(new String[]{"org.id", "org.name", accountField, "currency.id", "currency", "monthbalance+debitamount-creditamount monthbalance", "0 debitamount", "0 creditamount"});
        return ds;
    }

    private static DataSet getPeriodBalance(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DynamicObject period = AcctBalanceServiceHelper.getPeriodByDate(orgId, bizDate);
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and(new QFilter(accountField, "!=", (Object)0)).and(new QFilter("type", "=", (Object)(isCash ? "1" : "2")));
        if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
            filter = filter.and("period.id", "<=", (Object)period.getLong("id"));
        }
        if (acctBankId != null) {
            filter = filter.and(new QFilter(accountField, "in", acctBankId));
        }
        if (currencyId != null) {
            filter = filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        }
        DataSet journalBalDs = QueryServiceHelper.queryDataSet((String)"journalBallance", (String)"cas_journalbalance", (String)("org.id,org.name," + accountField + ",currency.id,currency.name currency,period.id,monthstart as monthbalance"), (QFilter[])new QFilter[]{filter}, null);
        DataSet currentPeriodDs = QueryServiceHelper.queryDataSet((String)"currentPeriodBal", (String)"cas_journalbalance", (String)("org.id," + accountField + ",currency.id,currency.name currency,period.id"), (QFilter[])new QFilter[]{filter}, null).groupBy(new String[]{"org.id", accountField, "currency.id", "currency"}).max("period.id").finish();
        return journalBalDs.join(currentPeriodDs, JoinType.INNER).on("org.id", "org.id").on(accountField, accountField).on("currency.id", "currency.id").on("period.id", "period.id").select(new String[]{"org.id", "org.name", accountField, "currency.id", "currency", "period.id", "monthbalance", "0 debitamount", "0 creditamount"}).finish();
    }

    public static DataSet getRangeJournal(Long orgId, Set<Long> acctBankId, Long currencyId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and("bookdate", "<", (Object)endDate);
        if (beginDate != null) {
            filter.and("bookdate", ">=", (Object)beginDate);
        }
        if (acctBankId != null) {
            filter = filter.and(new QFilter(accountField, "in", acctBankId));
        }
        if (currencyId != null) {
            filter = filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        }
        return QueryServiceHelper.queryDataSet((String)"bankJournal", (String)(isCash ? "cas_cashjournal" : "cas_bankjournal"), (String)("org.id,org.name," + accountField + ",currency.id,currency.name currency,0 monthbalance,debitamount,creditamount"), (QFilter[])filter.toArray(), null).groupBy(new String[]{"org.id", "org.name", accountField, "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
    }

    public static Date getBeginDate(Long orgId, Date bizDate) {
        DynamicObject[] maxPeriod;
        DynamicObject period = AcctBalanceServiceHelper.getPeriodByDate(orgId, bizDate);
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and(new QFilter(accountField, "!=", (Object)0)).and(new QFilter("type", "=", (Object)(isCash ? "1" : "2")));
        if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
            filter = filter.and("period.id", "<=", (Object)period.getLong("id"));
        }
        if ((maxPeriod = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"period", (QFilter[])new QFilter[]{filter}, (String)"period.ID DESC")).length > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)maxPeriod[0].getLong("period.id"), (String)"bd_period", (String)"begindate").getDate("begindate");
        }
        return null;
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date) {
        long periodTypeId = AcctBalanceServiceHelper.getPeriodTypeId(orgId);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static long getPeriodTypeId(long orgId) {
        DynamicObject periodType = AcctBalanceServiceHelper.getPeriodType(orgId);
        return periodType == null ? 0L : periodType.getLong("id");
    }

    public static DynamicObject getPeriodType(long orgId) {
        DynamicObject systemStatusCtrol = AcctBalanceServiceHelper.getSystemStatusCtrol(orgId);
        return systemStatusCtrol == null ? null : systemStatusCtrol.getDynamicObject("periodtype");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static List<DataSet> getJournalBalanceByDate(List<Long> orgIds, DataSet acctBankDs, List<Long> currencyId, Date beginDate, Date endDate) {
        List orgIdPart = Lists.partition(orgIds, (int)3000);
        DataSet beginBalanceDs = null;
        DataSet endBalanceDs = null;
        for (List orgIdList : orgIdPart) {
            List<DataSet> dsList = AcctBalanceServiceHelper.getBankJournalByDate(orgIdList, acctBankDs, currencyId, beginDate, endDate);
            beginBalanceDs = beginBalanceDs == null ? dsList.get(0) : beginBalanceDs.union(dsList.get(0));
            endBalanceDs = endBalanceDs == null ? dsList.get(1) : endBalanceDs.union(dsList.get(1));
        }
        return Arrays.asList(beginBalanceDs, endBalanceDs);
    }

    public static List<DataSet> getJournalBalanceTimeRange(List<Long> orgIds, DataSet acctBankDs, List<Long> currencyId, Date beginDate, Date endDate) {
        return AcctBalanceServiceHelper.getBankJournalTimeRange(orgIds, acctBankDs, currencyId, beginDate, endDate);
    }

    public static DataSet getJournalBalanceByDate(List<Long> orgIds, Set<Long> acctBankId, List<Long> currencyId, Date bizDate) {
        List orgIdPart = Lists.partition(orgIds, (int)3000);
        DataSet balanceDs = null;
        for (List orgIdList : orgIdPart) {
            DataSet ds = AcctBalanceServiceHelper.getBankJournalSumDataSet(orgIdList, acctBankId, currencyId, null, bizDate);
            ds = ds.addField("monthbalance + debitamount - creditamount", "endBalance");
            if (balanceDs == null) {
                balanceDs = ds;
                continue;
            }
            balanceDs = balanceDs.union(ds);
        }
        return balanceDs;
    }

    private static List<DataSet> getBankJournalByDate(List<Long> orgIds, DataSet acctBankDs, List<Long> currencyId, Date beginDate, Date endDate) {
        Set<Long> acctBankId = AcctBalanceServiceHelper.getAccountBankIds(acctBankDs);
        DataSet endDataSet = AcctBalanceServiceHelper.getBankJournalDataSet(orgIds, acctBankId, currencyId, null, endDate);
        DataSet beginDataSet = endDataSet.filter("to_char(bookdate, 'yyyyMMdd')<=" + DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd"));
        beginDataSet = AcctBalanceServiceHelper.groupByBankJournalDataSet(beginDataSet, acctBankDs);
        endDataSet = AcctBalanceServiceHelper.groupByBankJournalDataSet(endDataSet, acctBankDs);
        DataSet balanceDataSet = AcctBalanceServiceHelper.getJounalBalance(orgIds, acctBankId, currencyId);
        balanceDataSet = balanceDataSet.groupBy(new String[]{"org", "period", "accountbank", "currency"}).sum("monthstart").finish();
        DataSet startPeriodDataSet = AcctBalanceServiceHelper.getStartPeriod(orgIds).filter("standardcurrency > 0");
        DataSet initBalanceDataSet = startPeriodDataSet.copy().leftJoin(balanceDataSet.copy()).on("org", "org").on("startperiod", "period").select(new String[]{"org"}, new String[]{"currency", "accountbank", "period", "monthstart"}).finish().updateField("monthstart", "case when monthstart = null then 0 else monthstart end");
        beginDataSet = AcctBalanceServiceHelper.getDataSet(beginDataSet, initBalanceDataSet);
        endDataSet = AcctBalanceServiceHelper.getDataSet(endDataSet, initBalanceDataSet);
        return Arrays.asList(beginDataSet, endDataSet);
    }

    private static List<DataSet> getBankJournalTimeRange(List<Long> orgIds, DataSet acctBankDs, List<Long> currencyId, Date beginDate, Date endDate) {
        Set<Long> acctBankId = AcctBalanceServiceHelper.getAccountBankIds(acctBankDs);
        AccountBalanceQueryService queryService = new AccountBalanceQueryService();
        AccountBalanceQueryParam param = new AccountBalanceQueryParam();
        param.setOrgIds(orgIds).setAccountIds(new ArrayList<Long>(acctBankId)).setCurrencyIds(currencyId).setBeginDate(beginDate).setEndDate(endDate);
        List<DataSet> dataSetList = queryService.queryBankJournalBalanceTimeRange(param);
        if (EmptyUtil.isEmpty(dataSetList)) {
            return dataSetList;
        }
        DataSet beginDs = dataSetList.get(0);
        DataSet endDs = dataSetList.get(1);
        beginDs = queryService.addBaseDataName(beginDs, "bos_org", "orgid", "org.name");
        endDs = queryService.addBaseDataName(endDs, "bos_org", "orgid", "org.name");
        beginDs = queryService.addBaseDataName(beginDs, "bd_currency", "currencyid", "currency");
        endDs = queryService.addBaseDataName(endDs, "bd_currency", "currencyid", "currency");
        beginDs = beginDs.select("accountid as accountbank.id,orgid as org.id, org.name,currencyid as currency.id, currency, debitamount,creditamount,endBalance");
        endDs = endDs.select("accountid as accountbank.id,orgid as org.id, org.name,currencyid as currency.id, currency, debitamount,creditamount,endBalance");
        return Arrays.asList(beginDs, endDs);
    }

    private static DataSet getDataSet(DataSet dataSet, DataSet initBalanceDataSet) {
        return dataSet.leftJoin(initBalanceDataSet).on("org.id", "org").on("currency.id", "currency").on("accountbank.id", "accountbank").select(dataSet.getRowMeta().getFieldNames(), new String[]{"monthstart"}).finish().updateField("endBalance", "endBalance + monthstart").removeFields(new String[]{"monthstart"});
    }

    private static DataSet groupByBankJournalDataSet(DataSet dataSet, DataSet acctBankDs) {
        dataSet = dataSet.removeFields(new String[]{"bookdate"}).groupBy(new String[]{"org.id", "accountbank.id", "currency.id"}).sum("debitamount").sum("creditamount").finish();
        dataSet = dataSet.addField("debitamount - creditamount", "endBalance");
        return AcctBalanceServiceHelper.getAcctBankJoinJournalDataSet(dataSet, acctBankDs);
    }

    private static DataSet getAcctBankJoinJournalDataSet(DataSet dataSet, DataSet acctBankDs) {
        return acctBankDs.leftJoin(dataSet).on("org.id", "org.id").on("currency.id", "currency.id").on("accountbank.id", "accountbank.id").select(acctBankDs.getRowMeta().getFieldNames(), new String[]{"debitamount", "creditamount", "endBalance"}).finish().updateField("debitamount", "case when debitamount = null then 0 else debitamount end").updateField("creditamount", "case when creditamount = null then 0 else creditamount end").updateField("endBalance", "case when endBalance = null then 0 else endBalance end");
    }

    private static DataSet getJounalBalance(List<Long> orgIds, Set<Long> acctBankId, List<Long> currencyId) {
        QFilter filter = new QFilter("org", "in", orgIds);
        if (!EmptyUtil.isEmpty(acctBankId)) {
            filter = filter.and("accountbank", "in", acctBankId);
        }
        filter = !EmptyUtil.isEmpty(currencyId) ? filter.and("currency", "in", currencyId) : filter.and("currency", ">", (Object)0L);
        return QueryServiceHelper.queryDataSet((String)"getJounalInitBalance", (String)"cas_journalbalance", (String)"id, org, accountbank, currency, period, monthstart", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getStartPeriod(List<Long> orgIds) {
        QFilter filter = new QFilter("org", "in", orgIds);
        return QueryServiceHelper.queryDataSet((String)"getStartPeriod", (String)"cas_cashmgtinit", (String)"id, org, startperiod, standardcurrency.id standardcurrency", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getBankJournalDataSet(List<Long> orgIds, Set<Long> acctBankId, List<Long> currencyId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org.id", "in", orgIds).and("bookdate", "<=", (Object)endDate);
        if (beginDate != null) {
            filter.and("bookdate", ">=", (Object)beginDate);
        }
        if (!EmptyUtil.isEmpty(acctBankId)) {
            filter = filter.and("accountbank.id", "in", acctBankId);
        }
        filter = !EmptyUtil.isEmpty(currencyId) ? filter.and("currency.id", "in", currencyId) : filter.and("currency.id", ">", (Object)0L);
        return QueryServiceHelper.queryDataSet((String)"getOrgBankJournal", (String)"cas_bankjournal", (String)"org.id, accountbank.id, currency.id, bookdate, debitamount, creditamount", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getBankJournalSumDataSet(List<Long> orgIds, Set<Long> acctBankId, List<Long> currencyId, Date beginDate, Date endDate) {
        return AcctBalanceServiceHelper.getBankJournalDataSet(orgIds, acctBankId, currencyId, beginDate, endDate).removeFields(new String[]{"bookdate"}).groupBy(new String[]{"org.id", "org.name", "accountbank.id", "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
    }

    private static Set<Long> getAccountBankIds(DataSet acctBankDs) {
        HashSet<Long> ids = new HashSet<Long>(10);
        for (Row row : acctBankDs.copy()) {
            ids.add(row.getLong("accountbank.id"));
        }
        return ids;
    }
}

