/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.helper.AcctBalanceServiceHelper;
import kd.tmc.mon.report.service.bankjournal.AccountBalanceQueryParam;
import kd.tmc.mon.report.service.bankjournal.AccountBalanceQueryService;

public class BalanceQueryServiceHelper {
    private static String accountField = "accountbank.id";

    public static DataSet queryAcctBalance(Map<String, Object> paramMap) {
        String dataSource = (String)paramMap.get("filter_datasource");
        Date bizDate = (Date)paramMap.get("filter_querydate");
        List orgIds = (List)paramMap.get("filter_org");
        if ("bankbalance".equals(dataSource)) {
            return BalanceQueryServiceHelper.getBankBalanceDs(paramMap, bizDate);
        }
        return BalanceQueryServiceHelper.getJournalBalanceByDate(orgIds, BalanceQueryServiceHelper.getAccountIds(paramMap), null, bizDate);
    }

    private static DataSet getJournalBalanceByDate(List<Long> orgIds, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        AccountBalanceQueryService queryService = new AccountBalanceQueryService();
        AccountBalanceQueryParam param = new AccountBalanceQueryParam();
        param.setOrgIds(orgIds).setAccountIds(new ArrayList<Long>(acctBankId)).setCurrencyIds(currencyId != null ? Collections.singletonList(currencyId) : null).setBeginDate(null).setEndDate(bizDate);
        DataSet dataSet = queryService.queryBankJournalBalance(param);
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = queryService.addBaseDataName(dataSet, "bos_org", "orgid", "orgname");
        dataSet = queryService.addBaseDataName(dataSet, "bd_finorginfo", "bankid", "finorginfoname");
        return dataSet.select(new String[]{"orgid as org", "orgname", "endBalance as dpt_balance", "bankid as finorginfo", "finorginfoname", "currencyid as currency"});
    }

    private static DataSet getJournalBalance_ByDate(List<Long> orgIds, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DataSet ds = null;
        for (Long orgId : orgIds) {
            DataSet tempDs = BalanceQueryServiceHelper.getJournalBalance_ByDate(orgId, acctBankId, currencyId, bizDate);
            if (ds == null) {
                ds = tempDs;
                continue;
            }
            if (!tempDs.isEmpty()) {
                ds = ds.union(tempDs);
            }
            IOUtils.closeQuietly((AutoCloseable)tempDs);
        }
        if (null == ds || ds.isEmpty()) {
            return null;
        }
        return ds.select(new String[]{"org", "orgname", "dpt_balance", "finorginfo", "finorginfoname", "currency"});
    }

    private static DataSet getBankBalanceDs(Map<String, Object> paramMap, Date date) {
        DynamicObjectCollection currencyDoc;
        Object finOrgInfos;
        Object allOrgIds = paramMap.get("filter_org");
        QFilter qFilter = new QFilter("company", "in", allOrgIds);
        qFilter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)Boolean.TRUE)));
        qFilter.and(new QFilter("accountbank.acctstatus", "!=", (Object)"closed"));
        boolean containInner = (Boolean)paramMap.get("filter_containinner");
        if (!containInner) {
            qFilter.and(new QFilter("accountbank.acctclassify", "=", (Object)"B"));
        }
        if (EmptyUtil.isNoEmpty((Object)(finOrgInfos = paramMap.get("filter_finorginfo")))) {
            qFilter = qFilter.and(new QFilter("accountbank.bank", "in", finOrgInfos));
        }
        if (!CollectionUtils.isEmpty((Collection)(currencyDoc = (DynamicObjectCollection)paramMap.get("filter_currency")))) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject currency : currencyDoc) {
                ids.add(currency.getLong("id"));
            }
            qFilter.and(new QFilter("currency", "in", ids));
        }
        String selectFields = "id, company.id as org, company.name as orgname,accountbank.bank as finorginfo,accountbank.bank.name as finorginfoname, accountbank.id, currency.id, currency, lstbalance, amount endBalance, bizdate";
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)"getbankbalanceDs", (String)"bei_bankbalance", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        DataSet balanceDataSetLastGroup = balanceDataSet.groupBy(new String[]{"accountbank.id", "org", "orgname", "finorginfo", "finorginfoname", "currency.id"}).max("bizdate").finish();
        return balanceDataSetLastGroup.join(balanceDataSet, JoinType.LEFT).on("accountbank.id", "accountbank.id").on("currency.id", "currency.id").on("bizdate", "bizdate").select(new String[]{"org", "orgname", "endBalance as dpt_balance", "finorginfo", "finorginfoname", "currency"}).finish();
    }

    private static DataSet getJournalBalance_ByDate(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DataSet ds;
        DataSet beginBalanceDs = BalanceQueryServiceHelper.getDayBeginBalance(orgId, acctBankId, currencyId, bizDate);
        DataSet dsData = ds = BalanceQueryServiceHelper.getRangeJournal(orgId, acctBankId, currencyId, bizDate, DateUtils.getNextDay((Date)bizDate, (int)1));
        if (!beginBalanceDs.isEmpty()) {
            dsData = ds.isEmpty() ? beginBalanceDs : ds.union(beginBalanceDs);
        }
        DataSet result = dsData.addField("monthbalance + debitamount - creditamount", "dpt_balance").groupBy(new String[]{"org", "orgname", "finorginfo", "finorginfoname", "currency.id as currency"}).sum("dpt_balance").finish();
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{beginBalanceDs, ds, dsData});
        return result;
    }

    private static DataSet getDayBeginBalance(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DataSet ds;
        DataSet periodBalance = BalanceQueryServiceHelper.getPeriodBalance(orgId, acctBankId, currencyId, bizDate);
        DataSet beginBalanceDs = periodBalance.removeFields(new String[]{"period.id"});
        Date newBeginDate = AcctBalanceServiceHelper.getBeginDate(orgId, bizDate);
        DataSet dsData = ds = BalanceQueryServiceHelper.getRangeJournal(orgId, acctBankId, currencyId, newBeginDate, bizDate);
        if (ds.isEmpty()) {
            dsData = beginBalanceDs;
        }
        if (!beginBalanceDs.isEmpty()) {
            dsData = ds.union(beginBalanceDs);
        }
        DataSet dataSet = dsData.groupBy(new String[]{"org", "orgname", accountField, "finorginfo", "finorginfoname", "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
        DataSet result = dataSet.select(new String[]{"org", "orgname", accountField, "finorginfo", "finorginfoname", "currency.id", "currency", "monthbalance+debitamount-creditamount monthbalance", "0 debitamount", "0 creditamount"});
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{beginBalanceDs, ds, dataSet, dsData});
        return result;
    }

    private static DataSet getPeriodBalance(Long orgId, Set<Long> acctBankId, Long currencyId, Date bizDate) {
        DynamicObject period = AcctBalanceServiceHelper.getPeriodByDate(orgId, bizDate);
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and(new QFilter(accountField, "!=", (Object)0)).and(new QFilter("type", "=", (Object)"2"));
        if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
            filter = filter.and("period.id", "<=", (Object)period.getLong("id"));
        }
        if (acctBankId != null) {
            filter = filter.and(new QFilter(accountField, "in", acctBankId));
        }
        if (currencyId != null) {
            filter = filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        }
        DataSet journalBalDs = QueryServiceHelper.queryDataSet((String)"journalBallance", (String)"cas_journalbalance", (String)("org.id as org,org.name as orgname,accountbank.bank as finorginfo,accountbank.bank.name as finorginfoname," + accountField + ",currency.id,currency.name currency,period.id,monthstart as monthbalance"), (QFilter[])new QFilter[]{filter}, null);
        DataSet currentPeriodDs = QueryServiceHelper.queryDataSet((String)"currentPeriodBal", (String)"cas_journalbalance", (String)("org.id as org,org.name as orgname,accountbank.bank as finorginfo,accountbank.bank.name as finorginfoname," + accountField + ",currency.id,currency.name currency,period.id"), (QFilter[])new QFilter[]{filter}, null).groupBy(new String[]{"org", accountField, "finorginfo", "finorginfoname", "currency.id", "currency"}).max("period.id").finish();
        DataSet resultDs = journalBalDs.join(currentPeriodDs, JoinType.INNER).on("org", "org").on(accountField, accountField).on("currency.id", "currency.id").on("period.id", "period.id").select(new String[]{"org", "orgname", accountField, "finorginfo", "finorginfoname", "currency.id", "currency", "period.id", "monthbalance", "0 debitamount", "0 creditamount"}).finish();
        IOUtils.closeQuietly((AutoCloseable)journalBalDs);
        IOUtils.closeQuietly((AutoCloseable)currentPeriodDs);
        return resultDs;
    }

    private static DataSet getRangeJournal(Long orgId, Set<Long> acctBankId, Long currencyId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and("bookdate", "<", (Object)endDate);
        if (beginDate != null) {
            filter.and("bookdate", ">=", (Object)beginDate);
        }
        if (acctBankId != null) {
            filter = filter.and(new QFilter(accountField, "in", acctBankId));
        }
        if (currencyId != null) {
            filter = filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bankJournal", (String)"cas_bankjournal", (String)("org.id as org,org.name as orgname,accountbank.bank as finorginfo,accountbank.bank.name as finorginfoname," + accountField + ",currency.id,currency.name currency,0 monthbalance,debitamount,creditamount"), (QFilter[])filter.toArray(), null);
        DataSet result = dataSet.groupBy(new String[]{"org", "orgname", accountField, "finorginfo", "finorginfoname", "currency.id", "currency"}).sum("monthbalance").sum("debitamount").sum("creditamount").finish();
        IOUtils.closeQuietly((AutoCloseable)dataSet);
        return result;
    }

    private static Set<Long> getAccountIds(Map<String, Object> customParam) {
        DataSet acctDS;
        Object finOrgInfos;
        QFilter filter = new QFilter("acctstatus", "!=", (Object)"closed");
        boolean containInner = (Boolean)customParam.get("filter_containinner");
        if (!containInner) {
            filter.and(new QFilter("acctclassify", "=", (Object)"B"));
        }
        if (EmptyUtil.isNoEmpty((Object)(finOrgInfos = customParam.get("filter_finorginfo")))) {
            filter.and(new QFilter("bank", "in", finOrgInfos));
        }
        if (null == (acctDS = QueryServiceHelper.queryDataSet((String)"getAccountIds", (String)"am_accountbank", (String)"id", (QFilter[])filter.toArray(), null)) || acctDS.isEmpty()) {
            return null;
        }
        HashSet<Long> accountIds = new HashSet<Long>();
        for (Row row : acctDS) {
            accountIds.add(row.getLong("id"));
        }
        return accountIds;
    }
}

