/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ExpireBizWarnHelper {
    public static Map<String, String> getColumsConfig() {
        HashMap<String, String> columsMap = new HashMap<String, String>();
        columsMap.put("cfm_creditlimit", "'cfm_creditlimit'   billtype, credittype.name biztype, '-' as contractbillno, '-' as contractno,number billno,enddate expiredate,org.name orgname,bank,banktype,bank.name bankname,currency,totalamt amount,totalamt expireamount, 1 sort");
        columsMap.put("cfm_loanbill_b_l", "'cfm_loanbill_b_l'      billtype, loantype,finproduct.name biztype, '-' as contractbillno, '-' as contractno,billno, (case when renewalexpiredate is null then expiredate else renewalexpiredate end) as expiredate,org.name orgname,textcreditor bankname,currency,drawamount amount,notrepayamount expireamount, 2 sort");
        columsMap.put("cdm_payablebill", "'cdm_payablebill' billtype,draftbilltype.name biztype, '-' as contractbillno, '-' as contractno,billno,draftbillexpiredate expiredate,drawername orgname,acceptername bankname,currency,amount,amount expireamount, 5 sort");
        columsMap.put("lc_arrival", "'lc_arrival' billtype,credittype.name biztype, '-' as contractbillno, '-' as contractno,billno,endpaydate expiredate,org.name orgname,lettercredit.bank.name bankname,arrivalcurrency currency,arrivalamount amount,todoamount expireamount,arrivaltype, 6 sort");
        columsMap.put("gm_letterofguarantee", "'gm_letterofguarantee' billtype,guaranteetype.name biztype, '-' as contractbillno, '-' as contractno,billno,expiredate,applyorg.name orgname,finorginfo.name bankname,currency,amount,amount expireamount, 7 sort");
        columsMap.put("gm_guaranteecontract", "id,'gm_guaranteecontract' billtype,guarantee.name biztype, '-' as contractbillno, '-' as contractno,billno,enddate expiredate,guaranteeorgtext orgname,guaranteedorgtext bankname,currency,amount, 8 sort");
        columsMap.put("cim_invest_loanbill", "'cim_invest_loanbill' billtype, finproduct.name biztype, '-' as contractbillno, '-' as contractno,billno, (case when renewalexpiredate is null then expiredate else renewalexpiredate end) as expiredate,creditorg.name orgname,textdebtor bankname,currency,drawamount amount,notrepayamount expireamount, 9 sort");
        columsMap.put("cim_finsubscribe", "'cim_finsubscribe' billtype, investvarieties.name biztype, '-' as contractbillno, '-' as contractno,billno,expiredate,org.name orgname,finorginfo.name bankname,currency,amount,surplusamount expireamount,redeemway, 10 sort");
        columsMap.put("cdm_receivablebill", "'cdm_receivablebill' billtype, draftbilltype.name biztype, '-' as contractbillno, '-' as contractno,billno,draftbillexpiredate expiredate,company.name orgname,acceptername bankname,currency,amount,amount expireamount,11 sort");
        columsMap.put("lc_present", "'lc_present' billtype,credittype.name biztype, '-' as contractbillno, '-' as contractno,billno,endpaydate expiredate,org.name orgname,lettercredit.bank.name bankname,arrivalcurrency currency,arrivalamount amount,todoamount expireamount,arrivaltype, 12 sort");
        columsMap.put("gm_receiveletter", "'gm_receiveletter' billtype,guaranteetype.name biztype, '-' as contractbillno, '-' as contractno,billno,expiredate,applyorg.name orgname,finorginfo.name bankname,currency,amount,amount expireamount, 13 sort");
        columsMap.put("cim_deposit", "'cim_deposit' billtype,investvarieties.name biztype, '-' as contractbillno, '-' as contractno,billno,expiredate,org.name orgname,finorginfo.name bankname,currency,amount,surplusamount expireamount, 14 sort");
        columsMap.put("fl_receiptbill", "'fl_receiptbill'      billtype, loantype,finproduct.name biztype, loancontractbill.number contractbillno, loancontractbill.contractno contractno,billno, (case when renewalexpiredate is null then expiredate else renewalexpiredate end) as expiredate,org.name orgname,textcreditor bankname,currency,drawamount amount,notrepayamount expireamount, 2 sort");
        return columsMap;
    }

    public static Map<String, Pair<String, String>> getFilterColums() {
        HashMap<String, Pair<String, String>> columsMap = new HashMap<String, Pair<String, String>>();
        columsMap.put("cfm_creditlimit", Pair.of((Object)"org", (Object)"enddate"));
        columsMap.put("cfm_loanbill_b_l", Pair.of((Object)"org", (Object)"expiredate"));
        columsMap.put("cfm_loanbill_e_l", Pair.of((Object)"org", (Object)"expiredate"));
        columsMap.put("cfm_loanbill_bond", Pair.of((Object)"org", (Object)"expiredate"));
        columsMap.put("cdm_payablebill", Pair.of((Object)"company", (Object)"draftbillexpiredate"));
        columsMap.put("lc_arrival", Pair.of((Object)"org", (Object)"endpaydate"));
        columsMap.put("gm_letterofguarantee", Pair.of((Object)"applyorg", (Object)"expiredate"));
        columsMap.put("gm_guaranteecontract", Pair.of((Object)"guaranteeorg", (Object)"enddate"));
        columsMap.put("cim_invest_loanbill", Pair.of((Object)"creditorg", (Object)"expiredate"));
        columsMap.put("cim_finsubscribe", Pair.of((Object)"org", (Object)"expiredate"));
        columsMap.put("cdm_receivablebill", Pair.of((Object)"company", (Object)"draftbillexpiredate"));
        columsMap.put("lc_present", Pair.of((Object)"org", (Object)"endpaydate"));
        columsMap.put("gm_receiveletter", Pair.of((Object)"applyorg", (Object)"expiredate"));
        columsMap.put("cim_deposit", Pair.of((Object)"org", (Object)"expiredate"));
        columsMap.put("fl_receiptbill", Pair.of((Object)"org", (Object)"expiredate"));
        return columsMap;
    }

    public static Map<String, String> getExtendDateFilter() {
        HashMap<String, String> columsMap = new HashMap<String, String>();
        columsMap.put("cfm_loanbill_b_l", "renewalexpiredate");
        columsMap.put("cfm_loanbill_e_l", "renewalexpiredate");
        columsMap.put("cfm_loanbill_bond", "renewalexpiredate");
        columsMap.put("cim_invest_loanbill", "renewalexpiredate");
        return columsMap;
    }

    public static Set<Long> getPropVals(DataSet ds, String prop) {
        HashSet<Long> vals = new HashSet<Long>();
        ds.copy().forEach(d -> {
            if (CreditFinTypeEnum.ORG.getValue().equals(d.getString("banktype"))) {
                vals.add(d.getLong(prop));
            }
        });
        return vals;
    }

    public static QFilter getLoanFilterByType(Set<String> billTypeSet) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("confirmstatus", "=", (Object)"yetconfirm")).and(new QFilter("lendernature", "=", (Object)"ingroup").or(new QFilter("datasource", "!=", (Object)"invest"))).and(new QFilter("drawtype", "!=", (Object)"closeout")).and(new QFilter("notrepayamount", ">", (Object)0));
        HashSet<String> loanTypes = new HashSet<String>();
        if (billTypeSet.contains("cfm_loanbill_b_l")) {
            loanTypes.add("sl");
            loanTypes.add("loan");
        }
        if (billTypeSet.contains("cfm_loanbill_e_l")) {
            loanTypes.add("entrust");
            loanTypes.add("ec");
        }
        if (billTypeSet.contains("cfm_loanbill_bond")) {
            loanTypes.add("bond");
        }
        if (billTypeSet.contains("fl_receiptbill")) {
            loanTypes.add("fl");
            loanTypes.add("finlease");
        }
        if (loanTypes.size() != 0 && loanTypes.size() != 5) {
            filter.and(new QFilter("loantype", "in", loanTypes));
        }
        return filter;
    }

    public static Set<String> getBillTypes(String billTypes) {
        String[] billTypeArr = billTypes.split(",");
        Set billTypeSet = Arrays.stream(billTypeArr).filter(o -> EmptyUtil.isNoEmpty((String)o)).collect(Collectors.toSet());
        Set<String> newTypeSet = billTypeSet.stream().filter(o -> !"cfm_loanbill_b_l".equals(o) && !"cfm_loanbill_bond".equals(o) && !"cfm_loanbill_e_l".equals(o)).collect(Collectors.toSet());
        if (billTypeSet.size() != newTypeSet.size()) {
            newTypeSet.add("cfm_loanbill_b_l");
        }
        return newTypeSet;
    }

    public static QFilter getOrgFilter(QFilter filter, DynamicObjectCollection filterOrgs, String orgName, String appId) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterOrgs)) {
            Set orgIds = filterOrgs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            filter.and(new QFilter(orgName, "in", orgIds));
        } else {
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"mon_expirebizwarnrpt", (String)"47150e89000000ac");
            filter.and(new QFilter(orgName, "in", (Object)comIdList));
        }
        return filter;
    }

    public static QFilter getOrgFilter(QFilter filter, List<Long> orgId, String orgName, String appId) {
        if (EmptyUtil.isNoEmpty(orgId)) {
            filter.and(new QFilter(orgName, "in", orgId));
        } else {
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"mon_expirebizwarnrpt", (String)"47150e89000000ac");
            if (EmptyUtil.isEmpty((Collection)comIdList)) {
                throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u62a5\u8868\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7", (String)"ExpireBizWarnHelper_0", (String)"tmc-mon-report", (Object[])new Object[0])});
            }
            filter.and(new QFilter(orgName, "in", (Object)comIdList));
        }
        return filter;
    }
}

