/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinReportHelper
extends AbstractReportFormPlugin {
    @Deprecated
    public static DataSet getExChangeDataSet(DataSet currencyDataSet, Long exChangetabelid, Long tarCurrencyId, Long orgId, Date date) {
        if (EmptyUtil.isEmpty((Long)exChangetabelid)) {
            exChangetabelid = FinReportHelper.getExchageTableId(orgId);
        }
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("tarcurrency", (DataType)DataType.LongType));
        field.add(new Field("rate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>();
        for (Row row : currencyDataSet) {
            Long currencyId = row.getLong("currency");
            if (rateMap.containsKey(currencyId)) continue;
            if (currencyId.equals(tarCurrencyId)) {
                rateMap.put(currencyId, BigDecimal.ONE);
                continue;
            }
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exChangetabelid, (Long)currencyId, (Long)tarCurrencyId, (Date)date);
            if (exchangeRate == null) {
                DynamicObject fromCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"name");
                DynamicObject toCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)tarCurrencyId, (String)"bd_currency", (String)"name");
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u627e\u4e0d\u5230%2$s\u5151%3$s\u7684\u6c47\u7387", (String)"FinReportHelper_0", (String)"tmc-mon-report", (Object[])new Object[0]), EmptyUtil.isNoEmpty((DynamicObject)org) ? org.getString("name") : null, EmptyUtil.isNoEmpty((DynamicObject)fromCurrency) ? fromCurrency.getString("name") : null, EmptyUtil.isNoEmpty((DynamicObject)toCurrency) ? toCurrency.getString("name") : null));
            }
            rateMap.put(currencyId, exchangeRate);
        }
        for (Long currencyId : rateMap.keySet()) {
            Object[] obj = new Object[]{currencyId, rateMap.get(currencyId)};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    public static Long getExchageTableId(Long orgId) {
        DynamicObject standardExRateTable;
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long exchangeTableId = null;
        if (EmptyUtil.isNoEmpty((Object)baseAccountingInfo)) {
            exchangeTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        }
        if (EmptyUtil.isEmpty(exchangeTableId) && EmptyUtil.isNoEmpty((DynamicObject)(standardExRateTable = SystemStatusCtrolHelper.getStandardExRateTable((long)orgId)))) {
            exchangeTableId = standardExRateTable.getLong("id");
        }
        return exchangeTableId;
    }

    public static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    public static DataSet getBdFinorgInfo(Set<Long> bankIds, String parentField) {
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)"getBdFinorgInfo", (String)"bd_finorginfo", (String)("id,name," + parentField + " pid"), (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)}, null).addField("id", "rowid").addField("case when pid=0 then '1' else '0' end ", "isgroupnode").addField("case when pid=0 then 1 else 2 end ", "level");
        return finOrgDs;
    }

    public static DataSet getBaseDataDs(Set<Long> bankTypeIds, String entityName) {
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)"getBankcgSetting", (String)entityName, (String)"id,name,0 pid", (QFilter[])new QFilter[]{new QFilter("id", "in", bankTypeIds)}, null).addField("id", "rowid").addField("'1'", "isgroupnode").addField("1", "level");
        return finOrgDs;
    }

    public static String getTotalCaption(String type) {
        switch (type) {
            case "bank": {
                return ResManager.loadKDString((String)"\u94f6\u884c", (String)"AbstractTmcListDataPlugin_3", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            case "finorg": {
                return ResManager.loadKDString((String)"\u975e\u94f6\u884c", (String)"AbstractTmcListDataPlugin_4", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            case "settlecenter": {
                return ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"AbstractTmcListDataPlugin_5", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            case "innerunit": {
                return ResManager.loadKDString((String)"\u5185\u90e8\u5355\u4f4d", (String)"AbstractTmcListDataPlugin_6", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            case "custom": {
                return ResManager.loadKDString((String)"\u5ba2\u5546", (String)"AbstractTmcListDataPlugin_7", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            case "other": {
                return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AbstractTmcListDataPlugin_8", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static QFilter getLoandTypeFilter(String loandType) {
        if ("sl".equals(loandType)) {
            return new QFilter("loantype", "=", (Object)"sl");
        }
        if ("bond".equals(loandType)) {
            return new QFilter("loantype", "=", (Object)"bond").and(new QFilter("investor_entry.id", "!=", (Object)0));
        }
        return new QFilter("loantype", "in", (Object)new String[]{"loan", "entrust", "ec"});
    }

    public static DynamicObject getBaseCurrency(Long orgId) {
        DynamicObject baseCcy = TmcBusinessBaseHelper.getCasBaseCurrency((long)orgId);
        if (baseCcy == null) {
            baseCcy = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
        }
        return baseCcy;
    }
}

