/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mon.report.helper.OrgServiceQueryHelper;

public class FundDailyHelper {
    public static Map<String, Object> getParamMap(ReportQueryParam param) {
        return FundDailyHelper.transQueryParam(param);
    }

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    public static List<Long> getOrgIds(Map<String, Object> paramMap) {
        Map<String, Object> getOrgMap = null;
        String filterType = (String)paramMap.get("filter_searchtype");
        if ("queryorg".equals(filterType)) {
            DynamicObjectCollection orgDoc = (DynamicObjectCollection)paramMap.get("filter_company");
            getOrgMap = FundDailyHelper.getOrgMap(orgDoc);
        } else {
            DynamicObject dynamicObject = (DynamicObject)paramMap.get("filter_compview");
            getOrgMap = FundDailyHelper.getOrgMap(dynamicObject);
        }
        List orgIds = (List)getOrgMap.get("list");
        return orgIds;
    }

    public static List<QFilter> baseFilter(Map<String, Object> paramMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        Map<String, Object> getOrgMap = null;
        String filterType = (String)paramMap.get("filter_searchtype");
        if ("queryorg".equals(filterType)) {
            DynamicObjectCollection orgDoc = (DynamicObjectCollection)paramMap.get("filter_company");
            getOrgMap = FundDailyHelper.getOrgMap(orgDoc);
        } else {
            DynamicObject dynamicObject = (DynamicObject)paramMap.get("filter_compview");
            getOrgMap = FundDailyHelper.getOrgMap(dynamicObject);
        }
        List getOrgIds = (List)getOrgMap.get("list");
        QFilter filterOrg = new QFilter("org", "in", (Object)getOrgIds);
        filters.add(filterOrg);
        DynamicObject current = (DynamicObject)paramMap.get("filter_currencies");
        QFilter filterCurrent = new QFilter("currency", "=", current.getPkValue());
        filters.add(filterCurrent);
        Date beginDate = (Date)paramMap.get("filter_begindate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        QFilter filterDate = new QFilter("bookdate", ">=", (Object)DateUtils.getDataFormat((Date)beginDate, (boolean)true)).and(new QFilter("bookdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        filters.add(filterDate);
        return filters;
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>(32);
        if (orgList == null) {
            return idList;
        }
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static Map<String, Object> getOrgMap(DynamicObjectCollection orgList) {
        if (orgList == null) {
            return new HashMap<String, Object>(32);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        ArrayList<Long> idList = new ArrayList<Long>(32);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(32);
        for (DynamicObject org : orgList) {
            Long orgId = org.getLong("id");
            idList.add(orgId);
            orgMap.put(orgId, org.getString("name"));
        }
        returnMap.put("list", idList);
        returnMap.put("map", orgMap);
        return returnMap;
    }

    public static Map<String, Object> getOrgMap(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return new HashMap<String, Object>(2);
        }
        String companyViewNum = dynamicObject.getString("number");
        return OrgServiceQueryHelper.getInstance().getAllOrgByViewNumber(companyViewNum);
    }

    public static List<Date> getDatesBetweenDate(Date beginDate, Date endDate, int DateCycle) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Date> listDate = new ArrayList<Date>(16);
        listDate.add(beginDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        while (bContinue) {
            cal.add(5, DateCycle);
            if (!date.after(cal.getTime())) break;
            listDate.add(cal.getTime());
        }
        return listDate;
    }

    public static List<String> getStringDatesBetweenDate(Date beginDate, Date endDate, int DateCycle) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        ArrayList<String> listDate = new ArrayList<String>(16);
        listDate.add(sdf.format(beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, DateCycle);
            if (!endDate.after(cal.getTime())) break;
            listDate.add(sdf.format(cal.getTime()));
        }
        listDate.add(sdf.format(endDate));
        return listDate;
    }

    public static List<String> getDateBetweenDate(Date beginDate, Date endDate, int DateCycle) throws ParseException {
        String str = String.format("yyyy%sMM%sdd%s", ResManager.loadKDString((String)"\u5e74", (String)"FundDailyHelper_02", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6708", (String)"FundDailyHelper_03", (String)"tmc-mon-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5", (String)"FundDailyHelper_04", (String)"tmc-mon-report", (Object[])new Object[0]));
        SimpleDateFormat sdf = new SimpleDateFormat(str);
        ArrayList<String> listDate = new ArrayList<String>(16);
        listDate.add(sdf.format(beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, DateCycle);
            if (!endDate.after(cal.getTime())) break;
            listDate.add(sdf.format(cal.getTime()));
        }
        listDate.add(sdf.format(endDate));
        return listDate;
    }

    public static DataSet buildTotalDataSet(DataSet dataSet, String totalSumCol, List<String> countColumns) {
        DataSet totakDataSet = dataSet.copy();
        GroupbyDataSet groupbyDataSet = totakDataSet.copy().groupBy(null);
        for (String countColumn : countColumns) {
            groupbyDataSet.sum(countColumn);
        }
        totakDataSet = groupbyDataSet.finish();
        Field[] groupFields = totakDataSet.getRowMeta().getFields();
        HashSet groupFieldsSet = new HashSet();
        Stream.of(groupFields).forEach(record -> groupFieldsSet.add(record.getAlias()));
        Field[] reportAllFields = dataSet.getRowMeta().getFields();
        ArrayList<String> groupSelectFields = new ArrayList<String>(reportAllFields.length);
        for (Field field : reportAllFields) {
            String fieldName;
            String emptyField = fieldName = field.getAlias();
            if (!groupFieldsSet.contains(fieldName)) {
                emptyField = "null as " + fieldName;
                if (totalSumCol.equalsIgnoreCase(fieldName)) {
                    emptyField = "'" + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FundDailyHelper_01", (String)"tmc-mon-report", (Object[])new Object[0]) + "'" + "as" + fieldName;
                }
                if ("summarytype".equalsIgnoreCase(fieldName)) {
                    emptyField = String.format("%s as %s", "1", fieldName);
                }
                if (countColumns.contains(fieldName.toLowerCase(Locale.ROOT))) {
                    emptyField = fieldName;
                }
            }
            groupSelectFields.add(emptyField);
        }
        totakDataSet = totakDataSet.select(groupSelectFields.toArray(new String[groupSelectFields.size()]));
        return totakDataSet;
    }

    public static DataSet mergeTotalDataSet(DataSet dataSet, DataSet totalDataSet, String clazzName) {
        Algo algo = Algo.create((String)clazzName);
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        for (Row row : dataSet) {
            datasetBuilder.append(row);
        }
        for (Row row : totalDataSet) {
            datasetBuilder.append(row);
        }
        return datasetBuilder.build();
    }
}

