/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.enums.StatisCycleEnum;
import kd.tmc.mon.report.helper.ReportCommonHelper;

public class CPevalutionService {
    private static final String[] GROUPBY_FIELD = new String[]{"name", "currency"};
    private static final String[] GROUPBY_FIELD1 = new String[]{"name"};
    private static final String[] ORDERBY_FIELD = new String[]{"amout desc"};
    private static final String[] SELECT_FIELD = new String[]{"amout", "currency"};
    private static final String[] SELECT_FIELD2 = new String[]{"name"};
    private static final String[] SELECT_FIELDALL = new String[]{"amout", "currency", "name"};
    private static final Long DEFAULTORGVIEWID = 8L;
    private static final Log logger = LogFactory.getLog(CPevalutionService.class);

    public static DataSet getDataByParam(ReportQueryParam reportQueryParam, boolean isDataList) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(reportQueryParam);
        paramMap.putAll(reportQueryParam.getCustomParam());
        Long reportCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        int topnum = Integer.parseInt((String)paramMap.get("topnum"));
        DataSet dataSet = CPevalutionService.getInitDataSet(paramMap);
        DataSet currencySet = dataSet.groupBy(GROUPBY_FIELD).sum("amout").finish();
        Long orgId = TmcOrgDataHelper.getCurrentOrgId();
        Date today = new Date();
        Algo algo = Algo.create((String)CPevalutionService.class.getName());
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(currencySet.getRowMeta());
        Long exRateTableId = ((DynamicObject)paramMap.get("exratetable")).getLong("id");
        while (currencySet.hasNext()) {
            Object[] rowData = new Object[3];
            Row row = currencySet.next();
            BigDecimal tempRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)row.getLong("currency"), (Long)reportCurrencyId, (Date)today);
            BigDecimal rate = EmptyUtil.isEmpty((BigDecimal)tempRate) ? BigDecimal.ONE : tempRate;
            rowData[0] = row.getString(0);
            rowData[1] = row.getLong(1);
            rowData[2] = row.getBigDecimal(2).multiply(rate).divide(BigDecimal.valueOf(10000L), 4, 4);
            datasetBuilder.append(rowData);
        }
        DataSet resultSet = datasetBuilder.build().groupBy(GROUPBY_FIELD1).sum("amout").finish().orderBy(ORDERBY_FIELD);
        if (isDataList) {
            resultSet = resultSet.top(topnum).select("name as recpayer,'' as sortnum,amout").addField(reportCurrencyId + "", "currencyfield");
        }
        currencySet.close();
        return resultSet;
    }

    public static Map<String, Date> getStartEndDate(StatisCycleEnum statTypeEnum, Map<String, Object> paramMap) {
        Date enddate;
        Date startdate;
        Date today = new Date();
        switch (statTypeEnum) {
            case LASTYEAR: {
                startdate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)today, (int)1));
                enddate = DateUtils.getLastYearDate((Date)DateUtils.getLastYear((Date)today, (int)1));
                break;
            }
            case THISYEAR: {
                startdate = DateUtils.getFirstDayOfCurYear();
                enddate = DateUtils.getLastDayOfCurYear();
                break;
            }
            case LASTMONTH: {
                startdate = DateUtils.getMinMonthDate((Date)DateUtils.getLastMonth((Date)today, (int)1));
                enddate = DateUtils.getMaxMonthDate((Date)DateUtils.getLastMonth((Date)today, (int)1));
                break;
            }
            case THISMONTH: {
                startdate = DateUtils.getFirstDayOfCurMonth();
                enddate = DateUtils.getLastDayOfCurMonth();
                break;
            }
            case CONSTOM: {
                startdate = (Date)paramMap.get("daterangefield_startdate");
                enddate = (Date)paramMap.get("daterangefield_enddate");
                break;
            }
            default: {
                startdate = DateUtils.getFirstDayOfCurYear();
                enddate = DateUtils.getLastDayOfCurYear();
            }
        }
        HashMap<String, Date> resultMap = new HashMap<String, Date>(5);
        resultMap.put("start_date", startdate);
        resultMap.put("end_date", DateUtils.getDataFormat((Date)enddate, (boolean)false));
        return resultMap;
    }

    public static DataSet getCurrentSet(ReportQueryParam reportQueryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(reportQueryParam);
        paramMap.putAll(reportQueryParam.getCustomParam());
        QFilter[] filters = CPevalutionService.initQfilter(paramMap, "cas_bankjournal");
        DataSet currDataSet = QueryServiceHelper.queryDataSet((String)CPevalutionService.class.getName(), (String)"cas_bankjournal", (String)"currency", (QFilter[])filters, (String)"").groupBy(new String[]{"currency"}).finish();
        return currDataSet;
    }

    private static QFilter[] initQfilter(Map<String, Object> paramMap, String entityName) {
        boolean statsInnerAcct;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String statType = (String)paramMap.get("stattype");
        StatisCycleEnum statTypeEnum = StatisCycleEnum.getByCode((String)statType);
        Map<String, Date> dateMap = CPevalutionService.getStartEndDate(statTypeEnum, paramMap);
        Date startdate = dateMap.get("start_date");
        Date enddate = dateMap.get("end_date");
        String propertyName = "bookdate";
        if ("bei_transdetail".equals(entityName)) {
            propertyName = "bizdate";
            filters.add(CPevalutionService.initOrgFilter(paramMap, "company"));
        }
        QFilter startDateFilter = new QFilter(propertyName, ">=", (Object)startdate);
        QFilter endDateFilter = new QFilter(propertyName, "<=", (Object)enddate);
        filters.add(startDateFilter);
        filters.add(endDateFilter);
        Object statcurrency = paramMap.get("statcurrency");
        if (EmptyUtil.isNoEmpty((Object)statcurrency)) {
            DynamicObjectCollection currencyid = (DynamicObjectCollection)statcurrency;
            QFilter currencyFilter = new QFilter("currency", "in", currencyid.stream().filter(EmptyUtil::isNoEmpty).map(e -> e.getLong("id")).collect(Collectors.toList()));
            filters.add(currencyFilter);
        }
        if (!(statsInnerAcct = ((Boolean)paramMap.get("statsinneracct")).booleanValue())) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{acctFilter});
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter innerAcctFilter = new QFilter("accountbank", "in", acctIds);
            filters.add(innerAcctFilter);
        }
        if ("cas_bankjournal".equals(entityName)) {
            QFilter recpayertypeFilter = new QFilter("recpayertype", "=", paramMap.get("recpayertype"));
            filters.add(recpayertypeFilter);
            QFilter isinternal = new QFilter("isinternal", "=", (Object)"0");
            filters.add(isinternal);
            filters.add(CPevalutionService.initOrgFilter(paramMap, "org"));
        } else if ("bei_transdetail".equals(entityName)) {
            QFilter oppUnitFilter0 = new QFilter("oppunit", "!=", (Object)" ");
            QFilter oppUnitFilter1 = new QFilter("oppunit", "is not null", null);
            QFilter oppUnitFilter2 = new QFilter("oppunit", "!=", (Object)"");
            oppUnitFilter0.or(oppUnitFilter1).or(oppUnitFilter2);
            filters.add(oppUnitFilter0);
        }
        QFilter[] qFilters = new QFilter[filters.size()];
        filters.toArray(qFilters);
        return qFilters;
    }

    public static QFilter initOrgFilter(Map<String, Object> paramMap, String orgProp) {
        List orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)paramMap.get("formid");
        String appId = (String)paramMap.get("appid");
        String queryWay = (String)paramMap.get("filter_queryway");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)paramMap.get("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)paramMap.get("filter_org");
                orgIds = EmptyUtil.isEmpty(orgIds) ? TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true) : TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
            }
        } else {
            orgIds = (List)paramMap.get("filter_org");
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            if (paramMap.containsKey("filter_isincludelower") && ((Boolean)paramMap.get("filter_isincludelower")).booleanValue()) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)DEFAULTORGVIEWID, orgIds, (boolean)true);
            }
        }
        logger.info("\u6709\u6743\u9650\u7684\u7ec4\u7ec7id\uff1a" + orgIds);
        QFilter orgFilter = new QFilter(orgProp, "in", orgIds);
        return orgFilter;
    }

    public static DataSet getInitDataSet(Map<String, Object> paramMap) {
        String datasource = (String)paramMap.get("datasource");
        String bankJournalFiled = "currency,recpayer,(debitamount+creditamount) as amout";
        String transDetailFiled = "(debitamount+creditamount) as amout,currency,oppunit as name";
        String recpayertype = (String)paramMap.get("recpayertype");
        DataSet typeSet = QueryServiceHelper.queryDataSet((String)CPevalutionService.class.getName(), (String)recpayertype, (String)"id,name", null, (String)"");
        DataSet dataset = null;
        switch (datasource) {
            case "bankbalance": {
                QFilter[] transDetailQFilter = CPevalutionService.initQfilter(paramMap, "bei_transdetail");
                dataset = QueryServiceHelper.queryDataSet((String)"bei_transdetail", (String)"bei_transdetail", (String)transDetailFiled, (QFilter[])transDetailQFilter, null);
                dataset = dataset.join(typeSet).on("name", "name").select(SELECT_FIELDALL).finish();
                dataset = dataset.copy().filter("name != ' ' and name != null and name != ''").select(SELECT_FIELDALL);
                break;
            }
            case "directconnacct": {
                boolean statsInnerAcct = (Boolean)paramMap.get("statsinneracct");
                QFilter qFilter = new QFilter("enable", "=", (Object)true);
                if (!statsInnerAcct) {
                    qFilter.and(new QFilter("inneracct", "=", (Object)0L));
                }
                DynamicObjectCollection acctColls = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{qFilter});
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : acctColls) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                QFilter[] normalFilter = CPevalutionService.initQfilter(paramMap, "cas_bankjournal");
                ArrayList<QFilter> normalFilterList = new ArrayList<QFilter>();
                normalFilterList.addAll(Arrays.asList(normalFilter));
                normalFilterList.add(new QFilter("accountbank", "in", noDirectIds));
                DataSet baseJournalDS = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)bankJournalFiled, (QFilter[])normalFilterList.toArray(new QFilter[0]), null);
                DataSet journalDS = baseJournalDS.join(typeSet).on("recpayer", "id").select(SELECT_FIELD, SELECT_FIELD2).finish();
                QFilter[] transDetailFilter = CPevalutionService.initQfilter(paramMap, "bei_transdetail");
                ArrayList<QFilter> transDetailFilterList = new ArrayList<QFilter>();
                transDetailFilterList.addAll(Arrays.asList(transDetailFilter));
                transDetailFilterList.add(new QFilter("accountbank", "in", directIds));
                DataSet transDetailDS = QueryServiceHelper.queryDataSet((String)"bei_transdetail", (String)"bei_transdetail", (String)transDetailFiled, (QFilter[])transDetailFilterList.toArray(new QFilter[0]), null);
                DataSet transDS = transDetailDS.join(typeSet).on("name", "name").select(SELECT_FIELDALL).finish();
                transDS = transDS.copy().filter("name != ' ' and name != null and name != ''").select(SELECT_FIELDALL);
                dataset = journalDS.union(transDS);
                break;
            }
            default: {
                QFilter[] filters = CPevalutionService.initQfilter(paramMap, "cas_bankjournal");
                DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)"cas_bankjournal", (String)"cas_bankjournal", (String)bankJournalFiled, (QFilter[])filters, null);
                dataset = baseDataSet.join(typeSet).on("recpayer", "id").select(SELECT_FIELD, SELECT_FIELD2).finish();
            }
        }
        return dataset;
    }

    private static DataSet matchCustomerOrSupplier(DataSet dataSet) {
        DynamicObjectCollection customerDs = QueryServiceHelper.query((String)"bd_customer", (String)"name", null, null);
        final List customerNameList = customerDs.stream().map(e -> e.getString("name")).collect(Collectors.toList());
        DynamicObjectCollection supplierDs = QueryServiceHelper.query((String)"bd_supplier", (String)"name", null, null);
        final List supplierNameList = supplierDs.stream().map(e -> e.getString("name")).collect(Collectors.toList());
        dataSet = dataSet.copy().filter(new FilterFunction(){

            public boolean test(Row row) {
                String name = row.getString("name");
                return customerNameList.contains(name) || supplierNameList.contains(name);
            }
        });
        return dataSet;
    }
}

