/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.service.bankjournal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.report.service.bankjournal.AccountBalanceQueryParam;

public class AccountBalanceQueryService {
    public static final String ORG_ID = "orgid";
    public static final String PERIOD_ID = "periodid";
    public static final String ACCOUNT_ID = "accountid";
    public static final String CURRENCY_ID = "currencyid";
    public static final String BANK_ID = "bankid";
    private static final Integer TYPE_BANK_JOURNAL = 2;
    static final String JOURNAL_BALANCE_FIELDS = "org.id as orgid,accountbank.id as accountid,accountbank.bank.id as bankid,currency.id as currencyid,period.id as periodid,monthstart as monthbalance";
    static final String JOURNAL_FIELDS = "org.id as orgid,accountbank.id as accountid,accountbank.bank.id as bankid,currency.id as currencyid,debitamount,creditamount,bookdate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryBankJournalBalance(AccountBalanceQueryParam param) {
        Map<Long, Set<Long>> orgPeriodTypeMap = this.getOrgPeriodTypeMap(param);
        Map<Long, List<DynamicObject>> periodTypeMap = this.getPeriodTypeMap(param, orgPeriodTypeMap);
        DataSet dsBalance = null;
        for (Map.Entry<Long, Set<Long>> entry : orgPeriodTypeMap.entrySet()) {
            DataSet dsJournalAmount;
            DataSet dsBeginBalance;
            DataSet dsMaxPeriod;
            block4: {
                Long periodTypeId = entry.getKey();
                Set<Long> orgIds = entry.getValue();
                List<DynamicObject> periodList = periodTypeMap.get(periodTypeId);
                Set<Long> periodIds = periodList != null ? periodList.stream().map(p -> p.getLong("id")).collect(Collectors.toSet()) : null;
                dsMaxPeriod = this.getJournalBallanceMaxPeriod(param, orgIds, periodIds, TYPE_BANK_JOURNAL);
                dsBeginBalance = this.getBeginJournalBalance(param, orgIds, dsMaxPeriod.copy());
                dsJournalAmount = this.getJournalAmount(param, orgIds, dsMaxPeriod.copy());
                try {
                    dsBalance = dsBalance == null ? dsBeginBalance.copy() : dsBalance.union(dsBeginBalance);
                    if (dsJournalAmount == null) break block4;
                    dsBalance = dsBalance.union(dsJournalAmount);
                }
                catch (Throwable throwable) {
                    IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsMaxPeriod, dsBeginBalance, dsJournalAmount});
                    throw throwable;
                }
            }
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsMaxPeriod, dsBeginBalance, dsJournalAmount});
        }
        if (dsBalance == null) {
            return null;
        }
        return dsBalance.addField("monthbalance + debitamount - creditamount", "endBalance").groupBy(new String[]{ORG_ID, BANK_ID, CURRENCY_ID}).sum("monthbalance").sum("debitamount").sum("creditamount").sum("endBalance").finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSet> queryBankJournalBalanceTimeRange(AccountBalanceQueryParam param) {
        Map<Long, Set<Long>> orgPeriodTypeMap = this.getOrgPeriodTypeMap(param);
        Map<Long, List<DynamicObject>> periodTypeMap = this.getPeriodTypeMap(param, orgPeriodTypeMap);
        DataSet beginBalance = null;
        DataSet endBalance = null;
        for (Map.Entry<Long, Set<Long>> entry : orgPeriodTypeMap.entrySet()) {
            Long periodTypeId = entry.getKey();
            Set<Long> orgIds = entry.getValue();
            List<DynamicObject> periodList = periodTypeMap.get(periodTypeId);
            Set<Long> periodIds = periodList != null ? periodList.stream().map(p -> p.getLong("id")).collect(Collectors.toSet()) : null;
            DataSet dsMaxPeriod = this.getJournalBallanceMaxPeriod(param, orgIds, periodIds, TYPE_BANK_JOURNAL);
            DataSet dsBeginBalance = this.getBeginJournalBalance(param, orgIds, dsMaxPeriod.copy());
            List<DataSet> dsList = this.getJournalAmountTimeRange(param, orgIds, dsMaxPeriod.copy());
            try {
                beginBalance = this.gatherDataSet(beginBalance, dsBeginBalance, EmptyUtil.isNoEmpty(dsList) ? dsList.get(0) : null);
                endBalance = this.gatherDataSet(endBalance, dsBeginBalance, EmptyUtil.isNoEmpty(dsList) ? dsList.get(1) : null);
            }
            catch (Throwable throwable) {
                IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsMaxPeriod, dsBeginBalance});
                if (EmptyUtil.isNoEmpty(dsList)) {
                    IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)dsList.get(0), (AutoCloseable)dsList.get(1)});
                }
                throw throwable;
            }
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsMaxPeriod, dsBeginBalance});
            if (!EmptyUtil.isNoEmpty(dsList)) continue;
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)dsList.get(0), (AutoCloseable)dsList.get(1)});
        }
        if (beginBalance == null || endBalance == null) {
            return Collections.emptyList();
        }
        beginBalance = beginBalance.addField("monthbalance + debitamount - creditamount", "endBalance").groupBy(new String[]{ORG_ID, BANK_ID, ACCOUNT_ID, CURRENCY_ID}).sum("monthbalance").sum("debitamount").sum("creditamount").sum("endBalance").finish();
        endBalance = endBalance.addField("monthbalance + debitamount - creditamount", "endBalance").groupBy(new String[]{ORG_ID, BANK_ID, ACCOUNT_ID, CURRENCY_ID}).sum("monthbalance").sum("debitamount").sum("creditamount").sum("endBalance").finish();
        return Arrays.asList(beginBalance, endBalance);
    }

    private DataSet gatherDataSet(DataSet beginBalance, DataSet dsBeginBalance, DataSet listElement) {
        beginBalance = beginBalance == null ? dsBeginBalance.copy() : beginBalance.union(dsBeginBalance);
        if (null != listElement) {
            beginBalance = beginBalance.union(listElement);
        }
        return beginBalance;
    }

    private Map<Long, List<DynamicObject>> getPeriodTypeMap(AccountBalanceQueryParam param, Map<Long, Set<Long>> orgPeriodTypeMap) {
        QFilter qFilter = new QFilter("periodtype", "in", orgPeriodTypeMap.keySet()).and("begindate", "<=", (Object)param.getEndDate());
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id, periodtype, begindate", (QFilter[])qFilter.toArray());
        return periods.stream().collect(Collectors.groupingBy(p -> p.getLong("periodtype")));
    }

    private Map<Long, Set<Long>> getOrgPeriodTypeMap(AccountBalanceQueryParam param) {
        DynamicObjectCollection orgPeriodTypes = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org, periodtype.id", (QFilter[])new QFilter("org", "in", param.getOrgIds()).toArray());
        return orgPeriodTypes.stream().collect(Collectors.groupingBy(p -> p.getLong("periodtype.id"), Collectors.mapping(p -> p.getLong("org"), Collectors.toCollection(HashSet::new))));
    }

    private DataSet getJournalBallanceMaxPeriod(AccountBalanceQueryParam param, Set<Long> orgIds, Set<Long> periodIds, Integer type) {
        DataSet dsMaxPeriod;
        Date startDate;
        QFilter filter = new QFilter("org.id", "in", orgIds).and(new QFilter("accountbank.id", ">", (Object)0)).and(new QFilter("type", "=", (Object)type.toString()));
        if (EmptyUtil.isNoEmpty(periodIds)) {
            filter = filter.and("period.id", "in", periodIds);
        }
        Date date = startDate = EmptyUtil.isNoEmpty((Object)param.getBeginDate()) ? param.getBeginDate() : param.getEndDate();
        if (EmptyUtil.isNoEmpty((Object)startDate)) {
            filter = filter.and("period.begindate", "<=", (Object)startDate);
        }
        if ((dsMaxPeriod = QueryServiceHelper.queryDataSet((String)"getJournalBallanceMaxPeriod", (String)"cas_journalbalance", (String)"org.id as orgid,period.id as periodid", (QFilter[])filter.toArray(), null).groupBy(new String[]{ORG_ID}).max(PERIOD_ID).finish()).isEmpty()) {
            return dsMaxPeriod;
        }
        HashSet<Long> maxPeriodIds = new HashSet<Long>(10);
        for (Row row : dsMaxPeriod.copy()) {
            maxPeriodIds.add(row.getLong(PERIOD_ID));
        }
        DataSet dsPeriod = QueryServiceHelper.queryDataSet((String)"getJournalBallancePeriod", (String)"bd_period", (String)"id, begindate", (QFilter[])new QFilter("id", "in", maxPeriodIds).toArray(), null);
        return dsMaxPeriod.join(dsPeriod).on(PERIOD_ID, "id").select(new String[]{ORG_ID, PERIOD_ID}, new String[]{"begindate"}).finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getOriginalJournalDataSet(AccountBalanceQueryParam param, Set<Long> orgIds, DataSet dsMaxPeriod) {
        QFilter filter = new QFilter("org.id", "in", orgIds).and("bookdate", "<=", (Object)param.getEndDate());
        if (EmptyUtil.isNoEmpty(param.getAccountIds())) {
            filter = filter.and(new QFilter("accountbank.id", "in", param.getAccountIds()));
        }
        if (EmptyUtil.isNoEmpty(param.getCurrencyIds())) {
            filter = filter.and(new QFilter("currency.id", "in", param.getCurrencyIds()));
        }
        DataSet dsJournal = QueryServiceHelper.queryDataSet((String)"bankJournal", (String)"cas_bankjournal", (String)JOURNAL_FIELDS, (QFilter[])filter.toArray(), null);
        DataSet dataSet = null;
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(10);
        DataSet dsPeriod = dsMaxPeriod.copy();
        for (Row row : dsPeriod) {
            dateMap.put(row.getLong(ORG_ID), row.getDate("begindate"));
        }
        IOUtils.closeQuietly((AutoCloseable)dsPeriod);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(10);
        for (Long orgId : orgIds) {
            Date beginDate = (Date)dateMap.get(orgId);
            String dsFilter = String.format("%s = %d", ORG_ID, orgId);
            if (beginDate != null) {
                dsFilter = dsFilter + String.format(" and to_char(bookdate,'yyyy-MM-dd') > '%s'", DateUtils.formatString((Date)beginDate, (String)"yyyy-MM-dd"));
            }
            DataSet dsJournalData = null;
            try {
                dsJournalData = dsJournal.copy();
                DataSet filterData = dsJournalData.filter(dsFilter);
                if (!filterData.isEmpty()) {
                    dataSets.add(filterData);
                } else {
                    IOUtils.closeQuietly((AutoCloseable)filterData);
                }
                if (dataSets.isEmpty() || dataSets.size() % 50 != 0) continue;
                dataSet = this.unionDataSet(dataSet, dataSets);
            }
            finally {
                IOUtils.closeQuietly((AutoCloseable)dsJournalData);
            }
        }
        if (!dataSets.isEmpty()) {
            dataSet = this.unionDataSet(dataSet, dataSets);
        }
        return dataSet;
    }

    private DataSet getJournalAmount(AccountBalanceQueryParam param, Set<Long> orgIds, DataSet dsMaxPeriod) {
        DataSet dataSet = this.getOriginalJournalDataSet(param, orgIds, dsMaxPeriod);
        return dataSet != null ? dataSet.removeFields(new String[]{"bookdate"}).addField("0", "monthbalance") : null;
    }

    private List<DataSet> getJournalAmountTimeRange(AccountBalanceQueryParam param, Set<Long> orgIds, DataSet dsMaxPeriod) {
        DataSet dataSet = this.getOriginalJournalDataSet(param, orgIds, dsMaxPeriod);
        if (null == dataSet) {
            return Collections.emptyList();
        }
        DataSet beginDateDs = dataSet.copy();
        final Date beginDate = param.getBeginDate();
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            beginDateDs = beginDateDs.filter(new FilterFunction(){

                public boolean test(Row row) {
                    Date bookdate = row.getDate("bookdate");
                    return EmptyUtil.isNoEmpty((Object)bookdate) && bookdate.compareTo(beginDate) <= 0;
                }
            });
        }
        dataSet = dataSet.removeFields(new String[]{"bookdate"}).addField("0", "monthbalance");
        beginDateDs = beginDateDs.removeFields(new String[]{"bookdate"}).addField("0", "monthbalance");
        return Arrays.asList(beginDateDs, dataSet);
    }

    private DataSet unionDataSet(DataSet dataSet, List<DataSet> dataSets) {
        if (dataSet == null) {
            dataSet = dataSets.get(0);
            dataSets.remove(0);
        }
        if (!dataSets.isEmpty()) {
            dataSet = dataSet.union(dataSets.toArray(new DataSet[0]));
            IOUtils.closeAllQuietly(dataSets);
        }
        dataSets.clear();
        return dataSet;
    }

    private DataSet getBeginJournalBalance(AccountBalanceQueryParam param, Set<Long> orgIds, DataSet dsMaxPeriod) {
        QFilter filter = new QFilter("org.id", "in", orgIds).and(new QFilter("type", "=", (Object)"2"));
        if (EmptyUtil.isNoEmpty(param.getAccountIds())) {
            filter = filter.and(new QFilter("accountbank.id", "in", param.getAccountIds()));
        }
        if (EmptyUtil.isNoEmpty(param.getCurrencyIds())) {
            filter = filter.and(new QFilter("currency.id", "in", param.getCurrencyIds()));
        }
        DataSet dsJournalBalance = QueryServiceHelper.queryDataSet((String)"getBeginJournalBalance", (String)"cas_journalbalance", (String)JOURNAL_BALANCE_FIELDS, (QFilter[])filter.toArray(), null);
        return dsJournalBalance.join(dsMaxPeriod, JoinType.INNER).on(ORG_ID, ORG_ID).on(PERIOD_ID, PERIOD_ID).select(new String[]{ORG_ID, ACCOUNT_ID, BANK_ID, CURRENCY_ID, "0 debitamount", "0 creditamount", "monthbalance"}).finish();
    }

    public DataSet addBaseDataName(DataSet dsData, String entityName, String idProp, String nameProp) {
        return this.addBaseDataName(dsData, entityName, idProp, Collections.singletonMap("name", nameProp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet addBaseDataName(DataSet dsData, String entityName, String idProp, Map<String, String> propMap) {
        DataSet dataSet;
        HashSet<Long> idSet = new HashSet<Long>(10);
        DataSet dsData1 = dsData.copy();
        DataSet dsData2 = null;
        try {
            for (Row row : dsData1) {
                idSet.add(row.getLong(idProp));
            }
            String props = propMap.entrySet().stream().map(p -> (String)p.getKey() + " as " + (String)p.getValue()).collect(Collectors.joining(","));
            DataSet dsBaseData = QueryServiceHelper.queryDataSet((String)("queryName_" + entityName), (String)entityName, (String)("id," + props), (QFilter[])new QFilter("id", "in", idSet).toArray(), null);
            dsData2 = dsData.copy();
            dataSet = dsData2.join(dsBaseData).on(idProp, "id").select(dsData.getRowMeta().getFieldNames(), propMap.values().toArray(new String[0])).finish();
        }
        catch (Throwable throwable) {
            IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsData1, dsData2});
            throw throwable;
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dsData1, dsData2});
        return dataSet;
    }

    public static String printDataSet(DataSet dataSet) {
        StringBuilder datas = new StringBuilder();
        CharSequence[] fieldNames = dataSet.getRowMeta().getFieldNames();
        datas.append(String.join((CharSequence)",", fieldNames)).append("\n");
        for (Row row : dataSet.copy()) {
            StringBuilder builder = new StringBuilder();
            for (CharSequence fieldName : fieldNames) {
                builder.append(",").append(row.get((String)fieldName));
            }
            datas.append(builder.substring(1)).append("\n");
        }
        return datas.toString();
    }
}

