/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.opplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.constant.InvocationTaskVO;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.validator.TransactionPlanSaveValidator;

public class TransactionPlanSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransactionPlanSaveOp.class);
    Set<Long> orgIdFromDb = new HashSet<Long>(10);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransactionPlanSaveValidator validator = new TransactionPlanSaveValidator();
        validator.setEntityKey("mon_transactionplan");
        e.addValidator((AbstractValidator)validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objFromDB;
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        List ids = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        for (DynamicObject item : objFromDB = BusinessDataServiceHelper.load((String)"mon_transactionplan", (String)"entryentity.e_org", (QFilter[])new QFilter("id", "in", ids).toArray())) {
            DynamicObjectCollection entities = item.getDynamicObjectCollection("entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entities)) continue;
            for (DynamicObject entity : entities) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)entity)) continue;
                this.orgIdFromDb.add(entity.getDynamicObject("e_org").getLong("id"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object[] transactionplanDys;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dynamicObject : transactionplanDys = e.getDataEntities()) {
            DynamicObjectCollection entities = dynamicObject.getDynamicObjectCollection("entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entities)) continue;
            for (DynamicObject entity : entities) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)entity)) continue;
                this.orgIdFromDb.add(entity.getDynamicObject("e_org").getLong("id"));
            }
        }
        if (EmptyUtil.isNoEmpty(this.orgIdFromDb)) {
            SqlBuilder detailSql = new SqlBuilder();
            detailSql.append("delete from t_mon_transaction_bei where", new Object[0]);
            detailSql.appendIn("forgid", this.orgIdFromDb.toArray());
            logger.info("TransactionPlanSaveOp: detail sql : {}", (Object)detailSql);
            DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"mon_transaction_bei").getDBRouteKey()), (SqlBuilder)detailSql);
            SqlBuilder journalSql = new SqlBuilder();
            journalSql.append("update t_cas_bankjournal_e set fislargeamount = '0',fissensitive='0',fisattention='0',fisdoubt='0' where fid in(", new Object[0]);
            journalSql.append("select fid from t_cas_bankjournal where ", new Object[0]);
            journalSql.appendIn("forgid", this.orgIdFromDb.toArray());
            journalSql.append(")", new Object[0]);
            DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (SqlBuilder)journalSql);
        }
        if (EmptyUtil.isNoEmpty((Object[])transactionplanDys)) {
            ThreadPools.executeOnce((String)TransactionPlanSaveOp.class.getName(), () -> TransactionPlanSaveOp.lambda$afterExecuteOperationTransaction$0((DynamicObject[])transactionplanDys));
        }
    }

    private static /* synthetic */ void lambda$afterExecuteOperationTransaction$0(DynamicObject[] transactionplanDys) {
        HashSet<Long> ids = new HashSet<Long>(transactionplanDys.length);
        for (DynamicObject dynamicObject : transactionplanDys) {
            ids.add(dynamicObject.getLong("id"));
        }
        ArrayList<String> params = new ArrayList<String>();
        String idsJson = JSON.toJSONString(ids);
        params.add(idsJson);
        boolean flag = false;
        try {
            RpcResult rpcResult;
            logger.info("TransactionPlanSaveOp begin");
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BankJournalDataDealServiceImpl", (String)"ruleDataDeal", (Object[])new Object[]{params});
            logger.info("TransactionPlanSaveOp end");
            flag = EmptyUtil.isNoEmpty((Object)result) ? !(rpcResult = (RpcResult)JSON.parseObject((String)result.toString(), RpcResult.class)).isSuccess() : true;
        }
        catch (Exception e1) {
            flag = true;
        }
        if (flag) {
            InvocationTaskVO taskVo = new InvocationTaskVO();
            taskVo.setCloudId("fi");
            taskVo.setAppId("cas");
            taskVo.setServiceName("BankJournalDataDealServiceImpl");
            taskVo.setMethodName("ruleDataDeal");
            taskVo.setMaxRetryCount(10);
            taskVo.setParams(params);
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"asyncInvocationTaskService", (String)"submit", (Object[])new Object[]{taskVo});
        }
    }
}

