/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.helper.OrgHelper;

public class BaseDataHelper {
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return exchangeRate;
        }
        Long exchangeRateTableId = OrgHelper.getExrateTable(orgId);
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        if (EmptyUtil.isNoEmpty((BigDecimal)exchangeRate)) {
            return exchangeRate;
        }
        return BigDecimal.ZERO;
    }

    public static Map<Long, BigDecimal> getExchangeRate(List<Long> srcCurIds, Long tarCurId, Long orgId, Date date) {
        HashMap<Long, BigDecimal> exRateMap = new HashMap<Long, BigDecimal>(srcCurIds.size());
        for (Long srcCurId : srcCurIds) {
            BigDecimal exRate = BaseDataHelper.getExchangeRate(srcCurId, tarCurId, orgId, date);
            exRateMap.put(srcCurId, exRate);
        }
        return exRateMap;
    }

    public static boolean verifyExchangeRate(List<Long> sourceCurrencyIdLst, Long targetCurrencyId, Long orgId, Date date, AbstractFormPlugin plugin) {
        if (date == null) {
            date = new Date();
        }
        ArrayList<OperateErrorInfo> errorLst = new ArrayList<OperateErrorInfo>();
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        QFilter srcCurrency = new QFilter("id", "in", sourceCurrencyIdLst);
        DynamicObjectCollection srcCurrencyInfo = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{srcCurrency});
        Map<Long, String> srcCurrencyNameMap = srcCurrencyInfo.stream().collect(Collectors.toMap(cur -> cur.getLong("id"), cur -> cur.getString("name"), (e1, e2) -> e1));
        QFilter tarCurrency = new QFilter("id", "=", (Object)targetCurrencyId);
        DynamicObject tarCurrencyInfo = QueryServiceHelper.queryOne((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{tarCurrency});
        OperationResult result = new OperationResult();
        OperateErrorInfo info = null;
        String msg = "";
        for (Long sourceCurrencyId : sourceCurrencyIdLst) {
            String srcCurrancyName;
            if (0L == sourceCurrencyId) continue;
            String string = srcCurrancyName = srcCurrencyNameMap.get(sourceCurrencyId) == null ? "" : srcCurrencyNameMap.get(sourceCurrencyId);
            BigDecimal rate = BaseDataHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, orgId, date);
            if (!rate.equals(BigDecimal.ZERO)) continue;
            info = new OperateErrorInfo();
            msg = String.format(ResManager.loadKDString((String)"%1$s: \u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362\u62a5\u544a\u5e01[%3$s]\u7684\u6c47\u7387", (String)"BaseDataHelper_0", (String)"tmc-mon-common", (Object[])new Object[0]), orgInfo.getString("name"), srcCurrancyName, tarCurrencyInfo.get("name"));
            info.setMessage(msg);
            info.setLevel(ErrorLevel.Warning);
            errorLst.add(info);
        }
        if (!errorLst.isEmpty()) {
            result.setAllErrorInfo(errorLst);
            BaseDataHelper.showOperationResultMulti(result, plugin);
            return false;
        }
        return true;
    }

    public static boolean verifyExchangeRateCard(List<Long> sourceCurrencyIdLst, Long targetCurrencyId, Long orgId, Date date, String cardName, AbstractFormPlugin plugin) {
        if (date == null) {
            date = new Date();
        }
        ArrayList<OperateErrorInfo> errorLst = new ArrayList<OperateErrorInfo>();
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        QFilter srcCurrency = new QFilter("id", "in", sourceCurrencyIdLst);
        DynamicObjectCollection srcCurrencyInfo = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{srcCurrency});
        QFilter tarCurrency = new QFilter("id", "=", (Object)targetCurrencyId);
        DynamicObject tarCurrencyInfo = QueryServiceHelper.queryOne((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{tarCurrency});
        OperationResult result = new OperationResult();
        OperateErrorInfo info = null;
        String msg = "";
        for (Long sourceCurrencyId : sourceCurrencyIdLst) {
            if (0L == sourceCurrencyId) continue;
            String srcCurrancyName = srcCurrencyInfo.stream().filter(vaule -> sourceCurrencyId.equals(vaule.getLong("id"))).map(vaule -> vaule.getString("name")).findFirst().get();
            BigDecimal rate = BaseDataHelper.getExchangeRate(sourceCurrencyId, targetCurrencyId, orgId, date);
            if (!rate.equals(BigDecimal.ZERO)) continue;
            info = new OperateErrorInfo();
            msg = String.format(ResManager.loadKDString((String)"%1$s : %2$s: \u6ca1\u6709\u7ef4\u62a4[%3$s]\u8f6c\u6362\u62a5\u544a\u5e01[%4$s]\u7684\u6c47\u7387", (String)"BaseDataHelper_1", (String)"tmc-mon-common", (Object[])new Object[0]), cardName, orgInfo.getString("name"), srcCurrancyName, tarCurrencyInfo.get("name"));
            info.setMessage(msg);
            info.setLevel(ErrorLevel.Warning);
            errorLst.add(info);
        }
        Object flag = plugin.getView().getFormShowParameter().getCustomParam("flag");
        if (flag != null && "yes".equals(String.valueOf(flag))) {
            return true;
        }
        if (!errorLst.isEmpty()) {
            result.setAllErrorInfo(errorLst);
            BaseDataHelper.showOperationResultMulti(result, plugin);
            return false;
        }
        return true;
    }

    private static void showOperationResultMulti(OperationResult operationResult, AbstractFormPlugin plugin) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append("<br/>");
        }
        parameters.setCustomParam("hasMore", (Object)(errorInfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", (Object)buf.append("</div>").toString().trim());
        plugin.getView().showForm(parameters);
    }

    public static BigDecimal getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return exchangeRate;
        }
        if (exchangeRateTableId == 0L || MonHelper.isEmpty(exchangeRateTableId)) {
            exchangeRateTableId = OrgHelper.getExrateTable(orgId);
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exratedate);
        return exchangeRate;
    }

    public static boolean isInternal(DynamicObject bill) {
        String recpayertype = bill.getString("recpayertype");
        Long recpayer = bill.getLong("recpayer");
        if (recpayer == 0L || MonHelper.isEmpty(recpayertype)) {
            return false;
        }
        if (!recpayertype.equals("bd_supplier") && !recpayertype.equals("bd_customer")) {
            return false;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)recpayer, (String)recpayertype);
        if (MonHelper.isNotEmpty(object)) {
            return object.getLong("internal_company_id") > 0L;
        }
        return false;
    }
}

