/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.autoschedulerule;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.psd.common.untils.StringUtils;

public class ScheRadioPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        BigDecimal scheDraftRadio = (BigDecimal)fsp.getCustomParam("schedraftradiosaveflag");
        BigDecimal scheRadio = (BigDecimal)fsp.getCustomParam("scheradiosaveflag");
        this.getModel().setValue("schedraftradio", (Object)scheDraftRadio);
        this.getModel().setValue("scheradio", (Object)scheRadio);
        BigDecimal total = BigDecimal.ZERO;
        if (null != scheRadio && null != scheDraftRadio) {
            total = scheRadio.add(scheDraftRadio);
        } else if (null != scheRadio && null == scheDraftRadio) {
            total = scheRadio;
        } else if (null == scheRadio && null != scheDraftRadio) {
            total = scheDraftRadio;
        }
        this.getModel().setValue("scheduleradio", (Object)total);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (fieldKey) {
            case "schedraftradio": 
            case "scheradio": {
                if (new BigDecimal("100").compareTo(this.getModel().getDataEntity().getBigDecimal("scheduleradio")) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u7968\u6bd4\u4f8b\u548c\u6392\u6b3e\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e100%", (String)"ScheRadioPlugin_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(fieldKey, (Object)0);
                    return;
                }
                BigDecimal scheDraftRadio = this.getModel().getDataEntity().getBigDecimal("schedraftradio");
                BigDecimal scheRadio = this.getModel().getDataEntity().getBigDecimal("scheradio");
                FormShowParameter fsp = this.getView().getFormShowParameter();
                boolean oneSchedule = false;
                String oneScheduleStr = (String)fsp.getCustomParam("onekeysche");
                if (StringUtils.isNotEmpty((String)oneScheduleStr) && "true".equals(oneScheduleStr)) {
                    oneSchedule = true;
                }
                if (!oneSchedule) break;
                if (scheDraftRadio.compareTo(BigDecimal.ZERO) != 0 && scheRadio.compareTo(BigDecimal.ZERO) != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u6301\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\uff0c\u53ea\u5141\u8bb8\u5168\u989d\u6392\u6b3e\u6216\u5168\u989d\u6392\u7968\uff01", (String)"ScheRadioPlugin_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (scheDraftRadio.compareTo(BigDecimal.ZERO) != 0 && scheDraftRadio.compareTo(new BigDecimal("100")) != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u6301\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\uff0c\u53ea\u5141\u8bb8\u5168\u989d\u6392\u6b3e\u6216\u5168\u989d\u6392\u7968\uff01", (String)"ScheRadioPlugin_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (scheRadio.compareTo(BigDecimal.ZERO) == 0 || scheRadio.compareTo(new BigDecimal("100")) == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u6301\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\uff0c\u53ea\u5141\u8bb8\u5168\u989d\u6392\u6b3e\u6216\u5168\u989d\u6392\u7968\uff01", (String)"ScheRadioPlugin_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        FormShowParameter parentParams;
        String oneSchedule;
        Control source = (Control)evt.getSource();
        if (BTN_OK.equals(source.getKey()) && Boolean.parseBoolean(oneSchedule = (String)(parentParams = this.getView().getFormShowParameter()).getCustomParam("onekeysche")) && !this.isFullCashOrBill()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\u65f6\uff0c\u4ec5\u652f\u6301\u5168\u989d100%\u6392\u6b3e\u6216\u5168\u989d100%\u6392\u7968\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u6392\u7a0b\u6bd4\u4f8b\u3002", (String)"ScheRadioPlugin_5", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>(10);
            BigDecimal scheDraftRadio = this.getModel().getDataEntity().getBigDecimal("schedraftradio");
            BigDecimal scheRadio = this.getModel().getDataEntity().getBigDecimal("scheradio");
            data.put("schedraftradiosaveflag", scheDraftRadio);
            data.put("scheradiosaveflag", scheRadio);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private boolean isFullCashOrBill() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal scheDraftRadio = dataEntity.getBigDecimal("schedraftradio");
        BigDecimal scheRadio = dataEntity.getBigDecimal("scheradio");
        if (scheDraftRadio.compareTo(BigDecimal.ZERO) != 0 && scheRadio.compareTo(BigDecimal.ZERO) != 0) {
            return false;
        }
        if (scheDraftRadio.compareTo(BigDecimal.ZERO) != 0 && scheDraftRadio.compareTo(Constants.ONE_HUNDRED) != 0) {
            return false;
        }
        return scheRadio.compareTo(BigDecimal.ZERO) == 0 || scheRadio.compareTo(Constants.ONE_HUNDRED) == 0;
    }
}

