/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.business.task.DiffSplitTask;
import kd.tmc.psd.business.task.TransNextTask;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.BotpHelper;
import kd.tmc.psd.common.helper.PermissionHelper;
import kd.tmc.psd.common.helper.PsdParameterHelper;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class PayScheBillList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(PayScheBillList.class);
    private String PAYSCHEBILLLIST_BATCHNUMS_CACHE = "payschebilllist_batchnums_cache";
    private static final String SCHEDULE_BILL_RETURN_ACTION_ID = "schedulebill_return";
    private static final String SCHEDULE_BILL_RETURN_FORM_ID = "psd_schedulebill_return";
    private String[] ops = new String[]{"pay", "cancelpay", "transnext", "canceltransnext", "delete"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"delete"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List<Long> scheBillIds;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (Arrays.asList(this.ops).contains(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("unittest".equals(key)) {
            new TransNextTask().execute(null, null);
            new DiffSplitTask().execute(null, null);
        }
        if ((key.equals("trackdown") || key.equals("trackup")) && args.getOperationResult().isSuccess()) {
            List selectedIdList = this.getSelectedIdList();
            DynamicObject[] scheduleBills = TmcDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            String billType = key.equals("trackdown") ? "paybill" : "schebill";
            List trackObjIds = Arrays.stream(scheduleBills).flatMap(v -> v.getDynamicObjectCollection("entrys").stream().filter(p -> p.getString("e_billtype").equals(billType)).filter(o -> !EmptyUtil.isEmpty((Long)o.getLong("e_payid"))).map(o -> o.getLong("e_payid"))).collect(Collectors.toList());
            DynamicObject[] trackObjs = TmcDataServiceHelper.load((Object[])trackObjIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
            List trackObjFromDBIds = Arrays.stream(trackObjs).map(v -> v.getLong("id")).collect(Collectors.toList());
            ArrayList billIds = new ArrayList(scheduleBills.length);
            for (DynamicObject scheduleBill : scheduleBills) {
                List billIdList = null;
                billIdList = scheduleBill.getDynamicObjectCollection("entrys").stream().filter(v -> v.getString("e_billtype").equals(billType)).filter(v -> !EmptyUtil.isEmpty((Long)v.getLong("e_payid")) && trackObjFromDBIds.contains(v.getLong("e_payid"))).map(v -> v.getLong("e_payid")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(billIdList)) continue;
                billIds.addAll(billIdList.stream().distinct().collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(billIds)) {
                tuples.add(new Tuple((Object)"cas_paybill", billIds));
            }
            if (CollectionUtils.isEmpty(tuples)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"PayScheBillList_0", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                return;
            }
            BotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        } else if ("trackscheduledeal".equals(key)) {
            this.trackScheduleDealBills();
        } else if ("freeze".equals(key)) {
            List pkIds = args.getOperationResult().getSuccessPkIds();
            HashSet<String> nonEmptyOfBatchNum = new HashSet<String>(16);
            if (pkIds.size() > 0) {
                DynamicObjectCollection scheduleBillArr = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id,batchnum", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
                for (DynamicObject scheduleBill : scheduleBillArr) {
                    String batchNum = scheduleBill.getString("batchnum");
                    if (null == batchNum || !EmptyUtil.isNotEmpty((CharSequence)batchNum)) continue;
                    nonEmptyOfBatchNum.add(batchNum);
                }
                if (!nonEmptyOfBatchNum.isEmpty()) {
                    this.getView().getPageCache().put(this.PAYSCHEBILLLIST_BATCHNUMS_CACHE, SerializationUtils.toJsonString(nonEmptyOfBatchNum));
                    this.getView().showConfirm("", ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u6392\u7a0b\u5355\u5c06\u53c2\u4e0e\u5408\u5e76\uff0c\u662f\u5426\u51bb\u7ed3\u6574\u4e2a\u6279\u6b21\u7684\u6392\u7a0b\u5355\uff1f", (String)"PayScheBillList_5", (String)"tmc-psd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("batchnum", (IFormPlugin)this));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"PayScheBillList_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("thaw".equals(key)) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            if (null != successPkIds && !successPkIds.isEmpty()) {
                DynamicObjectCollection successDataArr = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id,expectdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)});
                final ArrayList<Long> pkIds = new ArrayList<Long>(10);
                for (DynamicObject successData : successDataArr) {
                    Date expectDate = successData.getDate("expectdate");
                    Date currentDate = new Date(System.currentTimeMillis());
                    if (null != expectDate && Long.compare(expectDate.getTime(), currentDate.getTime()) >= 0) continue;
                    pkIds.add(successData.getLong("id"));
                }
                if (pkIds != null && !pkIds.isEmpty()) {
                    this.showForm((AbstractFormPlugin)this, "psd_modifyavd", ShowType.Modal, "thaw", (Map<String, Object>)new HashMap<String, Object>(){
                        private static final long serialVersionUID = -5133156341571886539L;
                        {
                            this.put("pkIds", SerializationUtils.toJsonString((Object)pkIds));
                        }
                    });
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u51bb\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"PayScheBillList_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("startsche".equals(key) && args.getOperationResult().isSuccess()) {
            scheBillIds = args.getOperationResult().getSuccessPkIds().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(scheBillIds)) {
                this.invokeStartSche(scheBillIds);
            }
        } else if ("afreshsche".equals(key) && args.getOperationResult().isSuccess()) {
            scheBillIds = args.getOperationResult().getSuccessPkIds().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(scheBillIds)) {
                this.invokeAfreshSche(scheBillIds);
            }
        } else if ("changedateop".equals(key) && args.getOperationResult().isSuccess()) {
            List schBillIds = args.getOperationResult().getSuccessPkIds().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setAppId("psd");
            formShowParameter.setFormId("psd_changedatebill");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("schbillidlist", schBillIds);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if ("trackchangedateop".equals(key) && args.getOperationResult().isSuccess()) {
            this.viewChangeDateRecord();
        } else if (!"diffsplit".equals(key) || args.getOperationResult().isSuccess()) {
            // empty if block
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    private void invokeAfreshSche(List<Long> scheBillIds) {
        if (scheBillIds.size() == 0) {
            return;
        }
        DynamicObject[] sourceScheBills = BusinessDataServiceHelper.load((Object[])scheBillIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        try {
            Optional maxDy = Arrays.stream(sourceScheBills).filter(Objects::nonNull).collect(Collectors.maxBy((n1, n2) -> n1.getDate("expectdate").compareTo(n2.getDate("expectdate"))));
            Optional minDy = Arrays.stream(sourceScheBills).filter(Objects::nonNull).collect(Collectors.minBy((n1, n2) -> n1.getDate("expectdate").compareTo(n2.getDate("expectdate"))));
            DynamicObjectCollection afreshScheBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcescheduleid", "in", scheBillIds)});
            List<Long> scheBills = afreshScheBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            IPayScheService payScheService = PayScheServiceFactory.getPayScheService();
            this.batchDraftData(scheBills);
            PayScheProcessResult result = payScheService.createNewProcessorByAfresh(scheBills, ((DynamicObject)minDy.get()).getDate("expectdate"), ((DynamicObject)maxDy.get()).getDate("expectdate"));
            if (result.isSuccess()) {
                DynamicObject company = sourceScheBills[0].getDynamicObject("company");
                Long orgId = Optional.ofNullable(company.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> company.getLong("id"));
                boolean hasAudit = PermissionHelper.hasViewRight((long)orgId, (String)"psd_schedealbill");
                if (hasAudit) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setAppId("psd");
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setFormId("psd_schebillcalc");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("KEY_PROCESSOR_ID", result.getResult());
                    this.getView().showForm(showParameter);
                    this.dealSourceBillBatchNum(sourceScheBills);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u6392\u7a0b\u64cd\u4f5c\u5df2\u6210\u529f\u5b8c\u6210\u3002", (String)"PayScheBillList_15", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                } else {
                    this.dealSourceBillBatchNum(sourceScheBills);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4ed8\u6b3e\u6392\u7a0b\u5904\u7406\u5355\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PayScheBillList_19", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                }
            } else {
                List errMsg = result.getErrMsgList();
                if (result.getErrMsgList().size() == 1) {
                    this.getView().showErrorNotification((String)errMsg.get(0));
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"PayScheBillList_16", (String)"tmc-psd-formplugin", (Object[])new Object[0]), errMsg.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
                }
                this.rollbackOfAfresh(sourceScheBills);
            }
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u6392\u7a0b\u5931\u8d25\uff1a%s\u3002", (String)"PayScheBillList_17", (String)"tmc-psd-formplugin", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            this.getView().showErrorNotification(errMsg);
            logger.error(errMsg, (Throwable)e);
            this.rollbackOfAfresh(sourceScheBills);
        }
    }

    private void batchDraftData(List<Long> scheBills) {
        DynamicObjectCollection dataEntities = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id,batchnum", (QFilter[])new QFilter[]{new QFilter("id", "in", scheBills)});
        HashSet<String> batchNumbers = new HashSet<String>(10);
        for (DynamicObject dataEntity : dataEntities) {
            String batchNum = dataEntity.getString("batchnum");
            if (!StringUtils.isNotEmpty((CharSequence)batchNum)) continue;
            batchNumbers.add(batchNum);
        }
        if (batchNumbers.size() == 0) {
            return;
        }
        DynamicObjectCollection entries = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNumbers).and(new QFilter("id", "not in", scheBills))});
        if (entries.size() == 0) {
            return;
        }
        Set entryIds = entries.stream().filter(Objects::nonNull).filter(o -> !scheBills.contains(o)).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (entryIds.size() == 0) {
            return;
        }
        scheBills.addAll(entryIds);
    }

    private void dealSourceBillBatchNum(DynamicObject[] sourceScheBills) {
        HashSet batchNums = new HashSet(16);
        Map<String, List<DynamicObject>> tempDataMap = Arrays.stream(sourceScheBills).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getString("batchnum")));
        Arrays.stream(sourceScheBills).filter(Objects::nonNull).forEach(o -> {
            String batchnum = o.getString("batchnum");
            if (!batchnum.isEmpty()) {
                batchNums.add(batchnum);
            }
            o.set("batchnum", null);
        });
        if (0 < batchNums.size()) {
            ArrayList updatePayScheList = new ArrayList(10);
            DynamicObject[] payScheArr = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", "id", "name", "billno", "batchnum"), (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNums)});
            Map<String, List<DynamicObject>> clearBatchNumGroupObjs = Arrays.stream(payScheArr).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getString("batchnum")));
            clearBatchNumGroupObjs.entrySet().stream().forEach(paySche -> {
                List clearBatchNumObj = (List)paySche.getValue();
                String batchNum = (String)paySche.getKey();
                List tempDy = (List)tempDataMap.get(batchNum);
                int count = clearBatchNumObj.size() - tempDy.size();
                if (1 == count) {
                    clearBatchNumObj.stream().forEach(a -> a.set("batchnum", null));
                    updatePayScheList.addAll(clearBatchNumObj);
                } else if (clearBatchNumObj.size() == 2) {
                    clearBatchNumObj.stream().forEach(a -> a.set("batchnum", null));
                    updatePayScheList.addAll(clearBatchNumObj);
                }
            });
            SaveServiceHelper.save((DynamicObject[])updatePayScheList.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.save((DynamicObject[])sourceScheBills);
    }

    private void rollbackOfAfresh(DynamicObject[] scheBills) {
        HashSet sourceScheduleIds = new HashSet(16);
        Arrays.stream(scheBills).forEach(o -> {
            o.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
            sourceScheduleIds.add(o.getLong("id"));
        });
        SaveServiceHelper.save((DynamicObject[])scheBills);
        QFilter delQFilter = new QFilter("sourcescheduleid", "in", (Object)sourceScheduleIds.toArray(new Long[0]));
        DeleteServiceHelper.delete((String)"psd_schedulebill", (QFilter[])new QFilter[]{delQFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        List<String> operateKeyStr = Arrays.asList("pay", "cancelpay", "transnext", "canceltransnext");
        if (operateKeyStr.contains(operateKey)) {
            FormOperate op = (FormOperate)args.getSource();
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            this.resetSelectedData(args);
        }
        if (operateKey.equals("startsche")) {
            operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
        }
        if ("afreshsche".equals(operateKey)) {
            operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
        }
        if ("changedateop".equals(operateKey)) {
            operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("strictvalidation", String.valueOf(true));
        }
        switch (operateKey) {
            case "delete": {
                String confirmDel = this.getView().getPageCache().get("confirmDel");
                if (!StringUtils.isEmpty((CharSequence)confirmDel)) break;
                List selectedIdList1 = this.getSelectedIdList();
                this.getView().showConfirm("", String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%d\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u662f\u5426\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\uff1f", (String)"PayScheBillList_18", (String)"tmc-psd-formplugin", (Object[])new Object[0]), selectedIdList1.size()), MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("paysche_delete", (IFormPlugin)this));
                this.getView().getPageCache().put("confirmDel", "true");
                args.setCancel(true);
                return;
            }
            case "onekeysche": {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                String entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg((ListSelectedRowCollection)listSelectedData, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u514d\u6392\u7a0b\u4ed8\u6b3e\u3002", (String)"PayScheBillList_21", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                if (!EmptyUtil.isNoEmpty((String)entrustScheduleValidateMsg)) break;
                this.getView().showErrorNotification(entrustScheduleValidateMsg);
                args.setCancel(true);
                return;
            }
            case "oneautosche": {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                Map isEntrustMap = PayScheduleUtil.isEntrust(listSelectedData.stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList()));
                String entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg((Map)isEntrustMap, (ListSelectedRowCollection)listSelectedData, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\u3002", (String)"PayScheBillList_20", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                if (EmptyUtil.isNoEmpty((String)entrustScheduleValidateMsg)) {
                    this.getView().showErrorNotification(entrustScheduleValidateMsg);
                    args.setCancel(true);
                }
                if (CollectionUtils.isEmpty((Map)isEntrustMap)) break;
                listSelectedData.removeIf(row -> isEntrustMap.getOrDefault(Long.parseLong(row.getPrimaryKeyValue().toString()), false));
                break;
            }
            case "startsche": 
            case "afreshsche": {
                List selectedIdList = this.getSelectedIdList();
                DynamicObjectCollection sameEntrustScheduleBills = PayScheduleUtil.querySameEntrustScheduleBill((List)selectedIdList);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)sameEntrustScheduleBills)) break;
                Map<Long, List<DynamicObject>> entrustPayIdGroupMap = sameEntrustScheduleBills.stream().collect(Collectors.groupingBy(b -> b.getLong("entrustpayid")));
                StringBuilder errMsg = new StringBuilder();
                entrustPayIdGroupMap.forEach((k, v) -> {
                    if (v.size() > 1) {
                        v.forEach(d -> {
                            if (selectedIdList.contains(d.getLong("id"))) {
                                if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                                    errMsg.append("\r\n");
                                }
                                errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c{0}\u201d\u7531\u6709\u591a\u6761\u660e\u7ec6\u7684\u59d4\u6258\u4ed8\u6b3e\u5355\u751f\u6210\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u4ed8\u6b3e\u6392\u7a0b\u3002", (String)"PayScheBillList_23", (String)"tmc-psd-formplugin", (Object[])new Object[]{d.getString("billno")}));
                            }
                        });
                    }
                });
                if (!EmptyUtil.isNoEmpty((String)errMsg.toString())) break;
                this.getView().showErrorNotification(errMsg.toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("thaw")) {
            DynamicObject[] datas;
            Map params = (Map)closedCallBackEvent.getReturnData();
            if (null == params) {
                return;
            }
            Date expectDate = (Date)params.get("expectDate");
            String pkIdStr = (String)params.get("pkIds");
            List pkIds = (List)SerializationUtils.fromJsonString((String)pkIdStr, List.class);
            for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"id,expectdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)})) {
                data.set("expectdate", (Object)expectDate);
            }
            SaveServiceHelper.save((DynamicObject[])datas);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u51bb\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"PayScheBillList_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        } else if (closedCallBackEvent.getActionId().equals("trackchangedateop")) {
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (selectedRowCollection != null && selectedRowCollection.size() > 0) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setPkId((Object)((Long)selectedRowCollection.get(0).getPrimaryKeyValue()));
                billShowParameter.setAppId("psd");
                billShowParameter.setFormId("psd_changedatebill");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        } else if (SCHEDULE_BILL_RETURN_ACTION_ID.equals(closedCallBackEvent.getActionId())) {
            String backreason = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)backreason)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("backreason", backreason);
                option.setVariableValue("isEntrustChargeBack", EmptyUtil.isNoEmpty((String)this.getPageCache().get("isEntrustChargeBack")) ? "1" : "0");
                this.getView().invokeOperation("chargeback", option);
            }
            this.getPageCache().remove("isEntrustChargeBack");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "tblreturn": {
                String entrustScheduleValidateMsg;
                List selectedList = this.getSelectedIdList();
                if (CollectionUtils.isEmpty((Collection)selectedList)) {
                    return;
                }
                Map isEntrustMap = PayScheduleUtil.isEntrust((List)selectedList);
                ListSelectedRowCollection listSelectedData = this.getSelectedRows();
                List entrustBillList = isEntrustMap.values().stream().filter(b -> b).collect(Collectors.toList());
                if (entrustBillList.size() > 0 && selectedList.size() > entrustBillList.size() && EmptyUtil.isNoEmpty((String)(entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg((Map)isEntrustMap, (ListSelectedRowCollection)listSelectedData, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0e\u975e\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u4e00\u8d77\u9000\u5355\u3002", (String)"PayScheBillList_22", (String)"tmc-psd-formplugin", (Object[])new Object[0]))))) {
                    this.getView().showErrorNotification(entrustScheduleValidateMsg);
                    return;
                }
                if (isEntrustMap.values().stream().anyMatch(b -> b)) {
                    List addSameEntrustScheduleIdList = PayScheduleUtil.addSameEntrustScheduleId((List)selectedList);
                    addSameEntrustScheduleIdList.forEach(scheduleId -> listSelectedData.add((Object)new ListSelectedRow(scheduleId)));
                    this.getPageCache().put("isEntrustChargeBack", "1");
                    this.reload();
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(SCHEDULE_BILL_RETURN_FORM_ID);
                showParameter.getOpenStyle().setShowType(ShowType.NonModal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCHEDULE_BILL_RETURN_ACTION_ID));
                this.getView().showForm(showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("batchnum".equals(actionId)) {
            if (result == MessageBoxResult.Yes) {
                DynamicObject[] scheduleBillArr;
                String cacheStr = this.getView().getPageCache().get(this.PAYSCHEBILLLIST_BATCHNUMS_CACHE);
                Set batchNums = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
                for (DynamicObject scheduleBill : scheduleBillArr = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"id,batchnum,freezestatus", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", (Object)batchNums)})) {
                    scheduleBill.set("freezestatus", (Object)FreezeStatusEnum.ManualFrozen.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])scheduleBillArr);
            } else if (result == MessageBoxResult.No) {
                // empty if block
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"PayScheBillList_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        } else if ("paysche_delete".equals(actionId)) {
            if (result == MessageBoxResult.Yes) {
                this.getView().invokeOperation("delete");
            }
            this.getView().getPageCache().remove("confirmDel");
            this.getView().invokeOperation("refresh");
        }
    }

    private void showForm(AbstractFormPlugin plugin, String formId, ShowType showType, String callback, Map<String, Object> customeParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(showType);
        parameter.setFormId(formId);
        parameter.setCustomParams(customeParams);
        if (null != callback) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callback));
        }
        plugin.getView().showForm(parameter);
    }

    private void resetSelectedData(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectedList = listSelectedData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        DynamicObject[] selectDatas = TmcDataServiceHelper.load((Object[])selectedList.toArray(), (DynamicObjectType)targetMainType);
        ArrayList<String> batchNums = new ArrayList<String>();
        for (DynamicObject payScheBill : selectDatas) {
            String batchNum = payScheBill.getString("batchnum");
            if (!EmptyUtil.isNotEmpty((CharSequence)batchNum)) continue;
            batchNums.add(batchNum);
        }
        DynamicObject[] sameBatchnumBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNums), new QFilter("id", "not in", selectedList)});
        if (sameBatchnumBills.length > 0) {
            for (DynamicObject payScheBill : sameBatchnumBills) {
                listSelectedData.add((Object)new ListSelectedRow(payScheBill.getPkValue()));
            }
        }
        args.setListSelectedData(listSelectedData);
    }

    private void invokeStartSche(List<Long> scheBillIds) {
        IPayScheService payScheService = PayScheServiceFactory.getPayScheService();
        DynamicObject payScheBill = BusinessDataServiceHelper.loadSingle((Object)scheBillIds.get(0), (String)"psd_schedulebill", (String)"company");
        boolean isOnTimeSche = PsdParameterHelper.getAppBoolParameter((long)((Long)payScheBill.getDynamicObject("company").getPkValue()), (String)"ontimesche");
        PayScheProcessResult createResult = isOnTimeSche ? payScheService.createNewProcessor(scheBillIds) : payScheService.createNewProcessorByStartEndDate(scheBillIds);
        if (createResult.isSuccess()) {
            DynamicObject company = payScheBill.getDynamicObject("company");
            Long orgId = Optional.ofNullable(company.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> company.getLong("id"));
            boolean hasAudit = PermissionHelper.hasViewRight((long)orgId, (String)"psd_schedealbill");
            if (hasAudit) {
                Long processorId = (Long)createResult.getResult();
                this.showPayScheCalcPage(processorId);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4ed8\u6b3e\u6392\u7a0b\u5904\u7406\u5355\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PayScheBillList_19", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        } else {
            List errMsgList = createResult.getErrMsgList();
            StringBuilder errMsg = new StringBuilder();
            for (String s : errMsgList) {
                errMsg.append(s).append(';');
            }
            if (errMsgList.size() == 1) {
                errMsg.deleteCharAt(errMsg.length() - 1);
            }
            this.getView().showErrorNotification(errMsg.toString());
        }
    }

    private void showPayScheCalcPage(Long processorId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("psd_schebillcalc");
        showParameter.setCustomParam("KEY_PROCESSOR_ID", (Object)processorId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private void viewChangeDateRecord() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8054\u67e5\u6539\u671f\u8bb0\u5f55\u3002", (String)"PayScheBillList_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Long billId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject schData = TmcDataServiceHelper.loadSingle((Object)billId, (String)"psd_schedulebill");
        String changeDateBillIdStr = schData.getString("changedaterecordid");
        if (StringUtils.isEmpty((CharSequence)changeDateBillIdStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5173\u8054\u7684\u6539\u671f\u8bb0\u5f55\u3002", (String)"PayScheBillList_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] changeDateBillIdArr = changeDateBillIdStr.split(",");
        Long[] changeDateBillIds = (Long[])ConvertUtils.convert((String[])changeDateBillIdArr, Long.class);
        if (changeDateBillIds.length == 1) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)changeDateBillIds[0]);
            billShowParameter.setAppId("psd");
            billShowParameter.setFormId("psd_changedatebill");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("psd_changedatebill");
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)"psd_changedatebill");
            String f7ListFormId = formConfig.getF7ListFormId();
            showParameter.setFormId(f7ListFormId);
            showParameter.setLookUp(true);
            showParameter.setShowApproved(false);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(false);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "trackchangedateop"));
            QFilter qFilter = new QFilter("id", "in", (Object)changeDateBillIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
            StyleCss css = new StyleCss();
            css.setHeight("550");
            css.setWidth("900");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void trackScheduleDealBills() {
        List selectedIdList = this.getSelectedIdList();
        DynamicObject[] scheduleBills = TmcDataServiceHelper.load((Object[])selectedIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(scheduleBills.length);
        HashSet<Long> scheduleDealIds = new HashSet<Long>(scheduleBills.length);
        for (DynamicObject scheduleBill : scheduleBills) {
            String scheduleStatus = scheduleBill.getString("schedulstatus");
            if ("noschedule".equals(scheduleStatus)) continue;
            Long scheduleDealId = scheduleBill.getLong("schedealid");
            scheduleDealIds.add(scheduleDealId);
        }
        DynamicObject[] trackScheduleBill = TmcDataServiceHelper.load((Object[])scheduleDealIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"));
        List trackScheduleBillIds = Arrays.stream(trackScheduleBill).map(v -> v.getLong("id")).collect(Collectors.toList());
        if (trackScheduleBillIds.size() == 1) {
            Long processorId = (Long)trackScheduleBillIds.get(0);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("psd_schebillcalc");
            showParameter.setCustomParam("KEY_PROCESSOR_ID", (Object)processorId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else {
            tuples.add(new Tuple((Object)"psd_schedealbill", trackScheduleBillIds));
            BotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        }
    }
}

