/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.balancecheck;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheBalanceCheckEdit
extends AbstractFormPlugin {
    private static final String SYSTEM_ID = "tmc-psd-formplugin";
    private static final String BD_ACCOUNTBANKS = "bd_accountbanks";
    private static final String CAS_ACCOUNTCASH = "cas_accountcash";
    private static final String CAS_PAYBILL_SYNONYM = "cas_paybill_synonym";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map params = fsp.getCustomParams();
        String psdFormId = (String)params.get("psdFormId");
        this.getModel().setValue("hidden_psdbillno", (Object)psdFormId);
        String datas = (String)params.get("psdDetailData");
        this.getPageCache().put("cashe_psdcalcmodeldata", datas);
        this.initBaseInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey;
        super.afterDoOperation(evt);
        switch (opKey = evt.getOperateKey()) {
            case "fundstransfer": {
                final Long orgId = Optional.ofNullable(this.getModel().getValue("base_org")).map(o -> {
                    DynamicObject orgDy = (DynamicObject)o;
                    String idStr = Optional.ofNullable(orgDy).map(pkValue -> pkValue.getPkValue().toString()).orElseGet(() -> orgDy.getString("id"));
                    return idStr == null ? null : Long.valueOf(idStr);
                }).orElseGet(() -> null);
                EntryGrid detailsEntry = (EntryGrid)this.getControl("entry_summary");
                int[] selectRows = detailsEntry.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6c47\u603b\u4fe1\u606f\u4e2d\u7684\u4e00\u6761\u975e\u5c0f\u8ba1\u660e\u7ec6\u6570\u636e\uff0c\u8fdb\u884c\u8d44\u91d1\u8c03\u62e8\u3002", (String)"PayScheBalanceCheckEdit_1", (String)SYSTEM_ID, (Object[])new Object[0]));
                    break;
                }
                final DynamicObject rowEntryData = this.getModel().getEntryRowEntity("entry_summary", selectRows[0]);
                String uuid = rowEntryData.getString("s_uuid");
                if (null == uuid || StringUtils.isBlank((String)uuid)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u9009\u62e9\u5c0f\u8ba1\u6570\u636e\u8fdb\u884c\u8d44\u91d1\u8c03\u62e8\u3002", (String)"PayScheBalanceCheckEdit_2", (String)SYSTEM_ID, (Object[])new Object[0]));
                    break;
                }
                DynamicObject currency = rowEntryData.getDynamicObject("s_currency");
                String currencyStr = Optional.ofNullable(currency).map(pKValue -> pKValue.getPkValue().toString()).orElseGet(() -> currency.getString("id"));
                final Long currencyId = currencyStr == null ? null : Long.valueOf(currencyStr);
                final String acctType = rowEntryData.getString("s_accounttype");
                if (BD_ACCOUNTBANKS.equals(acctType)) {
                    this.showForm(this, CAS_PAYBILL_SYNONYM, ShowType.MainNewTabPage, null, (Map<String, Object>)new HashMap<String, Object>(){
                        private static final long serialVersionUID = 8990379577348610486L;
                        {
                            this.put("orgId", orgId);
                            this.put("paymentAcctId", rowEntryData.getLong("s_project"));
                            this.put("paymentCurrency", currencyId);
                            this.put("source", "psd_balancedcheck");
                            this.put("balance", rowEntryData.getBigDecimal("s_balance"));
                            this.put("accType", acctType);
                        }
                    });
                    break;
                }
                if (!CAS_ACCOUNTCASH.equals(acctType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u8c03\u62e8\u529f\u80fd\u6682\u4e0d\u652f\u6301\u73b0\u91d1\u8d26\u6237\u3002", (String)"PayScheBalanceCheckEdit_3", (String)SYSTEM_ID, (Object[])new Object[0]));
            }
        }
    }

    private void initBaseInfo() {
        String formId = (String)this.getModel().getValue("hidden_psdbillno");
        if (null == formId || formId.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5e73\u8861\u68c0\u67e5\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u5355\u7f16\u53f7\u3002", (String)"PayScheBalanceCheckEdit_4", (String)SYSTEM_ID, (Object[])new Object[0]));
            return;
        }
        DynamicObject psdData = QueryServiceHelper.queryOne((String)"psd_schedealbill", (String)"id,company,scheduleperiod,startdate,enddate,company.name,scheduleperiod.name,creator.name,scheduleseq", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)formId)});
        this.getModel().setValue("base_org", psdData.get("company"));
        this.getModel().setValue("base_psdcycle", psdData.get("scheduleperiod"));
        this.getModel().setValue("base_psdstartdate", psdData.get("startdate"));
        this.getModel().setValue("base_psdenddate", psdData.get("enddate"));
        this.setLabelText("label_org", psdData.getString("company.name"));
        this.setLabelText("label_psdcycle", psdData.getString("scheduleperiod.name"));
        this.setLabelText("label_psdnum", psdData.getString("scheduleseq"));
        this.setLabelText("label_creator", psdData.getString("creator.name"));
    }

    private void setLabelText(String labelKey, String value) {
        Label label = (Label)this.getView().getControl(labelKey);
        label.setText(value == null || value.isEmpty() ? " - " : value);
    }

    private void showForm(AbstractFormPlugin plugin, String formId, ShowType showType, String callback, Map<String, Object> customeParams) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(showType);
        parameter.setFormId(formId);
        parameter.setCustomParams(customeParams);
        if (null != callback) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callback));
        }
        plugin.getView().showForm((FormShowParameter)parameter);
    }
}

