/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.balancecheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PsdCashBalanceCalcModel;
import kd.tmc.psd.common.model.PsdCashBalanceDetailsModel;
import kd.tmc.psd.common.model.PsdCashBalanceSummaryModel;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheCashBalancePlugin
extends AbstractFormPlugin {
    private static final String CASHE_SUMMARYMODEL = "psd_balancecheck_entry_data";
    private static final String SYSTEM_ID = "tmc-psd-formplugin";

    public void afterCreateNewData(EventObject e) {
        String datas = this.getPageCache().get("cashe_psdcalcmodeldata");
        List payScheCalcModelLst = PayScheCalcModel.deserializeList((String)datas);
        this.initCashBalanceEntryData(payScheCalcModelLst);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        IDataEntityProperty property = evt.getProperty();
        String propName = property.getName();
        ChangeData[] valSet = evt.getChangeSet();
        Object newValue = valSet[0].getNewValue();
        if (null == newValue) {
            return;
        }
        switch (propName) {
            case "s_currentexpectcollect": 
            case "s_planfinanceinflow": {
                this.updateEntryData(valSet[0], propName);
                break;
            }
        }
    }

    private void updateEntryData(ChangeData changeData, String propName) {
        int index = changeData.getRowIndex();
        String uuid = this.getModel().getValue("s_uuid", index).toString();
        Long currencyId = Optional.ofNullable(this.getModel().getValue("s_currency", index)).map(o -> {
            DynamicObject currency = (DynamicObject)o;
            return Long.valueOf(currency.getPkValue().toString());
        }).orElseGet(() -> 0L);
        String dataStr = this.getPageCache().get(CASHE_SUMMARYMODEL);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dataStr)) {
            return;
        }
        PsdCashBalanceSummaryModel summary = (PsdCashBalanceSummaryModel)SerializationUtils.fromJsonString((String)dataStr, PsdCashBalanceSummaryModel.class);
        switch (propName) {
            case "s_currentexpectcollect": {
                summary = summary.updateExpectValue(currencyId, uuid, new BigDecimal(changeData.getNewValue().toString()));
                break;
            }
            case "s_planfinanceinflow": {
                summary = summary.updatePlanFinanceinFlow(currencyId, uuid, new BigDecimal(changeData.getNewValue().toString()));
                break;
            }
        }
        this.fillData(summary.getSummary());
        this.getView().updateView();
        this.getPageCache().put(CASHE_SUMMARYMODEL, SerializationUtils.toJsonString((Object)summary));
    }

    private void initCashBalanceEntryData(List<PayScheCalcModel> payScheCalcModelLst) {
        if (null == payScheCalcModelLst || payScheCalcModelLst.isEmpty()) {
            return;
        }
        Map<Long, Map<Long, List<PayScheCalcModel>>> groupData = payScheCalcModelLst.stream().filter(o -> o.getCurrencyId() != null && o.getAcctBankId() != null).collect(Collectors.groupingBy(currencyGroup -> currencyGroup.getCurrencyId(), Collectors.groupingBy(accGroup -> accGroup.getAcctBankId())));
        Map<Long, List<PsdCashBalanceCalcModel>> statisticsData = this.conversionData(groupData);
        this.showEntry(statisticsData);
    }

    private Map<Long, List<PsdCashBalanceCalcModel>> conversionData(Map<Long, Map<Long, List<PayScheCalcModel>>> groupData) {
        HashMap<Long, List<PsdCashBalanceCalcModel>> statisticsData = new HashMap<Long, List<PsdCashBalanceCalcModel>>(16);
        for (Map.Entry<Long, Map<Long, List<PayScheCalcModel>>> currencyGroupEntry : groupData.entrySet()) {
            Iterator<Map.Entry<Long, List<PayScheCalcModel>>> accGroupIterator = currencyGroupEntry.getValue().entrySet().iterator();
            ArrayList<PsdCashBalanceCalcModel> psdCashBalanceCalcModelList = new ArrayList<PsdCashBalanceCalcModel>(5);
            while (accGroupIterator.hasNext()) {
                Map.Entry<Long, List<PayScheCalcModel>> accGroupEntry = accGroupIterator.next();
                List<Object> payScheCalcModels = accGroupEntry.getValue();
                payScheCalcModels = payScheCalcModels.stream().collect(Collectors.toList());
                PsdCashBalanceCalcModel psdCashBalanceCalcModel = new PsdCashBalanceCalcModel(payScheCalcModels);
                DynamicObject org = (DynamicObject)this.getModel().getValue("base_org");
                if (org != null) {
                    Long orgId = Long.valueOf(org.getPkValue().toString());
                    psdCashBalanceCalcModel.setOrg(orgId);
                }
                psdCashBalanceCalcModel.setPsdBillNo(this.getModel().getValue("hidden_psdbillno").toString());
                psdCashBalanceCalcModel.setStartDate((Date)this.getModel().getValue("base_psdstartdate"));
                psdCashBalanceCalcModel.setEndDate((Date)this.getModel().getValue("base_psdenddate"));
                psdCashBalanceCalcModelList.add(psdCashBalanceCalcModel);
            }
            statisticsData.put(currencyGroupEntry.getKey(), psdCashBalanceCalcModelList);
        }
        return statisticsData;
    }

    private void showEntry(Map<Long, List<PsdCashBalanceCalcModel>> statisticsData) {
        Iterator<Map.Entry<Long, List<PsdCashBalanceCalcModel>>> it = statisticsData.entrySet().iterator();
        HashMap<Long, List<PsdCashBalanceDetailsModel>> detailsLstMap = new HashMap<Long, List<PsdCashBalanceDetailsModel>>(16);
        PsdCashBalanceSummaryModel summary = new PsdCashBalanceSummaryModel();
        while (it.hasNext()) {
            Map.Entry<Long, List<PsdCashBalanceCalcModel>> entry = it.next();
            List<PsdCashBalanceCalcModel> currencyGroupLst = entry.getValue();
            List<PsdCashBalanceDetailsModel> detailsLst = this.transfer(currencyGroupLst);
            Optional.ofNullable(detailsLst).ifPresent(o -> detailsLstMap.put((Long)entry.getKey(), detailsLst));
        }
        summary.setSummary(detailsLstMap);
        this.getPageCache().put(CASHE_SUMMARYMODEL, SerializationUtils.toJsonString((Object)summary));
        this.fillData(detailsLstMap);
    }

    private List<PsdCashBalanceDetailsModel> transfer(List<PsdCashBalanceCalcModel> currencyGroupLst) {
        if (null == currencyGroupLst || currencyGroupLst.isEmpty()) {
            return new ArrayList<PsdCashBalanceDetailsModel>(0);
        }
        ArrayList<PsdCashBalanceDetailsModel> cashBalanceModelLst = new ArrayList<PsdCashBalanceDetailsModel>(currencyGroupLst.size());
        ArrayList<PsdCashBalanceDetailsModel.LimitFundModel> limitFundModels = new ArrayList<PsdCashBalanceDetailsModel.LimitFundModel>(currencyGroupLst.size());
        for (PsdCashBalanceCalcModel psdCashBalanceCalcModel : currencyGroupLst) {
            PsdCashBalanceDetailsModel detailsModel = new PsdCashBalanceDetailsModel();
            detailsModel.setUuid(UUID.randomUUID().toString());
            detailsModel.setCurrency(psdCashBalanceCalcModel.getCurrency());
            detailsModel.setProject(psdCashBalanceCalcModel.getProject());
            detailsModel.setProjectText(psdCashBalanceCalcModel.getProjectText());
            detailsModel.setInitialInventoryAmount(psdCashBalanceCalcModel.getInitialInventoryAmount());
            detailsModel.setCurrentExpectCollect(psdCashBalanceCalcModel.getCurrentExpectCollect());
            detailsModel.setPlanFinanceinFlow(psdCashBalanceCalcModel.getPlanFinanceinFlow());
            detailsModel.setCurrentPaymentAmount(psdCashBalanceCalcModel.getCurrentPaymentAmount());
            detailsModel.setStandbyAmount(psdCashBalanceCalcModel.getStandbyAmount());
            detailsModel.setBalance(psdCashBalanceCalcModel.getBalance());
            detailsModel.setAccountType(psdCashBalanceCalcModel.getAccountType());
            detailsModel.setLimitAmt(psdCashBalanceCalcModel.getLimitAmt());
            detailsModel.setIntransitAmt(psdCashBalanceCalcModel.getIntransitAmt());
            detailsModel.setOrgId(psdCashBalanceCalcModel.getOrg());
            cashBalanceModelLst.add(detailsModel);
            this.handleLimitFund(limitFundModels, psdCashBalanceCalcModel);
        }
        this.setLimitAmtFund(cashBalanceModelLst, limitFundModels);
        return cashBalanceModelLst;
    }

    private void handleLimitFund(List<PsdCashBalanceDetailsModel.LimitFundModel> limitFundModels, PsdCashBalanceCalcModel psdCashBalanceCalcModel) {
        PsdCashBalanceDetailsModel.LimitFundModel limitFundModel = new PsdCashBalanceDetailsModel.LimitFundModel(psdCashBalanceCalcModel.getCurrency(), psdCashBalanceCalcModel.getExrateTable());
        int index = limitFundModels.indexOf(limitFundModel);
        if (index < 0) {
            limitFundModel.setAccountIds(psdCashBalanceCalcModel.getProject());
            limitFundModel.setOrgIds(psdCashBalanceCalcModel.getOrg());
            limitFundModels.add(limitFundModel);
        } else {
            PsdCashBalanceDetailsModel.LimitFundModel lf = limitFundModels.get(index);
            Set accountIds = lf.getAccountIds();
            accountIds.add(psdCashBalanceCalcModel.getProject());
            Set orgIds = lf.getOrgIds();
            orgIds.add(psdCashBalanceCalcModel.getOrg());
        }
    }

    private void setLimitAmtFund(List<PsdCashBalanceDetailsModel> cashBalanceModelLst, List<PsdCashBalanceDetailsModel.LimitFundModel> limitFundModels) {
        if (limitFundModels.size() == 0) {
            return;
        }
        HashMap limitFunds = new HashMap(16);
        for (PsdCashBalanceDetailsModel.LimitFundModel lf : limitFundModels) {
            PsdCashBalanceCalcModel pcbcm = new PsdCashBalanceCalcModel();
            limitFunds.putAll(pcbcm.getLimitAmtFunds(lf.getAccountIds(), new ArrayList(lf.getOrgIds()), lf.getCurrencyId(), lf.getExtrateTableId()));
        }
        if (cashBalanceModelLst.size() == 0) {
            return;
        }
        for (PsdCashBalanceDetailsModel pcbdm : cashBalanceModelLst) {
            Long orgId = pcbdm.getOrgId();
            Long accountId = pcbdm.getProject();
            Long currency = pcbdm.getCurrency();
            String lat = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, accountId, currency});
            BigDecimal limitAmtFund = (BigDecimal)limitFunds.get(lat);
            if (limitAmtFund == null) {
                limitAmtFund = BigDecimal.ZERO;
            }
            pcbdm.setLimitAmtFund(limitAmtFund);
            BigDecimal balance = pcbdm.getBalance();
            if (balance == null) {
                balance = BigDecimal.ZERO;
            }
            pcbdm.setBalance(balance.subtract(limitAmtFund));
        }
    }

    private void fillData(Map<Long, List<PsdCashBalanceDetailsModel>> detailsLstMap) {
        if (null == detailsLstMap || detailsLstMap.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entry_summary");
        Iterator<Map.Entry<Long, List<PsdCashBalanceDetailsModel>>> psdCashBalanceModelMapIt = detailsLstMap.entrySet().iterator();
        ArrayList<PsdCashBalanceDetailsModel> details = new ArrayList<PsdCashBalanceDetailsModel>(10);
        while (psdCashBalanceModelMapIt.hasNext()) {
            Map.Entry<Long, List<PsdCashBalanceDetailsModel>> psdCashBalanceModelMapEntry = psdCashBalanceModelMapIt.next();
            this.calcSubtotalAndShow(psdCashBalanceModelMapEntry.getValue(), details);
            details.addAll((Collection<PsdCashBalanceDetailsModel>)psdCashBalanceModelMapEntry.getValue());
        }
        this.fillEntryDatas(details);
        this.getModel().endInit();
    }

    private void calcSubtotalAndShow(List<PsdCashBalanceDetailsModel> currencyGroupLst, List<PsdCashBalanceDetailsModel> details) {
        if (null == currencyGroupLst || currencyGroupLst.isEmpty()) {
            return;
        }
        PsdCashBalanceDetailsModel psdCashBalanceModelTemp = currencyGroupLst.get(0);
        PsdCashBalanceDetailsModel psdCashBalanceModel = new PsdCashBalanceDetailsModel();
        psdCashBalanceModel.setCurrency(psdCashBalanceModelTemp.getCurrency());
        psdCashBalanceModel.setProject(null);
        psdCashBalanceModel.setProjectText(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"PayScheProcessorBalanceCheckPlugin_0", (String)SYSTEM_ID, (Object[])new Object[0]));
        psdCashBalanceModel.setInitialInventoryAmount(this.sum(currencyGroupLst, "s_initialinventoryamount"));
        psdCashBalanceModel.setCurrentExpectCollect(this.sum(currencyGroupLst, "s_currentexpectcollect"));
        psdCashBalanceModel.setPlanFinanceinFlow(this.sum(currencyGroupLst, "s_planfinanceinflow"));
        psdCashBalanceModel.setCurrentPaymentAmount(this.sum(currencyGroupLst, "s_currentpaymentamount"));
        psdCashBalanceModel.setStandbyAmount(this.sum(currencyGroupLst, "s_standbyamount"));
        psdCashBalanceModel.setBalance(this.sum(currencyGroupLst, "s_balance"));
        psdCashBalanceModel.setLimitAmt(this.sum(currencyGroupLst, "s_limitamt"));
        psdCashBalanceModel.setLimitAmtFund(this.sum(currencyGroupLst, "s_limitamtfund"));
        psdCashBalanceModel.setIntransitAmt(this.sum(currencyGroupLst, "s_intransitamt"));
        psdCashBalanceModel.setAccountType(null);
        details.add(psdCashBalanceModel);
    }

    private BigDecimal sum(List<PsdCashBalanceDetailsModel> currencyGroupLst, String type) {
        BigDecimal sum = currencyGroupLst.stream().filter(o -> Objects.nonNull(o)).map(o -> {
            BigDecimal amount = BigDecimal.ZERO;
            switch (type) {
                case "s_initialinventoryamount": {
                    amount = o.getInitialInventoryAmount();
                    break;
                }
                case "s_currentexpectcollect": {
                    amount = o.getCurrentExpectCollect();
                    break;
                }
                case "s_planfinanceinflow": {
                    amount = o.getPlanFinanceinFlow();
                    break;
                }
                case "s_currentpaymentamount": {
                    amount = o.getCurrentPaymentAmount();
                    break;
                }
                case "s_standbyamount": {
                    amount = o.getStandbyAmount();
                    break;
                }
                case "s_balance": {
                    amount = o.getBalance();
                    break;
                }
                case "s_limitamt": {
                    amount = o.getLimitAmt();
                    break;
                }
                case "s_limitamtfund": {
                    amount = o.getLimitAmtFund();
                    break;
                }
                case "s_intransitamt": {
                    amount = o.getIntransitAmt();
                    break;
                }
            }
            return amount;
        }).reduce(BigDecimal.ZERO, (x, y) -> x.add((BigDecimal)y));
        return sum;
    }

    private void fillEntryDatas(List<PsdCashBalanceDetailsModel> detailsModelLst) {
        int rowCount = this.getModel().getEntryRowCount("entry_summary");
        if (rowCount < detailsModelLst.size()) {
            this.getModel().batchCreateNewEntryRow("entry_summary", detailsModelLst.size() - rowCount);
            rowCount = detailsModelLst.size();
        }
        for (int row = 0; row < rowCount; ++row) {
            PsdCashBalanceDetailsModel detailsModel = detailsModelLst.get(row);
            String uuid = detailsModel.getUuid();
            this.getModel().setValue("s_uuid", (Object)uuid, row);
            this.getModel().setValue("s_currency", (Object)detailsModel.getCurrency(), row);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)uuid)) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("s_currency", row);
                this.getModel().setValue("s_currencytext", (Object)currency.getString("name"), row);
            }
            this.getModel().setValue("s_project", (Object)detailsModel.getProject(), row);
            this.getModel().setValue("s_projecttext", (Object)detailsModel.getProjectText(), row);
            this.getModel().setValue("s_initialinventoryamount", (Object)detailsModel.getInitialInventoryAmount(), row);
            this.getModel().setValue("s_currentexpectcollect", (Object)detailsModel.getCurrentExpectCollect(), row);
            this.getModel().setValue("s_planfinanceinflow", (Object)detailsModel.getPlanFinanceinFlow(), row);
            this.getModel().setValue("s_currentpaymentamount", (Object)detailsModel.getCurrentPaymentAmount(), row);
            this.getModel().setValue("s_standbyamount", (Object)detailsModel.getStandbyAmount(), row);
            this.getModel().setValue("s_balance", (Object)detailsModel.getBalance(), row);
            this.getModel().setValue("s_accounttype", (Object)detailsModel.getAccountType(), row);
            this.getModel().setValue("s_limitamt", (Object)detailsModel.getLimitAmt(), row);
            this.getModel().setValue("s_intransitamt", (Object)detailsModel.getIntransitAmt(), row);
            this.getModel().setValue("s_limitamtfund", (Object)detailsModel.getLimitAmtFund(), row);
        }
    }
}

