/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.calc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.PayBusinessTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheProcessorHandler;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSumData;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;
import kd.tmc.psd.business.utils.PayScheduleUtil;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PsdCombineModeEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.PayScheHelper;
import kd.tmc.psd.common.helper.PermissionHelper;
import kd.tmc.psd.common.resource.PsdBizResource;
import kd.tmc.psd.formplugin.payscheprocessor.calc.PayScheCalcBasePlugin;

public class PayScheCalcPlugin
extends PayScheCalcBasePlugin<PayScheSumData>
implements RowClickEventListener,
UploadListener {
    private static final String PAYSCHECALCPLUGIN_BATCHNUM_CACHE = "payschecalcplugin_batchnum_cache";
    private static final String PK_VALUE = "LC_ARRICAL_Value";
    private static final String LC_ARRIVAL_CALL_BACK = "LC_ARRIVAL_CALL_BACK";
    private static final String META_ARRIVAL = "lc_arrival";
    private static final String DRAFT_TYPE_ARRIVAL = "7";
    private static final String ENTRY_SEQ = "seq";
    private static String[] entryOpItem = new String[]{"batchschedule", "batchdraft", "tonext", "canceltonext", "rejectpay", "split", "combine", "cancelcombine", "barbatchfill"};
    private static final String KEY_INIT_CARDSELECT = "KEY_INIT_CARDSELECT";
    private static final String CONFIRM_TONEXT_CALLBACK = "CONFIRM_TONEXT_CALLBACK";
    private static final String KEY_BATCHFILLPAYINFO = "KEY_BATCHFILLPAYINFO";
    private static final String KEY_BATCHFILLDRAFTINFO = "KEY_BATCHFILLDRAFTINFO";
    private static final String ACTION_CONFIRM_UNIQUECOMBINE = "ACTION_CONFIRM_UNIQUECOMBINE";
    private static final String ACTION_BATCH_FILL = "ACTION_BATCH_FILL";
    private static final String KEY_SUMSCHEEDIT = "KEY_SUMSCHEEDIT";
    private static final String KEY_MUTXCALLBACK = "mutxCallBack";
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private static final String CACHE_UPLOADS = "cacheUploads";
    private static final String ISELECPAYMENT = "iselecpayment";
    private static final String SETTLEMENTTYPE = "settlementtype";
    private PayScheProcessorHandler payScheHandler;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry card = (CardEntry)this.getControl("sumentry");
        card.addHyperClickListener(evt -> {
            if ("c_scheduleratio".equals(evt.getFieldName())) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                int rowIndex = evt.getRowIndex();
                CardEntry cardEntry = (CardEntry)this.getControl("sumentry");
                cardEntry.selectCard(Integer.valueOf(rowIndex));
                Object billStatus = this.getModel().getValue("billstatus");
                if (BillStatusEnum.SUBMIT.equals(billStatus) || BillStatusEnum.AUDIT.equals(billStatus)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u6c47\u603b\u6392\u7a0b\uff0c\u4ec5\u6682\u5b58\u72b6\u6001\u7684\u6392\u7a0b\u5904\u7406\u5355\u5141\u8bb8\u8fdb\u884c\u6c47\u603b\u6392\u7a0b\u5904\u7406\u3002", (String)"PayScheCalcPlugin_15", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || !this.getPayScheHandler().isSumSche()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u627e\u5230\u5408\u9002\u7684\u6c47\u603b\u6392\u7a0b\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u662f\u5426\u5b58\u5728\u6c47\u603b\u6392\u7a0b\u89c4\u5219\uff0c\u6216\u8be5\u7ec4\u7ec7\u7684\u6c47\u603b\u89c4\u5219\u5468\u671f\u662f\u5426\u4e0e\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u5468\u671f\u4e00\u81f4\u3002", (String)"PayScheCalcPlugin_8", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection c_entry = this.getModel().getEntryEntity("sumentry");
                DynamicObject currScheDo = (DynamicObject)c_entry.get(rowIndex);
                if (EmptyUtil.isNoEmpty((DynamicObject)currScheDo)) {
                    ArrayList scheduleList;
                    String entrustScheduleValidateMsg;
                    PayScheSumData sumData = this.getPayScheHandler().getSumScheData(this.getSelectSumId(true));
                    if (sumData.getApplyAmt().compareTo(BigDecimal.ZERO) <= 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5305\u542b\u6b63\u6570\u91d1\u989d\u7684\u6392\u7a0b\u5355\uff0c\u65e0\u6cd5\u53d1\u8d77\u6c47\u603b\u6392\u7a0b\u3002", (String)"PayScheCalcPlugin_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && EmptyUtil.isNoEmpty((String)(entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg(scheduleList = new ArrayList(entryEntity), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u6392\u6b3e\u3001\u90e8\u5206\u6392\u7968\u3001\u540c\u65f6\u6392\u6b3e\u6392\u7968\u3001\u6279\u91cf\u6392\u6b3e\u3001\u6279\u91cf\u6392\u7968\u3001\u81ea\u52a8\u6392\u7a0b\u3001\u6c47\u603b\u6392\u7a0b\u3002", (String)"PayScheCalcPlugin_22", (String)"tmc-psd-formplugin", (Object[])new Object[0]))))) {
                        this.getView().showErrorNotification(entrustScheduleValidateMsg);
                        if (scheduleList.size() == 1) {
                            return;
                        }
                    }
                    SumScheInfo sumScheInfo = this.getPayScheHandler().getSumScheInfo(sumData.getSummaryId().longValue(), (String)this.getModel().getValue("sumdim"));
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setCustomParam("orgid", (Object)this.getOrgId());
                    fsp.setCustomParam("scheperiodid", (Object)this.getPeriodTypeId());
                    fsp.setCustomParam("dimtype", this.getModel().getValue("sumdim"));
                    fsp.setCustomParam("KEY_SUMENTRYINFO", (Object)JSON.toJSONString((Object)sumData));
                    fsp.setCustomParam("KEY_SUMSCHEINFO", (Object)JSON.toJSONString((Object)sumScheInfo));
                    fsp.setFormId("psd_schesuminfo");
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SUMSCHEEDIT));
                    this.getView().showForm(fsp);
                }
            }
        });
        final Tab tab = (Tab)this.getControl("tabap");
        card.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                String currentTab = tab.getCurrentTab();
                if ("singleschetap".equals(currentTab)) {
                    PayScheCalcPlugin.this.refreshCard(evt.getRow());
                }
            }
        });
        tab.addTabSelectListener(tabEvt -> this.refreshTab(tabEvt.getTabKey()));
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        TextEdit settletNumber = (TextEdit)this.getView().getControl("e_lcarrival");
        settletNumber.addButtonClickListener((ClickListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL_AP);
        attachmentPanel.addUploadListener((UploadListener)this);
        ItemClassEdit acctBank = (ItemClassEdit)this.getControl("e_acctbank");
        acctBank.addBeforeF7SelectListener(evt -> {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object value = this.getModel().getValue("e_acctbanktype");
            if (EmptyUtil.isNoEmpty((Object)value) && "bd_accountbanks".equals(value)) {
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("e_settletype", currentRowIndex);
                DynamicObject company = (DynamicObject)this.getModel().getValue("company");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)company.getLong("id"));
                    qFilters.add(baseDataFilter);
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                    QFilter virtualFilter;
                    String settlementType = settleType.getString(SETTLEMENTTYPE);
                    if (SettleMentTypeEnum.VIRTUAL.getValue().equals(settlementType)) {
                        virtualFilter = new QFilter("isvirtual", "=", (Object)"1");
                        qFilters.add(virtualFilter);
                    } else {
                        virtualFilter = new QFilter("isvirtual", "=", (Object)"0");
                        qFilters.add(virtualFilter);
                    }
                    int rowIdx = entryGrid.getSelectRows()[0];
                    String businessType = (String)this.getModel().getValue("e_businesstype", rowIdx);
                    if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                        qFilters.add(new QFilter(ISELECPAYMENT, "!=", (Object)true));
                    } else if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType) || PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                        qFilters.add(new QFilter(ISELECPAYMENT, "=", (Object)true));
                    } else {
                        qFilters.add(new QFilter(ISELECPAYMENT, "!=", (Object)true));
                    }
                    qFilters.add(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
                }
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            }
        });
        this.initSettleType();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proKeyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int index = e.getChangeSet()[0].getRowIndex();
        if ("de_transferamt".equals(proKeyName)) {
            DynamicObject darftEntryItem = (DynamicObject)this.getModel().getEntryEntity("draftinfoentry").get(index);
            PayScheDraftInfo payScheDraftInfo = new PayScheDraftInfo(Long.valueOf(darftEntryItem.getLong("de_payscheinfo")), Long.valueOf(darftEntryItem.getDynamicObject("de_draftinfo").getLong("id")), darftEntryItem.getBigDecimal("de_transferamt"));
            Long scheId = darftEntryItem.getLong("de_payscheinfo");
            BigDecimal draftTransAmounts = BigDecimal.ZERO;
            DynamicObjectCollection draftItems = this.getModel().getEntryEntity("draftinfoentry");
            Set draftItemSet = draftItems.stream().filter(o -> scheId.equals(o.getLong("de_payscheinfo"))).collect(Collectors.toSet());
            for (DynamicObject draftItem : draftItemSet) {
                draftTransAmounts = draftTransAmounts.add(draftItem.getBigDecimal("de_transferamt"));
            }
            HashMap<Long, BigDecimal> draftAmounts = new HashMap<Long, BigDecimal>(2);
            draftAmounts.put(scheId, draftTransAmounts);
            this.getPayScheHandler().setTransDraftAmounts(draftAmounts);
            this.getPayScheHandler().updateTransferAmt(Collections.singletonList(payScheDraftInfo));
            this.changeScheInfo(darftEntryItem, proKeyName, draftTransAmounts);
        } else if ("e_draftno".equals(proKeyName)) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            DynamicObject payScheEntryData = (DynamicObject)entryList.get(e.getChangeSet()[0].getRowIndex());
            PayScheCalcModel scheModel = this.getPayScheDataTransfer().transDataToCalcModel(payScheEntryData);
            if (scheModel.isArchiveMerger()) {
                this.getHandler().updateScheInfo(scheModel.getSummaryId(), new ArrayList<PayScheCalcModel>(Collections.singletonList(scheModel)), this.getPageId(), "mergeDraftChg", scheModel.isArchiveMerger(), scheModel.getDraftBillAmt());
            }
        } else if ("e_acctbank".equals(proKeyName)) {
            DynamicObject acct = (DynamicObject)this.getModel().getValue("e_acctbank", index);
            String institutionCode = this.getInstitUtionCode(acct, index);
            this.getModel().setValue("e_institutioncode", (Object)institutionCode, index);
            String institutionName = this.getInstitutionName(acct, index);
            this.getModel().setValue("e_institutionname", (Object)institutionName, index);
        } else if ("e_settletype".equals(proKeyName)) {
            DynamicObject settleType = (DynamicObject)newValue;
            if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.DIGITALWALLET.getValue().equals(settleType.getString(SETTLEMENTTYPE))) {
                DynamicObject cny = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CNY")});
                this.getModel().setValue("e_paycurrency", (Object)cny, index);
                this.getModel().setValue("e_currency", (Object)cny, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"e_paycurrency", "e_draftamt", "e_isbilldibs"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"e_paycurrency", "e_draftamt", "e_isbilldibs"});
            }
        } else if ("e_businesstype".equals(proKeyName)) {
            this.getModel().setValue("e_acctbank", null, index);
            this.getModel().setValue("e_institutioncode", null, index);
            this.getModel().setValue("e_institutionname", null, index);
        }
    }

    public void changeScheInfo(DynamicObject darftEntryItem, String proKeyName, BigDecimal draftTransAmounts) {
        String pageId = this.getPageId();
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        String batchNo = darftEntryItem.getString("de_batchnum");
        for (DynamicObject payScheEntryData : entryList) {
            PayScheCalcModel scheModel = this.getPayScheDataTransfer().transDataToCalcModel(payScheEntryData);
            if (!scheModel.isArchiveMerger() || !StringUtils.isNotEmpty((CharSequence)scheModel.getBatchnum()) || !scheModel.getBatchnum().equals(batchNo)) continue;
            this.getHandler().updateScheInfo(scheModel.getSummaryId(), new ArrayList<PayScheCalcModel>(Collections.singletonList(scheModel)), pageId, proKeyName, scheModel.isArchiveMerger(), draftTransAmounts);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid source = (EntryGrid)evt.getSource();
        String entryKey = source.getEntryKey();
        if ("entryentity".equals(entryKey)) {
            int row = evt.getRow();
            if (row == -1) {
                return;
            }
            this.clickEntryToRenderInfo(row);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "e_lcarrival": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)META_ARRIVAL, (boolean)false);
                EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                int index = selectRows[0];
                DynamicObject payBill = this.getModel().getEntryRowEntity("entryentity", index);
                this.getPageCache().put(PK_VALUE, payBill.getPkValue().toString());
                DynamicObject org = (DynamicObject)this.getModel().getValue("company");
                DynamicObject currency = payBill.getDynamicObject("e_paycurrency");
                String payeetype = payBill.getString("e_payeetype");
                long payeeid = payBill.getLong("e_recid");
                String payeename = payBill.getString("e_payeename");
                BigDecimal payeeamount = payBill.getBigDecimal("e_draftamt");
                String settlementType = SettleMentTypeEnum.CREDIT.getValue();
                QFilter qFilter = PayScheCalcPlugin.getArrivalNoQFilter(org, currency, payeetype, payeeid, payeename, payeeamount, settlementType);
                showParameter.getListFilterParameter().setFilter(qFilter);
                showParameter.setIsolationOrg(false);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LC_ARRIVAL_CALL_BACK));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long processorId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_PROCESSOR_ID");
        this.fillProcessorData();
        StringBuilder errMsg = new StringBuilder();
        boolean result = this.recordOrRequireMutex(this.getView().getFormShowParameter().getCustomParams(), processorId, errMsg);
        if (!result) {
            String msg;
            if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                msg = errMsg.toString();
            } else {
                DynamicObject processorBill = TmcDataServiceHelper.loadSingle((Object)processorId, (String)"psd_schedealbill");
                msg = String.format(ResManager.loadKDString((String)"%s: \u5f53\u524d\u6392\u7a0b\u5904\u7406\u5355\u5df2\u88ab\u4ed6\u4eba\u5360\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PayScheCalcPlugin_7", (String)"tmc-psd-formplugin", (Object[])new Object[0]), processorBill.getString("billno"));
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_MUTXCALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void afterBindData(EventObject e) {
        List atts;
        super.afterBindData(e);
        this.loadProcessor(null);
        if (Objects.isNull(this.getModel().getValue("scheduleperiod"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scheduleperiod"});
        }
        if (!CollectionUtils.isEmpty((Collection)(atts = AttachmentServiceHelper.getAttachments((String)"psd_schebillcalc", (Object)this.getModel().getValue("processorid"), (String)ATTACHMENT_PANEL_AP, (boolean)false)))) {
            AttachmentPanel panel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
            panel.bindData(atts);
            panel.upload(atts);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IPageCache pageCache = this.getPageCache();
        EntryGrid entryLists = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryLists.getSelectRows();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (operateKey.equals("save") || operateKey.equals("audit")) {
            List scheDataList = this.getPayScheHandler().getAllScheDataList();
            op.getOption().setVariableValue("key_payschemodel", PayScheCalcModel.serializeList((List)scheDataList));
            op.getOption().setVariableValue("deleteScheduleBillList", this.getPageCache().get("deleteScheduleBillList"));
        }
        if (operateKey.equals("presubmit")) {
            boolean combineIsLegal = this.getPayScheHandler().checkCombine(true);
            if (combineIsLegal) {
                List scheDataList = this.getPayScheHandler().getAllScheDataList();
                op.getOption().setVariableValue("key_payschemodel", PayScheCalcModel.serializeList((List)scheDataList));
                op.getOption().setVariableValue("deleteScheduleBillList", this.getPageCache().get("deleteScheduleBillList"));
            } else {
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("mergerschetap");
                args.setCancel(true);
            }
        }
        if (operateKey.equals("split") && selectRows.length == 1 && EmptyUtil.isNoEmpty((String)(entryEntity = (DynamicObject)entrys.get(selectRows[0])).getString("e_batchnum"))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5408\u5e76\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PayScheProcessorCalcPlugin_06", (String)"tmc-psd-formplugin", (Object[])new Object[0]), entryEntity.getString("e_billno")));
            args.setCancel(true);
            return;
        }
        if (operateKey.equals("audit") || operateKey.equals("unaudit") || operateKey.equals("presubmit") || operateKey.equals("unsubmit")) {
            HashMap<String, String> auditPreId = new HashMap<String, String>(){
                {
                    this.put("audit", "47162f66000000ac");
                    this.put("unaudit", "47165e8e000000ac");
                    this.put("presubmit", "804f6478000000ac");
                    this.put("unsubmit", "80513207000000ac");
                }
            };
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            Long orgId = Optional.ofNullable(company.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> company.getLong("id"));
            boolean hasAudit = PermissionHelper.checkCurrentUserPermission((long)orgId, (String)"psd_schedealbill", (String)((String)auditPreId.get(operateKey)));
            if (!hasAudit) {
                HashMap<String, String> auditNameMap = new HashMap<String, String>(){
                    {
                        this.put("audit", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PayScheCalcPlugin_9", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        this.put("unaudit", ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"PayScheCalcPlugin_10", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        this.put("presubmit", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PayScheCalcPlugin_11", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        this.put("unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"PayScheCalcPlugin_12", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    }
                };
                String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4ed8\u6b3e\u6392\u7a0b\u5904\u7406\u5355\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PayScheCalcPlugin_13", (String)"tmc-psd-formplugin", (Object[])new Object[0]), auditNameMap.get(operateKey));
                this.getView().showMessage(errMsg);
                args.setCancel(true);
            }
        }
        switch (operateKey) {
            case "split": 
            case "cancelcombine": 
            case "rejectpay": {
                String msg;
                String entrustScheduleValidateMsg;
                List<Object> selectPayScheduleList = this.getSelectPayScheList();
                if (!EmptyUtil.isNoEmpty(selectPayScheduleList) || !EmptyUtil.isNoEmpty((String)(entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg(selectPayScheduleList, (String)(msg = StringUtils.equals((CharSequence)"rejectpay", (CharSequence)operateKey) ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u62d2\u4ed8\uff0c\u8bf7\u4f7f\u7528\u9000\u5355\u529f\u80fd\u3002", (String)"PayScheCalcPlugin_23", (String)"tmc-psd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u6216\u53d6\u6d88\u5408\u5e76\u6216\u5220\u9664\u3002", (String)"PayScheCalcPlugin_20", (String)"tmc-psd-formplugin", (Object[])new Object[0])))))) break;
                this.getView().showErrorNotification(entrustScheduleValidateMsg);
                args.setCancel(true);
                return;
            }
            case "combine": 
            case "autocombine": {
                String entrustScheduleValidateMsg;
                List entrustScheduleList;
                List<Object> selectPayScheduleList;
                boolean autoCombine = StringUtils.equals((CharSequence)operateKey, (CharSequence)"autocombine");
                List<Object> list = selectPayScheduleList = autoCombine ? new ArrayList(entrys) : this.getSelectPayScheList();
                if (!EmptyUtil.isNoEmpty(selectPayScheduleList) || !EmptyUtil.isNoEmpty(entrustScheduleList = selectPayScheduleList.stream().filter(selectPaySchedule -> EmptyUtil.isNoEmpty((Long)selectPaySchedule.getLong("e_entrustpayid"))).collect(Collectors.toList())) || selectPayScheduleList.size() <= entrustScheduleList.size() || !EmptyUtil.isNoEmpty((String)(entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg(entrustScheduleList, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0e\u5176\u4ed6\u6e90\u5355\u751f\u6210\u7684\u6392\u7a0b\u5355\u5408\u5e76\u3002", (String)"PayScheCalcPlugin_21", (String)"tmc-psd-formplugin", (Object[])new Object[0]))))) break;
                this.getView().showErrorNotification(entrustScheduleValidateMsg);
                if (autoCombine) break;
                args.setCancel(true);
                return;
            }
            case "batchschedule": 
            case "batchdraft": 
            case "autoschedule": {
                List<Object> selectPayScheduleList = StringUtils.equals((CharSequence)operateKey, (CharSequence)"autoschedule") ? new ArrayList(entrys) : this.getSelectScheduleDetailList();
                String entrustScheduleValidateMsg = PayScheduleUtil.getEntrustScheduleValidateMsg(selectPayScheduleList, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u6392\u6b3e\u3001\u90e8\u5206\u6392\u7968\u3001\u540c\u65f6\u6392\u6b3e\u6392\u7968\u3001\u6279\u91cf\u6392\u6b3e\u3001\u6279\u91cf\u6392\u7968\u3001\u81ea\u52a8\u6392\u7a0b\u3001\u6c47\u603b\u6392\u7a0b\u3002", (String)"PayScheCalcPlugin_22", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                if (!EmptyUtil.isNoEmpty((String)entrustScheduleValidateMsg)) break;
                this.getView().showErrorNotification(entrustScheduleValidateMsg);
                if (selectPayScheduleList.size() != 1) break;
                args.setCancel(true);
                return;
            }
            case "deleteentry": {
                List<Object> deleteList;
                List<Object> selectPayScheduleList = this.getSelectScheduleDetailList();
                List scheduleDataList = PayScheduleUtil.getNotMergerScheduleDataList((List)this.getPayScheHandler().getAllScheDataList());
                if (scheduleDataList.size() == 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6392\u7a0b\u5904\u7406\u5355\u4ec5\u6709\u4e00\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u901a\u8fc7\u5220\u9664\u6392\u7a0b\u5904\u7406\u5355\u5904\u7406\u3002", (String)"PayScheCalcPlugin_24", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (scheduleDataList.size() == selectRows.length) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u5904\u7406\u5355\u4e0d\u652f\u6301\u5220\u9664\u5168\u90e8\u6392\u7a0b\u5355\u5206\u5f55\uff0c\u8bf7\u81f3\u5c11\u4fdd\u7559\u5176\u4e2d\u4e00\u884c\u3002", (String)"PayScheCalcPlugin_27", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                StringBuilder errMsg = new StringBuilder();
                ArrayList errorList = new ArrayList(10);
                selectPayScheduleList.forEach(e -> {
                    if (EmptyUtil.isNoEmpty((String)e.getString("e_batchnum"))) {
                        errorList.add(e.getInt(ENTRY_SEQ));
                        if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                            errMsg.append("\r\n");
                        }
                        errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c{0}\u201d\u5df2\u64cd\u4f5c\u5408\u5e76\u6392\u7a0b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u884c\uff0c\u5982\u9700\u5220\u9664\u8bf7\u5148\u53d6\u6d88\u5408\u5e76\u6392\u7a0b\u3002", (String)"PayScheCalcPlugin_25", (String)"tmc-psd-formplugin", (Object[])new Object[]{e.getString("e_billno")}));
                    }
                });
                Set scheduleBillNoSet = selectPayScheduleList.stream().filter(e -> EmptyUtil.isEmpty((String)e.getString("e_batchnum"))).map(e -> e.getString("e_billno")).collect(Collectors.toSet());
                DynamicObjectCollection scheduleBillList = QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", "billno", "applyamt", "balanceamt"), (QFilter[])new QFilter("billno", "in", scheduleBillNoSet).toArray());
                Map<String, DynamicObject> billNoAndScheduleBillMap = scheduleBillList.stream().collect(Collectors.toMap(s -> s.getString("billno"), dy -> dy, (m1, m2) -> m1));
                selectPayScheduleList.stream().filter(e -> EmptyUtil.isEmpty((String)e.getString("e_batchnum"))).forEach(e -> {
                    DynamicObject scheduleBill = (DynamicObject)billNoAndScheduleBillMap.get(e.getString("e_billno"));
                    if (EmptyUtil.isEmpty((DynamicObject)scheduleBill) || scheduleBill.getBigDecimal("applyamt").compareTo(e.getBigDecimal("e_applyamt")) != 0) {
                        errorList.add(e.getInt(ENTRY_SEQ));
                        if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                            errMsg.append("\r\n");
                        }
                        errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c{0}\u201d\u4e3a\u62c6\u5206\u5206\u5f55\u4f46\u672a\u4fdd\u5b58\u5165\u5e93\uff0c\u4e0d\u652f\u6301\u5220\u9664\u884c\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u64cd\u4f5c\u5220\u9664\u3002", (String)"PayScheCalcPlugin_26", (String)"tmc-psd-formplugin", (Object[])new Object[]{e.getString("e_billno")}));
                    }
                });
                if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                    this.getView().showErrorNotification(errMsg.toString());
                }
                if (errorList.size() == selectPayScheduleList.size()) {
                    args.setCancel(true);
                    return;
                }
                PayScheDataTransfer payScheDataTransfer = new PayScheDataTransfer();
                if (errorList.size() > 0) {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                    deleteList = new ArrayList<Object>(10);
                    int[] selectRowIndexes = new int[selectPayScheduleList.size() - errorList.size()];
                    int index = 0;
                    for (DynamicObject dynamicObject : selectPayScheduleList) {
                        if (errorList.contains(dynamicObject.getInt(ENTRY_SEQ))) continue;
                        selectRowIndexes[index++] = dynamicObject.getInt(ENTRY_SEQ) - 1;
                        deleteList.add(dynamicObject);
                    }
                    entryGrid.selectRows(selectRowIndexes, selectRowIndexes[0]);
                } else {
                    deleteList = selectPayScheduleList;
                }
                pageCache.put("key_payschemodel_delete", PayScheCalcModel.serializeList(deleteList.stream().map(arg_0 -> ((PayScheDataTransfer)payScheDataTransfer).transDataToCalcModel(arg_0)).collect(Collectors.toList())));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        IPageCache pageCache = this.getPageCache();
        if (opResult != null && opResult.isSuccess()) {
            this.getPageCache().put("opKey", operateKey);
            switch (operateKey) {
                case "viewflowchart": {
                    WorkflowServiceHelper.viewFlowchartWithEntityNumber((String)this.getPageId(), (String)"psd_schedealbill", (Object)this.getModel().getValue("processorid"));
                    break;
                }
                case "freeze": {
                    EntryGrid detailsEntryObjOfFreezee = (EntryGrid)this.getControl("entryentity");
                    int[] rows = detailsEntryObjOfFreezee.getSelectRows();
                    HashSet<String> batchNumNotEmptyLst = new HashSet<String>(16);
                    for (int index : rows) {
                        DynamicObject selectRowObj = this.getModel().getEntryRowEntity("entryentity", index);
                        if (!StringUtils.isNotEmpty((CharSequence)selectRowObj.getString("e_batchnum"))) continue;
                        batchNumNotEmptyLst.add(selectRowObj.getString("e_batchnum"));
                        break;
                    }
                    if (!batchNumNotEmptyLst.isEmpty()) {
                        this.getView().getPageCache().put(PAYSCHECALCPLUGIN_BATCHNUM_CACHE, SerializationUtils.toJsonString(batchNumNotEmptyLst));
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u6392\u7a0b\u5355\u5c06\u53c2\u4e0e\u5408\u5e76\uff0c\u662f\u5426\u51bb\u7ed3\u6574\u4e2a\u6279\u6b21\u7684\u6392\u7a0b\u5355\uff1f", (String)"PayScheCalcPlugin_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("freeze", (IFormPlugin)this));
                        break;
                    }
                    this.getPayScheHandler().freeze(this.getSelectSumId(true), this.getSelectPayScheIdList(), false, this.isMegerTab());
                    break;
                }
                case "thaw": {
                    EntryGrid detailsEntryObjOfThaw = (EntryGrid)this.getControl("entryentity");
                    int[] rowsOfThaw = detailsEntryObjOfThaw.getSelectRows();
                    boolean flag = false;
                    for (int index : rowsOfThaw) {
                        DynamicObject selectRowObj = this.getModel().getEntryRowEntity("entryentity", index);
                        Date expectDate = selectRowObj.getDate("e_expectdate");
                        Date currentDate = new Date(System.currentTimeMillis());
                        if (null != expectDate && Long.compare(expectDate.getTime(), currentDate.getTime()) >= 0) continue;
                        flag = true;
                        break;
                    }
                    if (flag) {
                        this.checkScheSelectRow();
                        this.showForm(this, "psd_modifyavd", ShowType.Modal, "thaw", (Map<String, Object>)new HashMap<String, Object>(){
                            private static final long serialVersionUID = -5133156341571886539L;
                            {
                                this.put("pkIds", "0");
                            }
                        });
                        break;
                    }
                    this.getPayScheHandler().thaw(this.getSelectSumId(true), this.getSelectPayScheIdList(), null, this.isMegerTab());
                    break;
                }
                case "autocombine": {
                    this.openCombineRuleWindow();
                    break;
                }
                case "balancedcheck": {
                    final String id = (String)this.getModel().getValue("billno");
                    this.showForm(this, "psd_balancedcheck", ShowType.MainNewTabPage, null, (Map<String, Object>)new HashMap<String, Object>(){
                        private static final long serialVersionUID = 3922914496148170326L;
                        {
                            this.put("psdFormId", id);
                            List scheDataList = PayScheCalcPlugin.this.getPayScheHandler().getAllScheDataList();
                            this.put("psdDetailData", PayScheCalcModel.serializeList((List)scheDataList));
                        }
                    });
                    break;
                }
                case "batchschedule": {
                    this.checkScheSelectRow();
                    this.dibsCannotOp(ResManager.loadKDString((String)"\u6279\u91cf\u6392\u6b3e", (String)"PayScheCalcPlugin_04", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    ListShowParameter sp = ShowFormHelper.createShowListForm((String)"psd_payment_rule", (boolean)false);
                    sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BATCHFILLPAYINFO));
                    List payscheFilters = sp.getListFilterParameter().getQFilters();
                    if (null != payscheFilters) {
                        ArrayList<Long> orgIds = new ArrayList<Long>(2);
                        orgIds.add(this.getOrgId());
                        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                        qFilter.and(new QFilter("entryentity.ruleorg", "in", orgIds).or(new QFilter("entryentity.ruleorg", "is null", null)));
                        payscheFilters.add(qFilter);
                    }
                    this.getView().showForm((FormShowParameter)sp);
                    break;
                }
                case "batchdraft": {
                    this.checkScheSelectRow();
                    this.dibsCannotOp(ResManager.loadKDString((String)"\u6279\u91cf\u6392\u7968", (String)"PayScheCalcPlugin_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"psd_queueticket_rule", (boolean)false);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BATCHFILLDRAFTINFO));
                    List draftFilters = lsp.getListFilterParameter().getQFilters();
                    if (null != draftFilters) {
                        draftFilters.add(new QFilter("enable", "=", (Object)"1"));
                    }
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                case "tonext": {
                    this.checkScheSelectRow();
                    DynamicObject schePeriod = this.getModel().getDataEntity().getDynamicObject("scheduleperiod");
                    Date endDate = schePeriod.getDate("enddate");
                    String toNextDate = DateUtils.formatString((Date)DateUtils.getNextDay((Date)endDate, (int)1), (String)"yyyy-MM-dd");
                    this.getView().showConfirm(new PsdBizResource().getTipForTonext(toNextDate), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_TONEXT_CALLBACK, (IFormPlugin)this));
                    break;
                }
                case "canceltonext": {
                    this.checkScheSelectRow();
                    this.getPayScheHandler().cancelTrans(this.getSelectSumId(true), this.getSelectPayScheIdList());
                    break;
                }
                case "autoschedule": {
                    this.dibsCannotOp(ResManager.loadKDString((String)"\u81ea\u52a8\u6392\u7a0b", (String)"PayScheCalcPlugin_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    this.getPayScheHandler().autoSchedule();
                    break;
                }
                case "rejectpay": {
                    this.checkScheSelectRow();
                    this.checkReject();
                    this.getPayScheHandler().refusePay(this.getSelectSumId(true), this.getSelectPayScheIdList());
                    break;
                }
                case "split": {
                    EntryGrid detailsEntry = (EntryGrid)this.getControl("entryentity");
                    int[] selectRows = detailsEntry.getSelectRows();
                    if (selectRows.length > 1 || selectRows.length <= 0) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u660e\u7ec6\u6570\u636e\u3002", (String)"PayScheCalcPlugin_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    String sourceBillType = (String)this.getModel().getValue("e_sourcebilltype");
                    DynamicObject selectObject = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
                    String sourceBillNo = selectObject.getString("e_sourcebillnumber");
                    if (!PayScheHelper.isPartPaymentBySourceBillNo((String)sourceBillNo, (String)sourceBillType)) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u8d44\u91d1\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u652f\u6301\u62c6\u5206", (String)"PayScheCalcPlugin_16", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    if (this.existArrival()) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u4fe1\u7528\u8bc1,\u4e0d\u652f\u6301\u62c6\u5206.", (String)"PayScheCalcPlugin_17", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    boolean isLegal = this.getPayScheHandler().checkSplit(this.getSelectSumId(true), this.getSelectPayScheIdList().get(0));
                    if (!isLegal) break;
                    DynamicObject detailObj = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
                    PayScheCalcModel calcModel = new PayScheDataTransfer().transDataToCalcModel(detailObj);
                    final String serializeStr = calcModel.serialize();
                    this.showForm(this, "psd_schebillsplit", ShowType.Modal, String.format("%s%s", "split", "psd_schebillsplit"), new HashMap(){
                        {
                            this.put("key_splitModelData", serializeStr);
                            this.put("KEY_PROCESSOR_INFO", JSON.toJSONString((Object)PayScheCalcPlugin.this.getProcessorInfo()));
                        }
                    });
                    break;
                }
                case "combine": {
                    if (this.isContainsDcep()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u65f6\u542b\u6709\u7533\u8bf7\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u4e0e\u975e\u6570\u5e01\u94b1\u5305\u7684,\u4e0d\u652f\u6301\u5408\u5e76\u3002", (String)"PayScheCalcPlugin_19", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    Tuple result = this.getPayScheHandler().manualCombine(this.getSelectSumId(true), this.getSelectPayScheIdList());
                    if (!((Boolean)result.item1).booleanValue()) break;
                    this.getView().showConfirm((String)result.item2, MessageBoxOptions.YesNo, new ConfirmCallBackListener(ACTION_CONFIRM_UNIQUECOMBINE));
                    break;
                }
                case "cancelcombine": {
                    this.getPayScheHandler().cancelCombine(this.getSelectPayScheIdList());
                    PayScheProcessorInfo payScheProcessorInfo = new PayScheProcessorInfo();
                    payScheProcessorInfo.setPageIdForBids(this.getPageId());
                    this.getPayScheHandler().cleanFiled(payScheProcessorInfo);
                    break;
                }
                case "showallcombine": {
                    List allCombineDataList = this.getPayScheHandler().getAllCombineDataList();
                    if (allCombineDataList.size() > 0) {
                        this.showCombineProcessPage(PsdCombineModeEnum.VIEW_COMBINE, allCombineDataList, null);
                        break;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u5e76\u9879", (String)"PayScheCalcPlugin_5", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "setcombinerule": {
                    this.showCombineRule();
                    break;
                }
                case "presubmit": {
                    OperateOption option = OperateOption.create();
                    List scheDataList = this.getPayScheHandler().getAllScheDataList();
                    option.setVariableValue("key_payschemodel", PayScheCalcModel.serializeList((List)scheDataList));
                    option.setVariableValue("deleteScheduleBillList", this.getPageCache().get("deleteScheduleBillList"));
                    OperationResult execOperate = TmcOperateServiceHelper.execOperate((String)"submit", (String)"psd_schedealbill", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)option);
                    if (null == execOperate || !execOperate.isSuccess()) break;
                    this.uploadAfterSaveOrSubmit();
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"PayScheProcessorCalcPlugin_18", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "save": 
                case "refresh": {
                    Tab tab = (Tab)this.getControl("tabap");
                    tab.activeTab("singleschetap");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcombinelab"});
                    this.getView().setVisible(Boolean.valueOf(true), entryOpItem);
                    if ("save".equals(operateKey)) {
                        this.uploadAfterSaveOrSubmit();
                        break;
                    }
                    this.getPageCache().remove(CACHE_UPLOADS);
                    break;
                }
                case "unsubmit": 
                case "unaudit": 
                case "audit": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "batchfill": {
                    this.checkScheSelectRow();
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("psd_schebatchfill");
                    showParameter.setAppId("psd");
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_BATCH_FILL));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(showParameter);
                    break;
                }
            }
            List<String> refreshOpList = Arrays.asList("save", "submit", "audit", "unsubmit", "unaudit", "refresh");
            if (refreshOpList.contains(operateKey)) {
                this.fillProcessorData();
                this.loadProcessor(this.getSelectSumId(false));
                this.getPageCache().remove("deleteScheduleBillList");
            }
        }
        switch (operateKey) {
            case "deleteentry": {
                String deleteScheduleEntryData = pageCache.get("key_payschemodel_delete");
                if (!EmptyUtil.isNoEmpty((String)deleteScheduleEntryData)) break;
                String allDeleteScheduleBills = pageCache.get("deleteScheduleBillList");
                List deleteScheduleList = PayScheCalcModel.deserializeList((String)deleteScheduleEntryData);
                List allDeleteScheduleList = EmptyUtil.isNoEmpty((String)allDeleteScheduleBills) ? PayScheCalcModel.deserializeList((String)allDeleteScheduleBills) : new ArrayList(10);
                this.getPayScheHandler().directUpdateData(deleteScheduleList);
                allDeleteScheduleList.addAll(deleteScheduleList);
                this.getPageCache().remove("key_payschemodel_delete");
                this.getPageCache().put("deleteScheduleBillList", PayScheCalcModel.serializeList((List)allDeleteScheduleList));
            }
        }
    }

    private void dibsCannotOp(String businessName) {
        EntryGrid entryList = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryList.getSelectRows();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (int selectRow : selectRows) {
            DynamicObject entryEntity = (DynamicObject)entrys.get(selectRow);
            if (!entryEntity.getBoolean("e_isbilldibs")) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e\u627e\u96f6\u65f6\uff0c\u4e0d\u652f\u6301%1$s\u3002", (String)"PayScheCalcPlugin_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]), businessName));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (result.equals((Object)MessageBoxResult.Yes) && callBackId.equals(CONFIRM_TONEXT_CALLBACK)) {
            this.getPayScheHandler().transToNextPeriod(this.getSelectSumId(true), this.getSelectPayScheIdList());
        }
        if (ACTION_CONFIRM_UNIQUECOMBINE.equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPayScheHandler().manualUniqueCombine(this.getSelectSumId(true), this.getSelectPayScheIdList());
        } else if ("freeze".equals(callBackId)) {
            if (result.equals((Object)MessageBoxResult.Cancel)) {
                this.getPayScheHandler().freeze(this.getSelectSumId(true), this.getSelectPayScheIdList(), true, this.isMegerTab());
            } else if (result.equals((Object)MessageBoxResult.Yes)) {
                List<Long> ids = this.getSelectPayScheIdList();
                String cacheStr = this.getView().getPageCache().get(PAYSCHECALCPLUGIN_BATCHNUM_CACHE);
                Set batchNumNotEmptyLsts = (Set)SerializationUtils.fromJsonString((String)cacheStr, Set.class);
                DynamicObjectCollection schebills = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject schebill : schebills) {
                    String batchNum = schebill.getString("e_batchnum");
                    if (null == batchNum || !EmptyUtil.isNotEmpty((CharSequence)batchNum) || !batchNumNotEmptyLsts.contains(batchNum)) continue;
                    ids.add(schebill.getLong("e_id"));
                }
                this.getPayScheHandler().freeze(this.getSelectSumId(true), ids, false, this.isMegerTab());
            }
        } else if (KEY_MUTXCALLBACK.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"psd_schebillcalc", "fieldsetpanelap", "advconap1", "advconap", "draftinfopanle", ATTACHMENT_PANEL_AP});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit", "audit", "autoschedule", "autocombine", "btn_balancedcheck", "refresh"});
                Map<String, Object> custom = PayScheCalcPlugin.buildCustomStyle();
                this.getView().updateControlMetadata("c_scheduleratio", custom);
                return;
            }
            this.getView().close();
        }
    }

    private static Map<String, Object> buildCustomStyle() {
        HashMap<String, Object> custom = new HashMap<String, Object>();
        custom.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQge1xuwqDCoHBvaW50ZXItZXZlbnRzOm5vbmU7XG7CoH1cbiJ9");
        return custom;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        Long sumCardInx;
        ListSelectedRowCollection selectRows;
        Map params;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if ("thaw".equals(e.getActionId()) && returnData instanceof Map) {
            params = (Map)returnData;
            Date expectDate = (Date)params.get("expectDate");
            if (null == expectDate) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u671b\u65e5\u671f\u3002", (String)"PayScheCalcPlugin_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPayScheHandler().thaw(this.getSelectSumId(true), this.getSelectPayScheIdList(), expectDate, this.isMegerTab());
        }
        if (KEY_BATCHFILLPAYINFO.equals(e.getActionId()) && returnData instanceof ListSelectedRowCollection && (selectRows = (ListSelectedRowCollection)returnData).size() > 0) {
            sumCardInx = this.getSelectSumId(true);
            if (this.isMegerTab()) {
                sumCardInx = -1L;
            }
            this.getPayScheHandler().autoFillPayInfo((Long)selectRows.get(0).getPrimaryKeyValue(), sumCardInx, this.getSelectPayScheIdList());
        }
        if (KEY_BATCHFILLDRAFTINFO.equals(e.getActionId()) && returnData instanceof ListSelectedRowCollection && (selectRows = (ListSelectedRowCollection)returnData).size() > 0) {
            sumCardInx = this.getSelectSumId(true);
            if (this.isMegerTab()) {
                sumCardInx = -1L;
            }
            this.getPayScheHandler().autoFillTradeBillInfo((Long)selectRows.get(0).getPrimaryKeyValue(), sumCardInx, this.getSelectPayScheIdList());
        }
        if (KEY_SUMSCHEEDIT.equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData) && returnData instanceof SumScheInfo) {
            SumScheInfo sumScheInfo = (SumScheInfo)returnData;
            this.getPayScheHandler().sumSchedule(this.getSelectSumId(true), sumScheInfo);
        }
        if ("autocombine".equals(e.getActionId()) && returnData != null) {
            selectRows = (ListSelectedRowCollection)returnData;
            Object[] primaryKeyValues = selectRows.getPrimaryKeyValues();
            if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                Long ruleId = (Long)primaryKeyValues[0];
                DynamicObjectCollection rules = QueryServiceHelper.query((String)"psd_autocombinerule", (String)"id, entryentity.feildvalue", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
                List ruleFields = Optional.ofNullable(rules).map(ruleLst -> ruleLst.stream().map(rule -> rule.getString("entryentity.feildvalue")).collect(Collectors.toList())).orElseGet(() -> null);
                List result = this.getPayScheHandler().preCombine(ruleFields);
                if (result != null) {
                    this.showCombineProcessPage(PsdCombineModeEnum.AUTO_COMBINE, result, new ParamMap().put("key_combineprops", (Object)ruleFields).getParams());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81ea\u52a8\u5408\u5e76\u89c4\u5219\u3002", (String)"PayScheCalcPlugin_14", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
        }
        if (String.format("%s%s", "split", "psd_schebillsplit").equals(e.getActionId()) && returnData != null) {
            String serializeStr = returnData.toString();
            List calcModelLst = PayScheCalcModel.deserializeList((String)serializeStr);
            this.getPayScheHandler().directUpdateDataList(calcModelLst);
        }
        if (LC_ARRIVAL_CALL_BACK.equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)returnData))) {
            this.setEntryArrivalNo(this.getModel(), "entryentity", this.getPageCache().get(PK_VALUE), rows.get(0).getPrimaryKeyValue());
        }
        if (ACTION_BATCH_FILL.equals(e.getActionId()) && returnData instanceof Map) {
            params = (Map)returnData;
            if (!params.isEmpty()) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows2 = entryGrid.getSelectRows();
                AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
                DynamicObjectCollection entryList = dataModel.getEntryEntity("entryentity");
                for (Object row : (List)selectRows2) {
                    DynamicObject entryData = (DynamicObject)entryList.get((int)row);
                    if (!CollectionUtils.isEmpty((Collection)entryData.getDynamicObjectCollection("e_draftno")) || !StringUtils.isBlank((CharSequence)entryData.getString("e_batchnum")) || !FreezeStatusEnum.UnFrozen.getValue().equals(entryData.getString("e_freezestatus"))) continue;
                    for (Map.Entry entry2 : params.entrySet()) {
                        entryData.set((String)entry2.getKey(), entry2.getValue());
                    }
                }
                List dataList = entryList.stream().map(entry -> {
                    DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                    LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                    for (IDataEntityProperty property : properties) {
                        data.put(property.getName(), entry.get(property.getName()));
                    }
                    return data;
                }).collect(Collectors.toList());
                TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)dataModel, dataList);
                PayScheDataTransfer payScheDataTransfer = this.getPayScheDataTransfer();
                DynamicObjectCollection newEntryList = dataModel.getEntryEntity("entryentity");
                List payScheDataList = newEntryList.stream().map(arg_0 -> ((PayScheDataTransfer)payScheDataTransfer).transDataToCalcModel(arg_0)).collect(Collectors.toList());
                this.getPayScheHandler().directUpdateDataList(payScheDataList);
                String successMsg = ResManager.loadKDString((String)"\u6279\u91cf\u586b\u5145\u6210\u529f", (String)"PayScheProcessorCalcPlugin_23", (String)"tmc-psd-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(successMsg);
            } else {
                String successMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u586b\u5145\u7684\u6570\u636e", (String)"PayScheProcessorCalcPlugin_24", (String)"tmc-psd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(successMsg);
            }
        }
    }

    public void setEntryArrivalNo(IDataModel model, String entryEntityName, String pkValue, Object setValue) {
        EntryGrid entryGrid;
        int[] selectRows;
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryEntityName);
        if (entryEntity != null && entryEntity.size() > 0 && (selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length > 0) {
            DynamicObject arrivalBill = BusinessDataServiceHelper.loadSingle((Object)setValue, (String)META_ARRIVAL);
            String arrivalNo = arrivalBill.getString("arrivalno");
            model.setValue("e_lcarrival", (Object)arrivalNo, selectRows[0]);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        this.getPayScheHandler().clearDraftBillCache();
    }

    public void updateSummaryInfo(List<PayScheSumData> sumDataList, boolean isReplace) {
        if (isReplace) {
            Long prevSumId = this.getSelectSumId(false);
            List entryMapList = sumDataList.stream().map(o -> {
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                entryMap.put("c_collectdimension", o.getDimName());
                entryMap.put("c_dimval", o.getDimVal());
                entryMap.put("c_scheduleratio", o.getPercent());
                entryMap.put("c_applyamt", o.getApplyAmt());
                entryMap.put("c_scheduletotalamt", o.getScheAmt());
                entryMap.put("c_totaldraftamt", o.getDraftAmt());
                entryMap.put("c_balanceamt", o.getScheBalance());
                entryMap.put("c_currency", o.getCurrencyId());
                entryMap.put("id", o.getSummaryId());
                return entryMap;
            }).collect(Collectors.toList());
            TmcViewInputHelper.batchFillEntity((String)"sumentry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), entryMapList);
            this.getView().updateView("sumentry");
            this.selectSumEntry(prevSumId);
        } else {
            DynamicObjectCollection sumEntryList = this.getModel().getEntryEntity("sumentry");
            ArrayList deleteEntryIndexs = new ArrayList();
            for (int i = 0; i < sumEntryList.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)sumEntryList.get(i);
                for (PayScheSumData sumData : sumDataList) {
                    if (!sumData.getSummaryId().equals(entryEntity.getLong("id"))) continue;
                    this.getModel().setValue("c_scheduleratio", (Object)sumData.getPercent(), i);
                    this.getModel().setValue("c_applyamt", (Object)sumData.getApplyAmt(), i);
                    this.getModel().setValue("c_scheduletotalamt", (Object)sumData.getScheAmt(), i);
                    this.getModel().setValue("c_totaldraftamt", (Object)sumData.getDraftAmt(), i);
                    this.getModel().setValue("c_balanceamt", (Object)sumData.getScheBalance(), i);
                    this.getModel().setValue("c_currency", (Object)sumData.getCurrencyId(), i);
                    this.getModel().setValue("c_collectdimension", (Object)sumData.getDimName(), i);
                    this.getModel().setValue("c_dimval", (Object)sumData.getDimVal(), i);
                }
            }
            if (!CollectionUtils.isEmpty(deleteEntryIndexs)) {
                int[] indexs = new int[deleteEntryIndexs.size()];
                for (int i = 0; i < deleteEntryIndexs.size(); ++i) {
                    indexs[i] = (Integer)deleteEntryIndexs.get(i);
                }
                this.getModel().deleteEntryRows("sumentry", indexs);
            }
        }
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public Long getOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        return (Long)org.getPkValue();
    }

    public String getDimType() {
        String dimType = (String)this.getModel().getValue("sumdim");
        return dimType;
    }

    public Long getPeriodTypeId() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("scheduleperiod");
        if (EmptyUtil.isNoEmpty((DynamicObject)period)) {
            DynamicObject periodType = period.getDynamicObject("schetype");
            return (Long)periodType.getPkValue();
        }
        return null;
    }

    public String getMainPageId() {
        return this.getView().getPageId();
    }

    @Override
    protected PayScheCalcBaseHandler<PayScheSumData> getHandler() {
        return this.getPayScheHandler();
    }

    private void showCombineRule() {
        BaseShowParameter fp = new BaseShowParameter();
        fp.setFormId("psd_autocombinerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        long orgId = RequestContext.get().getOrgId();
        DynamicObject[] combineRules = TmcDataServiceHelper.load((String)"psd_autocombinerule", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (combineRules.length > 0) {
            fp.setPkId(combineRules[0].getPkValue());
        }
        this.getView().showForm((FormShowParameter)fp);
    }

    public PayScheProcessorInfo getProcessorInfo() {
        PayScheProcessorInfo processorInfo = new PayScheProcessorInfo();
        processorInfo.setOrgId(this.getOrgId());
        processorInfo.setDimType(this.getDimType());
        processorInfo.setPeriodTypeId(this.getPeriodTypeId());
        processorInfo.setStartDate((Date)this.getModel().getValue("startdate"));
        processorInfo.setEndDate((Date)this.getModel().getValue("enddate"));
        return processorInfo;
    }

    private PayScheProcessorHandler getPayScheHandler() {
        if (this.payScheHandler == null) {
            Long processorId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_PROCESSOR_ID");
            this.payScheHandler = new PayScheProcessorHandler((IPayScheProcessorView)this, processorId);
        }
        return this.payScheHandler;
    }

    private void refreshTab(String tabKey) {
        if ("singleschetap".equals(tabKey)) {
            CardEntry cardEntry = (CardEntry)this.getControl("sumentry");
            int[] selectRows = cardEntry.getSelectRows();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelcombinelab"});
            this.getView().setVisible(Boolean.valueOf(true), entryOpItem);
            this.refreshCard(selectRows[0]);
        } else if ("mergerschetap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancelcombinelab", "freeze", "thaw", "batchschedule", "batchdraft"});
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus) || BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"cancelcombinelab"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"cancelcombinelab"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tonext", "canceltonext", "rejectpay", "split", "combine", "barbatchfill"});
            this.refreshCard(-1);
        }
    }

    private void refreshCard(int rowIndex) {
        Long sumId = null;
        if (rowIndex == -1) {
            sumId = -1L;
        } else {
            String isInit = this.getPageCache().get(KEY_INIT_CARDSELECT);
            if (isInit != null) {
                this.getPageCache().remove(KEY_INIT_CARDSELECT);
                return;
            }
            DynamicObject sumEntry = this.getModel().getEntryRowEntity("sumentry", rowIndex);
            sumId = sumEntry.getLong("id");
        }
        this.getPayScheHandler().loadScheDataList(sumId);
    }

    private void selectSumEntry(Long sumId) {
        DynamicObjectCollection sumEntryList = this.getModel().getEntryEntity("sumentry");
        if (sumEntryList.size() == 0) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl("sumentry");
        int selectIndex = 0;
        if (sumId == null) {
            sumId = 0L;
        }
        for (int i = 0; i < sumEntryList.size(); ++i) {
            if (!sumId.equals(((DynamicObject)sumEntryList.get(i)).getLong("id"))) continue;
            selectIndex = i;
            break;
        }
        if (cardEntry.getSelectRows().length > 0) {
            int currIndex = cardEntry.getSelectRows()[0];
            if (currIndex == selectIndex) {
                this.refreshCard(currIndex);
            }
        } else {
            cardEntry.selectCard(Integer.valueOf(selectIndex));
        }
    }

    private void fillProcessorData() {
        Long processorId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_PROCESSOR_ID");
        DynamicObject processorBill = TmcDataServiceHelper.loadSingle((Object)processorId, (String)"psd_schedealbill");
        this.getModel().setValue("processorid", (Object)processorId);
        this.getModel().setValue("billno", processorBill.get("billno"));
        this.getModel().setValue("company", processorBill.get("company"));
        this.getModel().setValue("scheduleperiod", processorBill.get("scheduleperiod"));
        this.getModel().setValue("startdate", processorBill.get("startdate"));
        this.getModel().setValue("bizdate", processorBill.get("createtime"));
        this.getModel().setValue("enddate", processorBill.get("enddate"));
        this.getModel().setValue("scheduleseq", processorBill.get("scheduleseq"));
        this.getModel().setValue("adjustcount", processorBill.get("adjustcount"));
        this.getModel().setValue("sumdim", processorBill.get("sumdim"));
        this.getModel().setValue("billstatus", processorBill.get("billstatus"));
        this.getModel().setValue("creator", processorBill.get("creator"));
        this.getModel().setValue("description", processorBill.get("description"));
        String billStatus = processorBill.getString("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"autoschedule", "autocombine", "showallcombine", "deleteentry"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"save", "submit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"unsubmit", "audit", "unaudit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"save", "submit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"audit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"autoschedule", "autocombine", "showallcombine", "deleteentry"});
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"unsubmit", "audit"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"submit", "audit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "submit", "unaudit"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"unaudit"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"save", "submit"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "submit", "unsubmit", "audit"});
            }
        }
    }

    private void loadProcessor(Long sumId) {
        String dimType = this.getPayScheHandler().loadProcessor();
        if (dimType != null) {
            this.getModel().setValue("sumdim", (Object)dimType);
        }
        this.selectSumEntry(sumId);
    }

    private Long getSelectSumId(boolean emptyThrowException) {
        CardEntry entryList = (CardEntry)this.getControl("sumentry");
        int[] selectRows = entryList.getSelectRows();
        if (selectRows.length == 0 || selectRows.length == 1 && selectRows[0] == -1) {
            if (emptyThrowException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6c47\u603b\u5361\u7247\u3002", (String)"PayScheProcessorCalcPlugin_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        int selectRow = selectRows[0];
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("sumentry", selectRow);
        return (Long)entryEntity.getPkValue();
    }

    private void openCombineRuleWindow() {
        ListShowParameter createShowListForm = ShowFormHelper.createShowListForm((String)"psd_autocombinerule", (boolean)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "autocombine");
        createShowListForm.setCloseCallBack(callBack);
        List qFilters = createShowListForm.getListFilterParameter().getQFilters();
        if (null != qFilters) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        this.getView().showForm((FormShowParameter)createShowListForm);
    }

    private void showForm(AbstractFormPlugin plugin, String formId, ShowType showType, String callback, Map<String, Object> customeParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(showType);
        parameter.setFormId(formId);
        parameter.setCustomParams(customeParams);
        if (null != callback) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callback));
        }
        plugin.getView().showForm(parameter);
    }

    private boolean recordOrRequireMutex(Map<String, Object> mutexInfo, Object pkId, StringBuilder errMsg) {
        boolean isSuccess = true;
        String mutexEntityKey = (String)mutexInfo.get("MUTEX_ENTITY_KEY");
        String mutexOperationKey = (String)mutexInfo.get("MUTEX_OPER_KEY");
        String mutexObjId = (String)mutexInfo.get("MUTEX_OBJ_ID");
        if ((StringUtils.isBlank((CharSequence)mutexObjId) || StringUtils.isBlank((CharSequence)mutexOperationKey) || StringUtils.isBlank((CharSequence)mutexEntityKey)) && StringUtils.isNotBlank((Object)pkId)) {
            try {
                isSuccess = MutexHelper.requireMutex4BillController((IFormView)this.getView(), (String)"psd_schedealbill", (Object)pkId, (String)"modify", (boolean)true, (StringBuilder)errMsg);
            }
            catch (Exception e) {
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    @Override
    public void updateScheDataList(List<PayScheCalcModel> scheDataList, boolean isReplace) {
        List<PayScheCalcModel> payScheCalcModels = this.filterScheData(scheDataList);
        super.updateScheDataList(payScheCalcModels, isReplace);
        if (EmptyUtil.isNoEmpty(scheDataList)) {
            PayScheCalcModel payScheCalcModel = scheDataList.get(0);
            if (!payScheCalcModel.isArchiveMerger() && EmptyUtil.isNoEmpty((String)payScheCalcModel.getBatchnum())) {
                Map<String, PayScheCalcModel> masterDataRelationMap = scheDataList.stream().filter(o -> o.isArchiveMerger()).collect(Collectors.toMap(o -> o.getBatchnum(), o -> o));
                payScheCalcModel = masterDataRelationMap.get(payScheCalcModel.getBatchnum());
            }
            this.renderDraftEntry(payScheCalcModel);
        }
    }

    @Override
    public void deleteScheData(List<PayScheCalcModel> scheDataList) {
        List<PayScheCalcModel> payScheCalcModels = this.filterScheData(scheDataList);
        super.deleteScheData(payScheCalcModels);
    }

    private List<PayScheCalcModel> filterScheData(List<PayScheCalcModel> scheDataList) {
        List<Object> afterPaySches = new ArrayList<PayScheCalcModel>(10);
        CardEntry cardEntry = (CardEntry)this.getControl("sumentry");
        int currCardInx = cardEntry.getSelectRows()[0];
        DynamicObject sumEntry = this.getModel().getEntryRowEntity("sumentry", currCardInx);
        Long sumId = sumEntry.getLong("id");
        if (!this.isMegerTab()) {
            afterPaySches = scheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).filter(o -> sumId.compareTo(o.getSummaryId()) == 0).collect(Collectors.toList());
        } else if (this.isMegerTab()) {
            afterPaySches = scheDataList.stream().filter(Objects::nonNull).filter(o -> o.isArchiveMerger()).collect(Collectors.toList());
        }
        return afterPaySches;
    }

    private boolean isMegerTab() {
        Tab tab = (Tab)this.getControl("tabap");
        String tabKey = tab.getCurrentTab();
        return "mergerschetap".equals(tabKey);
    }

    private void clickEntryToRenderInfo(int index) {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        if (entryList.isEmpty()) {
            this.getModel().deleteEntryData("draftinfoentry");
            return;
        }
        Long scheId = ((DynamicObject)entryList.get(index)).getLong("e_id");
        List originCalcModels = this.getPayScheHandler().getAllScheDataList();
        List<Object> scheDataList = new ArrayList(originCalcModels.size());
        scheDataList = this.isMegerTab() ? originCalcModels.stream().filter(PayScheCalcModel::isArchiveMerger).collect(Collectors.toList()) : originCalcModels;
        PayScheCalcModel payScheCalcModel = scheDataList.stream().filter(o -> o.getScheId().compareTo(scheId) == 0).findFirst().orElseGet(() -> null);
        if (!payScheCalcModel.isArchiveMerger() && EmptyUtil.isNoEmpty((String)payScheCalcModel.getBatchnum())) {
            Map<String, PayScheCalcModel> masterDataRelationMap = scheDataList.stream().filter(o -> o.isArchiveMerger()).collect(Collectors.toMap(o -> o.getBatchnum(), o -> o));
            payScheCalcModel = masterDataRelationMap.get(payScheCalcModel.getBatchnum());
        }
        this.renderDraftEntry(payScheCalcModel);
    }

    private void renderDraftEntry(PayScheCalcModel payScheCalcModel) {
        if (payScheCalcModel != null) {
            this.getModel().deleteEntryData("draftinfoentry");
            List payScheDraftInfos = payScheCalcModel.getPayScheDraftInfos();
            if (EmptyUtil.isNoEmpty((Object)payScheDraftInfos)) {
                this.getModel().batchCreateNewEntryRow("draftinfoentry", payScheDraftInfos.size());
                for (int inx = 0; inx < payScheDraftInfos.size(); ++inx) {
                    boolean isMegerPaySche;
                    PayScheDraftInfo payScheDraftInfo = (PayScheDraftInfo)payScheDraftInfos.get(inx);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"de_payscheinfo", (Object)payScheDraftInfo.getPayScheId(), (int)inx);
                    this.getModel().setValue("de_draftinfo", (Object)payScheDraftInfo.getDraftId(), inx);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"de_paycurrency", (Object)payScheDraftInfo.getCurrencyId(), (int)inx);
                    this.getModel().setValue("de_isbilldibs", (Object)payScheDraftInfo.isBillDibs(), inx);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"de_transferamt", (Object)payScheDraftInfo.getTransferAmt(), (int)inx);
                    boolean isEnable = true;
                    boolean isNewGenDraft = payScheDraftInfo.isSplit() && "receivebill".equals(payScheDraftInfo.getRptype()) && EmptyUtil.isNoEmpty((String)payScheDraftInfo.getElcCirculateStatus());
                    boolean bl = isMegerPaySche = !payScheCalcModel.isArchiveMerger() && EmptyUtil.isNotEmpty((CharSequence)payScheDraftInfo.getBatchnum());
                    if (payScheDraftInfo.isBillDibs() || !isNewGenDraft || isMegerPaySche) {
                        isEnable = false;
                    }
                    this.getView().setEnable(Boolean.valueOf(isEnable), inx, new String[]{"de_transferamt"});
                    this.getModel().setValue("de_batchnum", (Object)payScheDraftInfo.getBatchnum(), inx);
                    this.getModel().setValue("de_draftlogid", (Object)payScheDraftInfo.getDraftLogId(), inx);
                    DynamicObject draft = TmcDataServiceHelper.loadSingle((Object)payScheDraftInfo.getDraftId(), (String)"cdm_payandrecdraft_f7");
                    this.getModel().setValue("de_lockedamount", (Object)draft.getBigDecimal("lockedamount"), inx);
                    this.getModel().setValue("de_availableamount", (Object)draft.getBigDecimal("availableamount"), inx);
                    this.getModel().setValue("de_usedamount", (Object)draft.getBigDecimal("usedamount"), inx);
                }
            }
        }
    }

    public static QFilter getArrivalNoQFilter(DynamicObject org, DynamicObject currency, String payeetype, long payeeid, String payeename, BigDecimal payeeamount, String settlementType) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("arrivalstatus", "=", (Object)"arrival_confirm");
        qFilter.and("arrivalway", "!=", (Object)"protest");
        qFilter.and("org", "=", org.getPkValue());
        if (SettleMentTypeEnum.CREDIT.getValue().equals(settlementType)) {
            qFilter.and("isinit", "=", (Object)Character.valueOf('0'));
            qFilter.and("eassrcid", "=", (Object)"");
        }
        qFilter.and("arrivalcurrency", "=", currency.getPkValue());
        logger.info("====PayScheCalcPlugin==getArrivalNoQFilter load data:{}", (Object)qFilter);
        DynamicObjectCollection arrivals = QueryServiceHelper.query((String)META_ARRIVAL, (String)"id,todoamount,lockamount", (QFilter[])new QFilter[]{qFilter});
        List arrivalIds = arrivals.stream().filter(item -> {
            if (item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount")) > 0) {
                if (payeeamount != null) {
                    return item.getBigDecimal("todoamount").compareTo(item.getBigDecimal("lockamount").add(payeeamount)) >= 0;
                }
                return true;
            }
            return false;
        }).map(item -> item.getLong("id")).collect(Collectors.toList());
        qFilter = new QFilter("id", "in", arrivalIds);
        logger.info("====PayScheCalcPlugin==getArrivalNoQFilter new filter:{}", (Object)qFilter);
        return qFilter;
    }

    private boolean existArrival() {
        EntryGrid detailsEntry = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = detailsEntry.getSelectRows();
        for (int i = 0; i < selectRows.length; ++i) {
            String type;
            DynamicObject selectObject = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
            DynamicObject draftSettle = selectObject.getDynamicObject("e_draftsettletype");
            if (draftSettle == null || EmptyUtil.isEmpty((DynamicObject)draftSettle) || !DRAFT_TYPE_ARRIVAL.equals(type = draftSettle.getString(SETTLEMENTTYPE))) continue;
            return true;
        }
        return false;
    }

    public void upload(UploadEvent evt) {
        AttachmentPanel source = (AttachmentPanel)evt.getSource();
        if (ATTACHMENT_PANEL_AP.equals(source.getKey())) {
            List uploadFiles;
            Object[] urls = evt.getUrls();
            List atts = Stream.of(urls).map(u -> (Map)u).collect(Collectors.toList());
            IPageCache pageCache = this.getPageCache();
            String uploadFilesJsonStr = pageCache.get(CACHE_UPLOADS);
            if (StringUtils.isNotBlank((CharSequence)uploadFilesJsonStr)) {
                uploadFiles = (List)JSONObject.parseObject((String)uploadFilesJsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                uploadFiles.addAll(atts);
            } else {
                uploadFiles = atts;
            }
            pageCache.put(CACHE_UPLOADS, JSONObject.toJSONString(uploadFiles));
        }
    }

    public void afterRemove(UploadEvent evt) {
        AttachmentPanel source = (AttachmentPanel)evt.getSource();
        if (ATTACHMENT_PANEL_AP.equals(source.getKey())) {
            Object[] urls = evt.getUrls();
            IPageCache pageCache = this.getPageCache();
            String uploadFilesJsonStr = pageCache.get(CACHE_UPLOADS);
            List uploadList = null;
            if (StringUtils.isNotBlank((CharSequence)uploadFilesJsonStr)) {
                uploadList = (List)JSONObject.parseObject((String)uploadFilesJsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            }
            for (Object url : urls) {
                Map att = (Map)url;
                AttachmentServiceHelper.remove((String)"psd_schebillcalc", (Object)this.getModel().getValue("processorid"), att.get("uid"));
                if (uploadList == null) continue;
                uploadList.removeIf(f -> StringUtils.equals((CharSequence)((String)att.get("url")), (CharSequence)((String)f.get("url"))));
            }
            if (uploadList != null) {
                pageCache.put(CACHE_UPLOADS, JSONObject.toJSONString((Object)uploadList));
            }
        }
    }

    private void uploadAfterSaveOrSubmit() {
        IPageCache pageCache = this.getPageCache();
        String uploadFilesJson = pageCache.get(CACHE_UPLOADS);
        if (StringUtils.isNotBlank((CharSequence)uploadFilesJson)) {
            Object processorId = this.getModel().getValue("processorid");
            List uploadFiles = (List)JSONObject.parseObject((String)uploadFilesJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            for (Map uploadFile : uploadFiles) {
                String realUrl = AttachmentServiceHelper.saveTempToFileService((String)((String)uploadFile.get("url")), (String)"psd", (String)"psd_schebillcalc", (Object)processorId, (String)((String)uploadFile.get("name")));
                uploadFile.put("url", realUrl);
            }
            AttachmentServiceHelper.upload((String)"psd_schebillcalc", (Object)processorId, (String)ATTACHMENT_PANEL_AP, (List)uploadFiles);
            pageCache.remove(CACHE_UPLOADS);
        }
        this.refreshCard(-1);
    }

    private String getInstitUtionCode(DynamicObject account, int index) {
        QFilter filter;
        DynamicObjectCollection query;
        String acctBankType = (String)this.getModel().getValue("e_acctbanktype", index);
        if (EmptyUtil.isNoEmpty((DynamicObject)account) && "bd_accountbanks".equals(acctBankType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"bd_finorginfo", (String)"bank_cate.institutioncode", (QFilter[])(filter = new QFilter("id", "=", (Object)account.getLong("bank.id"))).toArray())))) {
            return ((DynamicObject)query.get(0)).getString("bank_cate.institutioncode");
        }
        return null;
    }

    private String getInstitutionName(DynamicObject account, int index) {
        QFilter filter;
        DynamicObjectCollection query;
        String acctBankType = (String)this.getModel().getValue("e_acctbanktype", index);
        if (EmptyUtil.isNoEmpty((DynamicObject)account) && "bd_accountbanks".equals(acctBankType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"bd_finorginfo", (String)"bank_cate.institutionname", (QFilter[])(filter = new QFilter("id", "=", (Object)account.getLong("bank.id"))).toArray())))) {
            return ((DynamicObject)query.get(0)).getString("bank_cate.institutionname");
        }
        return null;
    }

    private void initSettleType() {
        BasedataEdit settleTypeF7 = (BasedataEdit)this.getControl("e_settletype");
        settleTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter qFilter;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject applySettleType = (DynamicObject)this.getModel().getValue("e_applysettletype", rowIndex);
            if (EmptyUtil.isNoEmpty((DynamicObject)applySettleType) && SettleMentTypeEnum.DIGITALWALLET.getValue().equals(applySettleType.getString(SETTLEMENTTYPE))) {
                qFilter = new QFilter(SETTLEMENTTYPE, "=", (Object)SettleMentTypeEnum.DIGITALWALLET.getValue());
            } else {
                List<String> creditTypes = Arrays.asList(SettleMentTypeEnum.DIGITALWALLET.getValue(), SettleMentTypeEnum.CREDITOPEN.getValue());
                qFilter = new QFilter(SETTLEMENTTYPE, "not in", creditTypes);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private boolean isContainsDcep() {
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryEntity.getSelectRows();
        HashSet<String> settleTypeSet = new HashSet<String>(4);
        for (int selectRow : selectRows) {
            DynamicObject applySettleType = (DynamicObject)this.getModel().getValue("e_applysettletype", selectRow);
            if (!EmptyUtil.isNoEmpty((DynamicObject)applySettleType)) continue;
            settleTypeSet.add(applySettleType.getString(SETTLEMENTTYPE));
        }
        return settleTypeSet.size() > 1 && settleTypeSet.contains(SettleMentTypeEnum.DIGITALWALLET.getValue());
    }
}

