/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.calc;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheSplitHandler;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSplitSumData;
import kd.tmc.psd.formplugin.payscheprocessor.calc.PayScheCalcBasePlugin;
import org.apache.commons.lang3.ObjectUtils;

public class PayScheSplitPlugin
extends PayScheCalcBasePlugin<PayScheSplitSumData> {
    private PayScheSplitHandler handler;

    public String getMainPageId() {
        return this.getView().getParentView().getPageId();
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public Long getOrgId() {
        return this.getProcessorInfo().getOrgId();
    }

    public String getDimType() {
        return this.getProcessorInfo().getDimType();
    }

    public Long getPeriodTypeId() {
        return this.getProcessorInfo().getPeriodTypeId();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PayScheSplitHandler handler = this.getPayScheHandler();
        handler.initSplitData();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String serializeStr = (String)fsp.getCustomParam("key_splitModelData");
        PayScheCalcModel payScheCalcModel = PayScheCalcModel.deserialize((String)serializeStr);
        new DraftBillLockCache(this.getPageId()).fromPrevPage(this.getMainPageId());
        this.initSplitInfo(payScheCalcModel);
    }

    private void initSplitInfo(PayScheCalcModel payScheCalcModel) {
        this.getModel().setValue("billno", (Object)payScheCalcModel.getScheNumber());
        this.getModel().setValue("org", (Object)payScheCalcModel.getOrgId());
        this.getModel().setValue("recname", (Object)payScheCalcModel.getPayeeName());
        this.getModel().setValue("recacctno", (Object)"");
        this.getModel().setValue("recacctbank", (Object)payScheCalcModel.getAcctBankId());
        this.getModel().setValue("applysettletype", (Object)payScheCalcModel.getApplySettlementTypeId());
        this.getModel().setValue("applycurrency", (Object)payScheCalcModel.getApplyCurrencyId());
        this.getModel().setValue("paycurrency", (Object)payScheCalcModel.getCurrencyId());
        this.getModel().setValue("applyamt", (Object)payScheCalcModel.getApplyAmt());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("openquotasplit".equals(operate.getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            BigDecimal splitBalance = (BigDecimal)ObjectUtils.defaultIfNull((Object)dataEntity.getBigDecimal("splitbalance"), (Object)BigDecimal.ZERO);
            if (splitBalance.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c6\u5206\u4f59\u989d\u4e0d\u8db3\uff0c\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ScheSplitPayPlugin_6", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("psd_quotasplit");
            showParameter.setAppId("psd");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "action_quotasplit"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject payCurrency = dataEntity.getDynamicObject("applycurrency");
            if (payCurrency != null) {
                showParameter.setCustomParam("applycurrency", (Object)payCurrency.getLong("id"));
            }
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (opResult != null && opResult.isSuccess()) {
            switch (operateKey) {
                case "addrow": {
                    this.getPayScheHandler().insertSplitData();
                    break;
                }
                case "deleterow": {
                    EntryGrid detailsEntry = (EntryGrid)this.getControl("entryentity");
                    int[] rows = detailsEntry.getSelectRows();
                    ArrayList<Long> scheIdLst = new ArrayList<Long>(rows.length);
                    for (int index : rows) {
                        DynamicObject rowEntryData = this.getModel().getEntryRowEntity("entryentity", index);
                        scheIdLst.add(rowEntryData.getLong("e_id"));
                    }
                    if (EmptyUtil.isEmpty(scheIdLst)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5206\u5f55\u6570\u636e\u3002", (String)"PayScheSplitPlugin_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getPayScheHandler().deleteSplitData(scheIdLst);
                    break;
                }
                case "returndata": {
                    boolean isValid = this.getPayScheHandler().validateSplitInfo();
                    if (!isValid) break;
                    List calcModelLst = this.getPayScheHandler().getAllScheDataList();
                    this.getView().returnDataToParent((Object)PayScheCalcModel.serializeList((List)calcModelLst));
                    DraftBillLockCache cache = new DraftBillLockCache(this.getCurrentPageId());
                    cache.updatePrevPage(this.getMainPageId());
                    this.getView().close();
                }
            }
        }
    }

    public void updateSummaryInfo(List<PayScheSplitSumData> sumDataList, boolean isReplace) {
        PayScheSplitSumData payScheSplitSumData = Optional.ofNullable(sumDataList).map(o -> (PayScheSplitSumData)o.get(0)).orElseGet(() -> null);
        if (null != payScheSplitSumData) {
            this.getModel().setValue("schebalance", (Object)payScheSplitSumData.getBalance());
            this.getModel().setValue("scheamt", (Object)payScheSplitSumData.getScheAmt());
            this.getModel().setValue("billamt", (Object)payScheSplitSumData.getBillAmt());
            this.getModel().setValue("splitbalance", (Object)payScheSplitSumData.getSplitBalance());
        }
        if (isReplace) {
            this.getPayScheHandler().loadScheDataList(Long.valueOf(0L));
        }
    }

    public PayScheProcessorInfo getProcessorInfo() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        String processorInfoStr = (String)sp.getCustomParam("KEY_PROCESSOR_INFO");
        return (PayScheProcessorInfo)JSON.parseObject((String)processorInfoStr, PayScheProcessorInfo.class);
    }

    private PayScheSplitHandler getPayScheHandler() {
        if (this.handler == null) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String serializeStr = (String)fsp.getCustomParam("key_splitModelData");
            this.handler = new PayScheSplitHandler((IPayScheProcessorView)this, PayScheCalcModel.deserialize((String)serializeStr));
        }
        return this.handler;
    }

    @Override
    protected PayScheCalcBaseHandler<PayScheSplitSumData> getHandler() {
        return this.getPayScheHandler();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if ("action_quotasplit".equals(evt.getActionId()) && (returnData = evt.getReturnData()) instanceof BigDecimal) {
            BigDecimal singleLimit = (BigDecimal)returnData;
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            ArrayList<Integer> needUpdateIdxList = new ArrayList<Integer>();
            for (int i = 0; i < entryList.size(); ++i) {
                if (((DynamicObject)entryList.get(i)).getBigDecimal("e_applyamt").compareTo(BigDecimal.ZERO) != 0) continue;
                needUpdateIdxList.add(i);
            }
            BigDecimal splitBanlance = (BigDecimal)this.getModel().getValue("splitbalance");
            BigDecimal[] countAndRemainder = splitBanlance.divideAndRemainder(singleLimit);
            int needUpdateCount = needUpdateIdxList.size();
            int count = countAndRemainder[0].intValue();
            ArrayList<BigDecimal> needInsertAmtList = new ArrayList<BigDecimal>(count);
            for (int i = 0; i < count; ++i) {
                if (i + 1 <= needUpdateCount) {
                    this.getModel().setValue("e_applyamt", (Object)singleLimit, ((Integer)needUpdateIdxList.get(i)).intValue());
                    continue;
                }
                needInsertAmtList.add(singleLimit);
            }
            if (countAndRemainder[1].compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal leftAmt = splitBanlance.subtract(singleLimit.multiply(countAndRemainder[0]));
                if (count + 1 <= needUpdateCount) {
                    this.getModel().setValue("e_applyamt", (Object)leftAmt, ((Integer)needUpdateIdxList.get(count)).intValue());
                } else {
                    needInsertAmtList.add(leftAmt);
                }
            }
            this.getPayScheHandler().batchInsertSplitData(needInsertAmtList);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b9a\u989d\u62c6\u5206\u6210\u529f\u3002", (String)"ScheSplitPayPlugin_7", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
    }
}

