/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.common.helper;

import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class BotpHelper {
    public static void showTrackParameter(List<Tuple<String, List<Long>>> billTuple, IFormView iFormView) {
        if (CollectionUtils.isEmpty(billTuple)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"TmcBotpHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        for (Tuple<String, List<Long>> tuple : billTuple) {
            BillShowParameter showParameter;
            String entityNumber = (String)tuple.item1;
            List billIds = (List)tuple.item2;
            if (billIds.size() == 1) {
                showParameter = BotpHelper.createBillShowParameter(entityNumber, (Long)billIds.get(0));
                if (showParameter == null) continue;
                iFormView.showForm((FormShowParameter)showParameter);
                continue;
            }
            showParameter = BotpHelper.createShowParameter(entityNumber, new HashSet<Long>(billIds));
            if (showParameter == null) continue;
            iFormView.showForm((FormShowParameter)showParameter);
        }
    }

    private static BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("isFromTrack", "true");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        showParameter.setStatusValue(OperationStatus.VIEW.getValue());
        showParameter.setHasRight(true);
        return showParameter;
    }

    private static ListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds) {
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", (Object)billIds.iterator().next()) : new QFilter("id", "in", (Object)billIds.toArray(new Long[billIds.size()]));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId(entityNumber);
        showParameter.setIsolationOrg(false);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        showParameter.setHasRight(true);
        return showParameter;
    }
}

