/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.tmc.psd.common.model.PsdCashBalanceDetailsModel;

public class PsdCashBalanceSummaryModel
implements Serializable {
    private static final long serialVersionUID = 6904507927398452331L;
    private Map<Long, List<PsdCashBalanceDetailsModel>> summary = null;

    public PsdCashBalanceSummaryModel updateExpectValue(Long currencyId, String uuid, BigDecimal value) {
        List<PsdCashBalanceDetailsModel> detailLst = this.summary.get(currencyId);
        if (null == detailLst || detailLst.isEmpty()) {
            return this;
        }
        for (PsdCashBalanceDetailsModel detail : detailLst) {
            if (!uuid.equalsIgnoreCase(detail.getUuid())) continue;
            detail.setCurrentExpectCollect(value);
            detail.setBalance(BigDecimal.ZERO.add(detail.getInitialInventoryAmount()).add(detail.getCurrentExpectCollect()).add(detail.getPlanFinanceinFlow()).subtract(detail.getCurrentPaymentAmount()).subtract(detail.getLimitAmt()).subtract(detail.getIntransitAmt()).subtract(detail.getLimitAmtFund()));
        }
        return this;
    }

    public PsdCashBalanceSummaryModel updatePlanFinanceinFlow(Long currencyId, String uuid, BigDecimal value) {
        List<PsdCashBalanceDetailsModel> detailLst = this.summary.get(currencyId);
        if (null == detailLst || detailLst.isEmpty()) {
            return this;
        }
        for (PsdCashBalanceDetailsModel detail : detailLst) {
            if (!uuid.equalsIgnoreCase(detail.getUuid())) continue;
            detail.setPlanFinanceinFlow(value);
            detail.setBalance(BigDecimal.ZERO.add(detail.getInitialInventoryAmount()).add(detail.getCurrentExpectCollect()).add(detail.getPlanFinanceinFlow()).subtract(detail.getCurrentPaymentAmount()).subtract(detail.getLimitAmt()).subtract(detail.getIntransitAmt()).subtract(detail.getLimitAmtFund()));
        }
        return this;
    }

    public Map<Long, List<PsdCashBalanceDetailsModel>> getSummary() {
        return this.summary;
    }

    public void setSummary(Map<Long, List<PsdCashBalanceDetailsModel>> summary) {
        this.summary = summary;
    }
}

