/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.dtx.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.dtx.model.PayScheChargeBackDtxModel;
import kd.tmc.psd.business.dtx.model.ReleaseReceiveBillModel;
import kd.tmc.psd.business.dtx.param.PayScheChargeBackDtxParam;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleHelper;
import kd.tmc.psd.business.service.paysche.rpc.bean.ChargeBackInfo;
import kd.tmc.psd.business.service.paysche.rpc.bean.PayRpcResult;
import kd.tmc.psd.business.service.paysche.rpc.bean.RpcStatus;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheBillChargeBackDtxService
extends EventualConsistencyService {
    private static final Log logger = LogFactory.getLog(PayScheBillChargeBackDtxService.class);

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        PayScheChargeBackDtxParam p = (PayScheChargeBackDtxParam)param;
        List<Object> ids = p.getIds();
        Map<Long, List<Long>> entryMap = p.getEntryMap();
        List<DraftLockInfo> draftAmountLockInfos = p.getDraftAmountLockInfos();
        Map<Object, String> sameBatchNumBillMap = p.getSameBatchNumBillMap();
        Map<Long, PayScheChargeBackDtxModel> backUpMap = p.getBackUpMap();
        List<JSONObject> releaseReceiveBills = p.getReleaseReceiveBills();
        List<JSONObject> callbackReceiveBills = p.getCallbackReceiveBills();
        DynamicObject[] payScheBills = TmcDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        String opBizName = "chargeBack";
        if (p.getChargeBackDelType().equals("delete")) {
            opBizName = "deletePayBill";
        }
        List infos = Arrays.stream(payScheBills).map(bill -> {
            ChargeBackInfo backInfo = PayScheHelper.createChargeBackInfo(bill);
            backInfo.setBackReason(p.getBackReason());
            return backInfo;
        }).collect(Collectors.toList());
        logger.info("\u6267\u884c\u9000\u5355\u5fae\u670d\u52a1 chargeBack \u8c03\u7528\uff0c\u8bf7\u6c42\u62a5\u6587:{}", (Object)LoggerPrintHelper.printObjectLoggerByToString(infos));
        String invokeResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"payScheService", (String)opBizName, (Object[])new Object[]{JSON.toJSONString(infos)});
        PayRpcResult rpcResult = (PayRpcResult)JSON.parseObject((String)invokeResult, PayRpcResult.class);
        logger.info("\u6267\u884c\u9000\u5355\u5fae\u670d\u52a1 chargeBack \u8c03\u7528\uff0c\u54cd\u5e94\u62a5\u6587:{}", (Object)LoggerPrintHelper.printObjectLoggerByToString((Object[])new PayRpcResult[]{rpcResult}));
        if (RpcStatus.SUCCESS == rpcResult.getStatus()) {
            if (p.getChargeBackDelType().equals("delete")) {
                for (DynamicObject data : payScheBills) {
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                    entrys.clear();
                }
            }
            if (p.getChargeBackDelType().equals("chargeBack")) {
                for (DynamicObject data : payScheBills) {
                    boolean isDiffSplit = data.getBoolean("issplit");
                    boolean isSplit = Optional.ofNullable(data.getString("splitno")).map(o -> EmptyUtil.isNoEmpty((String)o)).orElseGet(() -> false);
                    boolean isTransNext = Optional.ofNullable(data.getString("nextscheduleid")).map(o -> EmptyUtil.isNoEmpty((String)o)).orElseGet(() -> false);
                    if (!isDiffSplit && !isSplit && !isTransNext) continue;
                    DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        if (!entry.getString("e_billtype").equals("schebill")) continue;
                        entry.set("e_payid", null);
                    }
                }
            }
            PayScheduleHelper.getInstance().deletePaySchePayBillEntry(payScheBills, rpcResult);
            ArrayList<DraftLockInfo> backDraftLockInfoLst = new ArrayList<DraftLockInfo>(draftAmountLockInfos.size());
            backDraftLockInfoLst.addAll(draftAmountLockInfos);
            this.releaseDraft(payScheBills, draftAmountLockInfos, entryMap, backUpMap, sameBatchNumBillMap);
            ReleaseReceiveBillModel rrb = new ReleaseReceiveBillModel();
            rrb.setDataEntities(payScheBills);
            rrb.setDraftLockInfoLst(backDraftLockInfoLst);
            rrb.setEntryMap(entryMap);
            rrb.setBackUpMap(backUpMap);
            rrb.setSameBatchNumBillMap(sameBatchNumBillMap);
            rrb.setReleaseReceiveBills(releaseReceiveBills);
            rrb.setCallbackReceiveBills(callbackReceiveBills);
            this.releaseReceiveBill(rrb);
            SaveServiceHelper.save((DynamicObject[])payScheBills);
        } else {
            this.rollbackBillOriginalState(payScheBills, entryMap, backUpMap, sameBatchNumBillMap);
        }
        if (RpcStatus.SUCCESS != rpcResult.getStatus()) {
            throw new KDBizException(rpcResult.getErrMsg());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDraft(DynamicObject[] dataEntities, List<DraftLockInfo> draftLockInfoLst, Map<Long, List<Long>> entryMap, Map<Long, PayScheChargeBackDtxModel> backUpMap, Map<Object, String> sameBatchNumBillMap) {
        ArrayList<LockResult> successResults = new ArrayList<LockResult>();
        ArrayList<LockResult> failureResults = new ArrayList<LockResult>();
        try {
            logger.info("\u7968\u636e\u91ca\u653e:{}", (Object)LoggerPrintHelper.printObjectLoggerByToString(draftLockInfoLst));
            if (draftLockInfoLst.size() > 0) {
                DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper(false);
                List<LockResult> lockResults = draftLockServiceHelper.releaseOrLockDraft(draftLockInfoLst);
                for (LockResult result : lockResults) {
                    boolean success = result.isSuccess();
                    if (success) {
                        successResults.add(result);
                        continue;
                    }
                    failureResults.add(result);
                }
            }
            if (failureResults != null && !failureResults.isEmpty()) {
                Set failureIds = failureResults.stream().map(LockResult::getSourceBillId).collect(Collectors.toSet());
                List<DynamicObject> rollbackdatas = Arrays.stream(dataEntities).filter(o -> failureIds.contains(o.getPkValue())).collect(Collectors.toList());
                this.rollbackBillOriginalState(rollbackdatas.toArray(new DynamicObject[0]), entryMap, backUpMap, sameBatchNumBillMap);
            }
        }
        catch (Exception e) {
            this.rollbackBillOriginalState(dataEntities, entryMap, backUpMap, sameBatchNumBillMap);
            try {
                if (successResults != null && !successResults.isEmpty()) {
                    Set billIds = successResults.stream().map(LockResult::getSourceBillId).collect(Collectors.toSet());
                    List<DraftLockInfo> rollBackBills = draftLockInfoLst.stream().filter(o -> billIds.contains(o.getSourceBillId())).collect(Collectors.toList());
                    DraftAmountLockInfo.changeDraftOpMode(rollBackBills, true);
                    DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper(false);
                    List<LockResult> lockResults = draftLockServiceHelper.releaseOrLockDraft(rollBackBills);
                    Map<Object, List<DynamicObject>> waitDealScheMap = Arrays.stream(dataEntities).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getPkValue()));
                    List successLockResults = lockResults.stream().filter(LockResult::isSuccess).collect(Collectors.toList());
                    for (LockResult successResult : successLockResults) {
                        Long sourceBillId = successResult.getSourceBillId();
                        DynamicObject waitDealSche = waitDealScheMap.get(sourceBillId).get(0);
                        Map<Long, Long> billIdLogIdMap = successResult.getBillIdLogIdMap();
                        DynamicObjectCollection draftInfoEntry = waitDealSche.getDynamicObjectCollection("draftinfoentry");
                        for (DynamicObject draftInfo : draftInfoEntry) {
                            long draftId = PayScheHelper.getDraftId(draftInfo);
                            Long draftLogId = billIdLogIdMap.get(draftId);
                            if (!EmptyUtil.isNoEmpty((Long)draftLogId)) continue;
                            draftInfo.set("de_draftlogid", (Object)draftLogId);
                        }
                    }
                }
            }
            catch (Exception e1) {
                logger.error(e1.getMessage());
            }
        }
        finally {
            draftLockInfoLst.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReceiveBill(ReleaseReceiveBillModel rrb) {
        DynamicObject[] dataEntities = rrb.getDataEntities();
        List<JSONObject> releaseReceiveBills = rrb.getReleaseReceiveBills();
        Map<Long, List<Long>> entryMap = rrb.getEntryMap();
        Map<Long, PayScheChargeBackDtxModel> backUpMap = rrb.getBackUpMap();
        Map<Object, String> sameBatchNumBillMap = rrb.getSameBatchNumBillMap();
        List<JSONObject> callbackReceiveBills = rrb.getCallbackReceiveBills();
        try {
            logger.info("PayScheBillChargeBackDtxService:Release the receiving information:{}", (Object)releaseReceiveBills.toString());
            PayScheHelper.releaseReceiveBills(releaseReceiveBills);
        }
        catch (Exception e) {
            this.rollbackBillOriginalState(dataEntities, entryMap, backUpMap, sameBatchNumBillMap);
            try {
                List<DraftLockInfo> draftLockInfoLst = rrb.getDraftLockInfoLst();
                if (EmptyUtil.isNoEmpty(draftLockInfoLst)) {
                    DraftAmountLockInfo.changeDraftOpMode(draftLockInfoLst, true);
                    DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper(false);
                    List<LockResult> lockResults = draftLockServiceHelper.releaseOrLockDraft(draftLockInfoLst);
                    Map<Object, List<DynamicObject>> waitDealScheMap = Arrays.stream(dataEntities).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getPkValue()));
                    List successLockResults = lockResults.stream().filter(LockResult::isSuccess).collect(Collectors.toList());
                    for (LockResult successResult : successLockResults) {
                        Long sourceBillId = successResult.getSourceBillId();
                        DynamicObject waitDealSche = waitDealScheMap.get(sourceBillId).get(0);
                        Map<Long, Long> billIdLogIdMap = successResult.getBillIdLogIdMap();
                        DynamicObjectCollection draftInfoEntry = waitDealSche.getDynamicObjectCollection("draftinfoentry");
                        for (DynamicObject draftInfo : draftInfoEntry) {
                            long draftId = PayScheHelper.getDraftId(draftInfo);
                            Long draftLogId = billIdLogIdMap.get(draftId);
                            if (!EmptyUtil.isNoEmpty((Long)draftLogId)) continue;
                            draftInfo.set("de_draftlogid", (Object)draftLogId);
                        }
                    }
                }
            }
            catch (Exception e1) {
                logger.error(e1.getMessage());
            }
            logger.info("PayScheBillChargeBackDtxService:Lock the receiving information:{}", (Object)callbackReceiveBills.toString());
            PayScheHelper.lockReceiveBills(callbackReceiveBills);
            logger.error("release receive bills error:", (Throwable)e);
        }
        finally {
            releaseReceiveBills.clear();
            callbackReceiveBills.clear();
        }
    }

    private void rollbackBillOriginalState(DynamicObject[] dataEntities, Map<Long, List<Long>> entryMap, Map<Long, PayScheChargeBackDtxModel> backUpMap, Map<Object, String> sameBatchNumBillMap) {
        DynamicObject[] sameBatchNumBills;
        ArrayList<DynamicObject> waitSaveBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            PayScheChargeBackDtxModel model = backUpMap.get(data.getLong("id"));
            data.set("schedulstatus", (Object)model.getSchedulStatus());
            data.set("draftno", model.getDraftNo());
            data.set("batchnum", model.getBatchNum());
            data.set("amount", model.getAmount());
            data.set("draftamt", model.getDraftAmt());
            data.set("balanceamt", model.getBalanceAmt());
            data.set("waitpayamt", model.getWaitPayAmt());
            for (DynamicObject entry : entrys) {
                List<Long> oldEntryData = entryMap.get(entry.getLong("id"));
                entry.set("e_payid", (Object)oldEntryData.get(0));
                entry.set("e_payentryid", (Object)oldEntryData.get(1));
            }
        }
        List ids = sameBatchNumBillMap.entrySet().stream().map(o -> o.getKey()).collect(Collectors.toList());
        for (DynamicObject sameBatchBill : sameBatchNumBills = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"))) {
            String batchNum = sameBatchNumBillMap.get(sameBatchBill.getPkValue());
            sameBatchBill.set("batchnum", (Object)batchNum);
            waitSaveBills.add(sameBatchBill);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])waitSaveBills.toArray(new DynamicObject[waitSaveBills.size()]));
        backUpMap.clear();
        entryMap.clear();
    }
}

