/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class PaySchBillChangeDateDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entryentity");
        selector.add("entryentity.schbillid");
        selector.add("entryentity.schedulstatus");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        List schBillIdList = Stream.of(dataEntities).map(i -> i.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(i -> i.getLong("schbillid")).collect(Collectors.toList());
        DynamicObject[] schBillDataArr = TmcDataServiceHelper.load((Object[])schBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        for (DynamicObject data : dataEntities) {
            Object pkValue = data.getPkValue();
            String changeDateBillNo = data.getString("billno");
            DynamicObjectCollection entryDataColl = data.getDynamicObjectCollection("entryentity");
            List currSchBillIdList = entryDataColl.stream().map(i -> i.getLong("schbillid")).collect(Collectors.toList());
            List<DynamicObject> currDbSchBillData = Arrays.stream(schBillDataArr).filter(i -> currSchBillIdList.contains(i.getPkValue())).collect(Collectors.toList());
            currDbSchBillData.forEach(i -> {
                DynamicObject entryData = entryDataColl.stream().filter(j -> i.getPkValue().equals(j.getLong("schbillid"))).findFirst().get();
                i.set("schedulstatus", entryData.get("schedulstatus"));
                String changeDataRecordNo = i.getString("changedaterecordno");
                String changeDataRecordId = i.getString("changedaterecordid");
                ArrayList<String> changeDataRecordNoList = new ArrayList<String>(Arrays.asList(changeDataRecordNo.split(",")));
                ArrayList<String> changeDataRecordIdList = new ArrayList<String>(Arrays.asList(changeDataRecordId.split(",")));
                changeDataRecordNoList.remove(changeDateBillNo);
                changeDataRecordIdList.remove(pkValue.toString());
                i.set("changedaterecordid", (Object)String.join((CharSequence)",", changeDataRecordIdList));
                i.set("changedaterecordno", (Object)String.join((CharSequence)",", changeDataRecordNoList));
                if (changeDataRecordNoList.size() == 0) {
                    i.set("isexistchangedate", (Object)"0");
                }
            });
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])schBillDataArr, (OperateOption)OperateOption.create());
    }
}

