/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockInfo;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.business.utils.CombineUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.untils.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PayScheBillAfreshScheService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(PayScheBillAfreshScheService.class);
    private List<DynamicObject> newAfreshSche = new ArrayList<DynamicObject>(10);
    private String status = "";
    private Boolean isChargeBack = false;
    private List<OperateErrorInfo> failureMsgs = new ArrayList<OperateErrorInfo>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("draftinfoentry");
        selector.add("ismasterdata");
        selector.add(String.format("%s.%s", "draftinfoentry", "de_transferamt"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftinfo"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftlogid"));
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set<Object> queryIds = Arrays.stream(dataEntities).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set<DynamicObject> data = this.getData(queryIds);
        ArrayList<Object> ids = new ArrayList<Object>(data.size());
        HashMap batchBillIds = new HashMap();
        data.stream().forEach(dynamicObject -> {
            Long id = dynamicObject.getLong("id");
            String batchNum = dynamicObject.getString("batchnum");
            if (StringUtils.isNotEmpty((String)batchNum)) {
                ArrayList<Long> billIds = (ArrayList<Long>)batchBillIds.get(batchNum);
                if (billIds == null) {
                    billIds = new ArrayList<Long>(10);
                    batchBillIds.put(batchNum, billIds);
                }
                billIds.add(id);
            }
        });
        HashMap<Long, String> billIdsBatch = new HashMap<Long, String>(10);
        for (List idList : batchBillIds.values()) {
            String batchNum = CombineUtil.generateCombineNum(RequestContext.get().getOrgId());
            idList.stream().forEach(id -> billIdsBatch.put((Long)id, batchNum));
        }
        for (DynamicObject dataEntity : data) {
            DynamicObject clonePaySche = TmcDataServiceHelper.clone((DynamicObject)dataEntity);
            this.assignmentNewValue(clonePaySche, dataEntity, billIdsBatch);
            this.newAfreshSche.add(clonePaySche);
            dataEntity.set("schedulstatus", (Object)ScheStatusEnum.AFRESHSCHE.getValue());
            dataEntity.set("paymentno", null);
            ids.add(dataEntity.getPkValue());
        }
        LOGGER.info("\u901a\u8fc7\u91cd\u65b0\u6392\u7a0b\u6821\u9a8c\u7684\u6392\u7a0b\u5355ID\u4e3a\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(ids));
        data.addAll(this.newAfreshSche);
        SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        Set<Long> pkIds;
        super.afterProcess(dataEntities);
        List<DraftLockInfo> draftAmountLockInfos = new ArrayList<DraftLockInfo>(10);
        HashMap batchSourceBillIds = new HashMap(10);
        Set<Object> queryIds = Arrays.stream(dataEntities).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set<DynamicObject> data = this.getData(queryIds);
        data.stream().forEach(dynamicObject -> {
            Long sourceBillId = dynamicObject.getLong("id");
            String batchNum = dynamicObject.getString("batchnum");
            QFilter qFilter = new QFilter("locksourcebillid", "=", (Object)sourceBillId.toString()).and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill"));
            boolean isExitsDraft = QueryServiceHelper.exists((String)"cdm_draftbillf7", (QFilter[])new QFilter[]{qFilter});
            if (StringUtils.isNotEmpty((String)batchNum) && isExitsDraft) {
                batchSourceBillIds.put(batchNum, sourceBillId);
            }
        });
        if (batchSourceBillIds.size() > 0) {
            LOGGER.info("\u5408\u5e76\u4e0b\u6279\u6b21\u53f7\u5bf9\u5e94\u7684\u6e90\u5355ID\u4fe1\u606f:{}", batchSourceBillIds);
        }
        HashSet<String> dealBatchNumPayScheIds = new HashSet<String>(dataEntities.length);
        for (DynamicObject dataEntity2 : dataEntities) {
            String batchNum = dataEntity2.getString("batchnum");
            if (EmptyUtil.isNoEmpty((String)batchNum)) {
                if (!dealBatchNumPayScheIds.add(batchNum)) continue;
                boolean isMasterData = dataEntity2.getBoolean("ismasterdata");
                if (isMasterData) {
                    draftAmountLockInfos.add(this.buildDraftAmountLockInfo(dataEntity2));
                    continue;
                }
                DynamicObject masterPaySche = BusinessDataServiceHelper.loadSingle((String)"psd_schedulebill", (QFilter[])new QFilter[]{new QFilter("batchnum", "=", (Object)batchNum), new QFilter("ismasterdata", "=", (Object)"1")});
                draftAmountLockInfos.add(this.buildDraftAmountLockInfo(masterPaySche));
                continue;
            }
            draftAmountLockInfos.add(this.buildDraftAmountLockInfo(dataEntity2));
        }
        HashSet receiveIds = new HashSet(dataEntities.length);
        ArrayList<JSONObject> releaseReceiveBills = new ArrayList<JSONObject>(dataEntities.length);
        ArrayList<JSONObject> callbackReceiveBills = new ArrayList<JSONObject>(dataEntities.length);
        data.stream().forEach(dataEntity -> {
            DynamicObject receiveBill = (DynamicObject)dataEntity.get("dibsbalance");
            Boolean isBillBids = dataEntity.getBoolean("isbilldibs");
            if (isBillBids.booleanValue() && EmptyUtil.isNoEmpty((DynamicObject)receiveBill) && !receiveIds.contains(receiveBill.getLong("id"))) {
                Long receiveId = receiveBill.getLong("id");
                JSONObject object = new JSONObject();
                object.put("receiveBillId", receiveBill.get("id"));
                object.put("isUsed", (Object)false);
                String batchNum = dataEntity.getString("batchnum");
                if (StringUtils.isNotEmpty((String)batchNum)) {
                    object.put("batchNum", (Object)batchNum);
                } else {
                    object.put("usesourcebill", (Object)dataEntity.getLong("id"));
                }
                releaseReceiveBills.add(object);
                JSONObject rollback = new JSONObject();
                rollback.put("receiveBillId", receiveBill.get("id"));
                rollback.put("isUsed", (Object)true);
                if (StringUtils.isNotEmpty((String)batchNum)) {
                    rollback.put("batchNum", (Object)batchNum);
                } else {
                    rollback.put("usesourcebill", (Object)dataEntity.getLong("id"));
                }
                callbackReceiveBills.add(rollback);
                receiveIds.add(receiveId);
            }
        });
        List<Object> lockResults = new ArrayList(8);
        boolean flag = true;
        try {
            DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
            lockResults = draftLockServiceHelper.releaseOrLockDraft(draftAmountLockInfos);
            if (lockResults != null && !lockResults.isEmpty()) {
                Set successBillIds = lockResults.stream().filter(LockResult::isSuccess).map(o -> o.getSourceBillId()).collect(Collectors.toSet());
                Arrays.stream(dataEntities).filter(o -> !successBillIds.contains(o.getPkValue())).forEach(dataEntity -> dataEntity.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue()));
                SaveServiceHelper.save((DynamicObject[])dataEntities);
            }
        }
        catch (Exception e) {
            pkIds = this.newAfreshSche.stream().filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"), (Object[])pkIds.toArray(new Long[0]));
            Arrays.stream(dataEntities).filter(Objects::nonNull).forEach(dataEntity -> dataEntity.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue()));
            SaveServiceHelper.save((DynamicObject[])dataEntities);
            LOGGER.info("\u7968\u636e\u91ca\u653e\u64cd\u4f5c\u6d41\u7a0b\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            this.createFailureMsg(dataEntities);
            flag = false;
        }
        if (flag) {
            try {
                LOGGER.info("PayScheBillAfreshScheService:Release the receiving information::{}", (Object)((Object)releaseReceiveBills).toString());
                PayScheHelper.releaseReceiveBills(releaseReceiveBills);
            }
            catch (Exception e) {
                pkIds = this.newAfreshSche.stream().filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toSet());
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"), (Object[])pkIds.toArray(new Long[0]));
                Arrays.stream(dataEntities).filter(Objects::nonNull).forEach(dataEntity -> dataEntity.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue()));
                SaveServiceHelper.save((DynamicObject[])dataEntities);
                if (lockResults != null && !lockResults.isEmpty()) {
                    Set successBillIds = lockResults.stream().filter(LockResult::isSuccess).map(o -> o.getSourceBillId()).collect(Collectors.toSet());
                    draftAmountLockInfos = draftAmountLockInfos.stream().filter(o -> successBillIds.contains(o.getSourceBillId())).collect(Collectors.toList());
                    DraftAmountLockInfo.changeDraftOpMode(draftAmountLockInfos, true);
                    DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
                    draftLockServiceHelper.releaseOrLockDraft(draftAmountLockInfos);
                }
                LOGGER.info("PayScheBillAfreshScheService:Lock the receiving information::{}", (Object)((Object)callbackReceiveBills).toString());
                PayScheHelper.lockReceiveBills(callbackReceiveBills);
                LOGGER.info("\u51fa\u7eb3\u6536\u6b3e\u5355\u76f8\u5173\u6d41\u7a0b\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
            finally {
                releaseReceiveBills.clear();
                callbackReceiveBills.clear();
            }
        }
    }

    private void createFailureMsg(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            Object pkValue = dataEntity.getPkValue();
            String billSign = dataEntity.getDynamicObjectType().getName();
            String billNo = dataEntity.getString("billno");
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, pkValue, (Object)billSign);
            operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u6392\u7a0b\u5355\u7968\u636e\u91ca\u653e\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u7968\u636e\u7ba1\u7406\u9501\u7968\u65e5\u5fd7\u4fe1\u606f", (String)"PayScheBillPayService_4", (String)"tmc-psd-business", (Object[])new Object[0]), billNo));
            this.failureMsgs.add(operateErrorInfo);
        }
    }

    private Set<DynamicObject> getData(Set<Object> queryIds) {
        LOGGER.info("\u9009\u62e9\u7684ID\uff1a{}", queryIds);
        DynamicObject[] dataEntities = BusinessDataServiceHelper.load((Object[])queryIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        HashSet<DynamicObject> data = new HashSet<DynamicObject>(10);
        for (DynamicObject dataEntitie : dataEntities) {
            data.add(dataEntitie);
        }
        HashSet<String> batchNumbers = new HashSet<String>(10);
        for (DynamicObject dataEntity : dataEntities) {
            String payBillType = dataEntity.getString(String.join((CharSequence)".", "draftsettletype", "settlementtype"));
            if (!SettleMentTypeEnum.CHECK.getValue().equals(payBillType) && !SettleMentTypeEnum.BUSINESS.getValue().equals(payBillType) && !SettleMentTypeEnum.BANK.getValue().equals(payBillType) && !SettleMentTypeEnum.CREDIT.getValue().equals(payBillType)) continue;
            String batchNum = dataEntity.getString("batchnum");
            LOGGER.info("\u6392\u7968\u91cd\u65b0\u6392\u7a0b\uff0c\u6279\u6b21\u53f7:{}", (Object)batchNum);
            DynamicObjectCollection draftnoList = dataEntity.getDynamicObjectCollection("draftno");
            if (!StringUtils.isNotEmpty((String)batchNum) || draftnoList == null || draftnoList.size() <= 0) continue;
            batchNumbers.add(batchNum);
        }
        if (batchNumbers.size() == 0) {
            return data;
        }
        LOGGER.info("\u5b58\u5728\u6392\u7968\u91cd\u65b0\u6392\u7a0b\u7684\u6279\u6b21\u53f7\u662f\uff1a{}", batchNumbers);
        DynamicObjectCollection entries = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNumbers).and(new QFilter("id", "not in", queryIds))});
        if (entries.size() == 0) {
            return data;
        }
        Set<Long> entryIds = entries.stream().filter(Objects::nonNull).filter(o -> !queryIds.contains(o)).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (entryIds.size() == 0) {
            return data;
        }
        LOGGER.info("\u5b58\u5728\u6392\u7968\u91cd\u65b0\u6392\u7a0b\u4e14\u62e5\u6709\u76f8\u540c\u6279\u6b21\u53f7\u7684ID\uff1a{}", entryIds);
        dataEntities = BusinessDataServiceHelper.load((Object[])entryIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        if (dataEntities.length == 0) {
            return data;
        }
        for (DynamicObject dataEntity : dataEntities) {
            data.add(dataEntity);
        }
        return data;
    }

    private void assignmentNewValue(DynamicObject clonePaySche, DynamicObject sourcePaySche, Map<Long, String> billIdsBatch) {
        DynamicObject applysettletype;
        Long pkId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias());
        clonePaySche.set("id", (Object)pkId);
        clonePaySche.set("schedulstatus", (Object)ScheStatusEnum.SCHEDULING.getValue());
        clonePaySche.set("schedealid", null);
        clonePaySche.set("prescheduleid", (Object)sourcePaySche.getLong("prescheduleid"));
        clonePaySche.set("sourcescheduleid", sourcePaySche.getPkValue());
        clonePaySche.set("modifytime", (Object)DateUtils.getCurrentDate());
        clonePaySche.set("auditdate", (Object)sourcePaySche.getDate("auditdate"));
        clonePaySche.set("billno", (Object)CodeRuleHelper.generateNumber((String)"psd_schedulebill", (DynamicObject)clonePaySche, (String)String.valueOf(clonePaySche.getDynamicObject("company").getPkValue()), (String)""));
        clonePaySche.set("creator", (Object)RequestContext.get().getUserId());
        clonePaySche.set("modifier", (Object)RequestContext.get().getUserId());
        clonePaySche.set("draftno", null);
        clonePaySche.set("amount", (Object)BigDecimal.ZERO);
        clonePaySche.set("paymentchannel", null);
        clonePaySche.set("draftamt", (Object)BigDecimal.ZERO);
        clonePaySche.set("limitbank", null);
        clonePaySche.set("iscasexitbill", (Object)"0");
        clonePaySche.set("backreason", null);
        clonePaySche.set("isbilldibs", (Object)false);
        clonePaySche.set("balance", (Object)BigDecimal.ZERO);
        clonePaySche.set("dibsbalance", null);
        clonePaySche.set("payerrmsg", null);
        String batchNum = billIdsBatch.get(sourcePaySche.getLong("id"));
        BigDecimal draftAmount = sourcePaySche.getBigDecimal("draftamt");
        DynamicObjectCollection draftNoList = sourcePaySche.getDynamicObjectCollection("draftno");
        if (CollectionUtils.isNotEmpty((Collection)draftNoList) && StringUtils.isNotEmpty((String)batchNum) && draftAmount != null && BigDecimal.ZERO.compareTo(draftAmount) != 0) {
            clonePaySche.set("batchnum", (Object)batchNum);
        } else {
            clonePaySche.set("batchnum", null);
            clonePaySche.set("ismasterdata", null);
        }
        if (this.isChargeBack.booleanValue()) {
            clonePaySche.set("ismasterdata", null);
            clonePaySche.set("isbilldibs", (Object)false);
            clonePaySche.set("dibsbalance", null);
            clonePaySche.set("batchnum", null);
            clonePaySche.set("draftpayacct", null);
            clonePaySche.set("schedulstatus", (Object)this.status);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(applysettletype = sourcePaySche.getDynamicObject("applysettletype")))) {
            String settlementtype = applysettletype.getString("settlementtype");
            List<String> draftTypeList = Arrays.asList("2", "5", "6", "7");
            if (draftTypeList.contains(settlementtype)) {
                clonePaySche.set("draftsettletype", (Object)applysettletype);
                clonePaySche.set("settletype", null);
            } else {
                clonePaySche.set("settletype", (Object)applysettletype);
                clonePaySche.set("draftsettletype", null);
            }
            if ("0".equals(applysettletype.getString("settlementtype"))) {
                clonePaySche.set("acctbanktype", (Object)"cas_accountcash");
            } else {
                clonePaySche.set("acctbanktype", (Object)"bd_accountbanks");
                clonePaySche.set("acctbank", (Object)sourcePaySche.getDynamicObject("applyacctbank"));
            }
        }
        clonePaySche.set("draftpaymethod", (Object)"draftpay");
        clonePaySche.set("paymentchannel", sourcePaySche.get("applypaychannel"));
        clonePaySche.set("draftpaychannel", sourcePaySche.get("applypaychannel"));
        sourcePaySche.set("draftno", null);
        clonePaySche.getDynamicObjectCollection("draftinfoentry").clear();
        LOGGER.info("\u8fdb\u884c\u91cd\u65b0\u6392\u7a0b\u7684\u5355\u4e3a\uff1a{}\uff0c\n\u91cd\u65b0\u6392\u7a0b\u4ea7\u751f\u7684\u65b0\u5355\u4e3a\uff1a{}", sourcePaySche.getPkValue(), clonePaySche.getPkValue());
    }

    public DraftLockInfo buildDraftAmountLockInfo(DynamicObject payScheBill) {
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillId(payScheBill.getLong("id"));
        draftLockInfo.setSourceBillType(payScheBill.getDataEntityType().getName());
        draftLockInfo.setBizBillNo(payScheBill.getString("billno"));
        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(3);
        String draftPayMethod = payScheBill.getString("draftpaymethod");
        boolean isDraftBook = "draftbook".equals(draftPayMethod);
        Object draftCol = payScheBill.getDynamicObjectCollection("draftinfoentry");
        boolean isOld = false;
        if (EmptyUtil.isEmpty((Collection)draftCol)) {
            DynamicObjectCollection draftnos = payScheBill.getDynamicObjectCollection("draftno");
            List draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftnoIds)});
            draftCol = new ArrayList(draftArr);
            isOld = true;
        }
        for (DynamicObject draftInfo : draftCol) {
            DraftAmountLockSubInfo releaseLockInfo = PayScheHelper.getReleaseLockInfo(payScheBill, isDraftBook, false, draftInfo, isOld);
            draftAmountLockSubInfoList.add(releaseLockInfo);
        }
        draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
        return draftLockInfo;
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.failureMsgs != null && !this.failureMsgs.isEmpty()) {
            for (OperateErrorInfo failureMsg : this.failureMsgs) {
                e.addErrorInfo(failureMsg);
            }
        }
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setChargeBack(Boolean chargeBack) {
        this.isChargeBack = chargeBack;
    }
}

