/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;
import kd.tmc.psd.business.service.period.PeriodHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheBillAutoStartScheduleService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheBillAutoStartScheduleService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("schedulstatus");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("company");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List needAutoScheBills = Arrays.stream(dataEntities).filter(v -> ScheStatusEnum.NOSCHEDULE.getValue().equals(v.getString("schedulstatus")) && BillStatusEnum.AUDIT.getValue().equals(v.getString("billstatus")) && EmptyUtil.isNoEmpty((DynamicObject)v.getDynamicObject("company")) && EmptyUtil.isNoEmpty((DynamicObject)v.getDynamicObject("currency"))).collect(Collectors.toList());
        ArrayList<OperateErrorInfo> errors = new ArrayList<OperateErrorInfo>(10);
        if (CollectionUtils.isEmpty(needAutoScheBills)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u6709\u9700\u8981\u81ea\u52a8\u53d1\u8d77\u6392\u7a0b\u7684\u6392\u7a0b\u5355");
            return;
        }
        Map<Long, List<DynamicObject>> orgIdDObjMap = needAutoScheBills.stream().collect(Collectors.groupingBy(v -> v.getDynamicObject("company").getLong("id")));
        logger.info(String.format("\u64cd\u4f5c\u7684\u6570\u636e\uff1a%s", LoggerPrintHelper.printObjectLoggerByJSON((Object[])new Map[]{orgIdDObjMap})));
        for (Map.Entry<Long, List<DynamicObject>> orgIdDObj : orgIdDObjMap.entrySet()) {
            Long orgId = orgIdDObj.getKey();
            List<DynamicObject> scheDObjList = orgIdDObj.getValue();
            List<Long> opIdList = scheDObjList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            try {
                PayScheProcessResult<Long> createResult;
                IPayScheService payScheService = PayScheServiceFactory.getPayScheService();
                boolean isOnTimeSche = PsdParameterHelper.getAppBoolParameter((long)orgId, (String)"ontimesche");
                if (isOnTimeSche) {
                    Set currencyIds = scheDObjList.stream().map(o -> o.getDynamicObject("currency").getLong("id")).collect(Collectors.toSet());
                    DynamicObject currPeriod = PeriodHelper.getCurrPeriod(orgId);
                    long periodId = currPeriod.getLong("id");
                    createResult = payScheService.createNewProcessor(orgId, periodId, new ArrayList<Long>(currencyIds));
                } else {
                    createResult = payScheService.createNewProcessorByStartEndDate(opIdList);
                }
                if (createResult.isSuccess()) {
                    this.getOperationResult().setSuccess(true);
                    continue;
                }
                List<String> errMsgList = createResult.getErrMsgList();
                String errMsgstr = String.join((CharSequence)",", errMsgList);
                throw new KDBizException(errMsgstr);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                for (Long opId : opIdList) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setPkValue((Object)opId);
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(e.getMessage());
                    errors.add(operateErrorInfo);
                }
            }
        }
        if (!CollectionUtils.isEmpty(errors)) {
            this.getOperationResult().setAllErrorInfo(errors);
            this.getOperationResult().setSuccess(false);
        }
    }
}

