/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.psd.common.enums.PayScheRespEnum;

public class PayScheBillErrChangeService
extends AbstractTmcBizOppService {
    protected List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();
    private static final String MUTEX_KEY = "sche_pay";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("payrespstatus");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("payerrmsg");
        selector.add("payerrmsg_TAG");
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Map<String, List<DynamicObject>> payScheBillGroup = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(o -> o.getString("sourcebilltype")));
        for (Map.Entry<String, List<DynamicObject>> entry : payScheBillGroup.entrySet()) {
            String srcType = entry.getKey();
            Set srcIdSet = entry.getValue().stream().map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
            Map srcLockResult = MutexServiceHelper.batchRequest(srcIdSet.stream().map(String::valueOf).collect(Collectors.toList()), (String)srcType, (String)MUTEX_KEY);
            Set currSuccessIdSet = srcLockResult.entrySet().stream().filter(Map.Entry::getValue).map(o -> Long.parseLong((String)o.getKey())).collect(Collectors.toSet());
            try {
                for (DynamicObject data : dynamicObjects) {
                    String errMsg = ResManager.loadKDString((String)"\u8d85\u65f6\u672a\u54cd\u5e94", (String)"PayScheBillErrChangeService_0", (String)"tmc-psd-business", (Object[])new Object[0]);
                    data.set("payerrmsg", (Object)errMsg);
                    data.set("payerrmsg_TAG", (Object)errMsg);
                    data.set("payrespstatus", (Object)PayScheRespEnum.UNKNOWN_ERR.getValue());
                }
            }
            finally {
                if (currSuccessIdSet.size() <= 0) continue;
                List successIdList = currSuccessIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                MutexServiceHelper.batchRelease(successIdList, (String)srcType, (String)MUTEX_KEY);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            e.addErrorInfo(operateErrorInfo);
        }
    }
}

