/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class PayScheBillOneKeyScheService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayScheBillOneKeyScheService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(10);
        selector.add("schedulstatus");
        selector.add("amount");
        selector.add("applyamt");
        selector.add("paycurrency");
        selector.add("billstatus");
        selector.add("waitpayamt");
        selector.add("currency");
        selector.add("scheduletotalamt");
        selector.add("freezestatus");
        selector.add("draftamt");
        selector.add("balanceamt");
        selector.add("exchangerate");
        selector.add("expectpaydate");
        selector.add("fundflowitem");
        selector.add("settletype");
        selector.add("acctbanktype");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("paymentchannel");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftpaychannel");
        selector.add("draftno");
        selector.add("batchnum");
        selector.add("transferpost");
        selector.add("exratetable");
        selector.add("entrys");
        selector.add("e_billtype");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("iscasexitbill");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.length);
        for (DynamicObject payScheBill : dynamicObjects) {
            payScheBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETSCHEDULE.getValue());
            payScheBill.set("amount", payScheBill.get("applyamt"));
            payScheBill.set("balanceamt", (Object)BigDecimal.ZERO);
            payScheBill.set("waitpayamt", (Object)BigDecimal.ZERO);
            BigDecimal draftAmount = payScheBill.getBigDecimal("draftamt");
            BigDecimal amount = payScheBill.getBigDecimal("applyamt");
            if (EmptyUtil.isEmpty((BigDecimal)draftAmount)) {
                draftAmount = BigDecimal.ZERO;
            }
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                amount = BigDecimal.ZERO;
            }
            BigDecimal totalAmount = draftAmount.add(amount);
            payScheBill.set("scheduletotalamt", (Object)totalAmount);
            ids.add((Long)payScheBill.getPkValue());
        }
        logger.info("\u901a\u8fc7\u4e00\u952e\u6392\u7a0b\u6821\u9a8c\u7684\u6392\u7a0b\u5355ID\u4e3a\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger(ids));
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)("update t_psd_schedulebill set fschedulstatus = 'yetschedule' where fid in (" + TmcBusinessBaseHelper.idListToString(ids) + ") and fschedulstatus = 'noschedule'"), Collections.singletonList(new Object[0]));
        if (result.length < 1 || result[0] != ids.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u514d\u6392\u7a0b\u4ed8\u6b3e\u5931\u8d25\uff0c\u6392\u7a0b\u5355\u72b6\u6001\u4e0d\u5168\u4e3a\u201c\u5f85\u6392\u7a0b\u201d\u3002", (String)"PayScheBillOneKeyScheService_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Object[] idArr = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"pay", (String)"psd_schedulebill", (Object[])idArr, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            logger.info("\u4e00\u952e\u6392\u7a0b\u4ed8\u6b3e\u64cd\u4f5c\u4e0b\u63a8\u6210\u529f\u7684\u6392\u7a0b\u5355ID\u4e3a\uff1a{}", (Object)LoggerPrintHelper.printCollectionLogger((Collection)result.getSuccessPkIds()));
        }
    }
}

