/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayScheBillSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheBillSaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("paycurrency");
        selector.add("acctbanktype");
        selector.add("acctbank");
        selector.add("accountbanks");
        selector.add("accountcash");
        return selector;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject payScheBill = dataEntity.getDataEntity();
            Object account = payScheBill.get("acctbank");
            if ("bd_accountbanks".equals(payScheBill.getString("acctbanktype"))) {
                payScheBill.set("accountbanks", account);
                continue;
            }
            payScheBill.set("accountcash", account);
        }
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List orgList = Arrays.stream(dataEntities).filter(v -> EmptyUtil.isEmpty((Object)v.get("exratetable"))).map(v -> v.getDynamicObject("company").getLong("id")).collect(Collectors.toList());
        DynamicObject[] cashMgtInits = TmcDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,exratetable", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)});
        HashMap orgExratMap = Arrays.stream(cashMgtInits).collect(Collectors.toMap(v -> v.getDynamicObject("org").getLong("id"), p -> p.getDynamicObject("exratetable"), (o1, o2) -> o1, HashMap::new));
        for (DynamicObject dataEntity : dataEntities) {
            long orgId;
            DynamicObject initExrateTable;
            DynamicObject itempayeeDo = dataEntity.getDynamicObject("itempayee");
            if (EmptyUtil.isNoEmpty((DynamicObject)itempayeeDo)) {
                dataEntity.set("payee", itempayeeDo.getPkValue());
                dataEntity.set("payeename", (Object)itempayeeDo.getString("name"));
            }
            if (EmptyUtil.isEmpty((Object)dataEntity.get("exratetable")) && null != (initExrateTable = (DynamicObject)orgExratMap.get(orgId = dataEntity.getDynamicObject("company").getLong("id")))) {
                dataEntity.set("exratetable", (Object)initExrateTable);
                DynamicObject srcCurrency = dataEntity.getDynamicObject("currency");
                DynamicObject targetCurrency = dataEntity.getDynamicObject("paycurrency");
                BigDecimal exchangeRate = new BigDecimal(1);
                if (srcCurrency.getLong("id") != targetCurrency.getLong("id")) {
                    Date expectDate = dataEntity.getDate("expectdate");
                    exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)initExrateTable.getLong("id"), (Long)srcCurrency.getLong("id"), (Long)targetCurrency.getLong("id"), (Date)expectDate);
                }
                dataEntity.set("exchangerate", (Object)exchangeRate);
            }
            logger.info("\u5f85\u4fdd\u5b58\u7684\u6392\u7a0b\u5355\u6570\u636e: {}", dataEntity.getPkValue());
        }
    }
}

