/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.dtx.model.PayScheChargeBackDtxModel;
import kd.tmc.psd.business.dtx.param.PayScheChargeBackDtxParam;
import kd.tmc.psd.business.opservice.payschebill.PayScheBillAfreshScheService;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheChargeBackService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheChargeBackService.class);
    private Map<Long, List<Long>> entryMap = new HashMap<Long, List<Long>>();
    private Map<Object, String> sameBatchNumBillMap = new HashMap<Object, String>(16);
    List<DraftLockInfo> draftAmountLockInfos = new ArrayList<DraftLockInfo>(10);
    Map<Long, PayScheChargeBackDtxModel> backUpMap = new HashMap<Long, PayScheChargeBackDtxModel>(16);
    private List<JSONObject> releaseReceiveBills = new ArrayList<JSONObject>(16);
    private List<JSONObject> callbackReceiveBills = new ArrayList<JSONObject>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("schedulstatus");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("exchangerate");
        selector.add("exratetable");
        selector.add("draftno");
        selector.add("waitpayamt");
        selector.add("transferpost");
        selector.add("isbilldibs");
        selector.add("dibsbalance");
        selector.add("id");
        selector.add("e_id");
        selector.add("e_batchnum");
        selector.add("ismasterdata");
        selector.add("draftinfoentry");
        selector.add(String.format("%s.%s", "draftinfoentry", "de_transferamt"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftinfo"));
        selector.add(String.format("%s.%s", "draftinfoentry", "de_draftlogid"));
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set batchNums = Arrays.stream(dataEntities).filter(v -> EmptyUtil.isNoEmpty((String)v.getString("batchnum"))).map(v -> v.getString("batchnum")).collect(Collectors.toSet());
        List selectIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] sameBatchNumBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"batchnum", (QFilter[])new QFilter[]{new QFilter("id", "not in", selectIds), new QFilter("batchnum", "in", batchNums)});
        List sameBatchNumBillIds = Arrays.stream(sameBatchNumBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        sameBatchNumBills = TmcDataServiceHelper.load((Object[])sameBatchNumBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        Map<String, List<DynamicObject>> sameBatchNumBillsIndex = Arrays.stream(sameBatchNumBills).collect(Collectors.groupingBy(v -> v.getString("batchnum")));
        ArrayList<DynamicObject> waitSaveObjs = new ArrayList<DynamicObject>(16);
        HashSet<Long> receiveBillIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject payScheBill : dataEntities) {
            Boolean isBillBids = payScheBill.getBoolean("isbilldibs");
            DynamicObject receiveBill = (DynamicObject)payScheBill.get("dibsbalance");
            if (ScheStatusEnum.YETSCHEDULE.getValue().equals(payScheBill.getString("schedulstatus"))) {
                DraftLockInfo draftLockInfo = this.obtainDraftInfo(payScheBill);
                if (null != draftLockInfo) {
                    this.draftAmountLockInfos.add(draftLockInfo);
                }
                if (isBillBids.booleanValue() && EmptyUtil.isNoEmpty((DynamicObject)receiveBill) && !receiveBillIds.contains(receiveBill.getLong("id"))) {
                    Long receiveId = receiveBill.getLong("id");
                    JSONObject object = new JSONObject();
                    object.put("receiveBillId", receiveBill.get("id"));
                    object.put("isUsed", (Object)false);
                    String batchNum = payScheBill.getString("batchnum");
                    if (StringUtils.isNotEmpty((String)batchNum)) {
                        object.put("batchNum", (Object)batchNum);
                    } else {
                        object.put("usesourcebill", (Object)payScheBill.getLong("id"));
                    }
                    this.releaseReceiveBills.add(object);
                    JSONObject rollback = new JSONObject();
                    rollback.put("receiveBillId", receiveBill.get("id"));
                    rollback.put("isUsed", (Object)true);
                    if (StringUtils.isNotEmpty((String)batchNum)) {
                        object.put("batchNum", (Object)batchNum);
                    } else {
                        object.put("usesourcebill", (Object)payScheBill.getLong("id"));
                    }
                    this.callbackReceiveBills.add(rollback);
                    receiveBillIds.add(receiveId);
                }
            }
            DynamicObject clonePayScheBill = TmcDataServiceHelper.clone((DynamicObject)payScheBill);
            PayScheChargeBackDtxModel payScheChargeBackDtxModel = this.obtainChargeBackDtxModel(clonePayScheBill);
            this.backUpMap.put(payScheBill.getLong("id"), payScheChargeBackDtxModel);
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.YETCHARGEBACK.getValue());
            payScheBill.set("draftno", null);
            payScheBill.set("amount", (Object)new BigDecimal(0));
            payScheBill.set("draftamt", (Object)new BigDecimal(0));
            payScheBill.set("waitpayamt", (Object)payScheBill.getBigDecimal("applyamt"));
            payScheBill.set("balanceamt", (Object)payScheBill.getBigDecimal("balanceamt").add(payScheBill.getBigDecimal("amount").add(payScheBill.getBigDecimal("draftamt"))));
            DynamicObjectCollection entrys = payScheBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                this.entryMap.put(entry.getLong("id"), Arrays.asList(entry.getLong("e_payid"), entry.getLong("e_payentryid")));
            }
            String batchnum = payScheBill.getString("batchnum");
            List<DynamicObject> sameBatchNumBillList = sameBatchNumBillsIndex.get(batchnum);
            if (!CollectionUtils.isEmpty(sameBatchNumBillList) && sameBatchNumBillList.size() == 1) {
                DynamicObject sameBatchNumBill = sameBatchNumBillList.get(0);
                this.sameBatchNumBillMap.put(sameBatchNumBill.getPkValue(), batchnum);
                sameBatchNumBill.set("batchnum", null);
                waitSaveObjs.add(sameBatchNumBill);
            }
            payScheBill.set("batchnum", null);
            logger.info("\u6267\u884c\u9000\u5355\u64cd\u4f5c\uff0c\u5bf9\u5e94\u7684\u5355\u636eID:{}", payScheBill.getPkValue());
        }
        for (DynamicObject payScheBill : sameBatchNumBills) {
            DraftLockInfo draftLockInfo = this.obtainDraftInfo(payScheBill);
            if (null == draftLockInfo) continue;
            this.draftAmountLockInfos.add(draftLockInfo);
        }
        ArrayList<DraftLockInfo> filterDraftLockInfs = new ArrayList<DraftLockInfo>(this.draftAmountLockInfos.size());
        for (DraftLockInfo draftAmountLockInfo : this.draftAmountLockInfos) {
            String batchNum = draftAmountLockInfo.getBatchNum();
            Boolean isMasterData = draftAmountLockInfo.getMasterData();
            if (StringUtils.isEmpty((String)batchNum) && !this.sameBatchNumBillMap.containsKey(draftAmountLockInfo.getSourceBillId()) && !isMasterData.booleanValue()) {
                filterDraftLockInfs.add(draftAmountLockInfo);
                continue;
            }
            if (!isMasterData.booleanValue()) continue;
            filterDraftLockInfs.add(draftAmountLockInfo);
        }
        this.draftAmountLockInfos.clear();
        this.draftAmountLockInfos.addAll(filterDraftLockInfs);
        logger.info("\u5f85\u91ca\u653e\u7684\u7968\u636e:{}", (Object)LoggerPrintHelper.printCollectionLogger(this.draftAmountLockInfos));
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])waitSaveObjs.toArray(new DynamicObject[waitSaveObjs.size()]));
        if (sameBatchNumBills.length > 0) {
            PayScheBillAfreshScheService psbass = new PayScheBillAfreshScheService();
            psbass.setStatus(ScheStatusEnum.NOSCHEDULE.getValue());
            psbass.setChargeBack(true);
            psbass.process(sameBatchNumBills);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Long pkValue = dataEntities[0].getDynamicObject("company").getLong("id");
        String isEntrustChargeBack = this.operationVariable.getOrDefault("isEntrustChargeBack", "0");
        String chargeBackSet = PsdParameterHelper.getAppStringParameter((long)pkValue, (String)"chargebackset");
        if ("1".equals(isEntrustChargeBack) || EmptyUtil.isEmpty((String)chargeBackSet)) {
            chargeBackSet = "chargeback";
        }
        List<Object> ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ECSession ecSession = DtxFactory.createEC((String)"psd_payschechargeback");
        ecSession.setDbRoute(DBRoute.of((String)"tmc"));
        Map operationVariable = this.getOperationVariable();
        String backReason = Optional.ofNullable(operationVariable).map(o -> (String)o.get("backreason")).orElse("");
        try (TXHandle h = TX.requiresNew();){
            ecSession.begin();
            PayScheChargeBackDtxParam param = new PayScheChargeBackDtxParam();
            param.setIds(ids);
            param.setBackUpMap(this.backUpMap);
            param.setDraftAmountLockInfos(this.draftAmountLockInfos);
            param.setSameBatchNumBillMap(this.sameBatchNumBillMap);
            param.setEntryMap(this.entryMap);
            param.setChargeBackDelType(chargeBackSet);
            param.setReleaseReceiveBills(this.releaseReceiveBills);
            param.setCallbackReceiveBills(this.callbackReceiveBills);
            param.setBackReason(backReason);
            ecSession.register("tmc", "psd", "payScheBillChargeBackDtxService", (Param)param, "payschechargeback", "");
        }
        catch (Throwable e) {
            try {
                ecSession.rollback();
            }
            catch (Exception exception) {
                logger.error("\u4ed8\u6b3e\u6392\u7a0b\u5355\u9000\u5355\u5206\u5e03\u5f0f\u4e8b\u52a1\u5904\u7406\u56de\u6eda\u5931\u8d25:\n", (Throwable)exception);
            }
            throw e;
        }
        try {
            ecSession.commit();
        }
        catch (Exception e) {
            logger.error("\u4ed8\u6b3e\u6392\u7a0b\u5355\u9000\u5355\u5206\u5e03\u5f0f\u4e8b\u52a1\u5904\u7406\u63d0\u4ea4\u5931\u8d25:", (Throwable)e);
        }
    }

    public DraftLockInfo obtainDraftInfo(DynamicObject payScheBill) {
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        String draftPayMethod = payScheBill.getString("draftpaymethod");
        boolean isDraftBook = "draftbook".equals(draftPayMethod);
        draftLockInfo.setMasterData(payScheBill.getBoolean("ismasterdata"));
        draftLockInfo.setBatchNum(payScheBill.getString("batchnum"));
        draftLockInfo.setSourceBillId(payScheBill.getLong("id"));
        draftLockInfo.setSourceBillType(payScheBill.getDataEntityType().getName());
        draftLockInfo.setBizBillNo(payScheBill.getString("billno"));
        Object draftCol = payScheBill.getDynamicObjectCollection("draftinfoentry");
        boolean isOld = false;
        if (EmptyUtil.isEmpty((Collection)draftCol)) {
            DynamicObjectCollection draftnos = payScheBill.getDynamicObjectCollection("draftno");
            List draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftnoIds)});
            draftCol = new ArrayList(draftArr);
            isOld = true;
        }
        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        for (DynamicObject draftInfo : draftCol) {
            DraftAmountLockSubInfo draftAmountLockInfo = PayScheHelper.getReleaseLockInfo(payScheBill, isDraftBook, false, draftInfo, isOld);
            draftAmountLockSubInfoList.add(draftAmountLockInfo);
        }
        draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
        return draftLockInfo;
    }

    private PayScheChargeBackDtxModel obtainChargeBackDtxModel(DynamicObject payScheBill) {
        PayScheChargeBackDtxModel payScheChargeBackDtxModel = new PayScheChargeBackDtxModel();
        payScheChargeBackDtxModel.setSchedulStatus(payScheBill.getString("schedulstatus"));
        payScheChargeBackDtxModel.setDraftNo(payScheBill.get("draftno"));
        payScheChargeBackDtxModel.setBatchNum(payScheBill.get("batchnum"));
        payScheChargeBackDtxModel.setAmount(payScheBill.get("amount"));
        payScheChargeBackDtxModel.setDraftAmt(payScheBill.get("draftamt"));
        payScheChargeBackDtxModel.setBalanceAmt(payScheBill.get("balanceamt"));
        payScheChargeBackDtxModel.setWaitPayAmt(payScheBill.get("waitpayamt"));
        return payScheChargeBackDtxModel;
    }
}

