/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.dtx.model.PayScheDelDtxModel;
import kd.tmc.psd.business.dtx.param.PayScheDelDtxParam;
import kd.tmc.psd.business.opservice.payschebill.PayScheChargeBackService;

public class PayScheDelService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheChargeBackService.class);
    List<PayScheDelDtxModel> delDtxModels = new ArrayList<PayScheDelDtxModel>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("exchangerate");
        selector.add("exratetable");
        selector.add("draftno");
        selector.add("waitpayamt");
        selector.add("transferpost");
        selector.add("issplit");
        selector.add("isexistchangedate");
        selector.add("splitno");
        selector.add("prescheduleid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject payScheBill : dataEntities) {
            if (EmptyUtil.isEmpty((DynamicObject)payScheBill)) continue;
            PayScheDelDtxModel delDtxModel = new PayScheDelDtxModel();
            delDtxModel.setPayScheId(payScheBill.getLong("id"));
            boolean isSplit = Optional.ofNullable(payScheBill.getString("splitno")).map(o -> EmptyUtil.isNoEmpty((String)o)).orElseGet(() -> false);
            delDtxModel.setSplit(isSplit);
            boolean isDiffSplit = payScheBill.getBoolean("issplit");
            delDtxModel.setDiffSplit(isDiffSplit);
            this.delDtxModels.add(delDtxModel);
        }
        ECSession ecSession = DtxFactory.createEC((String)"psd_payschedelete");
        ecSession.setDbRoute(DBRoute.of((String)"tmc"));
        try (TXHandle h = TX.requiresNew();){
            ecSession.begin();
            PayScheDelDtxParam param = new PayScheDelDtxParam();
            param.setDtxParam(this.delDtxModels);
            ecSession.register("tmc", "psd", "payScheBillDelDtxService", (Param)param, "payschedelete", "");
        }
        catch (Throwable e) {
            try {
                ecSession.rollback();
            }
            catch (Exception exception) {
                logger.error("\u4ed8\u6b3e\u6392\u7a0b\u5355\u5220\u9664\u5206\u5e03\u5f0f\u4e8b\u52a1\u5904\u7406\u56de\u6eda\u5931\u8d25:\n", (Throwable)exception);
            }
            throw e;
        }
        try {
            ecSession.commit();
        }
        catch (Exception e) {
            logger.error("\u4ed8\u6b3e\u6392\u7a0b\u5355\u5220\u9664\u5206\u5e03\u5f0f\u4e8b\u52a1\u5904\u7406\u63d0\u4ea4\u5931\u8d25:", (Throwable)e);
        }
    }
}

