/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PayScheSaveDraftService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheSaveDraftService.class);
    private DraftLockServiceHelper draftLockServiceHelper;
    private List<OperateErrorInfo> failureMsgs = null;
    private DynamicObject[] payScheBillFromDB;
    List<PayScheCalcModel> scheDatasFromDB = new ArrayList<PayScheCalcModel>(10);
    Map<Long, PayScheCalcModel> payScheDraftInfoMap = new HashMap<Long, PayScheCalcModel>(16);

    public PayScheSaveDraftService() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("batchnum");
        selectors.add("batchnum");
        selectors.add("draftinfoentry.de_transferamt");
        selectors.add("draftinfoentry.de_draftinfo");
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List payScheBillIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        this.payScheBillFromDB = TmcDataServiceHelper.load((Object[])payScheBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        this.scheDatasFromDB.addAll(new PayScheDataTransfer().transScheDataToCalcModelList(Arrays.asList(this.payScheBillFromDB)));
        for (PayScheCalcModel payScheCalcModel : this.scheDatasFromDB) {
            List<PayScheDraftInfo> payScheDraftInfoList = payScheCalcModel.getPayScheDraftInfos();
            if (payScheDraftInfoList == null || payScheDraftInfoList.size() == 0) continue;
            this.payScheDraftInfoMap.put(payScheCalcModel.getScheId(), payScheCalcModel);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        logger.info("beforeCommit is start");
        String mode = (String)this.getOperationVariable().get("mode");
        if ("proc_del".equals(mode)) {
            logger.info("is from proc_del");
            return;
        }
        HashMap payScheBillFromDBMap = Arrays.stream(this.payScheBillFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (o1, o2) -> o1, HashMap::new));
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>();
        Map<Long, Long> viewMap = PayScheSaveDraftService.getMasterIdMap(dataEntities);
        Map<Long, Long> dbMap = PayScheSaveDraftService.getMasterIdMap(this.payScheBillFromDB);
        HashMap noChangeDraft = new HashMap(16);
        HashMap<String, ArrayList<Long>> batchScheIds = new HashMap<String, ArrayList<Long>>(16);
        for (DynamicObject dataEntity : dataEntities) {
            String batch = dataEntity.getString("batchnum");
            ArrayList<Long> scheIds = (ArrayList<Long>)batchScheIds.get(batch);
            if (scheIds == null) {
                scheIds = new ArrayList<Long>(16);
                batchScheIds.put(batch, scheIds);
            }
            scheIds.add(dataEntity.getLong("id"));
        }
        Long tmpMasterId = 0L;
        for (DynamicObject scheBill : dataEntities) {
            ArrayList<DynamicObject> filterList;
            Object draftIDList;
            DynamicObjectCollection draftnos;
            DynamicObjectCollection draftinfoentryColl;
            DynamicObject scheBillFromDB = (DynamicObject)payScheBillFromDBMap.get(scheBill.getPkValue());
            Set<Object> lockedDraftnoFromDB = this.getDraftIds(scheBillFromDB);
            Set<Object> set = this.getDraftIds(scheBill);
            Long billId = scheBill.getLong("id");
            if (!scheBill.getBoolean("ismasterdata") && EmptyUtil.isNoEmpty((String)scheBill.getString("batchnum"))) {
                logger.info("billId is not ismasterdata" + billId);
                continue;
            }
            String batchNum = scheBill.getString("batchnum");
            if (lockedDraftnoFromDB.equals(set)) {
                if (scheBillFromDB == null) continue;
                DynamicObjectCollection draftInfos = scheBill.getDynamicObjectCollection("draftinfoentry");
                DynamicObjectCollection draftInfosFromDB = scheBillFromDB.getDynamicObjectCollection("draftinfoentry");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfos) && EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfosFromDB)) {
                    Object draftInfo22;
                    HashMap<Long, BigDecimal> viewEntryMap = new HashMap<Long, BigDecimal>(8);
                    for (Object draftInfo22 : draftInfos) {
                        long draftId = PayScheHelper.getDraftId((DynamicObject)draftInfo22);
                        BigDecimal tranAmount = draftInfo22.getBigDecimal("de_transferamt");
                        viewEntryMap.put(draftId, tranAmount);
                    }
                    boolean isNeedCall = false;
                    draftInfo22 = draftInfosFromDB.iterator();
                    while (draftInfo22.hasNext()) {
                        DynamicObject draftInfoDb = (DynamicObject)draftInfo22.next();
                        long draftId = PayScheHelper.getDraftId(draftInfoDb);
                        BigDecimal tranAmountDb = draftInfoDb.getBigDecimal("de_transferamt");
                        BigDecimal viewAmount = (BigDecimal)viewEntryMap.get(draftId);
                        if (viewAmount.compareTo(tranAmountDb) == 0) continue;
                        isNeedCall = true;
                        break;
                    }
                    if (!isNeedCall) {
                        logger.info("billId is not isNeedCall :" + billId);
                        PayScheCalcModel payScheCalcModel = this.payScheDraftInfoMap.get(billId);
                        List<PayScheDraftInfo> getPayScheDraftInfo = payScheCalcModel.getPayScheDraftInfos();
                        ArrayList<PayScheDraftInfo> payScheDraftInfoList = new ArrayList<PayScheDraftInfo>(16);
                        if (payScheCalcModel != null && getPayScheDraftInfo != null && getPayScheDraftInfo.size() > 0) {
                            payScheDraftInfoList.addAll(getPayScheDraftInfo);
                        }
                        if (payScheDraftInfoList.size() <= 0) continue;
                        for (DynamicObject draftInfo3 : draftInfos) {
                            Long deDraftId = PayScheHelper.getDraftId(draftInfo3);
                            for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfoList) {
                                Long schId = payScheDraftInfo.getPayScheId();
                                Long l = payScheDraftInfo.getDraftId();
                                if (!l.equals(deDraftId)) continue;
                                HashMap<String, Long> draftLongMap = (HashMap<String, Long>)noChangeDraft.get(schId);
                                if (draftLongMap == null) {
                                    draftLongMap = new HashMap<String, Long>(16);
                                    noChangeDraft.put(schId, draftLongMap);
                                }
                                Long draftLogId = payScheDraftInfo.getDraftLogId();
                                String latKey = schId + "_" + deDraftId;
                                draftLongMap.put(latKey, draftLogId);
                            }
                        }
                        continue;
                    }
                }
            }
            HashSet<Object> tempDraftIds = new HashSet<Object>();
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            Long viewMasterId = viewMap.get(billId);
            Long dbMastterId = dbMap.get(billId);
            Long sourceBillId = 0L;
            boolean isMerged = false;
            if ((EmptyUtil.isEmpty((Long)viewMasterId) || 0L == viewMasterId) && (EmptyUtil.isEmpty((Long)dbMastterId) || 0L == dbMastterId)) {
                sourceBillId = billId;
            } else {
                Long curMasterId;
                isMerged = true;
                Long l = curMasterId = viewMasterId == 0L ? dbMastterId : viewMasterId;
                if (tmpMasterId.equals(curMasterId)) continue;
                tmpMasterId = curMasterId;
                sourceBillId = curMasterId;
            }
            draftLockInfo.setSourceBillId(sourceBillId);
            draftLockInfo.setSourceBillType(scheBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(scheBill.getString("billno"));
            String draftPayMethod = scheBill.getString("draftpaymethod");
            boolean isDraftBook = "draftbook".equals(draftPayMethod);
            tempDraftIds.addAll(lockedDraftnoFromDB);
            tempDraftIds.removeAll(set);
            if (!isMerged && scheBillFromDB != null && !CollectionUtils.isEmpty(tempDraftIds)) {
                boolean isOld = false;
                ArrayList<DynamicObject> needReleaseDraftInfos = new ArrayList(8);
                draftinfoentryColl = scheBillFromDB.getDynamicObjectCollection("draftinfoentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftinfoentryColl)) {
                    draftnos = scheBillFromDB.getDynamicObjectCollection("draftno");
                    draftIDList = new ArrayList(8);
                    for (DynamicObject draftno : draftnos) {
                        long draftId = draftno.getDynamicObject("fbasedataid").getLong("id");
                        if (!tempDraftIds.contains(draftId)) continue;
                        draftIDList.add(draftId);
                    }
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIDList)});
                    needReleaseDraftInfos = new ArrayList(dynamicObjectCollection);
                    isOld = true;
                } else {
                    filterList = new ArrayList<DynamicObject>(8);
                    for (DynamicObject dynamicObject : draftinfoentryColl) {
                        long draftId = PayScheHelper.getDraftId(dynamicObject);
                        if (!tempDraftIds.contains(draftId)) continue;
                        filterList.add(dynamicObject);
                    }
                    needReleaseDraftInfos = filterList;
                }
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (DynamicObject dynamicObject : needReleaseDraftInfos) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo = PayScheHelper.getReleaseLockInfo(scheBill, isDraftBook, false, dynamicObject, isOld);
                    draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
                }
                if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoList)) {
                    draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
                }
            } else if (isMerged && this.scheDatasFromDB.size() > 0) {
                List schIds = (List)batchScheIds.get(batchNum);
                for (Long schId : schIds) {
                    PayScheCalcModel payScheCalcModel = this.payScheDraftInfoMap.get(schId);
                    if (payScheCalcModel == null || EmptyUtil.isEmpty((Object)payScheCalcModel) || payScheCalcModel.getPayScheDraftInfos() == null || payScheCalcModel.getPayScheDraftInfos().size() == 0) continue;
                    PayScheHelper.releaseDraft(payScheCalcModel);
                }
            }
            tempDraftIds.clear();
            tempDraftIds.addAll(set);
            if (!CollectionUtils.isEmpty(tempDraftIds)) {
                ArrayList needLockDraftInfos = new ArrayList(8);
                boolean isOld = false;
                draftinfoentryColl = scheBill.getDynamicObjectCollection("draftinfoentry");
                if (EmptyUtil.isEmpty((Collection)draftinfoentryColl)) {
                    draftnos = scheBillFromDB.getDynamicObjectCollection("draftno");
                    draftIDList = new ArrayList(8);
                    for (DynamicObject draftno : draftnos) {
                        long draftId = draftno.getDynamicObject("fbasedataid").getLong("id");
                        if (!tempDraftIds.contains(draftId)) continue;
                        draftIDList.add(draftId);
                    }
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIDList)});
                    needLockDraftInfos = new ArrayList(dynamicObjectCollection);
                    isOld = true;
                } else {
                    filterList = new ArrayList(8);
                    for (DynamicObject dynamicObject : draftinfoentryColl) {
                        long draftId = PayScheHelper.getDraftId(dynamicObject);
                        if (!tempDraftIds.contains(draftId)) continue;
                        filterList.add(dynamicObject);
                    }
                    needLockDraftInfos = filterList;
                }
                ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (DynamicObject dynamicObject : needLockDraftInfos) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo = PayScheHelper.getReleaseLockInfo(scheBill, isDraftBook, true, dynamicObject, isOld);
                    lockSubInfoList.add(draftAmountLockSubInfo);
                }
                if (EmptyUtil.isNoEmpty(lockSubInfoList)) {
                    draftLockInfo.getLockSubInfoList().addAll(lockSubInfoList);
                }
            }
            if (!EmptyUtil.isNoEmpty(draftLockInfo.getLockSubInfoList())) continue;
            lockInfoList.add(draftLockInfo);
        }
        Map<Object, List<DynamicObject>> waitDealScheMap = Arrays.stream(dataEntities).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getPkValue()));
        if (EmptyUtil.isNoEmpty(lockInfoList)) {
            Long draftLogId;
            DynamicObjectCollection draftInfoEntry;
            Long sourceBillId;
            HashSet<DynamicObject> willUpdatePsdBill;
            List successResults;
            List<LockResult> lockResults = this.draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
            List failureResults = lockResults.stream().filter(o -> !o.isSuccess()).collect(Collectors.toList());
            if (failureResults != null && !failureResults.isEmpty()) {
                this.failureMsgs = new ArrayList<OperateErrorInfo>(failureResults.size());
                for (LockResult failureResult : failureResults) {
                    Long sourceBillId2 = failureResult.getSourceBillId();
                    DynamicObject dynamicObject = (DynamicObject)payScheBillFromDBMap.get(sourceBillId2);
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, dynamicObject.getPkValue(), (Object)dynamicObject.getDynamicObjectType().getName());
                    operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u6392\u7a0b\u5355\u9501\u7968\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u68c0\u67e5\u7968\u636e\u7ba1\u7406\u9501\u7968\u65e5\u5fd7\u4fe1\u606f", (String)"PayScheBillPayService_5", (String)"tmc-psd-business", (Object[])new Object[0]), dynamicObject.getString("billno")));
                    this.failureMsgs.add(operateErrorInfo);
                }
            }
            if ((successResults = lockResults.stream().filter(LockResult::isSuccess).collect(Collectors.toList())) != null && !successResults.isEmpty()) {
                willUpdatePsdBill = new HashSet<DynamicObject>(8);
                for (LockResult lockResult : successResults) {
                    sourceBillId = lockResult.getSourceBillId();
                    DynamicObject waitDealSche = waitDealScheMap.get(sourceBillId).get(0);
                    Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                    draftInfoEntry = waitDealSche.getDynamicObjectCollection("draftinfoentry");
                    for (DynamicObject draftInfo : draftInfoEntry) {
                        long draftId = PayScheHelper.getDraftId(draftInfo);
                        draftLogId = billIdLogIdMap.get(draftId);
                        if (!EmptyUtil.isNoEmpty((Long)draftLogId)) continue;
                        draftInfo.set("de_draftlogid", (Object)draftLogId);
                    }
                    willUpdatePsdBill.add(waitDealSche);
                }
                if (EmptyUtil.isNoEmpty(willUpdatePsdBill)) {
                    SaveServiceHelper.update((DynamicObject[])willUpdatePsdBill.toArray(new DynamicObject[0]));
                }
            }
            if (noChangeDraft.size() > 0) {
                willUpdatePsdBill = new HashSet(8);
                for (Map.Entry entry : noChangeDraft.entrySet()) {
                    sourceBillId = (Long)entry.getKey();
                    Map values = (Map)entry.getValue();
                    if (values.size() == 0) continue;
                    DynamicObject waitDealSche = waitDealScheMap.get(sourceBillId).get(0);
                    draftInfoEntry = waitDealSche.getDynamicObjectCollection("draftinfoentry");
                    for (DynamicObject draftInfo : draftInfoEntry) {
                        Long draftId = draftInfo.getLong("de_draftinfo");
                        String latKey = sourceBillId + "_" + draftId;
                        draftLogId = (Long)values.get(latKey);
                        if (!EmptyUtil.isNoEmpty((Long)draftLogId)) continue;
                        draftInfo.set("de_draftlogid", (Object)draftLogId);
                    }
                    willUpdatePsdBill.add(waitDealSche);
                }
                if (EmptyUtil.isNoEmpty(willUpdatePsdBill)) {
                    SaveServiceHelper.update((DynamicObject[])willUpdatePsdBill.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.failureMsgs != null && !this.failureMsgs.isEmpty()) {
            for (OperateErrorInfo failureMsg : this.failureMsgs) {
                e.addErrorInfo(failureMsg);
            }
        }
    }

    private Set<Object> getDraftIds(DynamicObject scheBill) {
        if (null == scheBill) {
            return new HashSet<Object>();
        }
        DynamicObjectCollection draftnoList = scheBill.getDynamicObjectCollection("draftno");
        Set<Object> draftnoIds = draftnoList.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        return draftnoIds;
    }

    private static Map<Long, Long> getMasterIdMap(DynamicObject[] payScheBills) {
        Map<String, Long> batchnumMap = Arrays.stream(payScheBills).filter(d -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{d.getString("batchnum")}) && d.getBoolean("ismasterdata")).collect(Collectors.toMap(d -> d.getString("batchnum"), d -> d.getLong("id")));
        if (EmptyUtil.isEmpty(batchnumMap)) {
            return new HashMap<Long, Long>(16);
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (DynamicObject data : payScheBills) {
            String batchnum = data.getString("batchnum");
            if (EmptyUtil.isEmpty((String)batchnum)) {
                result.put(data.getLong("id"), 0L);
                continue;
            }
            Long masterId = batchnumMap.get(batchnum);
            result.put(data.getLong("id"), masterId);
        }
        return result;
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        this.draftLockServiceHelper.rollback();
    }
}

