/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payschebill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;

public class ReceiveBillUpdateService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReceiveBillUpdateService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)data.get("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject receiveBill;
                Boolean isBillDibs = dynamicObject.getBoolean("e_isbilldibs");
                if (!isBillDibs.booleanValue() || EmptyUtil.isEmpty((DynamicObject)(receiveBill = (DynamicObject)dynamicObject.get("e_dibsbalance")))) continue;
                Long schId = dynamicObject.getLong("e_id");
                String batchNum = dynamicObject.getString("e_batchnum");
                JSONObject object = new JSONObject();
                object.put("receiveBillId", receiveBill.get("id"));
                object.put("isUsed", (Object)true);
                if (StringUtils.isNotEmpty((String)batchNum)) {
                    object.put("batchNum", (Object)batchNum);
                } else {
                    object.put("usesourcebill", (Object)String.valueOf(schId));
                }
                jsonObjectList.add(object);
            }
        }
        logger.info("ReceiveBillUpdateService:Lock the receiving information::{}", (Object)((Object)jsonObjectList).toString());
        PayScheHelper.lockReceiveBills(jsonObjectList);
    }
}

