/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.payscheprocessor;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheProcrUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProcrUnAuditService.class);
    private static final String[] SELECTOR = new String[]{"schedulstatus", "draftnopayamt", "nopayamt", "nopayamt", "checktotalamt", "checkamt"};

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("c_checktotalamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] payScheBills;
        List payScheProcBillIds = Stream.of(dataEntities).map(o -> o.getLong("processorid")).collect(Collectors.toList());
        logger.info("\u4ed8\u6b3e\u6392\u7a0b\u53cd\u5ba1\u6838\u7684\u5355\u636eID\u4e3a: {}", payScheProcBillIds);
        for (DynamicObject payScheBill : payScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)String.join((CharSequence)",", SELECTOR), (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcBillIds), new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.YETSCHEDULE.getValue())})) {
            logger.info("\u4ed8\u6b3e\u6392\u7a0b\u53cd\u5ba1\u6838\u7684\u524d\u4e3a: {}", (Object)payScheBill.toString());
            payScheBill.set("schedulstatus", (Object)ScheStatusEnum.SCHEDULING.getValue());
            payScheBill.set("draftnopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("nopayamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checktotalamt", (Object)BigDecimal.ZERO);
            payScheBill.set("checkamt", (Object)BigDecimal.ZERO);
            logger.info("\u4ed8\u6b3e\u6392\u7a0b\u53cd\u5ba1\u6838\u7684\u540e\u4e3a: {}", (Object)payScheBill.toString());
        }
        SaveServiceHelper.save((DynamicObject[])payScheBills);
        DynamicObject[] payScheProcessorArr = TmcDataServiceHelper.load((Object[])payScheProcBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"));
        OperateOption create = OperateOption.create();
        create.setVariableValue("isFromCalc", "true");
        logger.info("%s \u5355\u5f00\u59cb\u6267\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\uff0c\u6267\u884c\u7684\u5355\u636eID\u4e3a: {}", (Object)"psd_schedealbill", (Object)payScheProcessorArr);
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"psd_schedealbill", (DynamicObject[])payScheProcessorArr, (OperateOption)create);
    }
}

