/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.opservice.period;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.opservice.payscheprocessor.PayScheProRealUnAuditService;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class SchePeriodSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayScheProRealUnAuditService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("periodtype");
        selector.add("periodyear");
        selector.add("cycle");
        selector.add("autoschetype");
        selector.add("customday");
        selector.add("skiphol");
        selector.add("mergetype");
        selector.add("fixeddate");
        selector.add("comment");
        selector.add("group");
        selector.add("periodnum");
        selector.add("periodname");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("diffdays");
        selector.add("periodid");
        selector.add("uorg");
        selector.add("workcalendar");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();
        ArrayList<DynamicObject> periodList = new ArrayList<DynamicObject>();
        ArrayList<Long> periodIdList = new ArrayList<Long>();
        for (DynamicObject schePeriod : dataEntities) {
            DynamicObject[] periods = TmcDataServiceHelper.load((String)"psd_schedule_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodyear", "=", (Object)schePeriod.getInt("periodyear")), new QFilter("schetype", "=", schePeriod.getDynamicObject("group").getPkValue())});
            List periodIds = Arrays.stream(periods).map(v -> v.getPkValue()).collect(Collectors.toList());
            for (DynamicObject period : periods = TmcDataServiceHelper.load((Object[])periodIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedule_period"))) {
                periodList.add(period);
                periodMap.put(period.getLong("id"), period);
                periodIdList.add(period.getLong("id"));
            }
        }
        for (DynamicObject schePeriod : dataEntities) {
            DynamicObjectCollection entrys = schePeriod.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                Long periodId = entry.getLong("periodid");
                DynamicObject period = periodMap.getOrDefault(periodId, null);
                if (period == null) {
                    period = TmcDataServiceHelper.newDynamicObject((String)"psd_schedule_period");
                    periodList.add(period);
                } else {
                    periodIdList.remove(periodId);
                }
                period.set("number", schePeriod.get("number"));
                period.set("name", schePeriod.get("name"));
                period.set("schetype", schePeriod.get("group"));
                period.set("periodtype", schePeriod.get("periodtype"));
                period.set("periodyear", schePeriod.get("periodyear"));
                period.set("cycle", schePeriod.get("cycle"));
                period.set("autoschetype", schePeriod.get("autoschetype"));
                period.set("customday", schePeriod.get("customday"));
                period.set("skiphol", schePeriod.get("skiphol"));
                period.set("mergetype", schePeriod.get("mergetype"));
                period.set("fixeddate", schePeriod.get("fixeddate"));
                period.set("comment", schePeriod.get("comment"));
                Long workCalandarId = Optional.ofNullable(schePeriod.getDynamicObject("workcalendar")).map(o -> o.getLong("id")).orElseGet(() -> 0L);
                period.set("workcalendar", (Object)workCalandarId);
                period.set("id", entry.get("periodid"));
                period.set("periodnum", entry.get("periodnum"));
                period.set("name", entry.get("periodname"));
                period.set("startdate", (Object)DateUtils.getDataFormat((Date)entry.getDate("startdate"), (boolean)true));
                period.set("enddate", (Object)DateUtils.getDataFormat((Date)entry.getDate("enddate"), (boolean)true));
                period.set("diffdays", entry.get("diffdays"));
                period.set("status", (Object)BillStatusEnum.AUDIT.getValue());
                period.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
                period.set("createtime", (Object)schePeriod.getDate("createtime"));
                period.set("creator", schePeriod.getDynamicObject("creator").getPkValue());
                period.set("modifytime", (Object)schePeriod.getDate("modifytime"));
                logger.info("\u5f85\u4fdd\u5b58\u7684\u6392\u7a0b\u5468\u671f\u6570\u636e\u4e3a:{}", (Object)LoggerPrintHelper.printDyObjLogger((DynamicObject[])new DynamicObject[]{period}));
            }
        }
        if (CollectionUtils.isEmpty(periodIdList)) {
            for (Long pkId : periodIdList) {
                DynamicObject needDelObj = (DynamicObject)periodMap.get(pkId);
                periodList.remove(needDelObj);
            }
            DeleteServiceHelper.delete((String)"psd_schedule_period", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdList)});
        }
        if (!CollectionUtils.isEmpty(periodList)) {
            SaveServiceHelper.save((DynamicObject[])periodList.toArray(new DynamicObject[periodList.size()]));
        }
    }
}

