/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.service.paysche.autosche.AutoScheDataCreator;
import kd.tmc.psd.business.service.paysche.autosche.IAutoPayScheExecutor;
import kd.tmc.psd.business.service.paysche.autosche.bill.AutoPayScheBillExecutor;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.autosche.fund.AutoPayScheFundExecutor;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.sumsche.SumSchePrimeSorter;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;

public class AutoPayScheHandler {
    private static Log logger = LogFactory.getLog(AutoPayScheHandler.class);
    private IAutoPayScheExecutor billExecutor;
    private IAutoPayScheExecutor fundExecutor;
    private AutoScheDataCreator autoScheDataCreator;
    private Map<Long, DynamicObject> defaultRules;

    public AutoPayScheHandler(Long orgId, List<PayScheCalcModel> payScheDataList, String pageId) {
        this(orgId, payScheDataList, pageId, false);
    }

    public AutoPayScheHandler(Long orgId, List<PayScheCalcModel> payScheDataList, String pageId, boolean onKeySche) {
        this.billExecutor = new AutoPayScheBillExecutor(orgId, pageId, onKeySche);
        this.fundExecutor = new AutoPayScheFundExecutor(orgId);
        this.autoScheDataCreator = new AutoScheDataCreator(orgId, pageId, payScheDataList, onKeySche);
    }

    public List<PayScheCalcModel> doAutoSche() {
        return this.doAutoSche(null);
    }

    public List<PayScheCalcModel> doSumSche(SumScheInfo sumInfo) {
        return this.doAutoSche(sumInfo);
    }

    private List<PayScheCalcModel> doAutoSche(SumScheInfo sumInfo) {
        if (this.defaultRules != null) {
            this.autoScheDataCreator.setDefaultRules(this.defaultRules);
        }
        Tuple<List<WaitScheData>, List<WaitScheData>> waitScheDataInfo = this.autoScheDataCreator.createAutoPayScheList();
        List waitScheFundList = (List)waitScheDataInfo.item1;
        List waitScheBillList = (List)waitScheDataInfo.item2;
        if (sumInfo != null) {
            Long primaryRuleId = sumInfo.getPrimaryRuleId();
            DynamicObject primeRule = TmcDataServiceHelper.loadSingle((Object)primaryRuleId, (String)"psd_prime_rule");
            SumSchePrimeSorter sorter = new SumSchePrimeSorter(primeRule);
            sorter.sort(waitScheFundList);
            sorter.sort(waitScheBillList);
        }
        if (sumInfo == null || sumInfo.getBillTotalAmt() == null || sumInfo.getBillTotalAmt().compareTo(BigDecimal.ZERO) != 0) {
            this.billExecutor.execute(waitScheBillList, sumInfo != null ? sumInfo.getBillTotalAmt() : null);
        }
        this.fundExecutor.execute(waitScheFundList, sumInfo != null ? sumInfo.getFundTotalAmt() : null);
        this.doBatchBillToPaySche(waitScheFundList, waitScheBillList, sumInfo);
        this.doBatchBillToNewBillSche(waitScheBillList, sumInfo);
        return this.getSplitScheDataList(waitScheBillList);
    }

    public void doBatchFundSche(DynamicObject fundRule) {
        List<WaitScheData> autoScheDataList = this.autoScheDataCreator.createFundDataList(fundRule);
        this.fundExecutor.execute(autoScheDataList, null);
    }

    public List<PayScheCalcModel> doBatchBillSche(DynamicObject billRule) {
        List<WaitScheData> autoScheDataList = this.autoScheDataCreator.createBillDataList(billRule);
        this.billExecutor.execute(autoScheDataList, null);
        this.doBatchBillToPaySche(Collections.emptyList(), autoScheDataList, null);
        this.doBatchBillToNewBillSche(autoScheDataList, null);
        return this.getSplitScheDataList(autoScheDataList);
    }

    private List<PayScheCalcModel> getSplitScheDataList(List<WaitScheData> autoScheDataList) {
        return autoScheDataList.stream().map(WaitScheData::getNewScheData).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void doBatchBillToNewBillSche(List<WaitScheData> autoScheDataList, SumScheInfo sumInfo) {
        PayScheCalcModel originData;
        ArrayList<WaitScheData> waitScheDataList = new ArrayList<WaitScheData>(10);
        BigDecimal totalAmt = sumInfo != null ? sumInfo.getBillTotalAmt() : null;
        for (WaitScheData o : autoScheDataList) {
            originData = o.getPayScheData();
            if (totalAmt == null) continue;
            totalAmt = totalAmt.subtract(originData.getDraftBillAmt());
        }
        for (WaitScheData o : autoScheDataList) {
            originData = o.getPayScheData();
            if (!o.isNeedDoBillSche() || originData.isArchiveMerger()) continue;
            WaitScheData waitScheData = new WaitScheData();
            waitScheData.setScheRule(o.getScheRule());
            BigDecimal balance = totalAmt == null ? o.getBalance() : o.getBalance().min(totalAmt);
            if (balance.compareTo(Constants.ZERO) <= 0) continue;
            if (totalAmt != null) {
                totalAmt = totalAmt.subtract(balance);
            }
            originData.setApplyAmt(originData.getApplyAmt().subtract(balance));
            PayScheCalcModel newCalcModel = originData.cloneBean();
            newCalcModel.setSplitId(originData.getScheId());
            newCalcModel.setSplitno(originData.getScheNumber());
            newCalcModel.setApplyAmt(balance);
            newCalcModel.setDraftBillAmt(balance);
            newCalcModel.setScheAmt(BigDecimal.ZERO);
            newCalcModel.setScheBalance(BigDecimal.ZERO);
            newCalcModel.setCreateTime(new Date());
            DynamicObject originDataDy = BusinessDataServiceHelper.newDynamicObject((String)"psd_schedulebill");
            originDataDy.set("company", (Object)originData.getOrgId());
            String number = CodeRuleHelper.generateNumber((String)"psd_schedulebill", (DynamicObject)originDataDy, (String)originData.getOrgId().toString(), (String)"");
            newCalcModel.setScheNumber(number);
            waitScheData.setPayScheData(newCalcModel);
            waitScheData.setAmount(balance);
            o.setNewScheData(newCalcModel);
            waitScheDataList.add(waitScheData);
        }
        if (!waitScheDataList.isEmpty()) {
            this.billExecutor.execute(waitScheDataList, null);
        }
    }

    private void doBatchBillToPaySche(List<WaitScheData> waitScheFundList, List<WaitScheData> waitScheBillList, SumScheInfo sumInfo) {
        ArrayList<WaitScheData> seWaitScheFundList = new ArrayList<WaitScheData>();
        List waitFundPayScheIds = waitScheFundList.stream().map(o -> o.getPayScheData().getScheId()).collect(Collectors.toList());
        waitScheBillList.forEach(o -> {
            if (o.isNeedDoFundSche()) {
                BigDecimal eAmount = BigDecimal.ZERO;
                PayScheCalcModel payScheCalcModel = o.getPayScheData();
                if (payScheCalcModel != null && (eAmount = (BigDecimal)payScheCalcModel.getCalcPropVal("e_amount")) == null) {
                    eAmount = BigDecimal.ZERO;
                }
                o.setAmount(o.getBalance().add(eAmount));
                if (waitFundPayScheIds.contains(o.getPayScheData().getScheId())) {
                    o.setScheRule(null);
                }
                seWaitScheFundList.add((WaitScheData)o);
            }
        });
        this.fundExecutor.execute(seWaitScheFundList, sumInfo != null ? sumInfo.getFundTotalAmt() : null);
    }

    public void setDefaultRules(Map<Long, DynamicObject> defaultRules) {
        this.defaultRules = defaultRules;
    }
}

