/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche.bill;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.psd.common.helper.LoggerPrintHelper;

public class DraftBillLockCache {
    private static Log logger = LogFactory.getLog(DraftBillLockCache.class);
    private String pageId;
    private static IAppCache cache = TmcAppCache.get((String)TmcAppEnum.PSD.getValue(), (String)"", (String)"DraftBillLockCache");

    public DraftBillLockCache(String pageId) {
        this.pageId = pageId;
    }

    public void fromPrevPage(String prevPageId) {
        DraftBillLockCache draftCache = new DraftBillLockCache(prevPageId);
        logger.info("\u7f13\u5b58\u4e2d\u7684\u9875\u9762ID\u4fe1\u606f\u4e3a:{}", (Object)LoggerPrintHelper.printCollectionLogger(draftCache.getBillIdSet()));
        this.saveBillIdSet(draftCache.getBillIdSet());
    }

    public void updatePrevPage(String prevPageId) {
        DraftBillLockCache draftCache = new DraftBillLockCache(prevPageId);
        Set<Long> currenctDraftIds = this.getBillIdSet();
        Set<Long> parentDraftIds = draftCache.getBillIdSet();
        logger.info("\u5f53\u524d\u9875\u9762\u6240\u83b7\u53d6\u7684\u7968\u636e\u53f7\u4e3a:{}", (Object)LoggerPrintHelper.printCollectionLogger(currenctDraftIds));
        logger.info("\u7236\u9875\u9762\u6240\u83b7\u53d6\u7684\u7968\u636e\u53f7\u4e3a:{}", (Object)LoggerPrintHelper.printCollectionLogger(parentDraftIds));
        Set<Long> lockIds = DraftBillLockCache.difference(currenctDraftIds, parentDraftIds);
        Set<Long> releaseIds = DraftBillLockCache.difference(parentDraftIds, currenctDraftIds);
        logger.info("\u5f85\u9501\u5b9a\u7684\u7968\u636e\u53f7\u96c6\u5408\u4e3a:{}", (Object)LoggerPrintHelper.printCollectionLogger(lockIds));
        logger.info("\u5f85\u91ca\u653e\u7684\u7968\u636e\u53f7\u96c6\u5408\u4e3a:{}", (Object)LoggerPrintHelper.printCollectionLogger(releaseIds));
        draftCache.release(releaseIds);
        draftCache.lock(lockIds);
    }

    public Set<Long> getLockedBillIdSet() {
        return this.getBillIdSet();
    }

    public void lock(Collection<Long> billIdList) {
        if (CollectionUtils.isEmpty(billIdList)) {
            return;
        }
        Set<Long> billIdSet = this.getBillIdSet();
        billIdSet.addAll(billIdList);
        this.saveBillIdSet(billIdSet);
        logger.info("\u9501\u5b9a\u7684\u7968\u636e\u53f7:{}", (Object)LoggerPrintHelper.printCollectionLogger(billIdSet));
    }

    public void release(Collection<Long> billIdList) {
        if (CollectionUtils.isEmpty(billIdList)) {
            return;
        }
        Set<Long> billIdSet = this.getBillIdSet();
        billIdSet.removeAll(billIdList);
        this.saveBillIdSet(billIdSet);
        logger.info("\u91ca\u653e\u7684\u7968\u636e\u53f7:{}", (Object)LoggerPrintHelper.printCollectionLogger(billIdSet));
    }

    public void releaseAll() {
        cache.remove(this.pageId);
    }

    private Set<Long> getBillIdSet() {
        String billListStr = (String)cache.get(this.pageId, String.class);
        if (billListStr == null) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JSON.parseArray((String)billListStr, Long.class));
    }

    private void saveBillIdSet(Set<Long> billIdList) {
        cache.put(this.pageId, (Object)JSON.toJSONString(billIdList));
    }

    public static Set<Long> difference(Set<Long> setA, Set<Long> setB) {
        HashSet<Long> tmp = new HashSet<Long>(setA);
        tmp.removeAll(setB);
        return tmp;
    }
}

