/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IDraftBillProvider;
import kd.tmc.psd.business.service.paysche.autosche.data.DraftBillCoreData;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;

public class DraftBillProvider
implements IDraftBillProvider {
    private static DraftBillProvider instance;

    private DraftBillProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DraftBillProvider getInstance() {
        Class<DraftBillProvider> clazz = DraftBillProvider.class;
        synchronized (DraftBillProvider.class) {
            if (instance == null) {
                instance = new DraftBillProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Set<DraftBillCoreData> getAllBankBills(long orgId) {
        List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList("6");
        List<QFilter> filters = this.getBillFilterList(orgId, billTypeIdList);
        return this.getDraftBills(filters);
    }

    @Override
    public Set<DraftBillCoreData> getAllBizBills(long orgId) {
        List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList("5");
        List<QFilter> filters = this.getBillFilterList(orgId, billTypeIdList);
        return this.getDraftBills(filters);
    }

    private List<QFilter> getBillFilterList(Long orgId, List<Object> billTypeIdList) {
        QFilter draftFilter = new QFilter("company", "=", (Object)orgId);
        draftFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        draftFilter.and(new QFilter("draftbilltype", "in", billTypeIdList));
        draftFilter.and(new QFilter("istransfer", "=", (Object)"1"));
        draftFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        draftFilter.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")));
        draftFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        draftFilter.and(new QFilter("source", "in", (Object)new String[]{"handregister", "apply", "cdm", "cas", "bei", "cdm-draftallocate"}));
        QFilter inDraftPoolQFilter = this.getInDraftPoolQFilter(orgId, billTypeIdList);
        if (inDraftPoolQFilter != null) {
            draftFilter.or(inDraftPoolQFilter);
        }
        return Collections.singletonList(draftFilter);
    }

    private QFilter getInDraftPoolQFilter(Long orgId, List<Object> billTypeIdList) {
        DynamicObjectCollection billPools = QueryServiceHelper.query((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.size());
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        if (EmptyUtil.isEmpty(poolIds)) {
            return null;
        }
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (String)"08", (Long)orgId, (String)"isShowUnLockBill");
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("draftbilltype", "in", billTypeIdList));
        qFilterBillPool.and(new QFilter("istransfer", "=", (Object)"1"));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilterBillPool.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("source", "!=", (Object)"cas"));
        return qFilterBillPool;
    }

    public Set<DraftBillCoreData> getDraftBills(List<QFilter> filters) {
        DynamicObject[] billList = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id, draftbillexpiredate, accepterbankno, amount, currency, isendorsepay, locksourcebillid, draftbilltype.settlementtypebd,source,availableamount", (QFilter[])filters.toArray(new QFilter[0]));
        Set<DraftBillCoreData> billSet = Arrays.stream(billList).map(o -> {
            DraftBillCoreData data = new DraftBillCoreData();
            data.setId(o.getLong("id"));
            data.setAmt(o.getBigDecimal("amount"));
            data.setAvaliableAmount(o.getBigDecimal("availableamount"));
            data.setDate(o.getDate("draftbillexpiredate"));
            data.setBankCode(o.getString("accepterbankno"));
            Long currencyId = Optional.ofNullable(o.getDynamicObject("currency")).map(a -> Long.valueOf(a.getPkValue().toString())).orElseGet(() -> null);
            data.setCurrencyId(currencyId);
            data.setLockSourceId(o.getLong("locksourcebillid"));
            data.setLocked(o.getBoolean("isendorsepay"));
            DynamicObjectCollection linkSettypeObjs = o.getDynamicObjectCollection("draftbilltype.settlementtypebd");
            Set<Long> linkIds = linkSettypeObjs.stream().filter(Objects::nonNull).map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toSet());
            data.setSettleTypeIdLst(linkIds);
            data.setSourceSys(o.getString("source"));
            return data;
        }).collect(Collectors.toSet());
        return billSet;
    }

    @Override
    public Set<DraftBillCoreData> getAllBankPayBills(long orgId) {
        List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList("6");
        List<QFilter> filters = this.getPayBillFilterList(orgId, billTypeIdList);
        return this.getDraftPayBills(filters);
    }

    @Override
    public Set<DraftBillCoreData> getAllBizPayBills(long orgId) {
        List<Object> billTypeIdList = PayScheHelper.getBillTypeIdList("5");
        List<QFilter> filters = this.getPayBillFilterList(orgId, billTypeIdList);
        return this.getDraftPayBills(filters);
    }

    private List<QFilter> getPayBillFilterList(Long orgId, List<Object> billTypeIdList) {
        return Arrays.asList(new QFilter("drawercompany", "=", (Object)orgId), new QFilter("rptype", "=", (Object)"paybill"), new QFilter("draftbilltype", "in", billTypeIdList), new QFilter("billstatus", "=", (Object)"C"), new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")), new QFilter("draftbillstatus", "=", (Object)"registered"));
    }

    private Set<DraftBillCoreData> getDraftPayBills(List<QFilter> filters) {
        DynamicObject[] billList = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id, draweraccount, amount, currency, receivername, isendorsepay ,locksourcebillid, draftbilltype.settlementtypebd,source,availableamount", (QFilter[])filters.toArray(new QFilter[0]));
        Set<DraftBillCoreData> billSet = Arrays.stream(billList).map(o -> {
            DraftBillCoreData data = new DraftBillCoreData();
            data.setId(o.getLong("id"));
            Long drawerAccId = Optional.ofNullable(o.getDynamicObject("draweraccount")).map(a -> Long.valueOf(a.getPkValue().toString())).orElseGet(() -> null);
            data.setAccountId(drawerAccId);
            data.setAmt(o.getBigDecimal("amount"));
            data.setAvaliableAmount(o.getBigDecimal("availableamount"));
            Long currencyId = Optional.ofNullable(o.getDynamicObject("currency")).map(a -> Long.valueOf(a.getPkValue().toString())).orElseGet(() -> null);
            data.setCurrencyId(currencyId);
            data.setRecName(o.getString("receivername").trim());
            data.setLockSourceId(o.getLong("locksourcebillid"));
            data.setLocked(o.getBoolean("isendorsepay"));
            DynamicObjectCollection linkSettypeObjs = o.getDynamicObjectCollection("draftbilltype.settlementtypebd");
            Set<Long> linkIds = linkSettypeObjs.stream().filter(Objects::nonNull).map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toSet());
            data.setSettleTypeIdLst(linkIds);
            data.setSourceSys(o.getString("source"));
            return data;
        }).collect(Collectors.toSet());
        return billSet;
    }
}

