/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.autosche.fund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.psd.business.service.paysche.autosche.IAutoPayScheExecutor;
import kd.tmc.psd.business.service.paysche.autosche.data.WaitScheData;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.common.enums.DefaultAccountTypeEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.SelectPaymentAccEnum;
import kd.tmc.psd.common.enums.SelectSettleTypeEnum;

public class AutoPayScheFundExecutor
implements IAutoPayScheExecutor {
    private static Log logger = LogFactory.getLog(AutoPayScheFundExecutor.class);
    private Long orgId;

    public AutoPayScheFundExecutor(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public void execute(List<WaitScheData> waitScheDataList, BigDecimal totalAmt) {
        DynamicObject orgDefaultCashAcct = this.getDefaultCashAccount(this.orgId);
        DynamicObject orgDefaultBankAcct = this.getDefaultBankAccount(this.orgId);
        for (WaitScheData autoScheData : waitScheDataList) {
            if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) <= 0) {
                logger.info("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e\uff0ctotalAmt\u4e3a\u7a7a\u6216<= 0");
                break;
            }
            PayScheCalcModel scheData = autoScheData.getPayScheData();
            DynamicObject scheRule = autoScheData.getScheRule();
            if (scheRule != null) {
                DynamicObject settlementtype;
                String selSettleType = scheRule.getString("selectsettletype");
                DynamicObject defaultSettleType = null;
                if (SelectSettleTypeEnum.REDEFINESETTLE.getValue().equals(selSettleType)) {
                    defaultSettleType = scheRule.getDynamicObject("defaultsettletype");
                }
                String selPaymentAcc = scheRule.getString("selectpaymentacc");
                DynamicObject defaultAccountObj = scheRule.getDynamicObject("defaultaccount");
                DynamicObject targetMappingInfo = null;
                DynamicObject firstOrgMappingInfo = null;
                if (SelectPaymentAccEnum.REDEFINEACC.getValue().equals(selPaymentAcc)) {
                    logger.info("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u6392\u6b3e\u89c4\u5219\u4e2d\u7684\u8d26\u6237\u4e3a\u91cd\u5b9a\u4e49\u53d6\u503c");
                    if (defaultAccountObj != null) {
                        logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u6392\u6b3e\u89c4\u5219\u7684\u9ed8\u8ba4\u8d26\u6237\u4e0d\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u8d26\u6237\u8bbe\u7f6eid\uff1a{%s}", defaultAccountObj.getPkValue()));
                        if (!defaultAccountObj.containsProperty("entryentity")) {
                            defaultAccountObj = BusinessDataServiceHelper.loadSingle((Object)defaultAccountObj.getPkValue(), (String)"psd_defaultaccount");
                        }
                        DynamicObjectCollection mappingInfoColl = defaultAccountObj.getDynamicObjectCollection("entryentity");
                        Long dataOrgId = scheData.getOrgId();
                        Long payCurrencyId = scheData.getCurrencyId();
                        Long payeeBank = scheData.getPayeeBank();
                        Long payBillTypeId = scheData.getPaymenttypeId();
                        logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u6392\u7a0b\u5355\u4fe1\u606f\uff0corg\uff1a{%s},currency:{%s},payeeBank:{%s}", dataOrgId, payCurrencyId, payeeBank));
                        String beBankName = "";
                        if (payeeBank != null) {
                            DynamicObject beBankObj = TmcDataServiceHelper.loadSingle((Object)payeeBank, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_bebank"));
                            beBankName = beBankObj.getString("name");
                        }
                        String finalBeBankName = beBankName;
                        List orgEqualsColl = mappingInfoColl.stream().filter(e -> e.getDynamicObject("org").getPkValue().equals(dataOrgId)).collect(Collectors.toList());
                        if (orgEqualsColl.size() > 0) {
                            logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u5339\u914d\u5230\u7ec4\u7ec7\u4e00\u81f4\u7684\u4ed8\u6b3e\u4eba\u6570\uff1a{%s}", orgEqualsColl.size()));
                            for (DynamicObject orgEqualsItemObj : orgEqualsColl) {
                                List currencyList = orgEqualsItemObj.getDynamicObjectCollection("currency").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                                List bankTypeNameList = orgEqualsItemObj.getDynamicObjectCollection("banktype").stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toList());
                                List payBillTypeList = orgEqualsItemObj.getDynamicObjectCollection("paybilltype").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                                if (CollectionUtils.isEmpty(currencyList) && CollectionUtils.isEmpty(bankTypeNameList) && CollectionUtils.isEmpty(payBillTypeList) && firstOrgMappingInfo == null) {
                                    logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u5339\u914d\u5230\u7b2c\u4e00\u6761\u53ea\u6709\u7ec4\u7ec7\u4e00\u81f4\u7684\u4ed8\u6b3e\u4eba\uff0c%s", orgEqualsItemObj.getPkValue()));
                                    firstOrgMappingInfo = orgEqualsItemObj;
                                }
                                List isExistList = bankTypeNameList.stream().filter(e -> finalBeBankName.indexOf((String)e) >= 0).collect(Collectors.toList());
                                if (currencyList.contains(payCurrencyId) && isExistList.size() > 0 && payBillTypeList.contains(payBillTypeId)) {
                                    logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u5339\u914d\u5230\u7ec4\u7ec7\uff0c\u94f6\u884c\u7c7b\u522b\uff0c\u5e01\u79cd\uff0c\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\u7684\u4fe1\u606f\uff0c%s", orgEqualsItemObj.getPkValue()));
                                    targetMappingInfo = orgEqualsItemObj;
                                    break;
                                }
                                if (targetMappingInfo != null || !currencyList.contains(payCurrencyId) && isExistList.size() <= 0 && !payBillTypeList.contains(payBillTypeId)) continue;
                                logger.info(String.format("\u6392\u7a0b\u5904\u7406-\u6392\u6b3e-\u5339\u914d\u5230\u7ec4\u7ec7\uff0c\u94f6\u884c\u7c7b\u522b/\u5e01\u79cd/\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\u7684\u4fe1\u606f\uff0c%s", orgEqualsItemObj.getPkValue()));
                                targetMappingInfo = orgEqualsItemObj;
                            }
                        }
                        if (targetMappingInfo == null) {
                            targetMappingInfo = firstOrgMappingInfo;
                        }
                    }
                }
                DynamicObject defaultCashAcc = null;
                DynamicObject defaultBankAcc = null;
                if (SelectPaymentAccEnum.DEFAULTPAYMENTACC.getValue().equals(selPaymentAcc)) {
                    defaultCashAcc = orgDefaultCashAcct;
                    defaultBankAcc = orgDefaultBankAcct;
                } else if (SelectPaymentAccEnum.REDEFINEACC.getValue().equals(selPaymentAcc) && targetMappingInfo != null) {
                    if (defaultAccountObj.get("accounttype").equals(DefaultAccountTypeEnum.CASH.getValue())) {
                        defaultCashAcc = targetMappingInfo.getDynamicObject("account");
                    } else {
                        defaultBankAcc = targetMappingInfo.getDynamicObject("account");
                    }
                }
                Object settleTypePK = null;
                if (SelectSettleTypeEnum.REDEFINESETTLE.getValue().equals(selSettleType)) {
                    if (null != defaultSettleType && null != (settleTypePK = defaultSettleType.getPkValue())) {
                        scheData.setSettleTypeId((Long)settleTypePK);
                    }
                } else {
                    settleTypePK = scheData.getSettleTypeId();
                }
                Boolean isCash = Boolean.FALSE;
                if (null != settleTypePK && "0".equals((settlementtype = BusinessDataServiceHelper.loadSingleFromCache((Object)settleTypePK, (String)"bd_settlementtype", (String)"settlementtype")).getString("settlementtype"))) {
                    isCash = Boolean.TRUE;
                }
                if (isCash.booleanValue()) {
                    scheData.setAcctBankType("cas_accountcash");
                } else {
                    scheData.setAcctBankType("bd_accountbanks");
                }
                Long acctBankId = null;
                if (!SelectPaymentAccEnum.PAYMENTPLANACC.getValue().equals(selPaymentAcc)) {
                    if (isCash.booleanValue() && null != defaultCashAcc) {
                        Object defaultCashAccId = defaultCashAcc.getPkValue();
                        if (null != defaultCashAccId) {
                            acctBankId = (Long)defaultCashAcc.getPkValue();
                        }
                    } else if (!isCash.booleanValue() && null != defaultBankAcc && null != defaultBankAcc.getPkValue()) {
                        acctBankId = (Long)defaultBankAcc.getPkValue();
                    }
                    if (acctBankId != null) {
                        scheData.setAcctBankId(acctBankId);
                    }
                }
                String payChannel = scheRule.getString("paymentchannel");
                if (PayChannelEnum.PAYSCHBILL.getValue().equals(payChannel)) {
                    scheData.setPayChannel(scheData.getApplyPayChannel());
                } else {
                    scheData.setPayChannel(payChannel);
                }
            }
            BigDecimal scheAmt = totalAmt == null ? autoScheData.getAmount() : totalAmt.min(autoScheData.getAmount());
            scheData.setScheAmt(scheAmt);
            if (totalAmt == null) continue;
            totalAmt = totalAmt.subtract(scheAmt);
        }
    }

    private DynamicObject getDefaultCashAccount(long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("isdefaultpayer", "=", (Object)Boolean.TRUE));
        DynamicObject accountcash = BusinessDataServiceHelper.loadSingle((String)"cas_accountcash", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        return accountcash;
    }

    private DynamicObject getDefaultBankAccount(long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("company", "=", (Object)orgId));
        qFilters.add(new QFilter("isdefaultpay", "=", (Object)true));
        qFilters.add(new QFilter("acctstatus", "=", (Object)"normal"));
        DynamicObject bankAccont = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        return bankAccont;
    }
}

