/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheFormOperate;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheCombineSumData;
import kd.tmc.psd.business.service.paysche.service.impl.CombineSumScheService;
import kd.tmc.psd.common.enums.PsdCombineModeEnum;

public class PayScheCombineHandler
extends PayScheCalcBaseHandler<PayScheCombineSumData> {
    private CombineSumScheService combineSumScheService;
    private IPayScheProcessorView<PayScheCombineSumData> view;
    private PsdCombineModeEnum combineMode;

    public PayScheCombineHandler(IPayScheProcessorView<PayScheCombineSumData> view, PsdCombineModeEnum combineMode, List<String> combinePropList) {
        super(view.getPageId());
        this.combineMode = combineMode;
        this.combineSumScheService = new CombineSumScheService(combineMode, combinePropList);
        this.view = view;
    }

    public void initCombineData(List<PayScheCalcModel> scheDataList, boolean isSubmit) {
        this.payScheService.initCombineData(scheDataList);
        this.initData(scheDataList);
        if (this.combineMode == PsdCombineModeEnum.AUTO_COMBINE) {
            this.autoCombine();
        } else if (this.combineMode == PsdCombineModeEnum.VIEW_COMBINE) {
            this.checkCombine(isSubmit);
        }
    }

    public void autoCombine() {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Void>(ResManager.loadKDString((String)"\u81ea\u52a8\u5408\u5e76", (String)"PayScheCombineHandler_0", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCombineHandler.this.payScheService.autoCombine(scheDataList);
            }
        });
    }

    public void checkCombine(final boolean isSubmit) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Boolean>(ResManager.loadKDString((String)"\u68c0\u67e5\u5408\u5e76\u9879", (String)"PayScheCombineHandler_1", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Boolean> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCombineHandler.this.payScheService.checkCombine(scheDataList, isSubmit);
            }
        });
    }

    public Tuple<Boolean, String> manualCombine(Long sumId, List<Long> scheIdList) {
        PayScheProcessResult<Tuple<Boolean, String>> result = this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Tuple<Boolean, String>>(sumId, scheIdList, ResManager.loadKDString((String)"\u5408\u5e76", (String)"PayScheCombineHandler_2", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Tuple<Boolean, String>> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                PayScheCombineSumData sumData = sumDataList.get(0);
                return PayScheCombineHandler.this.payScheService.manualCombine(scheDataList, sumData.getCombineNum());
            }
        });
        return result.getResult();
    }

    public void manualUniqueCombine(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u7edf\u4e00\u5408\u5e76\u9879", (String)"PayScheCombineHandler_3", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                PayScheCombineSumData sumData = sumDataList.get(0);
                return PayScheCombineHandler.this.payScheService.manualUniqueCombine(scheDataList, sumData.getCombineNum());
            }
        });
    }

    public void cancelCombine(Long sumId, final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Void>(sumId, ResManager.loadKDString((String)"\u53d6\u6d88\u5408\u5e76", (String)"PayScheCombineHandler_4", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCombineHandler.this.payScheService.cancelCombine(scheDataList, scheIdList);
            }
        });
    }

    public void uniqueCombine(Long sumId, final Long scheId) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Void>(sumId, ResManager.loadKDString((String)"\u7edf\u4e00\u5408\u5e76\u9879", (String)"PayScheCombineHandler_3", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                PayScheCalcModel uniqueCalcModel = scheDataList.stream().filter(o -> o.getScheId().equals(scheId)).findFirst().orElseGet(() -> null);
                PayScheCombineSumData sumData = sumDataList.get(0);
                return PayScheCombineHandler.this.payScheService.uniqueCombine(uniqueCalcModel, scheDataList, sumData.getCombineNum());
            }
        });
    }

    public void remove(Long sumId, final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheCombineSumData, Void>(sumId, ResManager.loadKDString((String)"\u79fb\u9664", (String)"PayScheCombineHandler_5", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheCombineSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheCombineHandler.this.payScheService.removeCombine(scheDataList, scheIdList);
            }
        });
    }

    public boolean validateCombineInfo() {
        List sumInfoList = this.dataRepository.getAllScheSumInfoList();
        for (PayScheCombineSumData sumInfo : sumInfoList) {
            if (sumInfo.getErrCnt() <= 0) continue;
            this.getView().showErrorMessage(Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u5904\u7406\u5b8c\u672a\u5408\u5e76\u9879\u540e\uff0c\u518d\u6b21\u70b9\u51fb\u786e\u5b9a\u6309\u94ae\u3002", (String)"PayScheCombineHandler_6", (String)"tmc-psd-business", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    public List<PayScheCalcModel> getCombineResult(List<PayScheCalcModel> originDataList) {
        List<PayScheCalcModel> combinedDataList = this.getAllCombineDataList();
        ArrayList<PayScheCalcModel> removedDataList = new ArrayList<PayScheCalcModel>();
        for (PayScheCalcModel originData : originDataList) {
            boolean isRemovedData = true;
            for (PayScheCalcModel combinedData : combinedDataList) {
                if (!combinedData.getScheId().equals(originData.getScheId())) continue;
                isRemovedData = false;
            }
            if (!isRemovedData) continue;
            removedDataList.add(originData);
        }
        if (removedDataList.size() > 0) {
            for (PayScheCalcModel removedData : removedDataList) {
                removedData.setBatchnum(null);
            }
            combinedDataList.addAll(removedDataList);
        }
        return combinedDataList;
    }

    @Override
    protected IPayScheProcessorView<PayScheCombineSumData> getView() {
        return this.view;
    }

    @Override
    protected ISumScheService<PayScheCombineSumData> getSumScheService() {
        return this.combineSumScheService;
    }
}

