/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.ISumScheService;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheFormOperate;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSumData;
import kd.tmc.psd.business.service.paysche.service.impl.SumScheService;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;

public class PayScheProcessorHandler
extends PayScheCalcBaseHandler<PayScheSumData> {
    private static final Log logger = LogFactory.getLog(PayScheProcessorHandler.class);
    private Long processorId;
    private SumScheService sumScheService;
    private IPayScheProcessorView<PayScheSumData> view;
    private Map<Long, BigDecimal> transDraftAmounts = new HashMap<Long, BigDecimal>(4);

    public PayScheProcessorHandler(IPayScheProcessorView<PayScheSumData> view, Long processorId) {
        super(view.getPageId());
        this.view = view;
        this.processorId = processorId;
        this.sumScheService = new SumScheService(processorId, view.getOrgId(), view.getPeriodTypeId(), view.getDimType());
    }

    @Override
    protected IPayScheProcessorView<PayScheSumData> getView() {
        return this.view;
    }

    @Override
    protected ISumScheService<PayScheSumData> getSumScheService() {
        return this.sumScheService;
    }

    public String loadProcessor() {
        PayScheProcessResult<List<PayScheCalcModel>> result = this.payScheService.loadProcessor(this.processorId);
        if (!result.isSuccess()) {
            this.view.showErrorMessage(result.getErrMsgList());
            return null;
        }
        this.initData(result.getResult());
        return this.sumScheService.getDimType();
    }

    @Override
    public void loadScheDataList(Long sumId) {
        this.dataRepository.setCurrSumId(sumId);
        List<PayScheCalcModel> scheDataList = this.dataRepository.getScheDataList(sumId);
        this.view.updateScheDataList(scheDataList, true);
    }

    public List<PayScheCalcModel> preCombine(List<String> combinePropList) {
        List<PayScheCalcModel> allScheDataList = this.dataRepository.getAllScheDataList();
        List<PayScheCalcModel> nonCombineData = allScheDataList.stream().filter(o -> EmptyUtil.isEmpty((String)o.getBatchnum())).filter(p -> EmptyUtil.isEmpty((Long)p.getEntrustPayId())).collect(Collectors.toList());
        PayScheProcessResult<List<PayScheCalcModel>> preCombineResult = this.payScheService.filterCombineData(combinePropList, nonCombineData);
        if (preCombineResult.isSuccess()) {
            return preCombineResult.getResult();
        }
        this.view.showErrorMessage(preCombineResult.getErrMsgList());
        return null;
    }

    public boolean checkSplit(Long sumId, Long scheId) {
        List<PayScheCalcModel> scheDataList = this.dataRepository.getScheDataList(sumId, Collections.singletonList(scheId));
        PayScheProcessResult<Boolean> result = this.payScheService.checkSplit(scheDataList.get(0));
        if (!result.isSuccess()) {
            this.view.showErrorMessage(result.getErrMsgList());
        }
        return result.getResult();
    }

    public boolean checkCombine(boolean isSubmit) {
        List<PayScheCalcModel> allCombineDataList = this.getAllCombineDataList();
        if (allCombineDataList.size() > 0) {
            PayScheProcessResult<Boolean> result = this.payScheService.checkCombine(allCombineDataList, isSubmit);
            this.getView().showErrorMessage(result.getErrMsgList());
            return result.getResult();
        }
        return true;
    }

    public PayScheSumData getSumScheData(Long sumId) {
        PayScheSumData sumInfo = (PayScheSumData)this.dataRepository.getScheSumInfo(sumId);
        List<PayScheCalcModel> scheDataList = this.dataRepository.getScheDataList(sumId);
        this.sumScheService.fixSumScheData(sumInfo, scheDataList);
        return sumInfo;
    }

    public Tuple<Boolean, String> manualCombine(Long sumId, List<Long> scheIdList) {
        PayScheProcessResult<Tuple<Boolean, String>> result = this.doScheFormOperate(new PayScheFormOperate<PayScheSumData, Tuple<Boolean, String>>(sumId, scheIdList, ResManager.loadKDString((String)"\u5408\u5e76", (String)"PayScheProcessorHandler_10", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Tuple<Boolean, String>> doOperate(List<PayScheSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheProcessorHandler.this.payScheService.manualCombine(scheDataList, null);
            }
        });
        return result.getResult();
    }

    public void manualUniqueCombine(Long sumId, List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSumData, Void>(sumId, scheIdList, ResManager.loadKDString((String)"\u7edf\u4e00\u5408\u5e76\u9879", (String)"PayScheProcessorHandler_17", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheProcessorHandler.this.payScheService.manualUniqueCombine(scheDataList, null);
            }
        });
    }

    public void cancelCombine(final List<Long> scheIdList) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSumData, Void>(ResManager.loadKDString((String)"\u53d6\u6d88\u5408\u5e76", (String)"PayScheProcessorHandler_18", (String)"tmc-psd-business", (Object[])new Object[0])){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheProcessorHandler.this.payScheService.cancelCombine(scheDataList, scheIdList);
            }
        });
    }

    public void cleanFiled(final PayScheProcessorInfo payScheProcessorInfo) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSumData, Void>(){

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheProcessorHandler.this.payScheService.cleanField(scheDataList, payScheProcessorInfo);
            }
        });
    }

    public void updateTransferAmt(final List<PayScheDraftInfo> payScheDraftInfos) {
        this.doScheFormOperate(new PayScheFormOperate<PayScheSumData, Void>(){

            @Override
            void filterScheData(List<PayScheCalcModel> scheDataList) {
                super.filterScheData(scheDataList);
                ArrayList<PayScheCalcModel> waitUpdateCalcModels = new ArrayList<PayScheCalcModel>(payScheDraftInfos.size());
                for (PayScheDraftInfo payScheDraftInfo : payScheDraftInfos) {
                    Optional<PayScheCalcModel> trueScheModelOp;
                    Long payScheId = payScheDraftInfo.getPayScheId();
                    Optional<PayScheCalcModel> firstScheModelOp = scheDataList.stream().filter(o -> payScheId.compareTo(o.getScheId()) == 0).findFirst();
                    if (!firstScheModelOp.isPresent()) continue;
                    PayScheCalcModel calcModel = firstScheModelOp.get();
                    waitUpdateCalcModels.add(calcModel);
                    if (!calcModel.isArchiveMerger() || !(trueScheModelOp = scheDataList.stream().filter(o -> calcModel.getBatchnum().equals(o.getBatchnum())).filter(o -> o.isMasterData()).findFirst()).isPresent()) continue;
                    waitUpdateCalcModels.add(trueScheModelOp.get());
                }
                scheDataList.clear();
                if (EmptyUtil.isNoEmpty(waitUpdateCalcModels)) {
                    scheDataList.addAll(waitUpdateCalcModels);
                }
            }

            @Override
            PayScheProcessResult<Void> doOperate(List<PayScheSumData> sumDataList, List<PayScheCalcModel> scheDataList) {
                return PayScheProcessorHandler.this.payScheService.updateTransferAmt(payScheDraftInfos, scheDataList, PayScheProcessorHandler.this.transDraftAmounts);
            }
        });
    }

    public boolean isSumSche() {
        return this.sumScheService.isSumSche();
    }

    public SumScheInfo getSumScheInfo(long sumId, String dimType) {
        PayScheSumData sumData = (PayScheSumData)this.dataRepository.getScheSumInfo(sumId);
        return this.sumScheService.getSumScheInfo(dimType, sumData.getDimVal());
    }

    public void setTransDraftAmounts(Map<Long, BigDecimal> transDraftAmounts) {
        this.transDraftAmounts = transDraftAmounts;
    }
}

