/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.paysche.data.calc;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import org.apache.commons.lang3.StringUtils;

public class PsdCashBalanceCalcModel
implements Serializable {
    private static final long serialVersionUID = -1318789774529318060L;
    private static Log logger = LogFactory.getLog(PsdCashBalanceCalcModel.class);
    private static final String ENABLE = "1";
    private List<PayScheCalcModel> pscModelLst = null;
    private Long org = null;
    private String psdBillNo = null;
    private Date startDate = null;
    private Date endDate = null;

    public PsdCashBalanceCalcModel(List<PayScheCalcModel> pscModelLst) {
        this.pscModelLst = pscModelLst;
    }

    public PsdCashBalanceCalcModel() {
    }

    public List<PayScheCalcModel> getPscModelList() {
        return this.pscModelLst;
    }

    public Long getCurrency() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return null;
        }
        return this.pscModelLst.get(0).getCurrencyId();
    }

    public Long getProject() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return null;
        }
        return this.pscModelLst.get(0).getAcctBankId();
    }

    public String getProjectText() {
        Long accountId = this.getProject();
        String accountType = this.getAccountType();
        if (null == accountId || null == accountType || accountType.trim().isEmpty()) {
            return null;
        }
        DynamicObject accountObj = QueryServiceHelper.queryOne((String)accountType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountId)});
        return Optional.ofNullable(accountObj).map(o -> o.getString("name")).orElseGet(() -> "");
    }

    public String getAccountType() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return null;
        }
        return this.pscModelLst.get(0).getAcctBankType();
    }

    public BigDecimal getInitialInventoryAmount() {
        BigDecimal currAcctAmt = BigDecimal.ZERO;
        String accountType = this.getAccountType();
        if (EmptyUtil.isEmpty((String)accountType)) {
            return currAcctAmt;
        }
        ArrayList params = new ArrayList(1);
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>(4);
        param.put("orgid", this.getOrg());
        param.put("accountid", this.getProject());
        param.put("currencyid", this.getCurrency());
        param.put("bizdate", DateUtils.getCurrentDate());
        params.add(param);
        Long bankAcctId = this.getProject();
        if (accountType.equals("bd_accountbanks")) {
            DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((Object)bankAcctId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
            if (bankAcct.getBoolean("issetbankinterface")) {
                currAcctAmt = TmcBusinessBaseHelper.getLastestBeBalance((Long)bankAcctId, (Long)this.getCurrency());
            } else {
                Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"accountAmountService", (String)"getBankAccountAmount", (Object[])new Object[]{params});
                String key = String.format("%s%s%s", String.valueOf(this.getOrg()), String.valueOf(this.getProject()), String.valueOf(this.getCurrency()));
                currAcctAmt = Optional.ofNullable(result).map(o -> {
                    Map resultMap = (Map)result;
                    return (BigDecimal)resultMap.get(key);
                }).orElseGet(() -> BigDecimal.ZERO);
            }
        } else if (accountType.equals("cas_accountcash")) {
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"accountAmountService", (String)"getCashAccountAmount", (Object[])new Object[]{params});
            String key = String.format("%s%s%s", String.valueOf(this.getOrg()), String.valueOf(this.getProject()), String.valueOf(this.getCurrency()));
            currAcctAmt = Optional.ofNullable(result).map(o -> {
                Map resultMap = (Map)result;
                return (BigDecimal)resultMap.get(key);
            }).orElseGet(() -> BigDecimal.ZERO);
        }
        logger.info("\u671f\u521d\u5e93\u5b58\u91d1\u989d: {}", (Object)currAcctAmt);
        return currAcctAmt;
    }

    public BigDecimal getCurrentExpectCollect() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getPlanFinanceinFlow() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal planFinanceinFlowAmount = BigDecimal.ZERO;
        for (PayScheCalcModel model : this.pscModelLst) {
            Boolean result = model.getIsNeedFin();
            if (!result.booleanValue()) continue;
            planFinanceinFlowAmount = planFinanceinFlowAmount.add(model.getScheAmt());
        }
        logger.info("\u8ba1\u5212\u878d\u8d44\u6d41\u5165\u91d1\u989d: {}", (Object)planFinanceinFlowAmount);
        return planFinanceinFlowAmount;
    }

    public BigDecimal getCurrentPaymentAmount() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal currentPaymentAmount = BigDecimal.ZERO;
        for (PayScheCalcModel model : this.pscModelLst) {
            currentPaymentAmount = currentPaymentAmount.add(model.getScheAmt());
        }
        logger.info("\u672c\u671f\u6392\u6b3e\u91d1\u989d: {}", (Object)currentPaymentAmount);
        return currentPaymentAmount;
    }

    public BigDecimal getStandbyAmount() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getBalance() {
        return BigDecimal.ZERO.add(this.getInitialInventoryAmount()).add(this.getCurrentExpectCollect()).add(this.getPlanFinanceinFlow()).subtract(this.getCurrentPaymentAmount()).subtract(this.getLimitAmt()).subtract(this.getIntransitAmt());
    }

    public BigDecimal getLimitAmt() {
        Long currencyId;
        BigDecimal limitAmt = BigDecimal.ZERO;
        String accountType = this.getAccountType();
        if (EmptyUtil.isEmpty((String)accountType) || accountType.equals("cas_accountcash")) {
            return BigDecimal.ZERO;
        }
        Long bankAcctId = this.getProject();
        DynamicObject acctStrategy = TmcBusinessBaseHelper.getAcctStratg((Long)bankAcctId, (Long)(currencyId = this.getCurrency()));
        if (null == acctStrategy || !StringUtils.equals((CharSequence)acctStrategy.getString("enable"), (CharSequence)ENABLE)) {
            return BigDecimal.ZERO;
        }
        BigDecimal miniAcctLimit = acctStrategy.getBigDecimal("miniacctlimit") == null ? BigDecimal.ZERO : acctStrategy.getBigDecimal("miniacctlimit");
        BigDecimal overAmt = acctStrategy.getBigDecimal("overamt") == null ? BigDecimal.ZERO : acctStrategy.getBigDecimal("overamt");
        limitAmt = miniAcctLimit.subtract(overAmt);
        logger.info("\u672c\u671f\u6392\u6b3e\u91d1\u989d: {}", (Object)limitAmt);
        return limitAmt;
    }

    public Map<String, BigDecimal> getLimitAmtFunds(Set<Long> bankAccIds, List<Long> orgIds, Long currencyId, Long exrateTableId) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        DynamicObjectCollection accountBanks = new DynamicObjectCollection();
        for (Long bankAcctId : bankAccIds) {
            DynamicObject accountBank = BusinessDataServiceHelper.newDynamicObject((String)"am_accountbank");
            accountBank.set("id", (Object)bankAcctId);
            accountBanks.add((Object)accountBank);
        }
        param.put("filter_mulbankacct", accountBanks);
        param.put("filter_statisticalunits", ENABLE);
        param.put("filter_isshowsubtotal", false);
        param.put("filter_currencyunit", ENABLE);
        DynamicObject exrateTable = BusinessDataServiceHelper.newDynamicObject((String)"bd_exratetable");
        exrateTable.set("id", (Object)exrateTableId);
        param.put("filter_exratetable", exrateTable);
        param.put("filter_querytype", "org");
        param.put("filter_isincludelower", false);
        param.put("filter_org", orgIds);
        param.put("filter_isshowtotal", false);
        DynamicObjectCollection currencies = new DynamicObjectCollection();
        DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
        currency.set("id", (Object)currencyId);
        currencies.add((Object)currency);
        param.put("filter_currency", currencies);
        param.put("filter_statcurrency", currency);
        param.put("filter_date", new Date());
        param.put("filter_queryway", "org");
        param.put("filter_isincludefinorg", true);
        Map<String, BigDecimal> limitFunds = new HashMap<String, BigDecimal>(16);
        try {
            String limitFundsStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"am", (String)"restrictFundsData", (String)"getLimitFunds", (Object[])new Object[]{param, orgIds});
            limitFunds = (Map)JSONObject.parseObject((String)limitFundsStr, Map.class);
            if (limitFunds == null) {
                limitFunds = new HashMap(2);
            }
        }
        catch (Exception e) {
            logger.error("\u6392\u7a0b\u83b7\u53d6\u53d7\u9650\u8d44\u91d1\u4f59\u989d\u5f02\u5e38:", (Throwable)e);
        }
        return limitFunds;
    }

    public BigDecimal getIntransitAmt() {
        return TmcBusinessBaseHelper.getAcctPayingAmt((Long)this.getProject(), (Long)this.getCurrency());
    }

    public List<PayScheCalcModel> getPscModelLst() {
        return this.pscModelLst;
    }

    public Long getOrg() {
        return this.org;
    }

    public void setOrg(Long org) {
        this.org = org;
    }

    public String getPsdBillNo() {
        return this.psdBillNo;
    }

    public void setPsdBillNo(String psdBillNo) {
        this.psdBillNo = psdBillNo;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getExrateTable() {
        if (null == this.pscModelLst || this.pscModelLst.isEmpty()) {
            return null;
        }
        return this.pscModelLst.get(0).getExratetable();
    }
}

